/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.pool;

import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.pool.PoolDebugConfiguration;
import org.firebirdsql.pool.XCachablePreparedStatement;
import org.firebirdsql.pool.XStatementManager;

class XPreparedStatementCache {
    private static final boolean CACHE_PREPARED_STATEMENTS = true;
    private static final boolean LOG_STATEMENT_IN_POOL = PoolDebugConfiguration.DEBUG_STMT_POOL;
    private static Logger logChannel = LoggerFactory.getLogger(class$org$firebirdsql$pool$XPreparedStatementCache == null ? (class$org$firebirdsql$pool$XPreparedStatementCache = XPreparedStatementCache.class$("org.firebirdsql.pool.XPreparedStatementCache")) : class$org$firebirdsql$pool$XPreparedStatementCache, false);
    private XStatementManager owner;
    private LinkedQueue freeReferences = new LinkedQueue();
    private HashMap workingReferences = new HashMap();
    private String sql;
    private int resultSetType;
    private int resultSetConcurrency;
    private int maxSize;
    static /* synthetic */ Class class$org$firebirdsql$pool$XPreparedStatementCache;

    public XPreparedStatementCache(XStatementManager owner, String sql, int resultSetType, int resultSetConcurrency, int maxSize) {
        this.owner = owner;
        this.maxSize = maxSize;
        if (sql == null) {
            throw new NullPointerException("Null objects cannot be guarded.");
        }
        this.sql = sql;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
    }

    synchronized XCachablePreparedStatement take(Connection connection) throws SQLException {
        if (this.sql == null) {
            throw new IllegalStateException("This reference guard was already destroyed.");
        }
        try {
            XCachablePreparedStatement result;
            if (this.freeReferences.isEmpty()) {
                if (LOG_STATEMENT_IN_POOL && logChannel != null) {
                    logChannel.info("Found no free prepared statements, preparing new one.");
                }
                result = this.owner.prepareStatement(this.sql, this.resultSetType, this.resultSetConcurrency, this.workingReferences.size() < this.maxSize);
            } else {
                if (LOG_STATEMENT_IN_POOL && logChannel != null) {
                    logChannel.info("Found free prepared statement in pool.");
                }
                result = (XCachablePreparedStatement)this.freeReferences.take();
            }
            result.setConnection(connection);
            this.workingReferences.put(result.getOriginal(), result);
            return result;
        }
        catch (InterruptedException iex) {
            throw new SQLException("Cannot prepare SQL statement in pool");
        }
    }

    synchronized void put(Object reference) throws SQLException {
        if (reference == null) {
            throw new NullPointerException();
        }
        try {
            XCachablePreparedStatement statement = (XCachablePreparedStatement)reference;
            if (statement.isCached()) {
                statement.setConnection(null);
                this.freeReferences.put(reference);
            }
            this.workingReferences.remove(statement.getOriginal());
            if (!statement.isCached()) {
                statement.forceClose();
            }
            if (LOG_STATEMENT_IN_POOL && logChannel != null) {
                logChannel.info("Returned prepared statement to pool.");
            }
        }
        catch (InterruptedException ex) {
            logChannel.warn("Could not put statement back to pool.", ex);
        }
    }

    synchronized void invalidate() throws SQLException {
        this.sql = null;
        SQLException error = null;
        while (!this.freeReferences.isEmpty()) {
            try {
                XCachablePreparedStatement result = (XCachablePreparedStatement)this.freeReferences.take();
                result.forceClose();
            }
            catch (InterruptedException ex) {
            }
            catch (SQLException ex) {
                if (error == null) {
                    error = ex;
                    continue;
                }
                error.setNextException(ex);
            }
        }
        Iterator iter = this.workingReferences.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            XCachablePreparedStatement item = (XCachablePreparedStatement)entry.getValue();
            try {
                item.forceClose();
            }
            catch (SQLException ex) {
                if (error == null) {
                    error = ex;
                    continue;
                }
                error.setNextException(ex);
            }
        }
        this.workingReferences.clear();
        if (error != null) {
            throw error;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

