/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.pool;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.firebirdsql.pool.ObjectCloseTraceException;
import org.firebirdsql.pool.PooledConnectionHandler;
import org.firebirdsql.pool.ResultSetHandler;
import org.firebirdsql.pool.XConnectionUtil;
import org.firebirdsql.pool.XStatementManager;

public class PooledPreparedStatementHandler
implements InvocationHandler {
    private static final boolean TOLERANT_CHECK_MODE = false;
    private static final Method PREPARED_STATEMENT_CLOSE = PooledPreparedStatementHandler.findMethod(class$java$sql$PreparedStatement == null ? (class$java$sql$PreparedStatement = PooledPreparedStatementHandler.class$("java.sql.PreparedStatement")) : class$java$sql$PreparedStatement, "close", new Class[0]);
    private static final Method PREPARED_STATEMENT_GET_CONNECTION = PooledPreparedStatementHandler.findMethod(class$java$sql$PreparedStatement == null ? (class$java$sql$PreparedStatement = PooledPreparedStatementHandler.class$("java.sql.PreparedStatement")) : class$java$sql$PreparedStatement, "getConnection", new Class[0]);
    private static final Method PREPARED_STATEMENT_FORCE_CLOSE = PooledPreparedStatementHandler.findMethod(class$org$firebirdsql$pool$XCachablePreparedStatement == null ? (class$org$firebirdsql$pool$XCachablePreparedStatement = PooledPreparedStatementHandler.class$("org.firebirdsql.pool.XCachablePreparedStatement")) : class$org$firebirdsql$pool$XCachablePreparedStatement, "forceClose", new Class[0]);
    private static final Method PREPARED_STATEMENT_SET_CONNECTION = PooledPreparedStatementHandler.findMethod(class$org$firebirdsql$pool$XCachablePreparedStatement == null ? (class$org$firebirdsql$pool$XCachablePreparedStatement = PooledPreparedStatementHandler.class$("org.firebirdsql.pool.XCachablePreparedStatement")) : class$org$firebirdsql$pool$XCachablePreparedStatement, "setConnection", new Class[]{class$java$sql$Connection == null ? (class$java$sql$Connection = PooledPreparedStatementHandler.class$("java.sql.Connection")) : class$java$sql$Connection});
    private static final Method PREPARED_STATEMENT_GET_ORIGINAL = PooledPreparedStatementHandler.findMethod(class$org$firebirdsql$pool$XCachablePreparedStatement == null ? (class$org$firebirdsql$pool$XCachablePreparedStatement = PooledPreparedStatementHandler.class$("org.firebirdsql.pool.XCachablePreparedStatement")) : class$org$firebirdsql$pool$XCachablePreparedStatement, "getOriginal", new Class[0]);
    private static final Method PREPARED_STATEMENT_IS_CACHED = PooledPreparedStatementHandler.findMethod(class$org$firebirdsql$pool$XCachablePreparedStatement == null ? (class$org$firebirdsql$pool$XCachablePreparedStatement = PooledPreparedStatementHandler.class$("org.firebirdsql.pool.XCachablePreparedStatement")) : class$org$firebirdsql$pool$XCachablePreparedStatement, "isCached", new Class[0]);
    private String statement;
    private PreparedStatement preparedStatement;
    private XStatementManager owner;
    private Connection associatedConnection;
    private boolean cached;
    private boolean invalid;
    private ObjectCloseTraceException invalidateStackTrace;
    private String invalidateStackTraceStr = "";
    static /* synthetic */ Class class$java$sql$PreparedStatement;
    static /* synthetic */ Class class$org$firebirdsql$pool$XCachablePreparedStatement;
    static /* synthetic */ Class class$java$sql$Connection;
    static /* synthetic */ Class class$java$sql$ResultSet;

    public static Method findMethod(Class clazz, String name, Class[] params) {
        return PooledConnectionHandler.findMethod(clazz, name, params);
    }

    PooledPreparedStatementHandler(String statement, PreparedStatement preparedStatement, XStatementManager owner, boolean cached) {
        this.statement = statement;
        this.preparedStatement = preparedStatement;
        this.owner = owner;
        this.invalid = false;
        this.cached = cached;
    }

    protected void handleStatementClose(String statement, Object proxy) throws SQLException {
        if (this.invalid) {
            throw new SQLException("Statement is already closed.");
        }
        this.owner.statementClosed(statement, proxy);
    }

    protected void handleForceClose() throws SQLException {
        this.preparedStatement.close();
        this.associatedConnection = null;
        this.invalid = true;
        this.invalidateStackTrace = new ObjectCloseTraceException();
        this.invalidateStackTraceStr = XConnectionUtil.getStackTrace(this.invalidateStackTrace);
    }

    protected boolean handleIsCached() throws SQLException {
        return this.cached;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.checkCorrectness(method);
        try {
            if (method.equals(PREPARED_STATEMENT_CLOSE)) {
                this.handleStatementClose(this.statement, proxy);
                return Void.TYPE;
            }
            if (method.equals(PREPARED_STATEMENT_GET_CONNECTION)) {
                return this.associatedConnection;
            }
            if (method.equals(PREPARED_STATEMENT_SET_CONNECTION)) {
                this.associatedConnection = (Connection)args[0];
                return Void.TYPE;
            }
            if (method.equals(PREPARED_STATEMENT_GET_ORIGINAL)) {
                return this.preparedStatement;
            }
            if (method.equals(PREPARED_STATEMENT_FORCE_CLOSE)) {
                this.handleForceClose();
                return Void.TYPE;
            }
            if (method.equals(PREPARED_STATEMENT_IS_CACHED)) {
                return new Boolean(this.handleIsCached());
            }
            Object result = method.invoke((Object)this.preparedStatement, args);
            if (result instanceof ResultSet) {
                ResultSetHandler handler = new ResultSetHandler((PreparedStatement)proxy, (ResultSet)result);
                result = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{class$java$sql$ResultSet == null ? (class$java$sql$ResultSet = PooledPreparedStatementHandler.class$("java.sql.ResultSet")) : class$java$sql$ResultSet}, (InvocationHandler)handler);
            }
            return result;
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }

    protected void checkCorrectness(Method method) throws SQLException {
        boolean incorrectState;
        String message = "Statemenet has illegal state because it does not have any associated connection at this time. Usually this means that Statement.getConnection() method was called on a closed statement that currently lives in a statement pool. ";
        if (this.invalid) {
            message = message + "See the attached exception for the information where the object was closed.";
        }
        boolean bl = this.associatedConnection == null && method.getDeclaringClass().equals(class$java$sql$PreparedStatement == null ? (class$java$sql$PreparedStatement = PooledPreparedStatementHandler.class$("java.sql.PreparedStatement")) : class$java$sql$PreparedStatement) || this.invalid ? true : (incorrectState = false);
        if (incorrectState) {
            throw new IllegalStateException(message);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

