/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.logging;

import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.firebirdsql.logging.Logger;

public class Log4jLogger
extends Logger {
    private static boolean loggingAvailable = true;
    private final Category log;

    protected Log4jLogger(String name) {
        if (loggingAvailable) {
            Category myLog = null;
            try {
                myLog = Category.getInstance((String)name);
            }
            catch (Throwable t) {
                loggingAvailable = false;
            }
            this.log = myLog;
        } else {
            this.log = null;
        }
    }

    public boolean isDebugEnabled() {
        return loggingAvailable && this.log.isEnabledFor(Priority.DEBUG);
    }

    public void debug(Object message) {
        if (this.isDebugEnabled()) {
            this.log.log(Priority.DEBUG, message);
        }
    }

    public void debug(Object message, Throwable t) {
        if (this.isDebugEnabled()) {
            this.log.log(Priority.DEBUG, message, t);
        }
    }

    public boolean isInfoEnabled() {
        return loggingAvailable && this.log.isEnabledFor(Priority.INFO);
    }

    public void info(Object message) {
        if (this.isInfoEnabled()) {
            this.log.log(Priority.INFO, message);
        }
    }

    public void info(Object message, Throwable t) {
        if (this.isInfoEnabled()) {
            this.log.log(Priority.INFO, message, t);
        }
    }

    public boolean isWarnEnabled() {
        return loggingAvailable && this.log.isEnabledFor(Priority.WARN);
    }

    public void warn(Object message) {
        if (this.isWarnEnabled()) {
            this.log.log(Priority.WARN, message);
        }
    }

    public void warn(Object message, Throwable t) {
        if (this.isWarnEnabled()) {
            this.log.log(Priority.WARN, message, t);
        }
    }

    public boolean isErrorEnabled() {
        return loggingAvailable && this.log.isEnabledFor(Priority.ERROR);
    }

    public void error(Object message) {
        if (this.isErrorEnabled()) {
            this.log.log(Priority.ERROR, message);
        }
    }

    public void error(Object message, Throwable t) {
        if (this.isErrorEnabled()) {
            this.log.log(Priority.ERROR, message, t);
        }
    }

    public boolean isFatalEnabled() {
        return loggingAvailable && this.log.isEnabledFor(Priority.FATAL);
    }

    public void fatal(Object message) {
        if (this.isFatalEnabled()) {
            this.log.log(Priority.FATAL, message);
        }
    }

    public void fatal(Object message, Throwable t) {
        if (this.isFatalEnabled()) {
            this.log.log(Priority.FATAL, message, t);
        }
    }
}

