/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.FBBlob;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.field.FBFlushableField;
import org.firebirdsql.jdbc.field.FBStringField;

public class FBLongVarCharField
extends FBStringField
implements FBFlushableField {
    private static final int BUFF_SIZE = 4096;
    private boolean isCachedData = false;
    private FBBlob blob;
    int length;
    byte[] data;

    FBLongVarCharField(XSQLVAR field, FBResultSet rs, int numCol, int requiredType) throws SQLException {
        super(field, rs, numCol, requiredType);
    }

    public void close() throws SQLException {
        try {
            if (this.blob != null) {
                this.blob.close();
            }
        }
        catch (IOException ioex) {
            throw new FBSQLException(ioex);
        }
        finally {
            this.blob = null;
        }
    }

    public Blob getBlob() throws SQLException {
        if (this.blob != null) {
            return this.blob;
        }
        if (this.rs.row[this.numCol] == null) {
            return BLOB_NULL_VALUE;
        }
        this.blob = new FBBlob(this.c, this.field.decodeLong(this.rs.row[this.numCol]));
        return this.blob;
    }

    public InputStream getBinaryStream() throws SQLException {
        Blob blob = this.getBlob();
        if (blob == BLOB_NULL_VALUE) {
            return STREAM_NULL_VALUE;
        }
        return blob.getBinaryStream();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getBytes() throws SQLException {
        Blob blob = this.getBlob();
        if (blob == BLOB_NULL_VALUE) {
            return BYTES_NULL_VALUE;
        }
        InputStream in = blob.getBinaryStream();
        if (in == STREAM_NULL_VALUE) {
            return BYTES_NULL_VALUE;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buff = new byte[4096];
        int counter = 0;
        try {
            try {
                while ((counter = in.read(buff)) != -1) {
                    bout.write(buff, 0, counter);
                }
                Object var8_6 = null;
            }
            catch (IOException ioex) {
                throw (SQLException)FBLongVarCharField.createException(BYTES_CONVERSION_ERROR + " " + ioex.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            try {
                in.close();
            }
            catch (IOException ioex) {
                throw new FBSQLException(ioex);
            }
            try {
                bout.close();
                throw throwable;
            }
            catch (IOException ioex) {
                throw new FBSQLException(ioex);
            }
        }
        try {}
        catch (IOException ioex) {
            throw new FBSQLException(ioex);
        }
        in.close();
        try {}
        catch (IOException ioex) {
            throw new FBSQLException(ioex);
        }
        bout.close();
        return bout.toByteArray();
    }

    public byte[] getCachedObject() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return BYTES_NULL_VALUE;
        }
        return this.getBytes();
    }

    public String getString() throws SQLException {
        byte[] data = this.getBytes();
        if (data == BYTES_NULL_VALUE) {
            return STRING_NULL_VALUE;
        }
        return this.field.decodeString(data, this.javaEncoding, this.mappingPath);
    }

    public void setBlob(FBBlob blob) throws SQLException {
        this.field.sqldata = this.field.encodeLong(blob.getBlobId());
    }

    public void setString(String value) throws SQLException {
        if (value == STRING_NULL_VALUE) {
            this.setNull();
            return;
        }
        byte[] data = this.field.encodeString(value, this.javaEncoding, this.mappingPath);
        this.setBinaryStream(new ByteArrayInputStream(data), data.length);
    }

    public void setBytes(byte[] value) throws SQLException {
        if (value == BYTES_NULL_VALUE) {
            this.setNull();
            return;
        }
        byte[] data = this.field.encodeString(value, this.javaEncoding, this.mappingPath);
        this.setBinaryStream(new ByteArrayInputStream(data), data.length);
    }

    private void copyBinaryStream(InputStream in, int length) throws SQLException {
        if (!this.c.getAutoCommit()) {
            this.c.ensureInTransaction();
        }
        FBBlob blob = new FBBlob(this.c, 0L);
        blob.copyStream(in, length);
        this.field.sqldata = this.field.encodeLong(blob.getBlobId());
    }

    public void setBinaryStream(InputStream in, int length) throws SQLException {
        if (in == STREAM_NULL_VALUE) {
            this.setNull();
            return;
        }
        if (!this.c.getAutoCommit()) {
            this.copyBinaryStream(in, length);
        } else {
            byte[] buff = new byte[4096];
            ByteArrayOutputStream bout = new ByteArrayOutputStream(length);
            try {
                while (length > 0) {
                    int chunk = in.read(buff, 0, length < 4096 ? length : 4096);
                    bout.write(buff, 0, chunk);
                    length -= chunk;
                }
                bout.close();
            }
            catch (IOException ioe) {
                throw new FBSQLException(ioe);
            }
            this.data = bout.toByteArray();
            this.length = this.data.length;
            this.isCachedData = true;
        }
    }

    public void flushCachedData() throws SQLException {
        if (this.isCachedData) {
            this.copyBinaryStream(new ByteArrayInputStream(this.data), this.length);
            this.isCachedData = false;
        }
    }
}

