/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jca;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import org.firebirdsql.jca.FBResourceException;
import org.firebirdsql.jdbc.FBConnectionHelper;

public class FBTpbMapper
implements Serializable {
    public static final String DEFAULT_MAPPING_RESOURCE = "isc_tpb_mapping";
    public static final FBTpbMapper DEFAULT_MAPPER = new FBTpbMapper();
    private static final String TRANSACTION_SERIALIZABLE = "TRANSACTION_SERIALIZABLE";
    private static final String TRANSACTION_REPEATABLE_READ = "TRANSACTION_REPEATABLE_READ";
    private static final String TRANSACTION_READ_COMMITTED = "TRANSACTION_READ_COMMITTED";
    private static final String TRANSACTION_READ_UNCOMMITTED = "TRANSACTION_READ_UNCOMMITTED";
    private HashMap mapping = new HashMap();

    public FBTpbMapper() {
        HashSet<Integer> serializableTpb = new HashSet<Integer>();
        serializableTpb.add(new Integer(9));
        serializableTpb.add(new Integer(6));
        serializableTpb.add(new Integer(1));
        HashSet<Integer> repeatableReadTpb = new HashSet<Integer>();
        repeatableReadTpb.add(new Integer(9));
        repeatableReadTpb.add(new Integer(6));
        repeatableReadTpb.add(new Integer(2));
        HashSet<Integer> readCommittedTpb = new HashSet<Integer>();
        readCommittedTpb.add(new Integer(9));
        readCommittedTpb.add(new Integer(6));
        readCommittedTpb.add(new Integer(15));
        readCommittedTpb.add(new Integer(17));
        this.mapping.put(new Integer(8), serializableTpb);
        this.mapping.put(new Integer(4), repeatableReadTpb);
        this.mapping.put(new Integer(2), readCommittedTpb);
    }

    public FBTpbMapper(Map stringMapping) throws FBResourceException {
        this();
        this.processMapping(stringMapping);
    }

    private void processMapping(Map stringMapping) throws FBResourceException {
        Iterator iter = stringMapping.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String jdbcTxIsolation = (String)entry.getKey();
            if (TRANSACTION_SERIALIZABLE.equalsIgnoreCase(jdbcTxIsolation)) {
                this.mapping.put(new Integer(8), this.processMapping((String)entry.getValue()));
                continue;
            }
            if (TRANSACTION_REPEATABLE_READ.equalsIgnoreCase(jdbcTxIsolation)) {
                this.mapping.put(new Integer(4), this.processMapping((String)entry.getValue()));
                continue;
            }
            if (TRANSACTION_READ_COMMITTED.equalsIgnoreCase(jdbcTxIsolation)) {
                this.mapping.put(new Integer(2), this.processMapping((String)entry.getValue()));
                continue;
            }
            if (TRANSACTION_READ_UNCOMMITTED.equalsIgnoreCase(jdbcTxIsolation)) {
                this.mapping.put(new Integer(1), this.processMapping((String)entry.getValue()));
                continue;
            }
            throw new FBResourceException("Transaction isolation " + jdbcTxIsolation + " is not supported.");
        }
    }

    public FBTpbMapper(String mappingResource, ClassLoader cl) throws FBResourceException {
        this();
        try {
            ResourceBundle res = ResourceBundle.getBundle(mappingResource, Locale.getDefault(), cl);
            HashMap<String, String> mapping = new HashMap<String, String>();
            Enumeration<String> en = res.getKeys();
            while (en.hasMoreElements()) {
                String key = en.nextElement();
                String value = res.getString(key);
                mapping.put(key, value);
            }
            this.processMapping(mapping);
        }
        catch (MissingResourceException mrex) {
            throw new FBResourceException("Cannot load TPB mapping." + mrex.getMessage());
        }
    }

    private Set processMapping(String mapping) throws FBResourceException {
        HashSet<Integer> result = new HashSet<Integer>();
        StringTokenizer st = new StringTokenizer(mapping, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            Integer value = FBConnectionHelper.getTpbParam(token);
            if (value == null) {
                throw new FBResourceException("Keyword " + token + " unknown. Please check your mapping.");
            }
            result.add(value);
        }
        return result;
    }

    public Set getMapping(int transactionIsolation) throws FBResourceException {
        switch (transactionIsolation) {
            case 2: 
            case 4: 
            case 8: {
                return new HashSet((Set)this.mapping.get(new Integer(transactionIsolation)));
            }
            case 1: {
                return new HashSet((Set)this.mapping.get(new Integer(2)));
            }
        }
        throw new FBResourceException("Transaction isolation level " + transactionIsolation + " is not supported.");
    }

    public void setMapping(int transactionIsolation, Set tpb) throws FBResourceException {
        switch (transactionIsolation) {
            case 2: 
            case 4: 
            case 8: {
                this.mapping.put(new Integer(transactionIsolation), tpb);
                break;
            }
            default: {
                throw new FBResourceException("Transaction isolation level " + transactionIsolation + " is not supported.");
            }
        }
    }

    public Set getDefaultMapping() {
        return (Set)this.mapping.get(new Integer(2));
    }
}

