/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyModule;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class CallBlock
extends BlockBody {
    private final Arity arity;
    private final BlockCallback callback;
    private final RubyModule imClass;
    private final ThreadContext context;

    public static Block newCallClosure(IRubyObject self, RubyModule imClass, Arity arity2, BlockCallback callback, ThreadContext context) {
        Binding binding2 = new Binding(self, context.getCurrentFrame(), Visibility.PUBLIC, context.getRubyClass(), context.getCurrentScope());
        CallBlock body = new CallBlock(imClass, arity2, callback, context);
        return new Block(body, binding2);
    }

    private CallBlock(RubyModule imClass, Arity arity2, BlockCallback callback, ThreadContext context) {
        super(3);
        this.arity = arity2;
        this.callback = callback;
        this.imClass = imClass;
        this.context = context;
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2) {
        return this.callback.call(context, args2, Block.NULL_BLOCK);
    }

    public IRubyObject yield(ThreadContext context, IRubyObject value2, Binding binding2, Block.Type type2) {
        return this.callback.call(context, new IRubyObject[]{value2}, Block.NULL_BLOCK);
    }

    public IRubyObject yield(ThreadContext context, IRubyObject value2, IRubyObject self, RubyModule klass, boolean aValue, Binding binding2, Block.Type type2) {
        return this.callback.call(context, new IRubyObject[]{value2}, Block.NULL_BLOCK);
    }

    public StaticScope getStaticScope() {
        throw new RuntimeException("CallBlock does not have a static scope; this should not be called");
    }

    public Block cloneBlock(Binding binding2) {
        binding2 = new Binding(binding2.getSelf(), binding2.getFrame().duplicate(), Visibility.PUBLIC, binding2.getKlass(), binding2.getDynamicScope());
        return new Block(this, binding2);
    }

    public Arity arity() {
        return this.arity;
    }
}

