/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.invokers;

import java.util.Arrays;
import java.util.Map;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaCallable;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class RubyToJavaInvoker
extends JavaMethod {
    protected static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    protected JavaCallable javaCallable;
    protected JavaCallable[][] javaCallables;
    protected Map cache;
    protected volatile boolean initialized;

    RubyToJavaInvoker(RubyModule host) {
        super(host, Visibility.PUBLIC);
        this.setArity(Arity.OPTIONAL);
    }

    void raiseNoMatchingCallableError(String name2, IRubyObject proxy2, Object ... args2) {
        int len = args2.length;
        Object[] argTypes = new Class[args2.length];
        for (int i = 0; i < len; ++i) {
            argTypes[i] = args2[i].getClass();
        }
        throw proxy2.getRuntime().newNameError("no " + name2 + " with arguments matching " + Arrays.toString(argTypes) + " on object " + proxy2.getMetaClass(), null);
    }

    protected JavaCallable findCallable(IRubyObject self, String name2, IRubyObject[] args2, int arity2) {
        JavaCallable callable = this.javaCallable;
        if (callable == null) {
            JavaCallable[] callablesForArity = null;
            if (arity2 >= this.javaCallables.length || (callablesForArity = this.javaCallables[arity2]) == null) {
                throw self.getRuntime().newArgumentError(args2.length, this.javaCallables.length - 1);
            }
            callable = Java.matchingCallableArityN(self, this.cache, callablesForArity, args2, arity2);
        } else if (callable.getParameterTypes().length != args2.length) {
            throw self.getRuntime().newArgumentError(args2.length, callable.getParameterTypes().length);
        }
        return callable;
    }

    protected JavaCallable findCallableArityZero(IRubyObject self, String name2) {
        JavaCallable callable = this.javaCallable;
        if (callable == null) {
            JavaCallable[] callablesForArity = null;
            if (this.javaCallables.length == 0 || (callablesForArity = this.javaCallables[0]) == null) {
                this.raiseNoMatchingCallableError(name2, self, EMPTY_OBJECT_ARRAY);
            }
            callable = callablesForArity[0];
        } else if (callable.getParameterTypes().length != 0) {
            throw self.getRuntime().newArgumentError(0, callable.getParameterTypes().length);
        }
        return callable;
    }

    protected JavaCallable findCallableArityOne(IRubyObject self, String name2, IRubyObject arg0) {
        JavaCallable callable = this.javaCallable;
        if (callable == null) {
            JavaCallable[] callablesForArity = null;
            if (this.javaCallables.length < 1 || (callablesForArity = this.javaCallables[1]) == null) {
                throw self.getRuntime().newArgumentError(1, this.javaCallables.length - 1);
            }
            callable = Java.matchingCallableArityOne(self, this.cache, callablesForArity, arg0);
        } else if (callable.getParameterTypes().length != 1) {
            throw self.getRuntime().newArgumentError(1, callable.getParameterTypes().length);
        }
        return callable;
    }

    protected JavaCallable findCallableArityTwo(IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1) {
        JavaCallable callable = this.javaCallable;
        if (callable == null) {
            JavaCallable[] callablesForArity = null;
            if (this.javaCallables.length <= 2 || (callablesForArity = this.javaCallables[2]) == null) {
                throw self.getRuntime().newArgumentError(2, this.javaCallables.length - 1);
            }
            callable = Java.matchingCallableArityTwo(self, this.cache, callablesForArity, arg0, arg1);
        } else if (callable.getParameterTypes().length != 2) {
            throw self.getRuntime().newArgumentError(2, callable.getParameterTypes().length);
        }
        return callable;
    }

    protected JavaCallable findCallableArityThree(IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        JavaCallable callable = this.javaCallable;
        if (callable == null) {
            JavaCallable[] callablesForArity = null;
            if (this.javaCallables.length <= 3 || (callablesForArity = this.javaCallables[3]) == null) {
                throw self.getRuntime().newArgumentError(3, this.javaCallables.length - 1);
            }
            callable = Java.matchingCallableArityThree(self, this.cache, callablesForArity, arg0, arg1, arg2);
        } else if (callable.getParameterTypes().length != 3) {
            throw self.getRuntime().newArgumentError(3, callable.getParameterTypes().length);
        }
        return callable;
    }

    protected JavaCallable findCallableArityFour(IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        JavaCallable callable = this.javaCallable;
        if (callable == null) {
            JavaCallable[] callablesForArity = null;
            if (this.javaCallables.length <= 4 || (callablesForArity = this.javaCallables[4]) == null) {
                throw self.getRuntime().newArgumentError(4, this.javaCallables.length - 1);
            }
            callable = Java.matchingCallableArityFour(self, this.cache, callablesForArity, arg0, arg1, arg2, arg3);
        } else if (callable.getParameterTypes().length != 4) {
            throw self.getRuntime().newArgumentError(4, callable.getParameterTypes().length);
        }
        return callable;
    }
}

