/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.Channel;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.socket.IANA;
import org.jruby.ext.socket.RubyBasicSocket;
import org.jruby.ext.socket.RubyIPSocket;
import org.jruby.ext.socket.RubyTCPServer;
import org.jruby.ext.socket.RubyTCPSocket;
import org.jruby.ext.socket.RubyUDPSocket;
import org.jruby.ext.socket.RubyUNIXServer;
import org.jruby.ext.socket.RubyUNIXSocket;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.util.ByteList;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;

@JRubyClass(name={"Socket"}, parent="BasicSocket", include={"Socket::Constants"})
public class RubySocket
extends RubyBasicSocket {
    private static ObjectAllocator SOCKET_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubySocket(runtime2, klass);
        }
    };
    public static final int NI_DGRAM = 16;
    public static final int NI_MAXHOST = 1025;
    public static final int NI_MAXSERV = 32;
    public static final int NI_NAMEREQD = 4;
    public static final int NI_NOFQDN = 1;
    public static final int NI_NUMERICHOST = 2;
    public static final int NI_NUMERICSERV = 8;
    public static final int SOL_IP = 0;
    public static final int SOL_SOCKET = 65535;
    public static final int SOL_TCP = 6;
    public static final int SOL_UDP = 17;
    public static final int SO_BROADCAST = 32;
    public static final int SO_DEBUG = 1;
    public static final int SO_DONTROUTE = 16;
    public static final int SO_ERROR = 4103;
    public static final int SO_KEEPALIVE = 8;
    public static final int SO_LINGER = 128;
    public static final int SO_OOBINLINE = 256;
    public static final int SO_RCVBUF = 4098;
    public static final int SO_RCVLOWAT = 4100;
    public static final int SO_RCVTIMEO = 4102;
    public static final int SO_REUSEADDR = 4;
    public static final int SO_SNDBUF = 4097;
    public static final int SO_SNDLOWAT = 4099;
    public static final int SO_SNDTIMEO = 4101;
    public static final int SO_TIMESTAMP = 1024;
    public static final int SO_TYPE = 4104;
    public static final int SOCK_STREAM = 1;
    public static final int SOCK_DGRAM = 2;
    public static final int SOCK_RAW = 3;
    public static final int SOCK_RDM = 4;
    public static final int SOCK_SEQPACKET = 5;
    public static final int AF_UNSPEC = 0;
    public static final int PF_UNSPEC = 0;
    public static final int AF_UNIX = 1;
    public static final int PF_UNIX = 1;
    public static final int AF_INET = 2;
    public static final int PF_INET = 2;
    public static final int AF_IPX = 23;
    public static final int PF_IPX = 23;
    public static final int AF_INET6 = 30;
    public static final int IPPROTO_IP = 0;
    public static final int IPPROTO_ICMP = 1;
    public static final int IPPROTO_TCP = 6;
    public static final int IPPROTO_UDP = 17;
    public static final int MSG_OOB = 1;
    public static final int MSG_PEEK = 2;
    public static final int MSG_DONTROUTE = 4;
    private int soDomain;
    private int soType;
    private int soProtocol;
    private static final Pattern STRING_ADDRESS_PATTERN = Pattern.compile("((.*)\\/)?([\\.0-9]+)(:([0-9]+))?");
    private static final int HOST_GROUP = 3;
    private static final int PORT_GROUP = 5;

    static void createSocket(Ruby runtime2) {
        RubyClass rb_cSocket = runtime2.defineClass("Socket", runtime2.fastGetClass("BasicSocket"), SOCKET_ALLOCATOR);
        RubyModule rb_mConstants = rb_cSocket.defineModuleUnder("Constants");
        rb_mConstants.fastSetConstant("SOCK_STREAM", runtime2.newFixnum(1));
        rb_mConstants.fastSetConstant("SOCK_DGRAM", runtime2.newFixnum(2));
        rb_mConstants.fastSetConstant("SOCK_RAW", runtime2.newFixnum(3));
        rb_mConstants.fastSetConstant("SOCK_RDM", runtime2.newFixnum(4));
        rb_mConstants.fastSetConstant("SOCK_SEQPACKET", runtime2.newFixnum(5));
        rb_mConstants.fastSetConstant("PF_UNSPEC", runtime2.newFixnum(0));
        rb_mConstants.fastSetConstant("AF_UNSPEC", runtime2.newFixnum(0));
        rb_mConstants.fastSetConstant("PF_INET", runtime2.newFixnum(2));
        rb_mConstants.fastSetConstant("AF_INET", runtime2.newFixnum(2));
        rb_mConstants.fastSetConstant("PF_INET6", runtime2.newFixnum(30));
        rb_mConstants.fastSetConstant("AF_INET6", runtime2.newFixnum(30));
        rb_mConstants.fastSetConstant("PF_UNIX", runtime2.newFixnum(1));
        rb_mConstants.fastSetConstant("AF_UNIX", runtime2.newFixnum(1));
        rb_mConstants.fastSetConstant("PF_IPX", runtime2.newFixnum(23));
        rb_mConstants.fastSetConstant("AF_IPX", runtime2.newFixnum(23));
        rb_mConstants.fastSetConstant("MSG_OOB", runtime2.newFixnum(1));
        rb_mConstants.fastSetConstant("MSG_PEEK", runtime2.newFixnum(2));
        rb_mConstants.fastSetConstant("MSG_DONTROUTE", runtime2.newFixnum(4));
        rb_mConstants.fastSetConstant("SOL_SOCKET", runtime2.newFixnum(65535));
        rb_mConstants.fastSetConstant("SOL_IP", runtime2.newFixnum(0));
        rb_mConstants.fastSetConstant("SOL_TCP", runtime2.newFixnum(6));
        rb_mConstants.fastSetConstant("SOL_UDP", runtime2.newFixnum(17));
        rb_mConstants.fastSetConstant("IPPROTO_IP", runtime2.newFixnum(0));
        rb_mConstants.fastSetConstant("IPPROTO_ICMP", runtime2.newFixnum(1));
        rb_mConstants.fastSetConstant("IPPROTO_TCP", runtime2.newFixnum(6));
        rb_mConstants.fastSetConstant("IPPROTO_UDP", runtime2.newFixnum(17));
        rb_mConstants.fastSetConstant("INADDR_ANY", runtime2.newFixnum(0));
        rb_mConstants.fastSetConstant("INADDR_BROADCAST", runtime2.newFixnum(-1));
        rb_mConstants.fastSetConstant("INADDR_LOOPBACK", runtime2.newFixnum(2130706433));
        rb_mConstants.fastSetConstant("INADDR_UNSPEC_GROUP", runtime2.newFixnum(-536870912));
        rb_mConstants.fastSetConstant("INADDR_ALLHOSTS_GROUP", runtime2.newFixnum(-536870911));
        rb_mConstants.fastSetConstant("INADDR_MAX_LOCAL_GROUP", runtime2.newFixnum(-536870657));
        rb_mConstants.fastSetConstant("INADDR_NONE", runtime2.newFixnum(-1));
        rb_mConstants.fastSetConstant("SHUT_RD", runtime2.newFixnum(0));
        rb_mConstants.fastSetConstant("SHUT_WR", runtime2.newFixnum(1));
        rb_mConstants.fastSetConstant("SHUT_RDWR", runtime2.newFixnum(2));
        rb_mConstants.fastSetConstant("AI_PASSIVE", runtime2.newFixnum(1));
        rb_mConstants.fastSetConstant("SO_BROADCAST", runtime2.newFixnum(32));
        rb_mConstants.fastSetConstant("SO_DEBUG", runtime2.newFixnum(1));
        rb_mConstants.fastSetConstant("SO_DONTROUTE", runtime2.newFixnum(16));
        rb_mConstants.fastSetConstant("SO_ERROR", runtime2.newFixnum(4103));
        rb_mConstants.fastSetConstant("SO_KEEPALIVE", runtime2.newFixnum(8));
        rb_mConstants.fastSetConstant("SO_LINGER", runtime2.newFixnum(128));
        rb_mConstants.fastSetConstant("SO_OOBINLINE", runtime2.newFixnum(256));
        rb_mConstants.fastSetConstant("SO_RCVBUF", runtime2.newFixnum(4098));
        rb_mConstants.fastSetConstant("SO_RCVLOWAT", runtime2.newFixnum(4100));
        rb_mConstants.fastSetConstant("SO_RCVTIMEO", runtime2.newFixnum(4102));
        rb_mConstants.fastSetConstant("SO_REUSEADDR", runtime2.newFixnum(4));
        rb_mConstants.fastSetConstant("SO_SNDBUF", runtime2.newFixnum(4097));
        rb_mConstants.fastSetConstant("SO_SNDLOWAT", runtime2.newFixnum(4099));
        rb_mConstants.fastSetConstant("SO_SNDTIMEO", runtime2.newFixnum(4101));
        rb_mConstants.fastSetConstant("SO_TIMESTAMP", runtime2.newFixnum(1024));
        rb_mConstants.fastSetConstant("SO_TYPE", runtime2.newFixnum(4104));
        rb_mConstants.fastSetConstant("TCP_NODELAY", runtime2.newFixnum(1));
        rb_mConstants.fastSetConstant("TCP_MAXSEG", runtime2.newFixnum(2));
        rb_mConstants.fastSetConstant("NI_DGRAM", runtime2.newFixnum(16));
        rb_mConstants.fastSetConstant("NI_MAXHOST", runtime2.newFixnum(1025));
        rb_mConstants.fastSetConstant("NI_MAXSERV", runtime2.newFixnum(32));
        rb_mConstants.fastSetConstant("NI_NAMEREQD", runtime2.newFixnum(4));
        rb_mConstants.fastSetConstant("NI_NOFQDN", runtime2.newFixnum(1));
        rb_mConstants.fastSetConstant("NI_NUMERICHOST", runtime2.newFixnum(2));
        rb_mConstants.fastSetConstant("NI_NUMERICSERV", runtime2.newFixnum(8));
        rb_mConstants.fastSetConstant("IP_MULTICAST_TTL", runtime2.newFixnum(10));
        rb_mConstants.fastSetConstant("IP_MULTICAST_LOOP", runtime2.newFixnum(11));
        rb_mConstants.fastSetConstant("IP_ADD_MEMBERSHIP", runtime2.newFixnum(12));
        rb_mConstants.fastSetConstant("IP_MAX_MEMBERSHIPS", runtime2.newFixnum(20));
        rb_mConstants.fastSetConstant("IP_DEFAULT_MULTICAST_LOOP", runtime2.newFixnum(1));
        rb_mConstants.fastSetConstant("IP_DEFAULT_MULTICAST_TTL", runtime2.newFixnum(1));
        rb_cSocket.includeModule(rb_mConstants);
        rb_cSocket.defineAnnotatedMethods(RubySocket.class);
    }

    public RubySocket(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    protected int getSoTypeDefault() {
        return this.soType;
    }

    @Deprecated
    public static IRubyObject for_fd(IRubyObject socketClass, IRubyObject fd) {
        return RubySocket.for_fd(socketClass.getRuntime().getCurrentContext(), socketClass, fd);
    }

    @JRubyMethod(frame=true, meta=true)
    public static IRubyObject for_fd(ThreadContext context, IRubyObject socketClass, IRubyObject fd) {
        Ruby ruby = context.getRuntime();
        if (fd instanceof RubyFixnum) {
            RubySocket socket2 = (RubySocket)((RubyClass)socketClass).allocate();
            ChannelDescriptor descriptor = socket2.getDescriptorByFileno((int)((RubyFixnum)fd).getLongValue());
            if (descriptor == null) {
                throw ruby.newErrnoEBADFError();
            }
            Channel mainChannel = descriptor.getChannel();
            if (mainChannel instanceof SocketChannel) {
                socket2.soDomain = 2;
                socket2.soType = 1;
                socket2.soProtocol = 0;
            } else if (mainChannel instanceof DatagramChannel) {
                socket2.soDomain = 2;
                socket2.soType = 2;
                socket2.soProtocol = 0;
            } else {
                throw context.getRuntime().newErrnoENOTSOCKError("can't Socket.new/for_fd against a non-socket");
            }
            socket2.initSocket(ruby, descriptor);
            return socket2;
        }
        throw context.getRuntime().newTypeError(fd, context.getRuntime().getFixnum());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod
    public IRubyObject initialize(ThreadContext context, IRubyObject domain, IRubyObject type2, IRubyObject protocol) {
        try {
            void var5_11;
            if (domain instanceof RubyString) {
                String string2 = domain.toString();
                if (string2.equals("AF_INET")) {
                    this.soDomain = 2;
                } else {
                    if (!string2.equals("PF_INET")) throw RubySocket.sockerr(context.getRuntime(), "unknown socket domain " + string2);
                    this.soDomain = 2;
                }
            } else {
                this.soDomain = RubyNumeric.fix2int(domain);
            }
            if (type2 instanceof RubyString) {
                String string3 = type2.toString();
                if (string3.equals("SOCK_STREAM")) {
                    this.soType = 1;
                } else {
                    if (!string3.equals("SOCK_DGRAM")) throw RubySocket.sockerr(context.getRuntime(), "unknown socket type " + string3);
                    this.soType = 2;
                }
            } else {
                this.soType = RubyNumeric.fix2int(type2);
            }
            this.soProtocol = RubyNumeric.fix2int(protocol);
            Object var5_8 = null;
            if (this.soType == 1) {
                SocketChannel socketChannel = SocketChannel.open();
            } else if (this.soType == 2) {
                DatagramChannel datagramChannel = DatagramChannel.open();
            }
            this.initSocket(context.getRuntime(), new ChannelDescriptor((Channel)var5_11, RubyIO.getNewFileno(), new ModeFlags(2L), new FileDescriptor()));
            return this;
        }
        catch (InvalidValueException invalidValueException) {
            throw context.getRuntime().newErrnoEINVALError();
        }
        catch (IOException iOException) {
            throw RubySocket.sockerr(context.getRuntime(), "initialize: " + iOException.toString());
        }
    }

    private static RuntimeException sockerr(Ruby runtime2, String msg) {
        return new RaiseException(runtime2, runtime2.fastGetClass("SocketError"), msg, true);
    }

    @Deprecated
    public static IRubyObject gethostname(IRubyObject recv2) {
        return RubySocket.gethostname(recv2.getRuntime().getCurrentContext(), recv2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject gethostname(ThreadContext context, IRubyObject recv2) {
        try {
            return context.getRuntime().newString(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            try {
                return context.getRuntime().newString(InetAddress.getByAddress(new byte[]{0, 0, 0, 0}).getHostName());
            }
            catch (UnknownHostException e2) {
                throw RubySocket.sockerr(context.getRuntime(), "gethostname: name or service not known");
            }
        }
    }

    private static InetAddress intoAddress(Ruby runtime2, String s) {
        try {
            byte[] bs = ByteList.plain(s);
            return InetAddress.getByAddress(bs);
        }
        catch (Exception e) {
            throw RubySocket.sockerr(runtime2, "strtoaddr: " + e.toString());
        }
    }

    private static String intoString(Ruby runtime2, InetAddress as) {
        try {
            return new String(ByteList.plain(as.getAddress()));
        }
        catch (Exception e) {
            throw RubySocket.sockerr(runtime2, "addrtostr: " + e.toString());
        }
    }

    @Deprecated
    public static IRubyObject gethostbyaddr(IRubyObject recv2, IRubyObject[] args2) {
        return RubySocket.gethostbyaddr(recv2.getRuntime().getCurrentContext(), recv2, args2);
    }

    @JRubyMethod(required=1, rest=true, meta=true)
    public static IRubyObject gethostbyaddr(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        IRubyObject[] ret = new IRubyObject[]{runtime2.newString(RubySocket.intoAddress(runtime2, args2[0].convertToString().toString()).getCanonicalHostName()), runtime2.newArray(), runtime2.newFixnum(2), args2[0]};
        return runtime2.newArrayNoCopy(ret);
    }

    @Deprecated
    public static IRubyObject getservbyname(IRubyObject recv2, IRubyObject[] args2) {
        return RubySocket.getservbyname(recv2.getRuntime().getCurrentContext(), recv2, args2);
    }

    @JRubyMethod(required=1, optional=1, meta=true)
    public static IRubyObject getservbyname(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        int argc = Arity.checkArgumentCount(runtime2, args2, 1, 2);
        String name2 = args2[0].convertToString().toString();
        String service = argc == 1 ? "tcp" : args2[1].convertToString().toString();
        Integer port = IANA.serviceToPort.get(name2 + "/" + service);
        if (port == null) {
            throw RubySocket.sockerr(runtime2, "no such service " + name2 + "/" + service);
        }
        return runtime2.newFixnum(port);
    }

    @Deprecated
    public static IRubyObject pack_sockaddr_un(IRubyObject recv2, IRubyObject filename2) {
        return RubySocket.pack_sockaddr_un(recv2.getRuntime().getCurrentContext(), recv2, filename2);
    }

    @JRubyMethod(name={"pack_sockaddr_un", "sockaddr_un"}, meta=true)
    public static IRubyObject pack_sockaddr_un(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        StringBuilder sb = new StringBuilder();
        sb.append('\u0000');
        sb.append('\u0001');
        String str = filename2.convertToString().toString();
        sb.append(str);
        for (int i = str.length(); i < 104; ++i) {
            sb.append('\u0000');
        }
        return context.getRuntime().newString(sb.toString());
    }

    @Deprecated
    public static IRubyObject pack_sockaddr_in(IRubyObject recv2, IRubyObject port, IRubyObject host) {
        return RubySocket.pack_sockaddr_in(recv2.getRuntime().getCurrentContext(), recv2, port, host);
    }

    @JRubyMethod(name={"pack_sockaddr_in", "sockaddr_in"}, meta=true)
    public static IRubyObject pack_sockaddr_in(ThreadContext context, IRubyObject recv2, IRubyObject port, IRubyObject host) {
        StringBuilder sb = new StringBuilder();
        sb.append('\u0010');
        sb.append('\u0002');
        int iport = RubyNumeric.fix2int(port);
        sb.append((char)(iport >> 8 & 0xFF));
        sb.append((char)(iport & 0xFF));
        try {
            String str;
            String string2 = str = host.isNil() ? null : host.convertToString().toString();
            if (str != null && "".equals(str)) {
                sb.append('\u0000');
                sb.append('\u0000');
                sb.append('\u0000');
                sb.append('\u0000');
            } else {
                InetAddress[] addrs = InetAddress.getAllByName(str);
                byte[] addr2 = addrs[0].getAddress();
                sb.append((char)addr2[0]);
                sb.append((char)addr2[1]);
                sb.append((char)addr2[2]);
                sb.append((char)addr2[3]);
            }
        }
        catch (UnknownHostException e) {
            throw RubySocket.sockerr(context.getRuntime(), "getaddrinfo: No address associated with nodename");
        }
        sb.append('\u0000');
        sb.append('\u0000');
        sb.append('\u0000');
        sb.append('\u0000');
        sb.append('\u0000');
        sb.append('\u0000');
        sb.append('\u0000');
        sb.append('\u0000');
        return context.getRuntime().newString(sb.toString());
    }

    @Deprecated
    public static IRubyObject unpack_sockaddr_in(IRubyObject recv2, IRubyObject addr2) {
        return RubySocket.unpack_sockaddr_in(recv2.getRuntime().getCurrentContext(), recv2, addr2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject unpack_sockaddr_in(ThreadContext context, IRubyObject recv2, IRubyObject addr2) {
        String val = addr2.convertToString().toString();
        if (val.charAt(0) != '\u0010' || val.charAt(1) != '\u0002') {
            throw context.getRuntime().newArgumentError("can't resolve socket address of wrong type");
        }
        int port = (val.charAt(2) << 8) + val.charAt(3);
        StringBuilder sb = new StringBuilder();
        sb.append((int)val.charAt(4));
        sb.append(".");
        sb.append((int)val.charAt(5));
        sb.append(".");
        sb.append((int)val.charAt(6));
        sb.append(".");
        sb.append((int)val.charAt(7));
        IRubyObject[] result = new IRubyObject[]{context.getRuntime().newFixnum(port), context.getRuntime().newString(sb.toString())};
        return context.getRuntime().newArrayNoCopy(result);
    }

    @Deprecated
    public static IRubyObject gethostbyname(IRubyObject recv2, IRubyObject hostname) {
        return RubySocket.gethostbyname(recv2.getRuntime().getCurrentContext(), recv2, hostname);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject gethostbyname(ThreadContext context, IRubyObject recv2, IRubyObject hostname) {
        try {
            InetAddress addr2 = InetAddress.getByName(hostname.convertToString().toString());
            Ruby runtime2 = context.getRuntime();
            IRubyObject[] ret = new IRubyObject[]{runtime2.newString(addr2.getCanonicalHostName()), runtime2.newArray(), runtime2.newFixnum(2), runtime2.newString(RubySocket.intoString(runtime2, addr2))};
            return runtime2.newArrayNoCopy(ret);
        }
        catch (UnknownHostException e) {
            throw RubySocket.sockerr(context.getRuntime(), "gethostbyname: name or service not known");
        }
    }

    @Deprecated
    public static IRubyObject getaddrinfo(IRubyObject recv2, IRubyObject[] args2) {
        return RubySocket.getaddrinfo(recv2.getRuntime().getCurrentContext(), recv2, args2);
    }

    @JRubyMethod(required=2, optional=4, meta=true)
    public static IRubyObject getaddrinfo(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        args2 = Arity.scanArgs(context.getRuntime(), args2, 2, 4);
        try {
            Ruby r = context.getRuntime();
            IRubyObject host = args2[0];
            IRubyObject port = args2[1];
            if (port instanceof RubyString) {
                port = RubySocket.getservbyname(context, recv2, new IRubyObject[]{port});
            }
            IRubyObject socktype = args2[3];
            boolean sock_stream = true;
            boolean sock_dgram = true;
            if (!socktype.isNil()) {
                int val = RubyNumeric.fix2int(socktype);
                if (val == 1) {
                    sock_dgram = false;
                } else if (val == 2) {
                    sock_stream = false;
                }
            }
            InetAddress[] addrs = InetAddress.getAllByName(host.isNil() ? null : host.convertToString().toString());
            ArrayList<IRubyObject> l = new ArrayList<IRubyObject>();
            for (int i = 0; i < addrs.length; ++i) {
                IRubyObject[] c;
                if (sock_dgram) {
                    c = new IRubyObject[]{r.newString("AF_INET"), port, r.newString(addrs[i].getCanonicalHostName()), r.newString(addrs[i].getHostAddress()), r.newFixnum(2), r.newFixnum(2), r.newFixnum(17)};
                    l.add(r.newArrayNoCopy(c));
                }
                if (!sock_stream) continue;
                c = new IRubyObject[]{r.newString("AF_INET"), port, r.newString(addrs[i].getCanonicalHostName()), r.newString(addrs[i].getHostAddress()), r.newFixnum(2), r.newFixnum(1), r.newFixnum(6)};
                l.add(r.newArrayNoCopy(c));
            }
            return r.newArray(l);
        }
        catch (UnknownHostException e) {
            throw RubySocket.sockerr(context.getRuntime(), "getaddrinfo: name or service not known");
        }
    }

    @Deprecated
    public static IRubyObject getnameinfo(IRubyObject recv2, IRubyObject[] args2) {
        return RubySocket.getnameinfo(recv2.getRuntime().getCurrentContext(), recv2, args2);
    }

    @JRubyMethod(required=1, optional=1, meta=true)
    public static IRubyObject getnameinfo(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        InetAddress addr2;
        String port;
        String host;
        Ruby runtime2 = context.getRuntime();
        int argc = Arity.checkArgumentCount(runtime2, args2, 1, 2);
        int flags = argc == 2 ? RubyNumeric.num2int(args2[1]) : 0;
        IRubyObject arg0 = args2[0];
        if (arg0 instanceof RubyArray) {
            List list2 = ((RubyArray)arg0).getList();
            int len = list2.size();
            if (len < 3 || len > 4) {
                throw runtime2.newArgumentError("array size should be 3 or 4, " + len + " given");
            }
            host = list2.get(2).toString();
            port = list2.get(1).toString();
        } else if (arg0 instanceof RubyString) {
            String arg2 = ((RubyString)arg0).toString();
            Matcher m = STRING_ADDRESS_PATTERN.matcher(arg2);
            if (!m.matches()) {
                throw runtime2.newArgumentError("invalid address string");
            }
            host = m.group(3);
            if (host == null || host.length() == 0 || (port = m.group(5)) == null || port.length() == 0) {
                throw runtime2.newArgumentError("invalid address string");
            }
        } else {
            throw runtime2.newArgumentError("invalid args");
        }
        try {
            addr2 = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw RubySocket.sockerr(runtime2, "unknown host: " + host);
        }
        host = (flags & 2) == 0 ? addr2.getCanonicalHostName() : addr2.getHostAddress();
        return runtime2.newArray(runtime2.newString(host), runtime2.newString(port));
    }

    @JRubyModule(name={"Socket::Constants"})
    public static class Constants {
    }

    public static class Service
    implements Library {
        public void load(Ruby runtime2, boolean wrap2) throws IOException {
            runtime2.defineClass("SocketError", runtime2.getStandardError(), runtime2.getStandardError().getAllocator());
            RubyBasicSocket.createBasicSocket(runtime2);
            RubySocket.createSocket(runtime2);
            runtime2.getInstanceConfig();
            if (RubyInstanceConfig.nativeEnabled && RubyUNIXSocket.tryUnixDomainSocket()) {
                RubyUNIXSocket.createUNIXSocket(runtime2);
                RubyUNIXServer.createUNIXServer(runtime2);
            }
            RubyIPSocket.createIPSocket(runtime2);
            RubyTCPSocket.createTCPSocket(runtime2);
            RubyTCPServer.createTCPServer(runtime2);
            RubyUDPSocket.createUDPSocket(runtime2);
        }
    }

    @JRubyClass(name={"SocketError"}, parent="StandardError")
    public static class SocketError {
    }
}

