/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.common.IRubyWarnings;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXHandler;

public class JRubyPOSIXHandler
implements POSIXHandler {
    private final Ruby runtime;
    private final boolean isVerbose;

    public JRubyPOSIXHandler(Ruby runtime2) {
        this.runtime = runtime2;
        boolean verbose = false;
        try {
            verbose = Boolean.getBoolean("jruby.native.verbose");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.isVerbose = verbose;
    }

    public void error(POSIX.ERRORS error, String extraData) {
        switch (error) {
            case ENOENT: {
                throw this.runtime.newErrnoENOENTError("No such file or directory - " + extraData);
            }
        }
    }

    public void unimplementedError(String method2) {
        throw this.runtime.newNotImplementedError(method2 + " unsupported on this platform");
    }

    public void warn(POSIXHandler.WARNING_ID id2, String message2, Object ... data) {
        IRubyWarnings.ID ourID = id2 == POSIXHandler.WARNING_ID.DUMMY_VALUE_USED ? IRubyWarnings.ID.DUMMY_VALUE_USED : IRubyWarnings.ID.MISCELLANEOUS;
        this.runtime.getWarnings().warn(ourID, message2, data);
    }

    public boolean isVerbose() {
        return this.isVerbose;
    }

    public File getCurrentWorkingDirectory() {
        return new File(this.runtime.getCurrentDirectory());
    }

    public String[] getEnv() {
        RubyHash hash2 = (RubyHash)this.runtime.getObject().fastGetConstant("ENV");
        int i = 0;
        String[] env = new String[hash2.size()];
        for (Map.Entry entry : hash2.directEntrySet()) {
            env[i] = entry.getKey().toString() + "=" + entry.getValue().toString();
            ++i;
        }
        return env;
    }

    public PrintStream getErrorStream() {
        return this.runtime.getErrorStream();
    }

    public InputStream getInputStream() {
        return this.runtime.getInputStream();
    }

    public int getPID() {
        return this.runtime.hashCode();
    }

    public PrintStream getOutputStream() {
        return this.runtime.getOutputStream();
    }
}

