/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.Arrays;
import jruby.objectweb.asm.Label;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyRange;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ast.NodeType;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.ArrayCallback;
import org.jruby.compiler.BodyCompiler;
import org.jruby.compiler.BranchCallback;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.InvocationCompiler;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.VariableCompiler;
import org.jruby.compiler.impl.ASMClassBodyCompiler;
import org.jruby.compiler.impl.ChildScopedBodyCompiler;
import org.jruby.compiler.impl.RootScopedBodyCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.compiler.impl.StandardInvocationCompiler;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.InstanceVariables;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;

public abstract class BaseBodyCompiler
implements BodyCompiler {
    protected SkinnyMethodAdapter method;
    protected VariableCompiler variableCompiler;
    protected InvocationCompiler invocationCompiler;
    protected int argParamCount;
    protected Label[] currentLoopLabels;
    protected Label scopeStart = new Label();
    protected Label scopeEnd = new Label();
    protected Label redoJump;
    protected boolean inNestedMethod = false;
    private int lastLine = -1;
    private int lastPositionLine = -1;
    protected StaticScope scope;
    protected ASTInspector inspector;
    protected String methodName;
    protected StandardASMCompiler script;

    public BaseBodyCompiler(StandardASMCompiler scriptCompiler, String methodName, ASTInspector inspector, StaticScope scope) {
        this.script = scriptCompiler;
        this.scope = scope;
        this.inspector = inspector;
        this.methodName = methodName;
        this.argParamCount = scope.getRestArg() >= 0 || scope.getOptionalArgs() > 0 || scope.getRequiredArgs() > 3 ? 1 : scope.getRequiredArgs();
        this.method = new SkinnyMethodAdapter(this.script.getClassVisitor().visitMethod(1, methodName, this.getSignature(), null, null));
        this.createVariableCompiler();
        if (StandardASMCompiler.invDynInvCompilerConstructor != null) {
            try {
                this.invocationCompiler = (InvocationCompiler)StandardASMCompiler.invDynInvCompilerConstructor.newInstance(this, this.method);
            }
            catch (InstantiationException ie) {
            }
            catch (IllegalAccessException ie) {
            }
            catch (InvocationTargetException ie) {
                // empty catch block
            }
        }
        if (this.invocationCompiler == null) {
            this.invocationCompiler = new StandardInvocationCompiler(this, this.method);
        }
    }

    protected abstract String getSignature();

    protected abstract void createVariableCompiler();

    public abstract void beginMethod(CompilerCallback var1, StaticScope var2);

    public abstract void endBody();

    public BodyCompiler chainToMethod(String methodName) {
        BaseBodyCompiler compiler = this.outline(methodName);
        this.endBody();
        return compiler;
    }

    public abstract BaseBodyCompiler outline(String var1);

    public StandardASMCompiler getScriptCompiler() {
        return this.script;
    }

    public void lineNumber(ISourcePosition position) {
        int thisLine = position.getStartLine();
        if (thisLine == this.lastLine) {
            return;
        }
        this.lastLine = thisLine;
        Label line = new Label();
        this.method.label(line);
        this.method.visitLineNumber(thisLine + 1, line);
    }

    public void loadThreadContext() {
        this.method.aload(1);
    }

    public void loadSelf() {
        this.method.aload(2);
    }

    protected int getClosureIndex() {
        return 3 + this.argParamCount + 0;
    }

    protected int getRuntimeIndex() {
        return 3 + this.argParamCount + 2;
    }

    protected int getNilIndex() {
        return 3 + this.argParamCount + 4;
    }

    protected int getPreviousExceptionIndex() {
        return 3 + this.argParamCount + 6;
    }

    protected int getDynamicScopeIndex() {
        return 3 + this.argParamCount + 1;
    }

    protected int getVarsArrayIndex() {
        return 3 + this.argParamCount + 3;
    }

    protected int getFirstTempIndex() {
        return 3 + this.argParamCount + 7;
    }

    protected int getExceptionIndex() {
        return 3 + this.argParamCount + 5;
    }

    public void loadThis() {
        this.method.aload(0);
    }

    public void loadRuntime() {
        this.method.aload(this.getRuntimeIndex());
    }

    public void loadBlock() {
        this.method.aload(this.getClosureIndex());
    }

    public void loadNil() {
        this.method.aload(this.getNilIndex());
    }

    public void loadNull() {
        this.method.aconst_null();
    }

    public void loadSymbol(String symbol) {
        this.loadRuntime();
        this.method.ldc(symbol);
        this.invokeIRuby("newSymbol", CodegenUtils.sig(RubySymbol.class, CodegenUtils.params(String.class)));
    }

    public void loadObject() {
        this.loadRuntime();
        this.invokeIRuby("getObject", CodegenUtils.sig(RubyClass.class, CodegenUtils.params(new Class[0])));
    }

    public void invokeUtilityMethod(String methodName, String signature) {
        this.method.invokestatic(CodegenUtils.p(RuntimeHelpers.class), methodName, signature);
    }

    public void invokeThreadContext(String methodName, String signature) {
        this.method.invokevirtual(StandardASMCompiler.THREADCONTEXT, methodName, signature);
    }

    public void invokeIRuby(String methodName, String signature) {
        this.method.invokevirtual(StandardASMCompiler.RUBY, methodName, signature);
    }

    public void invokeIRubyObject(String methodName, String signature) {
        this.method.invokeinterface(StandardASMCompiler.IRUBYOBJECT, methodName, signature);
    }

    public void consumeCurrentValue() {
        this.method.pop();
    }

    public void duplicateCurrentValue() {
        this.method.dup();
    }

    public void swapValues() {
        this.method.swap();
    }

    public void retrieveSelf() {
        this.loadSelf();
    }

    public void retrieveSelfClass() {
        this.loadSelf();
        this.metaclass();
    }

    public VariableCompiler getVariableCompiler() {
        return this.variableCompiler;
    }

    public InvocationCompiler getInvocationCompiler() {
        return this.invocationCompiler;
    }

    public void assignConstantInCurrent(String name2) {
        this.loadThreadContext();
        this.method.ldc(name2);
        this.method.dup2_x1();
        this.method.pop2();
        this.invokeThreadContext("setConstantInCurrent", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class, IRubyObject.class)));
    }

    public void assignConstantInModule(String name2) {
        this.method.ldc(name2);
        this.loadThreadContext();
        this.invokeUtilityMethod("setConstantInModule", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, IRubyObject.class, String.class, ThreadContext.class));
    }

    public void assignConstantInObject(String name2) {
        this.loadRuntime();
        this.invokeIRuby("getObject", CodegenUtils.sig(RubyClass.class, CodegenUtils.params(new Class[0])));
        this.method.swap();
        this.assignConstantInModule(name2);
    }

    public void retrieveConstant(String name2) {
        this.script.getCacheCompiler().cacheConstant(this, name2);
    }

    public void retrieveConstantFromModule(String name2) {
        this.method.visitTypeInsn(192, CodegenUtils.p(RubyModule.class));
        this.method.ldc(name2);
        this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "fastGetConstantFrom", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class)));
    }

    public void retrieveClassVariable(String name2) {
        this.loadThreadContext();
        this.loadRuntime();
        this.loadSelf();
        this.method.ldc(name2);
        this.invokeUtilityMethod("fastFetchClassVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, Ruby.class, IRubyObject.class, String.class)));
    }

    public void assignClassVariable(String name2) {
        this.loadThreadContext();
        this.method.swap();
        this.loadRuntime();
        this.method.swap();
        this.loadSelf();
        this.method.swap();
        this.method.ldc(name2);
        this.method.swap();
        this.invokeUtilityMethod("fastSetClassVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, Ruby.class, IRubyObject.class, String.class, IRubyObject.class)));
    }

    public void assignClassVariable(String name2, CompilerCallback value2) {
        this.loadThreadContext();
        this.loadRuntime();
        this.loadSelf();
        this.method.ldc(name2);
        value2.call(this);
        this.invokeUtilityMethod("fastSetClassVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, Ruby.class, IRubyObject.class, String.class, IRubyObject.class)));
    }

    public void declareClassVariable(String name2) {
        this.loadThreadContext();
        this.method.swap();
        this.loadRuntime();
        this.method.swap();
        this.loadSelf();
        this.method.swap();
        this.method.ldc(name2);
        this.method.swap();
        this.invokeUtilityMethod("fastDeclareClassVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, Ruby.class, IRubyObject.class, String.class, IRubyObject.class)));
    }

    public void declareClassVariable(String name2, CompilerCallback value2) {
        this.loadThreadContext();
        this.loadRuntime();
        this.loadSelf();
        this.method.ldc(name2);
        value2.call(this);
        this.invokeUtilityMethod("fastDeclareClassVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, Ruby.class, IRubyObject.class, String.class, IRubyObject.class)));
    }

    public void createNewFloat(double value2) {
        this.loadRuntime();
        this.method.ldc(new Double(value2));
        this.invokeIRuby("newFloat", CodegenUtils.sig(RubyFloat.class, CodegenUtils.params(Double.TYPE)));
    }

    public void createNewFixnum(long value2) {
        this.script.getCacheCompiler().cacheFixnum(this, value2);
    }

    public void createNewBignum(BigInteger value2) {
        this.loadRuntime();
        this.script.getCacheCompiler().cacheBigInteger(this, value2);
        this.method.invokestatic(CodegenUtils.p(RubyBignum.class), "newBignum", CodegenUtils.sig(RubyBignum.class, CodegenUtils.params(Ruby.class, BigInteger.class)));
    }

    public void createNewString(ArrayCallback callback, int count2) {
        this.loadRuntime();
        this.invokeIRuby("newString", CodegenUtils.sig(RubyString.class, CodegenUtils.params(new Class[0])));
        for (int i = 0; i < count2; ++i) {
            callback.nextValue(this, null, i);
            this.method.invokevirtual(CodegenUtils.p(RubyString.class), "append", CodegenUtils.sig(RubyString.class, CodegenUtils.params(IRubyObject.class)));
        }
    }

    public void createNewSymbol(ArrayCallback callback, int count2) {
        this.loadRuntime();
        this.createNewString(callback, count2);
        this.toJavaString();
        this.invokeIRuby("newSymbol", CodegenUtils.sig(RubySymbol.class, CodegenUtils.params(String.class)));
    }

    public void createNewString(ByteList value2) {
        this.loadRuntime();
        this.script.getCacheCompiler().cacheByteList(this, value2);
        this.invokeIRuby("newStringShared", CodegenUtils.sig(RubyString.class, CodegenUtils.params(ByteList.class)));
    }

    public void createNewSymbol(String name2) {
        this.script.getCacheCompiler().cacheSymbol(this, name2);
    }

    public void createNewArray(boolean lightweight) {
        this.loadRuntime();
        this.method.swap();
        if (lightweight) {
            this.method.invokestatic(CodegenUtils.p(RubyArray.class), "newArrayNoCopyLight", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(Ruby.class, IRubyObject[].class)));
        } else {
            this.method.invokestatic(CodegenUtils.p(RubyArray.class), "newArrayNoCopy", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(Ruby.class, IRubyObject[].class)));
        }
    }

    public void createNewArray(Object[] sourceArray, ArrayCallback callback, boolean lightweight) {
        this.loadRuntime();
        this.createObjectArray(sourceArray, callback);
        if (lightweight) {
            this.method.invokestatic(CodegenUtils.p(RubyArray.class), "newArrayNoCopyLight", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(Ruby.class, IRubyObject[].class)));
        } else {
            this.method.invokestatic(CodegenUtils.p(RubyArray.class), "newArrayNoCopy", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(Ruby.class, IRubyObject[].class)));
        }
    }

    public void createEmptyArray() {
        this.loadRuntime();
        this.invokeIRuby("newArray", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(new Class[0])));
    }

    public void createObjectArray(Object[] sourceArray, ArrayCallback callback) {
        this.buildObjectArray(StandardASMCompiler.IRUBYOBJECT, sourceArray, callback);
    }

    public void createObjectArray(int elementCount) {
        if (elementCount >= 6) {
            throw new NotCompilableException("Don't use createObjectArray(int) for more than 5 elements");
        }
        Object[] params2 = new Class[elementCount];
        Arrays.fill(params2, IRubyObject.class);
        this.invokeUtilityMethod("constructObjectArray", CodegenUtils.sig(IRubyObject[].class, (Class[])params2));
    }

    private void buildObjectArray(String type2, Object[] sourceArray, ArrayCallback callback) {
        if (sourceArray.length == 0) {
            this.method.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
        } else if (sourceArray.length <= 5) {
            for (int i = 0; i < sourceArray.length; ++i) {
                callback.nextValue(this, sourceArray, i);
            }
            this.invokeUtilityMethod("constructObjectArray", CodegenUtils.sig(IRubyObject[].class, CodegenUtils.params(IRubyObject.class, sourceArray.length)));
        } else {
            this.method.pushInt(sourceArray.length);
            this.method.anewarray(type2);
            for (int i = 0; i < sourceArray.length; ++i) {
                this.method.dup();
                this.method.pushInt(i);
                callback.nextValue(this, sourceArray, i);
                this.method.arraystore();
            }
        }
    }

    public void createEmptyHash() {
        this.loadRuntime();
        this.method.invokestatic(CodegenUtils.p(RubyHash.class), "newHash", CodegenUtils.sig(RubyHash.class, CodegenUtils.params(Ruby.class)));
    }

    public void createNewHash(Object elements, ArrayCallback callback, int keyCount) {
        this.loadRuntime();
        if (keyCount <= 3) {
            for (int i = 0; i < keyCount; ++i) {
                callback.nextValue(this, elements, i);
            }
            this.invokeUtilityMethod("constructHash", CodegenUtils.sig(RubyHash.class, CodegenUtils.params(Ruby.class, IRubyObject.class, keyCount * 2)));
        } else {
            this.method.invokestatic(CodegenUtils.p(RubyHash.class), "newHash", CodegenUtils.sig(RubyHash.class, CodegenUtils.params(Ruby.class)));
            for (int i = 0; i < keyCount; ++i) {
                this.method.dup();
                callback.nextValue(this, elements, i);
                this.method.invokevirtual(CodegenUtils.p(RubyHash.class), "fastASet", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(IRubyObject.class, IRubyObject.class)));
            }
        }
    }

    public void createNewRange(boolean isExclusive) {
        this.loadRuntime();
        this.loadThreadContext();
        this.method.dup2_x2();
        this.method.pop2();
        if (isExclusive) {
            this.method.invokestatic(CodegenUtils.p(RubyRange.class), "newExclusiveRange", CodegenUtils.sig(RubyRange.class, CodegenUtils.params(Ruby.class, ThreadContext.class, IRubyObject.class, IRubyObject.class)));
        } else {
            this.method.invokestatic(CodegenUtils.p(RubyRange.class), "newInclusiveRange", CodegenUtils.sig(RubyRange.class, CodegenUtils.params(Ruby.class, ThreadContext.class, IRubyObject.class, IRubyObject.class)));
        }
    }

    private void isTrue() {
        this.invokeIRubyObject("isTrue", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
    }

    public void performBooleanBranch(BranchCallback trueBranch, BranchCallback falseBranch) {
        Label afterJmp = new Label();
        Label falseJmp = new Label();
        this.isTrue();
        this.method.ifeq(falseJmp);
        trueBranch.branch(this);
        this.method.go_to(afterJmp);
        this.method.label(falseJmp);
        falseBranch.branch(this);
        this.method.label(afterJmp);
    }

    public void performLogicalAnd(BranchCallback longBranch) {
        Label falseJmp = new Label();
        this.method.dup();
        this.isTrue();
        this.method.ifeq(falseJmp);
        this.method.pop();
        longBranch.branch(this);
        this.method.label(falseJmp);
    }

    public void performLogicalOr(BranchCallback longBranch) {
        Label falseJmp = new Label();
        this.method.dup();
        this.isTrue();
        this.method.ifne(falseJmp);
        this.method.pop();
        longBranch.branch(this);
        this.method.label(falseJmp);
    }

    public void performBooleanLoopSafe(BranchCallback condition, BranchCallback body, boolean checkFirst) {
        String mname = this.getNewRescueName();
        BaseBodyCompiler nested = this.outline(mname);
        nested.performBooleanLoopSafeInner(condition, body, checkFirst);
    }

    private void performBooleanLoopSafeInner(BranchCallback condition, BranchCallback body, boolean checkFirst) {
        this.performBooleanLoop(condition, body, checkFirst);
        this.endBody();
    }

    public void performBooleanLoop(BranchCallback condition, final BranchCallback body, boolean checkFirst) {
        Label tryBegin = new Label();
        Label tryEnd = new Label();
        Label catchNext = new Label();
        Label catchBreak = new Label();
        Label endOfBody = new Label();
        Label conditionCheck = new Label();
        final Label topOfBody = new Label();
        Label done = new Label();
        Label normalLoopEnd = new Label();
        this.method.trycatch(tryBegin, tryEnd, catchNext, CodegenUtils.p(JumpException.NextJump.class));
        this.method.trycatch(tryBegin, tryEnd, catchBreak, CodegenUtils.p(JumpException.BreakJump.class));
        this.method.label(tryBegin);
        Label[] oldLoopLabels = this.currentLoopLabels;
        this.currentLoopLabels = new Label[]{endOfBody, topOfBody, done};
        if (checkFirst) {
            this.method.go_to(conditionCheck);
        }
        this.method.label(topOfBody);
        Runnable redoBody = new Runnable(){

            public void run() {
                Runnable raiseBody = new Runnable(){

                    public void run() {
                        body.branch(BaseBodyCompiler.this);
                    }
                };
                Runnable raiseCatch = new Runnable(){

                    public void run() {
                        BaseBodyCompiler.this.loadThreadContext();
                        BaseBodyCompiler.this.invokeUtilityMethod("unwrapRedoNextBreakOrJustLocalJump", CodegenUtils.sig(Throwable.class, RaiseException.class, ThreadContext.class));
                        BaseBodyCompiler.this.method.athrow();
                    }
                };
                BaseBodyCompiler.this.method.trycatch(CodegenUtils.p(RaiseException.class), raiseBody, raiseCatch);
            }
        };
        Runnable redoCatch = new Runnable(){

            public void run() {
                BaseBodyCompiler.this.method.pop();
                BaseBodyCompiler.this.method.go_to(topOfBody);
            }
        };
        this.method.trycatch(CodegenUtils.p(JumpException.RedoJump.class), redoBody, redoCatch);
        this.method.label(endOfBody);
        this.method.pop();
        this.method.label(conditionCheck);
        condition.branch(this);
        this.isTrue();
        this.method.ifne(topOfBody);
        this.currentLoopLabels = oldLoopLabels;
        this.method.label(tryEnd);
        this.method.go_to(normalLoopEnd);
        this.method.label(catchNext);
        this.method.pop();
        this.method.go_to(conditionCheck);
        this.method.label(catchBreak);
        this.loadThreadContext();
        this.invokeUtilityMethod("breakJumpInWhile", CodegenUtils.sig(IRubyObject.class, JumpException.BreakJump.class, ThreadContext.class));
        this.method.go_to(done);
        this.method.label(normalLoopEnd);
        this.loadNil();
        this.method.label(done);
    }

    public void performBooleanLoopLight(BranchCallback condition, BranchCallback body, boolean checkFirst) {
        Label endOfBody = new Label();
        Label conditionCheck = new Label();
        Label topOfBody = new Label();
        Label done = new Label();
        Label[] oldLoopLabels = this.currentLoopLabels;
        this.currentLoopLabels = new Label[]{endOfBody, topOfBody, done};
        if (checkFirst) {
            this.method.go_to(conditionCheck);
        }
        this.method.label(topOfBody);
        body.branch(this);
        this.method.label(endOfBody);
        this.method.pop();
        this.method.label(conditionCheck);
        condition.branch(this);
        this.isTrue();
        this.method.ifne(topOfBody);
        this.currentLoopLabels = oldLoopLabels;
        this.loadNil();
        this.method.label(done);
    }

    public void createNewClosure(int line, StaticScope scope, int arity2, CompilerCallback body, CompilerCallback args2, boolean hasMultipleArgsHead, NodeType argsNodeId, ASTInspector inspector) {
        String closureMethodName = "block_" + this.script.getAndIncrementInnerIndex() + "$RUBY$" + "__block__";
        ChildScopedBodyCompiler closureCompiler = new ChildScopedBodyCompiler(this.script, closureMethodName, inspector, scope);
        closureCompiler.beginMethod(args2, scope);
        body.call(closureCompiler);
        closureCompiler.endBody();
        this.loadThreadContext();
        this.loadSelf();
        this.script.getCacheCompiler().cacheClosure(this, closureMethodName, arity2, scope, hasMultipleArgsHead, argsNodeId, inspector);
        this.invokeUtilityMethod("createBlock", CodegenUtils.sig(Block.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, BlockBody.class)));
    }

    public void runBeginBlock(StaticScope scope, CompilerCallback body) {
        String closureMethodName = "block_" + this.script.getAndIncrementInnerIndex() + "$RUBY$__begin__";
        ChildScopedBodyCompiler closureCompiler = new ChildScopedBodyCompiler(this.script, closureMethodName, null, scope);
        closureCompiler.beginMethod(null, scope);
        body.call(closureCompiler);
        closureCompiler.endBody();
        this.loadThreadContext();
        this.loadSelf();
        StandardASMCompiler.buildStaticScopeNames(this.method, scope);
        this.script.getCacheCompiler().cacheClosureOld(this, closureMethodName);
        this.invokeUtilityMethod("runBeginBlock", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, String[].class, CompiledBlockCallback.class)));
    }

    public void createNewForLoop(int arity2, CompilerCallback body, CompilerCallback args2, boolean hasMultipleArgsHead, NodeType argsNodeId) {
        String closureMethodName = "block_" + this.script.getAndIncrementInnerIndex() + "$RUBY$__for__";
        ChildScopedBodyCompiler closureCompiler = new ChildScopedBodyCompiler(this.script, closureMethodName, null, this.scope);
        closureCompiler.beginMethod(args2, null);
        body.call(closureCompiler);
        closureCompiler.endBody();
        this.loadThreadContext();
        this.loadSelf();
        this.method.pushInt(arity2);
        this.script.getCacheCompiler().cacheClosureOld(this, closureMethodName);
        this.method.ldc(hasMultipleArgsHead);
        this.method.ldc(BlockBody.asArgumentType(argsNodeId));
        this.invokeUtilityMethod("createSharedScopeBlock", CodegenUtils.sig(Block.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, Integer.TYPE, CompiledBlockCallback.class, Boolean.TYPE, Integer.TYPE)));
    }

    public void createNewEndBlock(CompilerCallback body) {
        String closureMethodName = "block_" + this.script.getAndIncrementInnerIndex() + "$RUBY$__end__";
        ChildScopedBodyCompiler closureCompiler = new ChildScopedBodyCompiler(this.script, closureMethodName, null, this.scope);
        closureCompiler.beginMethod(null, null);
        body.call(closureCompiler);
        closureCompiler.endBody();
        this.loadThreadContext();
        this.loadSelf();
        this.method.iconst_0();
        this.script.getCacheCompiler().cacheClosureOld(this, closureMethodName);
        this.method.iconst_0();
        this.method.iconst_0();
        this.invokeUtilityMethod("createSharedScopeBlock", CodegenUtils.sig(Block.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, Integer.TYPE, CompiledBlockCallback.class, Boolean.TYPE, Integer.TYPE)));
        this.loadRuntime();
        this.invokeUtilityMethod("registerEndBlock", CodegenUtils.sig(Void.TYPE, Block.class, Ruby.class));
        this.loadNil();
    }

    public void getCompiledClass() {
        this.method.aload(0);
        this.method.getfield(this.script.getClassname(), "$class", CodegenUtils.ci(Class.class));
    }

    public void println() {
        this.method.dup();
        this.method.getstatic(CodegenUtils.p(System.class), "out", CodegenUtils.ci(PrintStream.class));
        this.method.swap();
        this.method.invokevirtual(CodegenUtils.p(PrintStream.class), "println", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Object.class)));
    }

    public void defineAlias(String newName, String oldName) {
        this.loadThreadContext();
        this.method.ldc(newName);
        this.method.ldc(oldName);
        this.invokeUtilityMethod("defineAlias", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, String.class, String.class));
    }

    public void loadFalse() {
        this.loadRuntime();
        this.invokeIRuby("getFalse", CodegenUtils.sig(RubyBoolean.class, new Class[0]));
    }

    public void loadTrue() {
        this.loadRuntime();
        this.invokeIRuby("getTrue", CodegenUtils.sig(RubyBoolean.class, new Class[0]));
    }

    public void loadCurrentModule() {
        this.loadThreadContext();
        this.invokeThreadContext("getCurrentScope", CodegenUtils.sig(DynamicScope.class, new Class[0]));
        this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getStaticScope", CodegenUtils.sig(StaticScope.class, new Class[0]));
        this.method.invokevirtual(CodegenUtils.p(StaticScope.class), "getModule", CodegenUtils.sig(RubyModule.class, new Class[0]));
    }

    public void retrieveInstanceVariable(String name2) {
        this.loadSelf();
        this.loadRuntime();
        this.method.ldc(name2);
        this.invokeUtilityMethod("getInstanceVariable", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, Ruby.class, String.class));
    }

    public void assignInstanceVariable(String name2) {
        this.loadSelf();
        this.method.ldc(name2);
        this.invokeUtilityMethod("setInstanceVariable", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, IRubyObject.class, String.class));
    }

    public void assignInstanceVariable(String name2, CompilerCallback value2) {
        value2.call(this);
        this.loadSelf();
        this.method.ldc(name2);
        this.invokeUtilityMethod("setInstanceVariable", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, IRubyObject.class, String.class));
    }

    public void retrieveGlobalVariable(String name2) {
        this.loadRuntime();
        this.method.ldc(name2);
        this.invokeUtilityMethod("getGlobalVariable", CodegenUtils.sig(IRubyObject.class, Ruby.class, String.class));
    }

    public void assignGlobalVariable(String name2) {
        this.loadRuntime();
        this.method.ldc(name2);
        this.invokeUtilityMethod("setGlobalVariable", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, Ruby.class, String.class));
    }

    public void assignGlobalVariable(String name2, CompilerCallback value2) {
        value2.call(this);
        this.loadRuntime();
        this.method.ldc(name2);
        this.invokeUtilityMethod("setGlobalVariable", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, Ruby.class, String.class));
    }

    public void negateCurrentValue() {
        this.loadRuntime();
        this.invokeUtilityMethod("negate", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, Ruby.class));
    }

    public void splatCurrentValue() {
        this.method.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "splatValue", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(IRubyObject.class)));
    }

    public void singlifySplattedValue() {
        this.method.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "aValueSplat", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
    }

    public void aryToAry() {
        this.method.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "aryToAry", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
    }

    public void ensureRubyArray() {
        this.invokeUtilityMethod("ensureRubyArray", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(IRubyObject.class)));
    }

    public void ensureMultipleAssignableRubyArray(boolean masgnHasHead) {
        this.loadRuntime();
        this.method.pushBoolean(masgnHasHead);
        this.invokeUtilityMethod("ensureMultipleAssignableRubyArray", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(IRubyObject.class, Ruby.class, Boolean.TYPE)));
    }

    public void forEachInValueArray(int start2, int count2, Object source2, ArrayCallback callback, ArrayCallback nilCallback, CompilerCallback argsCallback) {
        while (start2 < count2) {
            this.method.dup();
            this.loadNil();
            this.method.pushInt(start2);
            this.invokeUtilityMethod("arrayEntryOrNil", CodegenUtils.sig(IRubyObject.class, RubyArray.class, IRubyObject.class, Integer.TYPE));
            callback.nextValue(this, source2, start2);
            this.method.pop();
            ++start2;
        }
        if (argsCallback != null) {
            this.method.dup();
            this.loadRuntime();
            this.method.pushInt(start2);
            this.invokeUtilityMethod("subarrayOrEmpty", CodegenUtils.sig(RubyArray.class, RubyArray.class, Ruby.class, Integer.TYPE));
            argsCallback.call(this);
            this.method.pop();
        }
    }

    public void asString() {
        this.method.invokeinterface(CodegenUtils.p(IRubyObject.class), "asString", CodegenUtils.sig(RubyString.class, new Class[0]));
    }

    public void toJavaString() {
        this.method.invokevirtual(CodegenUtils.p(Object.class), "toString", CodegenUtils.sig(String.class, new Class[0]));
    }

    public void nthRef(int match2) {
        this.method.pushInt(match2);
        this.backref();
        this.method.invokestatic(CodegenUtils.p(RubyRegexp.class), "nth_match", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Integer.TYPE, IRubyObject.class)));
    }

    public void match() {
        this.loadThreadContext();
        this.method.invokevirtual(CodegenUtils.p(RubyRegexp.class), "op_match2", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
    }

    public void match2() {
        this.loadThreadContext();
        this.method.swap();
        this.method.invokevirtual(CodegenUtils.p(RubyRegexp.class), "op_match", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class)));
    }

    public void match3() {
        this.loadThreadContext();
        this.invokeUtilityMethod("match3", CodegenUtils.sig(IRubyObject.class, RubyRegexp.class, IRubyObject.class, ThreadContext.class));
    }

    public void createNewRegexp(ByteList value2, int options2) {
        String regexpField = this.script.getNewConstant(CodegenUtils.ci(RubyRegexp.class), "lit_reg_");
        this.method.aload(0);
        this.method.getfield(this.script.getClassname(), regexpField, CodegenUtils.ci(RubyRegexp.class));
        Label alreadyCreated = new Label();
        this.method.ifnonnull(alreadyCreated);
        String regexpString = value2.toString();
        this.loadRuntime();
        this.method.ldc(regexpString);
        this.method.pushInt(options2);
        this.method.invokestatic(CodegenUtils.p(RubyRegexp.class), "newRegexp", CodegenUtils.sig(RubyRegexp.class, CodegenUtils.params(Ruby.class, String.class, Integer.TYPE)));
        this.method.aload(0);
        this.method.swap();
        this.method.putfield(this.script.getClassname(), regexpField, CodegenUtils.ci(RubyRegexp.class));
        this.method.label(alreadyCreated);
        this.method.aload(0);
        this.method.getfield(this.script.getClassname(), regexpField, CodegenUtils.ci(RubyRegexp.class));
    }

    public void createNewRegexp(CompilerCallback createStringCallback, int options2) {
        boolean onceOnly = (options2 & 0x80) != 0;
        Label alreadyCreated = null;
        String regexpField = null;
        if (onceOnly) {
            regexpField = this.script.getNewConstant(CodegenUtils.ci(RubyRegexp.class), "lit_reg_");
            this.method.aload(0);
            this.method.getfield(this.script.getClassname(), regexpField, CodegenUtils.ci(RubyRegexp.class));
            alreadyCreated = new Label();
            this.method.ifnonnull(alreadyCreated);
        }
        this.loadRuntime();
        createStringCallback.call(this);
        this.method.invokevirtual(CodegenUtils.p(RubyString.class), "getByteList", CodegenUtils.sig(ByteList.class, new Class[0]));
        this.method.pushInt(options2);
        this.method.invokestatic(CodegenUtils.p(RubyRegexp.class), "newRegexp", CodegenUtils.sig(RubyRegexp.class, CodegenUtils.params(Ruby.class, ByteList.class, Integer.TYPE)));
        if (onceOnly) {
            this.method.aload(0);
            this.method.swap();
            this.method.putfield(this.script.getClassname(), regexpField, CodegenUtils.ci(RubyRegexp.class));
            this.method.label(alreadyCreated);
            this.method.aload(0);
            this.method.getfield(this.script.getClassname(), regexpField, CodegenUtils.ci(RubyRegexp.class));
        }
    }

    public void pollThreadEvents() {
        if (!RubyInstanceConfig.THREADLESS_COMPILE_ENABLED) {
            this.loadThreadContext();
            this.invokeThreadContext("pollThreadEvents", CodegenUtils.sig(Void.TYPE, new Class[0]));
        }
    }

    public void nullToNil() {
        Label notNull = new Label();
        this.method.dup();
        this.method.ifnonnull(notNull);
        this.method.pop();
        this.loadNil();
        this.method.label(notNull);
    }

    public void isInstanceOf(Class clazz, BranchCallback trueBranch, BranchCallback falseBranch) {
        this.method.instance_of(CodegenUtils.p(clazz));
        Label falseJmp = new Label();
        Label afterJmp = new Label();
        this.method.ifeq(falseJmp);
        trueBranch.branch(this);
        this.method.go_to(afterJmp);
        this.method.label(falseJmp);
        falseBranch.branch(this);
        this.method.label(afterJmp);
    }

    public void isCaptured(final int number, final BranchCallback trueBranch, final BranchCallback falseBranch) {
        this.backref();
        this.method.dup();
        this.isInstanceOf(RubyMatchData.class, new BranchCallback(){

            public void branch(BodyCompiler context) {
                BaseBodyCompiler.this.method.visitTypeInsn(192, CodegenUtils.p(RubyMatchData.class));
                BaseBodyCompiler.this.method.dup();
                BaseBodyCompiler.this.method.invokevirtual(CodegenUtils.p(RubyMatchData.class), "use", CodegenUtils.sig(Void.TYPE, new Class[0]));
                BaseBodyCompiler.this.method.pushInt(number);
                BaseBodyCompiler.this.method.invokevirtual(CodegenUtils.p(RubyMatchData.class), "group", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Integer.TYPE)));
                BaseBodyCompiler.this.method.invokeinterface(CodegenUtils.p(IRubyObject.class), "isNil", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
                Label isNil = new Label();
                Label after = new Label();
                BaseBodyCompiler.this.method.ifne(isNil);
                trueBranch.branch(context);
                BaseBodyCompiler.this.method.go_to(after);
                BaseBodyCompiler.this.method.label(isNil);
                falseBranch.branch(context);
                BaseBodyCompiler.this.method.label(after);
            }
        }, new BranchCallback(){

            public void branch(BodyCompiler context) {
                BaseBodyCompiler.this.method.pop();
                falseBranch.branch(context);
            }
        });
    }

    public void branchIfModule(CompilerCallback receiverCallback, BranchCallback moduleCallback, BranchCallback notModuleCallback, boolean mustBeModule) {
        receiverCallback.call(this);
        this.invokeUtilityMethod("checkIsModule", CodegenUtils.sig(RubyModule.class, IRubyObject.class));
        this.isInstanceOf(RubyModule.class, moduleCallback, notModuleCallback);
    }

    public void backref() {
        this.loadThreadContext();
        this.invokeThreadContext("getCurrentFrame", CodegenUtils.sig(Frame.class, new Class[0]));
        this.method.invokevirtual(CodegenUtils.p(Frame.class), "getBackRef", CodegenUtils.sig(IRubyObject.class, new Class[0]));
    }

    public void backrefMethod(String methodName) {
        this.backref();
        this.method.invokestatic(CodegenUtils.p(RubyRegexp.class), methodName, CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
    }

    public void issueLoopBreak() {
        this.method.go_to(this.currentLoopLabels[2]);
    }

    public void issueLoopNext() {
        this.method.go_to(this.currentLoopLabels[0]);
    }

    public void issueLoopRedo() {
        this.method.go_to(this.currentLoopLabels[1]);
    }

    protected String getNewEnsureName() {
        return "ensure_" + this.script.getAndIncrementEnsureNumber() + "$RUBY$__ensure__";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void protect(BranchCallback regularCode, BranchCallback protectedCode, Class ret) {
        String mname = this.getNewEnsureName();
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(this.script.getClassVisitor().visitMethod(4097, mname, CodegenUtils.sig(ret, ThreadContext.class, IRubyObject.class, Block.class), null, null));
        SkinnyMethodAdapter old_method = null;
        SkinnyMethodAdapter var_old_method = null;
        SkinnyMethodAdapter inv_old_method = null;
        boolean oldInNestedMethod = this.inNestedMethod;
        this.inNestedMethod = true;
        Label[] oldLoopLabels = this.currentLoopLabels;
        this.currentLoopLabels = null;
        int oldArgCount = this.argParamCount;
        this.argParamCount = 0;
        try {
            old_method = this.method;
            var_old_method = this.getVariableCompiler().getMethodAdapter();
            inv_old_method = this.getInvocationCompiler().getMethodAdapter();
            this.method = mv;
            this.getVariableCompiler().setMethodAdapter(mv);
            this.getInvocationCompiler().setMethodAdapter(mv);
            mv.visitCode();
            mv.aload(1);
            mv.dup();
            mv.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
            mv.dup();
            mv.astore(this.getRuntimeIndex());
            mv.invokevirtual(CodegenUtils.p(Ruby.class), "getNil", CodegenUtils.sig(IRubyObject.class, new Class[0]));
            mv.astore(this.getNilIndex());
            mv.invokevirtual(CodegenUtils.p(ThreadContext.class), "getCurrentScope", CodegenUtils.sig(DynamicScope.class, new Class[0]));
            mv.dup();
            mv.astore(this.getDynamicScopeIndex());
            mv.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class, new Class[0]));
            mv.astore(this.getVarsArrayIndex());
            Label codeBegin = new Label();
            Label codeEnd = new Label();
            Label ensureBegin = new Label();
            Label ensureEnd = new Label();
            this.method.label(codeBegin);
            regularCode.branch(this);
            this.method.label(codeEnd);
            protectedCode.branch(this);
            mv.areturn();
            this.method.label(ensureBegin);
            this.method.astore(this.getExceptionIndex());
            this.method.label(ensureEnd);
            protectedCode.branch(this);
            this.method.aload(this.getExceptionIndex());
            this.method.athrow();
            this.method.trycatch(codeBegin, codeEnd, ensureBegin, null);
            this.method.trycatch(ensureBegin, ensureEnd, ensureBegin, null);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
        }
        finally {
            this.method = old_method;
            this.getVariableCompiler().setMethodAdapter(var_old_method);
            this.getInvocationCompiler().setMethodAdapter(inv_old_method);
            this.inNestedMethod = oldInNestedMethod;
            this.currentLoopLabels = oldLoopLabels;
            this.argParamCount = oldArgCount;
        }
        this.method.aload(0);
        this.loadThreadContext();
        this.loadSelf();
        if (this instanceof ChildScopedBodyCompiler) {
            this.pushNull();
        } else {
            this.loadBlock();
        }
        this.method.invokevirtual(this.script.getClassname(), mname, CodegenUtils.sig(ret, ThreadContext.class, IRubyObject.class, Block.class));
    }

    public void performEnsure(BranchCallback regularCode, BranchCallback protectedCode) {
        String mname = this.getNewEnsureName();
        BaseBodyCompiler ensure = this.outline(mname);
        ensure.performEnsureInner(regularCode, protectedCode);
    }

    private void performEnsureInner(BranchCallback regularCode, BranchCallback protectedCode) {
        Label codeBegin = new Label();
        Label codeEnd = new Label();
        Label ensureBegin = new Label();
        Label ensureEnd = new Label();
        this.method.label(codeBegin);
        regularCode.branch(this);
        this.method.label(codeEnd);
        protectedCode.branch(this);
        this.method.areturn();
        this.method.label(ensureBegin);
        this.method.astore(this.getExceptionIndex());
        this.method.label(ensureEnd);
        protectedCode.branch(this);
        this.method.aload(this.getExceptionIndex());
        this.method.athrow();
        this.method.trycatch(codeBegin, codeEnd, ensureBegin, null);
        this.method.trycatch(ensureBegin, ensureEnd, ensureBegin, null);
        this.loadNil();
        this.endBody();
    }

    protected String getNewRescueName() {
        return "rescue_" + this.script.getAndIncrementRescueNumber() + "$RUBY$__rescue__";
    }

    public void storeExceptionInErrorInfo() {
        this.loadException();
        this.loadThreadContext();
        this.invokeUtilityMethod("storeExceptionInErrorInfo", CodegenUtils.sig(Void.TYPE, Exception.class, ThreadContext.class));
    }

    public void clearErrorInfo() {
        this.loadThreadContext();
        this.invokeUtilityMethod("clearErrorInfo", CodegenUtils.sig(Void.TYPE, ThreadContext.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rescue(BranchCallback regularCode, Class exception2, BranchCallback catchCode, Class ret) {
        String mname = this.getNewRescueName();
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(this.script.getClassVisitor().visitMethod(4097, mname, CodegenUtils.sig(ret, ThreadContext.class, IRubyObject.class, Block.class), null, null));
        SkinnyMethodAdapter old_method = null;
        SkinnyMethodAdapter var_old_method = null;
        SkinnyMethodAdapter inv_old_method = null;
        Label afterMethodBody = new Label();
        Label catchRetry = new Label();
        Label catchRaised = new Label();
        Label catchJumps = new Label();
        Label exitRescue = new Label();
        boolean oldWithinProtection = this.inNestedMethod;
        this.inNestedMethod = true;
        Label[] oldLoopLabels = this.currentLoopLabels;
        this.currentLoopLabels = null;
        int oldArgCount = this.argParamCount;
        this.argParamCount = 0;
        try {
            old_method = this.method;
            var_old_method = this.getVariableCompiler().getMethodAdapter();
            inv_old_method = this.getInvocationCompiler().getMethodAdapter();
            this.method = mv;
            this.getVariableCompiler().setMethodAdapter(mv);
            this.getInvocationCompiler().setMethodAdapter(mv);
            mv.start();
            mv.aload(1);
            mv.dup();
            mv.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
            mv.dup();
            mv.astore(this.getRuntimeIndex());
            this.loadRuntime();
            this.invokeUtilityMethod("getErrorInfo", CodegenUtils.sig(IRubyObject.class, Ruby.class));
            mv.astore(this.getPreviousExceptionIndex());
            mv.invokevirtual(CodegenUtils.p(Ruby.class), "getNil", CodegenUtils.sig(IRubyObject.class, new Class[0]));
            mv.astore(this.getNilIndex());
            mv.invokevirtual(CodegenUtils.p(ThreadContext.class), "getCurrentScope", CodegenUtils.sig(DynamicScope.class, new Class[0]));
            mv.dup();
            mv.astore(this.getDynamicScopeIndex());
            mv.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class, new Class[0]));
            mv.astore(this.getVarsArrayIndex());
            Label beforeBody = new Label();
            Label afterBody = new Label();
            Label catchBlock = new Label();
            mv.trycatch(beforeBody, afterBody, catchBlock, CodegenUtils.p(exception2));
            mv.label(beforeBody);
            regularCode.branch(this);
            mv.label(afterBody);
            mv.go_to(exitRescue);
            mv.label(catchBlock);
            mv.astore(this.getExceptionIndex());
            catchCode.branch(this);
            mv.label(afterMethodBody);
            mv.go_to(exitRescue);
            mv.trycatch(catchBlock, afterMethodBody, catchRetry, CodegenUtils.p(JumpException.RetryJump.class));
            mv.label(catchRetry);
            mv.pop();
            mv.go_to(beforeBody);
            mv.trycatch(beforeBody, afterMethodBody, catchRaised, CodegenUtils.p(RaiseException.class));
            mv.label(catchRaised);
            mv.athrow();
            mv.trycatch(beforeBody, afterMethodBody, catchJumps, CodegenUtils.p(JumpException.class));
            mv.label(catchJumps);
            this.loadRuntime();
            mv.aload(this.getPreviousExceptionIndex());
            this.invokeUtilityMethod("setErrorInfo", CodegenUtils.sig(Void.TYPE, Ruby.class, IRubyObject.class));
            mv.athrow();
            mv.label(exitRescue);
            this.loadRuntime();
            mv.aload(this.getPreviousExceptionIndex());
            this.invokeUtilityMethod("setErrorInfo", CodegenUtils.sig(Void.TYPE, Ruby.class, IRubyObject.class));
            mv.areturn();
            mv.end();
        }
        finally {
            this.inNestedMethod = oldWithinProtection;
            this.method = old_method;
            this.getVariableCompiler().setMethodAdapter(var_old_method);
            this.getInvocationCompiler().setMethodAdapter(inv_old_method);
            this.currentLoopLabels = oldLoopLabels;
            this.argParamCount = oldArgCount;
        }
        this.method.aload(0);
        this.loadThreadContext();
        this.loadSelf();
        if (this instanceof ChildScopedBodyCompiler) {
            this.pushNull();
        } else {
            this.loadBlock();
        }
        this.method.invokevirtual(this.script.getClassname(), mname, CodegenUtils.sig(ret, ThreadContext.class, IRubyObject.class, Block.class));
    }

    public void performRescue(BranchCallback regularCode, BranchCallback rubyCatchCode, BranchCallback javaCatchCode) {
        String mname = this.getNewRescueName();
        BaseBodyCompiler rescueMethod = this.outline(mname);
        rescueMethod.performRescueInner(regularCode, rubyCatchCode, javaCatchCode);
    }

    public void performRescueInner(BranchCallback regularCode, BranchCallback rubyCatchCode, BranchCallback javaCatchCode) {
        Label afterRubyCatchBody = new Label();
        Label catchRetry = new Label();
        Label catchJumps = new Label();
        Label exitRescue = new Label();
        this.loadRuntime();
        this.invokeUtilityMethod("getErrorInfo", CodegenUtils.sig(IRubyObject.class, Ruby.class));
        this.method.astore(this.getPreviousExceptionIndex());
        Label beforeBody = new Label();
        Label afterBody = new Label();
        Label rubyCatchBlock = new Label();
        Label flowCatchBlock = new Label();
        this.method.visitTryCatchBlock(beforeBody, afterBody, flowCatchBlock, CodegenUtils.p(JumpException.FlowControlException.class));
        this.method.visitTryCatchBlock(beforeBody, afterBody, rubyCatchBlock, CodegenUtils.p(Exception.class));
        this.method.visitLabel(beforeBody);
        regularCode.branch(this);
        this.method.label(afterBody);
        this.method.go_to(exitRescue);
        this.method.label(flowCatchBlock);
        this.loadRuntime();
        this.method.aload(this.getPreviousExceptionIndex());
        this.invokeUtilityMethod("setErrorInfo", CodegenUtils.sig(Void.TYPE, Ruby.class, IRubyObject.class));
        this.method.athrow();
        this.method.label(rubyCatchBlock);
        this.method.astore(this.getExceptionIndex());
        rubyCatchCode.branch(this);
        this.method.label(afterRubyCatchBody);
        this.method.go_to(exitRescue);
        this.method.trycatch(rubyCatchBlock, afterRubyCatchBody, catchRetry, CodegenUtils.p(JumpException.RetryJump.class));
        this.method.label(catchRetry);
        this.method.pop();
        this.method.go_to(beforeBody);
        this.method.trycatch(rubyCatchBlock, afterRubyCatchBody, catchJumps, CodegenUtils.p(JumpException.FlowControlException.class));
        this.method.label(catchJumps);
        this.loadRuntime();
        this.method.aload(this.getPreviousExceptionIndex());
        this.invokeUtilityMethod("setErrorInfo", CodegenUtils.sig(Void.TYPE, Ruby.class, IRubyObject.class));
        this.method.athrow();
        this.method.label(exitRescue);
        this.loadRuntime();
        this.method.aload(this.getPreviousExceptionIndex());
        this.invokeUtilityMethod("setErrorInfo", CodegenUtils.sig(Void.TYPE, Ruby.class, IRubyObject.class));
        this.endBody();
    }

    public void wrapJavaException() {
        this.loadRuntime();
        this.loadException();
        this.wrapJavaObject();
    }

    public void wrapJavaObject() {
        this.method.invokestatic(CodegenUtils.p(JavaUtil.class), "convertJavaToUsableRubyObject", CodegenUtils.sig(IRubyObject.class, Ruby.class, Object.class));
    }

    public void inDefined() {
        this.method.aload(1);
        this.method.iconst_1();
        this.invokeThreadContext("setWithinDefined", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Boolean.TYPE)));
    }

    public void outDefined() {
        this.method.aload(1);
        this.method.iconst_0();
        this.invokeThreadContext("setWithinDefined", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Boolean.TYPE)));
    }

    public void stringOrNil() {
        this.loadRuntime();
        this.loadNil();
        this.invokeUtilityMethod("stringOrNil", CodegenUtils.sig(IRubyObject.class, String.class, Ruby.class, IRubyObject.class));
    }

    public void pushNull() {
        this.method.aconst_null();
    }

    public void pushString(String str) {
        this.method.ldc(str);
    }

    public void isMethodBound(String name2, BranchCallback trueBranch, BranchCallback falseBranch) {
        this.metaclass();
        this.method.ldc(name2);
        this.method.iconst_0();
        this.method.invokevirtual(CodegenUtils.p(RubyClass.class), "isMethodBound", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class, Boolean.TYPE)));
        Label falseLabel = new Label();
        Label exitLabel = new Label();
        this.method.ifeq(falseLabel);
        trueBranch.branch(this);
        this.method.go_to(exitLabel);
        this.method.label(falseLabel);
        falseBranch.branch(this);
        this.method.label(exitLabel);
    }

    public void hasBlock(BranchCallback trueBranch, BranchCallback falseBranch) {
        this.loadBlock();
        this.method.invokevirtual(CodegenUtils.p(Block.class), "isGiven", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
        Label falseLabel = new Label();
        Label exitLabel = new Label();
        this.method.ifeq(falseLabel);
        trueBranch.branch(this);
        this.method.go_to(exitLabel);
        this.method.label(falseLabel);
        falseBranch.branch(this);
        this.method.label(exitLabel);
    }

    public void isGlobalDefined(String name2, BranchCallback trueBranch, BranchCallback falseBranch) {
        this.loadRuntime();
        this.invokeIRuby("getGlobalVariables", CodegenUtils.sig(GlobalVariables.class, new Class[0]));
        this.method.ldc(name2);
        this.method.invokevirtual(CodegenUtils.p(GlobalVariables.class), "isDefined", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class)));
        Label falseLabel = new Label();
        Label exitLabel = new Label();
        this.method.ifeq(falseLabel);
        trueBranch.branch(this);
        this.method.go_to(exitLabel);
        this.method.label(falseLabel);
        falseBranch.branch(this);
        this.method.label(exitLabel);
    }

    public void isConstantDefined(String name2, BranchCallback trueBranch, BranchCallback falseBranch) {
        this.loadThreadContext();
        this.method.ldc(name2);
        this.invokeThreadContext("getConstantDefined", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class)));
        Label falseLabel = new Label();
        Label exitLabel = new Label();
        this.method.ifeq(falseLabel);
        trueBranch.branch(this);
        this.method.go_to(exitLabel);
        this.method.label(falseLabel);
        falseBranch.branch(this);
        this.method.label(exitLabel);
    }

    public void isInstanceVariableDefined(String name2, BranchCallback trueBranch, BranchCallback falseBranch) {
        this.loadSelf();
        this.invokeIRubyObject("getInstanceVariables", CodegenUtils.sig(InstanceVariables.class, new Class[0]));
        this.method.ldc(name2);
        this.method.invokeinterface(CodegenUtils.p(InstanceVariables.class), "fastHasInstanceVariable", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class)));
        Label trueLabel = new Label();
        Label exitLabel = new Label();
        this.method.ifne(trueLabel);
        falseBranch.branch(this);
        this.method.go_to(exitLabel);
        this.method.label(trueLabel);
        trueBranch.branch(this);
        this.method.label(exitLabel);
    }

    public void isClassVarDefined(String name2, BranchCallback trueBranch, BranchCallback falseBranch) {
        this.method.ldc(name2);
        this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "fastIsClassVarDefined", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class)));
        Label trueLabel = new Label();
        Label exitLabel = new Label();
        this.method.ifne(trueLabel);
        falseBranch.branch(this);
        this.method.go_to(exitLabel);
        this.method.label(trueLabel);
        trueBranch.branch(this);
        this.method.label(exitLabel);
    }

    public Object getNewEnding() {
        return new Label();
    }

    public void isNil(BranchCallback trueBranch, BranchCallback falseBranch) {
        this.method.invokeinterface(CodegenUtils.p(IRubyObject.class), "isNil", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
        Label falseLabel = new Label();
        Label exitLabel = new Label();
        this.method.ifeq(falseLabel);
        trueBranch.branch(this);
        this.method.go_to(exitLabel);
        this.method.label(falseLabel);
        falseBranch.branch(this);
        this.method.label(exitLabel);
    }

    public void isNull(BranchCallback trueBranch, BranchCallback falseBranch) {
        Label falseLabel = new Label();
        Label exitLabel = new Label();
        this.method.ifnonnull(falseLabel);
        trueBranch.branch(this);
        this.method.go_to(exitLabel);
        this.method.label(falseLabel);
        falseBranch.branch(this);
        this.method.label(exitLabel);
    }

    public void ifNull(Object gotoToken) {
        this.method.ifnull((Label)gotoToken);
    }

    public void ifNotNull(Object gotoToken) {
        this.method.ifnonnull((Label)gotoToken);
    }

    public void setEnding(Object endingToken) {
        this.method.label((Label)endingToken);
    }

    public void go(Object gotoToken) {
        this.method.go_to((Label)gotoToken);
    }

    public void isConstantBranch(final BranchCallback setup, final BranchCallback isConstant, final BranchCallback isMethod, final BranchCallback none, final String name2) {
        this.rescue(new BranchCallback(){

            public void branch(BodyCompiler context) {
                setup.branch(BaseBodyCompiler.this);
                BaseBodyCompiler.this.method.dup();
                BaseBodyCompiler.this.method.instance_of(CodegenUtils.p(RubyModule.class));
                Label falseJmp = new Label();
                Label afterJmp = new Label();
                Label nextJmp = new Label();
                Label nextJmpPop = new Label();
                BaseBodyCompiler.this.method.ifeq(nextJmp);
                BaseBodyCompiler.this.method.visitTypeInsn(192, CodegenUtils.p(RubyModule.class));
                BaseBodyCompiler.this.method.dup();
                BaseBodyCompiler.this.method.ldc(name2);
                BaseBodyCompiler.this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "fastGetConstantAt", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class)));
                BaseBodyCompiler.this.method.dup();
                BaseBodyCompiler.this.method.ifnull(nextJmpPop);
                BaseBodyCompiler.this.method.pop();
                BaseBodyCompiler.this.method.pop();
                isConstant.branch(BaseBodyCompiler.this);
                BaseBodyCompiler.this.method.go_to(afterJmp);
                BaseBodyCompiler.this.method.label(nextJmpPop);
                BaseBodyCompiler.this.method.pop();
                BaseBodyCompiler.this.method.label(nextJmp);
                BaseBodyCompiler.this.metaclass();
                BaseBodyCompiler.this.method.ldc(name2);
                BaseBodyCompiler.this.method.iconst_1();
                BaseBodyCompiler.this.method.invokevirtual(CodegenUtils.p(RubyClass.class), "isMethodBound", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class, Boolean.TYPE)));
                BaseBodyCompiler.this.method.ifeq(falseJmp);
                isMethod.branch(BaseBodyCompiler.this);
                BaseBodyCompiler.this.method.go_to(afterJmp);
                BaseBodyCompiler.this.method.label(falseJmp);
                none.branch(BaseBodyCompiler.this);
                BaseBodyCompiler.this.method.label(afterJmp);
            }
        }, JumpException.class, none, String.class);
    }

    public void metaclass() {
        this.invokeIRubyObject("getMetaClass", CodegenUtils.sig(RubyClass.class, new Class[0]));
    }

    public void aprintln() {
        this.method.aprintln();
    }

    public void getVisibilityFor(String name2) {
        this.method.ldc(name2);
        this.method.invokevirtual(CodegenUtils.p(RubyClass.class), "searchMethod", CodegenUtils.sig(DynamicMethod.class, CodegenUtils.params(String.class)));
        this.method.invokevirtual(CodegenUtils.p(DynamicMethod.class), "getVisibility", CodegenUtils.sig(Visibility.class, new Class[0]));
    }

    public void isPrivate(Object gotoToken, int toConsume) {
        this.method.getstatic(CodegenUtils.p(Visibility.class), "PRIVATE", CodegenUtils.ci(Visibility.class));
        Label temp = new Label();
        this.method.if_acmpne(temp);
        while (toConsume-- > 0) {
            this.method.pop();
        }
        this.method.go_to((Label)gotoToken);
        this.method.label(temp);
    }

    public void isNotProtected(Object gotoToken, int toConsume) {
        this.method.getstatic(CodegenUtils.p(Visibility.class), "PROTECTED", CodegenUtils.ci(Visibility.class));
        Label temp = new Label();
        this.method.if_acmpeq(temp);
        while (toConsume-- > 0) {
            this.method.pop();
        }
        this.method.go_to((Label)gotoToken);
        this.method.label(temp);
    }

    public void selfIsKindOf(Object gotoToken) {
        this.method.invokevirtual(CodegenUtils.p(RubyClass.class), "getRealClass", CodegenUtils.sig(RubyClass.class, new Class[0]));
        this.loadSelf();
        this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "isInstance", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(IRubyObject.class)));
        this.method.ifne((Label)gotoToken);
    }

    public void notIsModuleAndClassVarDefined(String name2, Object gotoToken) {
        this.method.dup();
        this.method.instance_of(CodegenUtils.p(RubyModule.class));
        Label falsePopJmp = new Label();
        Label successJmp = new Label();
        this.method.ifeq(falsePopJmp);
        this.method.visitTypeInsn(192, CodegenUtils.p(RubyModule.class));
        this.method.ldc(name2);
        this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "fastIsClassVarDefined", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class)));
        this.method.ifeq((Label)gotoToken);
        this.method.go_to(successJmp);
        this.method.label(falsePopJmp);
        this.method.pop();
        this.method.go_to((Label)gotoToken);
        this.method.label(successJmp);
    }

    public void ifSingleton(Object gotoToken) {
        this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "isSingleton", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
        this.method.ifne((Label)gotoToken);
    }

    public void getInstanceVariable(String name2) {
        this.method.ldc(name2);
        this.invokeIRubyObject("getInstanceVariables", CodegenUtils.sig(InstanceVariables.class, new Class[0]));
        this.method.invokeinterface(CodegenUtils.p(InstanceVariables.class), "fastGetInstanceVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class)));
    }

    public void getFrameName() {
        this.loadThreadContext();
        this.invokeThreadContext("getFrameName", CodegenUtils.sig(String.class, new Class[0]));
    }

    public void getFrameKlazz() {
        this.loadThreadContext();
        this.invokeThreadContext("getFrameKlazz", CodegenUtils.sig(RubyModule.class, new Class[0]));
    }

    public void superClass() {
        this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "getSuperClass", CodegenUtils.sig(RubyClass.class, new Class[0]));
    }

    public void attached() {
        this.method.visitTypeInsn(192, CodegenUtils.p(MetaClass.class));
        this.method.invokevirtual(CodegenUtils.p(MetaClass.class), "getAttached", CodegenUtils.sig(IRubyObject.class, new Class[0]));
    }

    public void ifNotSuperMethodBound(Object token) {
        this.method.swap();
        this.method.iconst_0();
        this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "isMethodBound", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class, Boolean.TYPE)));
        this.method.ifeq((Label)token);
    }

    public void concatArrays() {
        this.method.invokevirtual(CodegenUtils.p(RubyArray.class), "concat", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(IRubyObject.class)));
    }

    public void concatObjectArrays() {
        this.invokeUtilityMethod("concatObjectArrays", CodegenUtils.sig(IRubyObject[].class, CodegenUtils.params(IRubyObject[].class, IRubyObject[].class)));
    }

    public void appendToArray() {
        this.method.invokevirtual(CodegenUtils.p(RubyArray.class), "append", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(IRubyObject.class)));
    }

    public void appendToObjectArray() {
        this.invokeUtilityMethod("appendToObjectArray", CodegenUtils.sig(IRubyObject[].class, CodegenUtils.params(IRubyObject[].class, IRubyObject.class)));
    }

    public void convertToJavaArray() {
        this.method.invokestatic(CodegenUtils.p(ArgsUtil.class), "convertToJavaArray", CodegenUtils.sig(IRubyObject[].class, CodegenUtils.params(IRubyObject.class)));
    }

    public void aliasGlobal(String newName, String oldName) {
        this.loadRuntime();
        this.invokeIRuby("getGlobalVariables", CodegenUtils.sig(GlobalVariables.class, new Class[0]));
        this.method.ldc(newName);
        this.method.ldc(oldName);
        this.method.invokevirtual(CodegenUtils.p(GlobalVariables.class), "alias", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(String.class, String.class)));
        this.loadNil();
    }

    public void undefMethod(String name2) {
        this.loadThreadContext();
        this.invokeThreadContext("getRubyClass", CodegenUtils.sig(RubyModule.class, new Class[0]));
        Label notNull = new Label();
        this.method.dup();
        this.method.ifnonnull(notNull);
        this.method.pop();
        this.loadRuntime();
        this.method.ldc("No class to undef method '" + name2 + "'.");
        this.invokeIRuby("newTypeError", CodegenUtils.sig(RaiseException.class, CodegenUtils.params(String.class)));
        this.method.athrow();
        this.method.label(notNull);
        this.loadThreadContext();
        this.method.ldc(name2);
        this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "undef", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, String.class)));
        this.loadNil();
    }

    public void defineClass(final String name2, final StaticScope staticScope, final CompilerCallback superCallback, final CompilerCallback pathCallback, CompilerCallback bodyCallback, final CompilerCallback receiverCallback) {
        String classMethodName = null;
        if (receiverCallback == null) {
            String mangledName = JavaNameMangler.mangleStringForCleanJavaIdentifier(name2);
            classMethodName = "class_" + this.script.getAndIncrementMethodIndex() + "$RUBY$" + mangledName;
        } else {
            classMethodName = "sclass_" + this.script.getAndIncrementMethodIndex() + "$RUBY$__singleton__";
        }
        final ASMClassBodyCompiler classBody = new ASMClassBodyCompiler(this.script, classMethodName, null, staticScope);
        CompilerCallback bodyPrep = new CompilerCallback(){

            public void call(BodyCompiler context) {
                if (receiverCallback == null) {
                    if (superCallback != null) {
                        classBody.loadRuntime();
                        superCallback.call(classBody);
                        classBody.invokeUtilityMethod("prepareSuperClass", CodegenUtils.sig(RubyClass.class, CodegenUtils.params(Ruby.class, IRubyObject.class)));
                    } else {
                        classBody.method.aconst_null();
                    }
                    classBody.loadThreadContext();
                    pathCallback.call(classBody);
                    classBody.invokeUtilityMethod("prepareClassNamespace", CodegenUtils.sig(RubyModule.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class)));
                    classBody.method.swap();
                    classBody.method.ldc(name2);
                    classBody.method.swap();
                    classBody.method.invokevirtual(CodegenUtils.p(RubyModule.class), "defineOrGetClassUnder", CodegenUtils.sig(RubyClass.class, CodegenUtils.params(String.class, RubyClass.class)));
                } else {
                    classBody.loadRuntime();
                    classBody.method.aload(2);
                    int selfTemp = classBody.getVariableCompiler().grabTempLocal();
                    classBody.getVariableCompiler().setTempLocal(selfTemp);
                    classBody.method.aload(2);
                    classBody.invokeUtilityMethod("getSingletonClass", CodegenUtils.sig(RubyClass.class, CodegenUtils.params(Ruby.class, IRubyObject.class)));
                }
                classBody.method.dup();
                classBody.method.astore(2);
                classBody.loadThreadContext();
                classBody.method.swap();
                StandardASMCompiler.buildStaticScopeNames(classBody.method, staticScope);
                classBody.invokeThreadContext("preCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(RubyModule.class, String[].class)));
            }
        };
        Label start2 = new Label();
        Label end2 = new Label();
        Label after = new Label();
        Label noException = new Label();
        classBody.method.trycatch(start2, end2, after, null);
        ((RootScopedBodyCompiler)classBody).beginMethod(bodyPrep, staticScope);
        classBody.method.label(start2);
        bodyCallback.call(classBody);
        classBody.method.label(end2);
        classBody.loadThreadContext();
        classBody.invokeThreadContext("postCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(new Class[0])));
        classBody.method.go_to(noException);
        classBody.method.label(after);
        classBody.loadThreadContext();
        classBody.invokeThreadContext("postCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(new Class[0])));
        classBody.method.athrow();
        classBody.method.label(noException);
        classBody.endBody();
        this.method.aload(0);
        this.loadThreadContext();
        if (receiverCallback == null) {
            this.method.aload(2);
        } else {
            receiverCallback.call(this);
        }
        this.method.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
        this.method.invokevirtual(this.script.getClassname(), classMethodName, StandardASMCompiler.METHOD_SIGNATURES[0]);
    }

    public void defineModule(final String name2, final StaticScope staticScope, final CompilerCallback pathCallback, CompilerCallback bodyCallback) {
        String mangledName = JavaNameMangler.mangleStringForCleanJavaIdentifier(name2);
        String moduleMethodName = "module__" + this.script.getAndIncrementMethodIndex() + "$RUBY$" + mangledName;
        final ASMClassBodyCompiler classBody = new ASMClassBodyCompiler(this.script, moduleMethodName, null, staticScope);
        CompilerCallback bodyPrep = new CompilerCallback(){

            public void call(BodyCompiler context) {
                classBody.loadThreadContext();
                pathCallback.call(classBody);
                classBody.invokeUtilityMethod("prepareClassNamespace", CodegenUtils.sig(RubyModule.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class)));
                classBody.method.ldc(name2);
                classBody.method.invokevirtual(CodegenUtils.p(RubyModule.class), "defineOrGetModuleUnder", CodegenUtils.sig(RubyModule.class, CodegenUtils.params(String.class)));
                classBody.method.dup();
                classBody.method.astore(2);
                classBody.loadThreadContext();
                classBody.method.swap();
                StandardASMCompiler.buildStaticScopeNames(classBody.method, staticScope);
                classBody.invokeThreadContext("preCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(RubyModule.class, String[].class)));
            }
        };
        Label start2 = new Label();
        Label end2 = new Label();
        Label after = new Label();
        Label noException = new Label();
        classBody.method.trycatch(start2, end2, after, null);
        ((RootScopedBodyCompiler)classBody).beginMethod(bodyPrep, staticScope);
        classBody.method.label(start2);
        bodyCallback.call(classBody);
        classBody.method.label(end2);
        classBody.method.go_to(noException);
        classBody.method.label(after);
        classBody.loadThreadContext();
        classBody.invokeThreadContext("postCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(new Class[0])));
        classBody.method.athrow();
        classBody.method.label(noException);
        classBody.loadThreadContext();
        classBody.invokeThreadContext("postCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(new Class[0])));
        classBody.endBody();
        this.method.aload(0);
        this.loadThreadContext();
        this.loadSelf();
        this.method.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
        this.method.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
        this.method.invokevirtual(this.script.getClassname(), moduleMethodName, StandardASMCompiler.METHOD_SIGNATURES[4]);
    }

    public void unwrapPassedBlock() {
        this.loadBlock();
        this.invokeUtilityMethod("getBlockFromBlockPassBody", CodegenUtils.sig(Block.class, CodegenUtils.params(IRubyObject.class, Block.class)));
    }

    public void performBackref(char type2) {
        this.loadThreadContext();
        switch (type2) {
            case '~': {
                this.invokeUtilityMethod("backref", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
                break;
            }
            case '&': {
                this.invokeUtilityMethod("backrefLastMatch", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
                break;
            }
            case '`': {
                this.invokeUtilityMethod("backrefMatchPre", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
                break;
            }
            case '\'': {
                this.invokeUtilityMethod("backrefMatchPost", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
                break;
            }
            case '+': {
                this.invokeUtilityMethod("backrefMatchLast", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
                break;
            }
            default: {
                throw new NotCompilableException("ERROR: backref with invalid type");
            }
        }
    }

    public void callZSuper(CompilerCallback closure) {
        this.loadRuntime();
        this.loadThreadContext();
        if (closure != null) {
            closure.call(this);
        } else {
            this.method.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
        }
        this.loadSelf();
        this.invokeUtilityMethod("callZSuper", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Ruby.class, ThreadContext.class, Block.class, IRubyObject.class)));
    }

    public void checkIsExceptionHandled() {
        this.loadRuntime();
        this.loadThreadContext();
        this.loadSelf();
        this.invokeUtilityMethod("isExceptionHandled", CodegenUtils.sig(IRubyObject.class, RubyException.class, IRubyObject[].class, Ruby.class, ThreadContext.class, IRubyObject.class));
    }

    public void checkIsJavaExceptionHandled() {
        this.loadRuntime();
        this.loadThreadContext();
        this.loadSelf();
        this.invokeUtilityMethod("isJavaExceptionHandled", CodegenUtils.sig(IRubyObject.class, Exception.class, IRubyObject[].class, Ruby.class, ThreadContext.class, IRubyObject.class));
    }

    public void rethrowException() {
        this.loadException();
        this.method.athrow();
    }

    public void loadClass(String name2) {
        this.loadRuntime();
        this.method.ldc(name2);
        this.invokeIRuby("getClass", CodegenUtils.sig(RubyClass.class, String.class));
    }

    public void unwrapRaiseException() {
        this.method.invokevirtual(CodegenUtils.p(RaiseException.class), "getException", CodegenUtils.sig(RubyException.class, new Class[0]));
    }

    public void loadException() {
        this.method.aload(this.getExceptionIndex());
    }

    public void setFilePosition(ISourcePosition position) {
        if (!RubyInstanceConfig.POSITIONLESS_COMPILE_ENABLED) {
            this.loadThreadContext();
            this.method.ldc(position.getFile());
            this.invokeThreadContext("setFile", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(String.class)));
        }
    }

    public void setLinePosition(ISourcePosition position) {
        if (!RubyInstanceConfig.POSITIONLESS_COMPILE_ENABLED) {
            if (this.lastPositionLine == position.getStartLine()) {
                return;
            }
            this.lastPositionLine = position.getStartLine();
            this.loadThreadContext();
            this.method.pushInt(position.getStartLine());
            this.method.invokestatic(this.script.getClassname(), "setPosition", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, Integer.TYPE)));
        }
    }

    public void checkWhenWithSplat() {
        this.loadThreadContext();
        this.invokeUtilityMethod("isWhenTriggered", CodegenUtils.sig(RubyBoolean.class, IRubyObject.class, IRubyObject.class, ThreadContext.class));
    }

    public void issueRetryEvent() {
        this.invokeUtilityMethod("retryJump", CodegenUtils.sig(IRubyObject.class, new Class[0]));
    }

    public void defineNewMethod(String name2, int methodArity, StaticScope scope, CompilerCallback body, CompilerCallback args2, CompilerCallback receiver2, ASTInspector inspector, boolean root) {
        String newMethodName;
        if (root && Boolean.getBoolean("jruby.compile.toplevel")) {
            newMethodName = name2;
        } else {
            String mangledName = JavaNameMangler.mangleStringForCleanJavaIdentifier(name2);
            newMethodName = "method__" + this.script.getAndIncrementMethodIndex() + "$RUBY$" + mangledName;
        }
        BodyCompiler methodCompiler = this.script.startMethod(name2, newMethodName, args2, scope, inspector);
        body.call(methodCompiler);
        methodCompiler.endBody();
        this.loadThreadContext();
        this.loadSelf();
        if (receiver2 != null) {
            receiver2.call(this);
        }
        this.method.aload(0);
        this.method.ldc(name2);
        this.method.ldc(newMethodName);
        StandardASMCompiler.buildStaticScopeNames(this.method, scope);
        this.method.pushInt(methodArity);
        this.method.pushInt(scope.getRequiredArgs());
        this.method.pushInt(scope.getOptionalArgs());
        this.method.pushInt(scope.getRestArg());
        if (inspector.hasFrameAwareMethods() || !inspector.noFrame() && !RubyInstanceConfig.FRAMELESS_COMPILE_ENABLED) {
            if (inspector.hasClosure() || inspector.hasScopeAwareMethods()) {
                this.method.getstatic(CodegenUtils.p(CallConfiguration.class), CallConfiguration.FRAME_AND_SCOPE.name(), CodegenUtils.ci(CallConfiguration.class));
            } else if (inspector.hasConstant() || inspector.hasMethod() || inspector.hasClass() || inspector.hasClassVar()) {
                this.method.getstatic(CodegenUtils.p(CallConfiguration.class), CallConfiguration.FRAME_AND_DUMMY_SCOPE.name(), CodegenUtils.ci(CallConfiguration.class));
            } else {
                this.method.getstatic(CodegenUtils.p(CallConfiguration.class), CallConfiguration.FRAME_ONLY.name(), CodegenUtils.ci(CallConfiguration.class));
            }
        } else if (inspector.hasClosure() || inspector.hasScopeAwareMethods()) {
            if (RubyInstanceConfig.FASTEST_COMPILE_ENABLED) {
                this.method.getstatic(CodegenUtils.p(CallConfiguration.class), CallConfiguration.SCOPE_ONLY.name(), CodegenUtils.ci(CallConfiguration.class));
            } else {
                this.method.getstatic(CodegenUtils.p(CallConfiguration.class), CallConfiguration.BACKTRACE_AND_SCOPE.name(), CodegenUtils.ci(CallConfiguration.class));
            }
        } else if (RubyInstanceConfig.FASTEST_COMPILE_ENABLED || inspector.noFrame()) {
            this.method.getstatic(CodegenUtils.p(CallConfiguration.class), CallConfiguration.NO_FRAME_NO_SCOPE.name(), CodegenUtils.ci(CallConfiguration.class));
        } else {
            this.method.getstatic(CodegenUtils.p(CallConfiguration.class), CallConfiguration.BACKTRACE_ONLY.name(), CodegenUtils.ci(CallConfiguration.class));
        }
        if (receiver2 != null) {
            this.invokeUtilityMethod("defs", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, Object.class, String.class, String.class, String[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, CallConfiguration.class)));
        } else {
            this.invokeUtilityMethod("def", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, Object.class, String.class, String.class, String[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, CallConfiguration.class)));
        }
    }

    public void rethrowIfSystemExit() {
        this.loadRuntime();
        this.method.ldc("SystemExit");
        this.method.invokevirtual(CodegenUtils.p(Ruby.class), "fastGetClass", CodegenUtils.sig(RubyClass.class, String.class));
        this.method.swap();
        this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "isInstance", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(IRubyObject.class)));
        this.method.iconst_0();
        Label ifEnd = new Label();
        this.method.if_icmpeq(ifEnd);
        this.loadException();
        this.method.athrow();
        this.method.label(ifEnd);
    }

    public void literalSwitch(int[] cases, Object bodies, ArrayCallback arrayCallback, CompilerCallback defaultCallback) {
        this.method.checkcast(CodegenUtils.p(RubyFixnum.class));
        this.method.invokevirtual(CodegenUtils.p(RubyFixnum.class), "getLongValue", CodegenUtils.sig(Long.TYPE, new Class[0]));
        this.method.l2i();
        Label[] labels = new Label[cases.length];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = new Label();
        }
        Label defaultLabel = new Label();
        Label endLabel = new Label();
        this.method.lookupswitch(defaultLabel, cases, labels);
        for (int i = 0; i < cases.length; ++i) {
            this.method.label(labels[i]);
            arrayCallback.nextValue(this, bodies, i);
            this.method.go_to(endLabel);
        }
        this.method.label(defaultLabel);
        defaultCallback.call(this);
        this.method.label(endLabel);
    }

    public void typeCheckBranch(Class type2, BranchCallback trueCallback, BranchCallback falseCallback) {
        Label elseLabel = new Label();
        Label done = new Label();
        this.method.dup();
        this.method.instance_of(CodegenUtils.p(type2));
        this.method.ifeq(elseLabel);
        trueCallback.branch(this);
        this.method.go_to(done);
        this.method.label(elseLabel);
        falseCallback.branch(this);
        this.method.label(done);
    }

    public void loadFilename() {
        this.loadRuntime();
        this.loadThis();
        this.method.getfield(this.getScriptCompiler().getClassname(), "filename", CodegenUtils.ci(String.class));
        this.method.invokestatic(CodegenUtils.p(RubyString.class), "newString", CodegenUtils.sig(RubyString.class, Ruby.class, CharSequence.class));
    }
}

