/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.common;

import org.jruby.Ruby;
import org.jruby.common.IRubyWarnings;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyWarnings
implements IRubyWarnings {
    private final Ruby runtime;

    public RubyWarnings(Ruby runtime2) {
        this.runtime = runtime2;
    }

    public void warn(IRubyWarnings.ID id2, ISourcePosition position, String message2, Object ... data) {
        this.warn(id2, position.getFile(), position.getEndLine(), message2, data);
    }

    public void warn(IRubyWarnings.ID id2, String fileName, int lineNumber, String message2, Object ... data) {
        if (this.runtime.getVerbose().isNil()) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        buffer.append(fileName).append(':').append(lineNumber + 1).append(' ');
        buffer.append("warning: ").append(message2).append('\n');
        IRubyObject errorStream = this.runtime.getGlobalVariables().get("$stderr");
        errorStream.callMethod(this.runtime.getCurrentContext(), "write", this.runtime.newString(buffer.toString()));
    }

    public boolean isVerbose() {
        return this.runtime.getVerbose().isTrue();
    }

    public void warn(IRubyWarnings.ID id2, String message2, Object ... data) {
        ThreadContext context = this.runtime.getCurrentContext();
        this.warn(id2, context.getFile(), context.getLine(), message2, data);
    }

    public void warning(IRubyWarnings.ID id2, String message2, Object ... data) {
        ThreadContext context = this.runtime.getCurrentContext();
        this.warning(id2, context.getFile(), context.getLine(), message2, data);
    }

    public void warning(IRubyWarnings.ID id2, ISourcePosition position, String message2, Object ... data) {
        this.warning(id2, position.getFile(), position.getEndLine(), message2, data);
    }

    public void warning(IRubyWarnings.ID id2, String fileName, int lineNumber, String message2, Object ... data) {
        if (this.isVerbose()) {
            this.warn(id2, fileName, lineNumber, message2, data);
        }
    }
}

