/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyRegexp;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexpNode
extends Node
implements ILiteralNode {
    private RubyRegexp pattern;
    private final ByteList value;
    private final int options;

    public RegexpNode(ISourcePosition position, ByteList value2, int options2) {
        super(position, NodeType.REGEXPNODE);
        this.value = value2;
        this.options = options2;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitRegexpNode(this);
    }

    public int getOptions() {
        return this.options;
    }

    public ByteList getValue() {
        return this.value;
    }

    public void setPattern(RubyRegexp p2) {
        this.pattern = p2;
        this.pattern.setLiteral();
    }

    public RubyRegexp getPattern() {
        return this.pattern;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        if (this.pattern == null) {
            this.setPattern(RubyRegexp.newRegexp(runtime2, this.value, this.options));
        }
        return this.pattern;
    }
}

