/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyRegexp;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Match2Node
extends Node {
    private final Node receiverNode;
    private final Node valueNode;

    public Match2Node(ISourcePosition position, Node receiverNode, Node valueNode) {
        super(position, NodeType.MATCH2NODE);
        assert (receiverNode != null) : "receiverNode is not null";
        assert (valueNode != null) : "valueNode is not null";
        this.receiverNode = receiverNode;
        this.valueNode = valueNode;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitMatch2Node(this);
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    public Node getValueNode() {
        return this.valueNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.valueNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject recv2 = this.receiverNode.interpret(runtime2, context, self, aBlock);
        IRubyObject value2 = this.valueNode.interpret(runtime2, context, self, aBlock);
        return ((RubyRegexp)recv2).op_match(context, value2);
    }

    @Override
    public String definition(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        return "method";
    }
}

