/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.StrNode;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class DStrNode
extends ListNode
implements ILiteralNode {
    public DStrNode(ISourcePosition position) {
        super(position, NodeType.DSTRNODE);
    }

    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitDStrNode(this);
    }

    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        return DStrNode.buildDynamicString(runtime2, context, self, aBlock, this);
    }

    public static RubyString buildDynamicString(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock, ListNode list2) {
        RubyString string2 = runtime2.newString(new ByteList());
        int size2 = list2.size();
        for (int i = 0; i < size2; ++i) {
            DStrNode.appendToString(runtime2, context, self, aBlock, string2, list2.get(i));
        }
        return string2;
    }

    public static void appendToString(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock, RubyString string2, Node node) {
        if (node instanceof StrNode) {
            string2.getByteList().append(((StrNode)node).getValue());
        } else {
            string2.append(node.interpret(runtime2, context, self, aBlock));
        }
    }
}

