/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.net;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import net.sf.antcontrib.net.Prop;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;

public class PostTask
extends Task {
    private Hashtable props = new Hashtable();
    private URL to = null;
    private File propsFile = null;
    private String textProps = null;
    private String encoding = "UTF-8";
    private File log = null;
    private boolean append = true;
    private boolean verbose = true;
    private boolean wantResponse = true;
    private long maxwait = 180000L;
    private boolean failOnError = false;
    private URLConnection connection = null;
    private Thread currentRunner = null;

    public void setTo(URL name) {
        this.to = name;
    }

    public void setFile(File f) {
        this.propsFile = f;
    }

    public void setLogfile(File f) {
        this.log = f;
    }

    public void setAppend(boolean b) {
        this.append = b;
    }

    public void setVerbose(boolean b) {
        this.verbose = b;
    }

    public void setWantresponse(boolean b) {
        this.wantResponse = b;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setMaxwait(int wait) {
        this.maxwait = wait * 1000;
    }

    public void setFailonerror(boolean fail) {
        this.failOnError = fail;
    }

    public void addConfiguredProp(Prop p) throws BuildException {
        String name = p.getName();
        if (name == null) {
            throw new BuildException("name is null", this.getLocation());
        }
        String value = p.getValue();
        if (value == null) {
            value = this.getProject().getProperty(name);
        }
        if (value == null) {
            throw new BuildException("value is null", this.getLocation());
        }
        this.props.put(name, value);
    }

    public void addText(String text) {
        this.textProps = text;
    }

    public void execute() throws BuildException {
        block9: {
            if (this.to == null) {
                throw new BuildException("'to' attribute is required", this.getLocation());
            }
            final String content = this.getContent();
            try {
                this.log("Opening connection for post to " + this.to.toString() + "...");
                Thread runner = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        FilterOutputStream out = null;
                        try {
                            PostTask.this.connection = PostTask.this.to.openConnection();
                            PostTask.this.connection.setDoInput(true);
                            PostTask.this.connection.setDoOutput(true);
                            PostTask.this.connection.setUseCaches(false);
                            PostTask.this.connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                            if (PostTask.this.verbose) {
                                PostTask.this.log("Connected, sending data...");
                            }
                            out = new DataOutputStream(PostTask.this.connection.getOutputStream());
                            if (PostTask.this.verbose) {
                                PostTask.this.log(content);
                            }
                            ((DataOutputStream)out).writeBytes(content);
                            ((DataOutputStream)out).flush();
                            if (PostTask.this.verbose) {
                                PostTask.this.log("Data sent.");
                            }
                        }
                        catch (Exception e) {
                            if (PostTask.this.failOnError) {
                                throw new BuildException((Throwable)e, PostTask.this.getLocation());
                            }
                        }
                        finally {
                            try {
                                out.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                };
                runner.run();
                runner.join(this.maxwait);
                if (runner.isAlive()) {
                    runner.interrupt();
                    if (this.failOnError) {
                        throw new BuildException("maxwait exceeded, unable to send data", this.getLocation());
                    }
                    return;
                }
                if (this.wantResponse) {
                    if (this.verbose) {
                        this.log("Waiting for response...");
                    }
                    this.currentRunner = runner = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Loose catch block
                         */
                        public void run() {
                            block20: {
                                String line;
                                OutputStreamWriter fw = null;
                                BufferedReader in = null;
                                in = new BufferedReader(new InputStreamReader(PostTask.this.connection.getInputStream()));
                                if (PostTask.this.log != null) {
                                    fw = new FileWriter(PostTask.this.log.getAbsolutePath(), PostTask.this.append);
                                }
                                while (null != (line = in.readLine()) && PostTask.this.currentRunner == this) {
                                    line = PostTask.this.decode(line);
                                    if (PostTask.this.verbose) {
                                        PostTask.this.log(line);
                                    }
                                    if (fw == null) continue;
                                    fw.write(line);
                                }
                                Object var5_5 = null;
                                try {
                                    in.close();
                                }
                                catch (Exception e2) {
                                    // empty catch block
                                }
                                try {
                                    if (fw != null) {
                                        fw.flush();
                                        fw.close();
                                    }
                                    break block20;
                                }
                                catch (Exception e2) {}
                                break block20;
                                {
                                    catch (Exception e) {
                                        if (PostTask.this.failOnError) {
                                            throw new BuildException((Throwable)e, PostTask.this.getLocation());
                                        }
                                        Object var5_6 = null;
                                        try {
                                            in.close();
                                        }
                                        catch (Exception e2) {
                                            // empty catch block
                                        }
                                        try {
                                            if (fw != null) {
                                                fw.flush();
                                                fw.close();
                                            }
                                            break block20;
                                        }
                                        catch (Exception e2) {}
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var5_7 = null;
                                    try {
                                        in.close();
                                    }
                                    catch (Exception e2) {
                                        // empty catch block
                                    }
                                    try {
                                        if (fw != null) {
                                            fw.flush();
                                            fw.close();
                                        }
                                    }
                                    catch (Exception e2) {
                                        // empty catch block
                                    }
                                    throw throwable;
                                }
                            }
                        }
                    };
                    runner.run();
                    runner.join(this.maxwait);
                    if (runner.isAlive()) {
                        this.currentRunner = null;
                        runner.interrupt();
                        if (this.failOnError) {
                            throw new BuildException("maxwait exceeded, unable to receive data", this.getLocation());
                        }
                    }
                }
                this.log("Post complete.");
            }
            catch (Exception e) {
                if (!this.failOnError) break block9;
                throw new BuildException((Throwable)e);
            }
        }
    }

    private String getContent() {
        if (this.propsFile != null) {
            this.loadFile(this.propsFile);
        }
        if (this.textProps != null) {
            this.loadTextProps(this.textProps);
        }
        StringBuffer content = new StringBuffer();
        try {
            Enumeration e = this.props.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = (String)this.props.get(name);
                content.append(this.encode(name));
                content.append("=");
                content.append(this.encode(value));
                if (!e.hasMoreElements()) continue;
                content.append("&");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return content.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFile(File file) throws BuildException {
        block8: {
            Properties fileprops = new Properties();
            try {
                if (file.exists()) {
                    FileInputStream fis = new FileInputStream(file);
                    try {
                        fileprops.load(fis);
                    }
                    finally {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    this.addProperties(fileprops);
                    break block8;
                }
                this.log("Unable to find property file: " + file.getAbsolutePath(), 3);
            }
            catch (IOException ex) {
                if (!this.failOnError) break block8;
                throw new BuildException((Throwable)ex, this.location);
            }
        }
    }

    private void loadTextProps(String tp) {
        Properties p = new Properties();
        Project project = this.getProject();
        StringTokenizer st = new StringTokenizer(tp, "$");
        while (st.hasMoreTokens()) {
            String name;
            String value;
            String token = st.nextToken();
            int start = token.indexOf("{");
            int end = token.indexOf("}");
            if (start <= -1 || end <= -1 || end <= start || (value = project.getProperty(name = token.substring(start + 1, end - start))) == null) continue;
            p.setProperty(name, value);
        }
        this.addProperties(p);
    }

    private void addProperties(Properties fileprops) {
        this.resolveAllProperties(fileprops);
        Enumeration e = ((Hashtable)fileprops).keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = fileprops.getProperty(name);
            this.props.put(name, value);
        }
    }

    private void resolveAllProperties(Properties fileprops) throws BuildException {
        Enumeration e = ((Hashtable)fileprops).keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = fileprops.getProperty(name);
            boolean resolved = false;
            while (!resolved) {
                Vector fragments = new Vector();
                Vector propertyRefs = new Vector();
                ProjectHelper.parsePropertyString((String)value, fragments, propertyRefs);
                resolved = true;
                if (propertyRefs.size() == 0) continue;
                StringBuffer sb = new StringBuffer();
                Enumeration i = fragments.elements();
                Enumeration j = propertyRefs.elements();
                while (i.hasMoreElements()) {
                    String fragment = (String)i.nextElement();
                    if (fragment == null) {
                        String propertyName = (String)j.nextElement();
                        if (propertyName.equals(name)) {
                            throw new BuildException("Property " + name + " was circularly " + "defined.");
                        }
                        fragment = this.getProject().getProperty(propertyName);
                        if (fragment == null) {
                            if (((Hashtable)fileprops).containsKey(propertyName)) {
                                fragment = fileprops.getProperty(propertyName);
                                resolved = false;
                            } else {
                                fragment = "${" + propertyName + "}";
                            }
                        }
                    }
                    sb.append(fragment);
                }
                value = sb.toString();
                ((Hashtable)fileprops).put(name, value);
            }
        }
    }

    public String encode(String toEncode) throws BuildException {
        return this.invokeCoder("encode", toEncode);
    }

    public String decode(String toDecode) throws BuildException {
        return this.invokeCoder("decode", toDecode);
    }

    public String invokeCoder(String methodName, String toEncode) {
        try {
            Class<?> c = null;
            if (methodName.equals("encode")) {
                c = Class.forName("java.net.URLEncoder");
            } else if (methodName.equals("decode")) {
                c = Class.forName("java.net.URLDecoder");
            }
            if (c != null) {
                Class[] params = new Class[]{toEncode.getClass(), this.encoding.getClass()};
                Method m = null;
                try {
                    m = c.getMethod(methodName, params);
                    return (String)m.invoke(c, (Object[])new String[]{toEncode, this.encoding});
                }
                catch (NoSuchMethodException nsme) {
                    params = new Class[]{toEncode.getClass()};
                    try {
                        m = c.getMethod(methodName, params);
                        return (String)m.invoke(c, (Object[])new String[]{toEncode});
                    }
                    catch (NoSuchMethodException e) {
                        throw new BuildException((Throwable)e);
                    }
                }
            }
            throw new IllegalArgumentException("Method name must be one of 'encode' or 'decode'.");
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }
}

