/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.logic;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MacroDef;
import org.apache.tools.ant.taskdefs.MacroInstance;
import org.apache.tools.ant.taskdefs.Parallel;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public class ForDelegate {
    private String list;
    private String param;
    private String delimiter = ",";
    private Path currPath;
    private boolean trim;
    private MacroDef macroDef;
    private List hasIterators = new ArrayList();
    private boolean parallel = false;
    private Integer threadCount;
    private Parallel parallelTasks;
    private Project project;
    private Target owningTarget;

    public void setOwningTarget(Target owningTarget) {
        this.owningTarget = owningTarget;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    public void setThreadCount(int threadCount) {
        if (threadCount < 1) {
            throw new BuildException("Illegal value for threadCount " + threadCount + " it should be > 0");
        }
        this.threadCount = new Integer(threadCount);
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }

    public void setList(String list) {
        this.list = list;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setParam(String param) {
        this.param = param;
    }

    private Path getOrCreatePath() {
        if (this.currPath == null) {
            this.currPath = new Path(this.project);
        }
        return this.currPath;
    }

    public void addConfigured(Path path) {
        this.getOrCreatePath().append(path);
    }

    public void addConfiguredPath(Path path) {
        this.addConfigured(path);
    }

    public Object createSequential() {
        this.macroDef = new MacroDef();
        this.macroDef.setProject(this.project);
        return this.macroDef.createSequential();
    }

    public void execute() {
        if (this.parallel) {
            this.parallelTasks = (Parallel)this.project.createTask("parallel");
            if (this.threadCount != null) {
                this.parallelTasks.setThreadCount(this.threadCount.intValue());
            }
        }
        if (this.list == null && this.currPath == null && this.hasIterators.size() == 0) {
            throw new BuildException("You must have a list or path to iterate through");
        }
        if (this.param == null) {
            throw new BuildException("You must supply a property name to set on each iteration in param");
        }
        if (this.macroDef == null) {
            throw new BuildException("You must supply an embedded sequential to perform");
        }
        this.doTheTasks();
        if (this.parallel) {
            this.parallelTasks.perform();
        }
    }

    private void doSequentialIteration(String val) {
        MacroInstance instance = new MacroInstance();
        instance.setProject(this.project);
        instance.setOwningTarget(this.owningTarget);
        instance.setMacroDef(this.macroDef);
        instance.setDynamicAttribute(this.param.toLowerCase(), val);
        if (!this.parallel) {
            instance.execute();
        } else {
            this.parallelTasks.addTask((Task)instance);
        }
    }

    private void doTheTasks() {
        MacroDef.Attribute attribute = new MacroDef.Attribute();
        attribute.setName(this.param);
        this.macroDef.addConfiguredAttribute(attribute);
        if (this.list != null) {
            StringTokenizer st = new StringTokenizer(this.list, this.delimiter);
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                if (this.trim) {
                    tok = tok.trim();
                }
                this.doSequentialIteration(tok);
            }
        }
        String[] pathElements = new String[]{};
        if (this.currPath != null) {
            pathElements = this.currPath.list();
        }
        for (int i = 0; i < pathElements.length; ++i) {
            File nextFile = new File(pathElements[i]);
            this.doSequentialIteration(nextFile.getAbsolutePath());
        }
        Iterator i = this.hasIterators.iterator();
        while (i.hasNext()) {
            Iterator it = ((HasIterator)i.next()).iterator();
            while (it.hasNext()) {
                this.doSequentialIteration(it.next().toString());
            }
        }
    }

    public void add(Map map) {
        this.hasIterators.add(new MapIterator(map));
    }

    public void add(FileSet fileset) {
        this.getOrCreatePath().addFileset(fileset);
    }

    public void addFileSet(FileSet fileset) {
        this.add(fileset);
    }

    public void add(DirSet dirset) {
        this.getOrCreatePath().addDirset(dirset);
    }

    public void addDirSet(DirSet dirset) {
        this.add(dirset);
    }

    public void add(Collection collection) {
        this.hasIterators.add(new ReflectIterator(collection));
    }

    public void add(Iterator iterator) {
        this.hasIterators.add(new IteratorIterator(iterator));
    }

    public void add(Object obj) {
        this.hasIterators.add(new ReflectIterator(obj));
    }

    private static class ReflectIterator
    implements HasIterator {
        private Object obj;
        private Method method;

        public ReflectIterator(Object obj) {
            this.obj = obj;
            try {
                this.method = obj.getClass().getMethod("iterator", new Class[0]);
            }
            catch (Throwable t) {
                throw new BuildException("Invalid type " + obj.getClass() + " used in For task, it does" + " not have a public iterator method");
            }
        }

        public Iterator iterator() {
            try {
                return (Iterator)this.method.invoke(this.obj, new Object[0]);
            }
            catch (Throwable t) {
                throw new BuildException(t);
            }
        }
    }

    private static class MapIterator
    implements HasIterator {
        private Map map;

        public MapIterator(Map map) {
            this.map = map;
        }

        public Iterator iterator() {
            return this.map.values().iterator();
        }
    }

    private static class IteratorIterator
    implements HasIterator {
        private Iterator iterator;

        public IteratorIterator(Iterator iterator) {
            this.iterator = iterator;
        }

        public Iterator iterator() {
            return this.iterator;
        }
    }

    private static interface HasIterator {
        public Iterator iterator();
    }
}

