/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.library;

import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.docking.GenericDragTargetListener;
import it.businesslogic.ireport.gui.event.ReportSubDatasetChangedEvent;
import it.businesslogic.ireport.gui.event.ReportSubDatasetChangedListener;
import it.businesslogic.ireport.gui.event.SubDatasetObjectChangedEvent;
import it.businesslogic.ireport.gui.event.SubDatasetObjectChangedListener;
import it.businesslogic.ireport.gui.library.AbstractLibraryObject;
import it.businesslogic.ireport.gui.library.LibraryTreeCellRenderer;
import it.businesslogic.ireport.gui.library.TreeTransfertHandler;
import it.businesslogic.ireport.gui.library.objects.DateObject;
import it.businesslogic.ireport.gui.library.objects.PageNumberObject;
import it.businesslogic.ireport.gui.library.objects.PageXYObject;
import it.businesslogic.ireport.gui.library.objects.PercentageObject;
import it.businesslogic.ireport.gui.library.objects.TotalObject;
import it.businesslogic.ireport.gui.library.objects.TotalPagesObject;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.LanguageChangedListener;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class LibraryPanel
extends JPanel
implements LanguageChangedListener,
SubDatasetObjectChangedListener,
ReportSubDatasetChangedListener {
    DefaultMutableTreeNode systemObjectsNode = null;
    JReportFrame jrf;
    private JTree jLibraryTree;
    private JScrollPane jScrollPane1;

    public LibraryPanel() {
        this.initComponents();
        this.jLibraryTree.setCellRenderer(new LibraryTreeCellRenderer());
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Libs");
        DefaultTreeModel dtm = new DefaultTreeModel(root);
        this.jLibraryTree.setModel(dtm);
        this.jLibraryTree.setDragEnabled(true);
        this.jLibraryTree.setRootVisible(false);
        this.jLibraryTree.setTransferHandler(new TreeTransfertHandler());
        this.jLibraryTree.setDropTarget(new DropTarget(this, new GenericDragTargetListener()));
        this.jLibraryTree.expandPath(new TreePath(root));
        this.getInputMap(2).put(KeyStroke.getKeyStroke("F5"), "refresh");
        this.getActionMap().put("refresh", new AbstractAction("refresh"){

            public void actionPerformed(ActionEvent evt) {
                LibraryPanel.this.setJReportFrame(LibraryPanel.this.jrf);
            }
        });
        I18n.addOnLanguageChangedListener(this);
        this.loadSystemObjects();
        this.loadCustomObjects();
        this.languageChanged(null);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jLibraryTree = new JTree();
        this.setLayout(new BorderLayout());
        this.jScrollPane1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                LibraryPanel.this.jScrollPane1MouseClicked(evt);
            }
        });
        this.jLibraryTree.setDragEnabled(true);
        this.jLibraryTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                LibraryPanel.this.jLibraryTreeMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jLibraryTree);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private SubDataset getSelectedSubDataset() {
        Object osd;
        if (this.jrf == null) {
            return null;
        }
        SubDataset sd = this.jrf.getReport();
        TreePath[] paths = this.jLibraryTree.getSelectionPaths();
        if (paths != null && paths.length == 1 && paths[0].getLastPathComponent() instanceof DefaultMutableTreeNode && paths[0].getPath().length >= 2 && (osd = ((DefaultMutableTreeNode)paths[0].getPath()[1]).getUserObject()) instanceof SubDataset) {
            sd = (SubDataset)osd;
        }
        return sd;
    }

    private void jScrollPane1MouseClicked(MouseEvent evt) {
        this.jLibraryTreeMouseClicked(evt);
    }

    private void jLibraryTreeMouseClicked(MouseEvent evt) {
    }

    public void languageChanged(LanguageChangedEvent evt) {
        this.jLibraryTree.updateUI();
    }

    public void setJReportFrame(JReportFrame jrf) {
        this.jrf = jrf;
    }

    private void loadCustomObjects() {
    }

    private void loadSystemObjects() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.jLibraryTree.getModel().getRoot();
        root.add(new DefaultMutableTreeNode(new PageNumberObject()));
        root.add(new DefaultMutableTreeNode(new TotalPagesObject()));
        root.add(new DefaultMutableTreeNode(new PageXYObject()));
        root.add(new DefaultMutableTreeNode(new TotalObject()));
        root.add(new DefaultMutableTreeNode(new DateObject()));
        root.add(new DefaultMutableTreeNode(new PercentageObject()));
    }

    private void addLibraryObject(String folder, AbstractLibraryObject obj) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.jLibraryTree.getModel().getRoot();
        if (folder == null || folder.length() == 0) {
            root.add(new DefaultMutableTreeNode(new PageNumberObject()));
        } else {
            Enumeration<TreeNode> enum_childrens = root.children();
            while (enum_childrens.hasMoreElements()) {
                DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)enum_childrens.nextElement();
                if (!("" + dmtn.getUserObject()).equalsIgnoreCase(folder)) continue;
                dmtn.add(new DefaultMutableTreeNode(obj));
            }
        }
    }

    public void updateReportObjects() {
    }

    public void subDatasetObjectChanged(SubDatasetObjectChangedEvent evt) {
    }

    public void applyI18n() {
    }

    public void setSelectedObject(Object obj) {
        DefaultMutableTreeNode mtd = Misc.findNodeWithUserObject(obj, (TreeNode)this.jLibraryTree.getModel().getRoot());
        if (mtd != null) {
            TreePath path = new TreePath(mtd.getPath());
            this.jLibraryTree.setSelectionPath(path);
            this.jLibraryTree.scrollPathToVisible(path);
        }
    }

    public void reportSubDatasetChanged(ReportSubDatasetChangedEvent evt) {
    }
}

