/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.GraphicReportElement;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.Style;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class RectangleReportElement
extends GraphicReportElement {
    public static final String RADIUS = "RADIUS";
    public static final int DEFAULT_RADIUS = 0;

    public RectangleReportElement(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.setKey("rectangle");
    }

    public RectangleReportElement(int x, int y, int width, int height, int radius) {
        this(x, y, width, height);
        this.setPropertyValue(RADIUS, "" + radius);
    }

    public void drawObject(Graphics2D g, double zoom_factor, int x_shift_origin, int y_shift_origin) {
        this.position.x -= 10;
        this.position.y -= 10;
        x_shift_origin -= 10;
        y_shift_origin -= 10;
        this.zoom_factor = zoom_factor;
        g.setColor(this.getBgcolor());
        if (!this.getTransparent().equalsIgnoreCase("Transparent")) {
            g.fillRoundRect(this.getZoomedDim(this.position.x) - x_shift_origin, this.getZoomedDim(this.position.y) - y_shift_origin, this.getZoomedDim(this.width), this.getZoomedDim(this.height), (int)((double)(2 * this.getRadius()) * zoom_factor), (int)((double)(2 * this.getRadius()) * zoom_factor));
        }
        g.setColor(this.getFgcolor());
        this.position.x += 10;
        this.position.y += 10;
        this.drawGraphicsElement(g, this.getGraphicElementPen(), zoom_factor, x_shift_origin += 10, y_shift_origin += 10, (int)((double)(2 * this.getRadius()) * zoom_factor));
    }

    public ReportElement cloneMe() {
        RectangleReportElement newReportElement = new RectangleReportElement(this.position.x, this.position.y, this.width, this.height);
        this.copyBaseReportElement(newReportElement, this);
        return newReportElement;
    }

    public void drawGraphicsElement(Graphics2D g, String pen, double zoom_factor, int x_shift_origin, int y_shift_origin) {
        Stroke stroke = this.getPenStroke(pen, zoom_factor);
        g.setColor(this.getFgcolor());
        this.zoom_factor = zoom_factor;
        if (stroke == null || pen.equalsIgnoreCase("None")) {
            return;
        }
        this.position.x -= 10;
        this.position.y -= 10;
        Stroke oldStroke = g.getStroke();
        g.setStroke(stroke);
        g.drawRoundRect(this.getZoomedDim(this.position.x) - (x_shift_origin -= 10), this.getZoomedDim(this.position.y) - (y_shift_origin -= 10), this.getZoomedDim(this.width), this.getZoomedDim(this.height), (int)((double)(2 * this.getRadius()) * zoom_factor), (int)((double)(2 * this.getRadius()) * zoom_factor));
        this.position.x += 10;
        this.position.y += 10;
        g.setStroke(oldStroke);
    }

    public int getRadius() {
        if (this.getPropertyValue(RADIUS) == null && this.getStyle() != null) {
            Style style = this.getStyle();
            this.getStyle();
            return style.getAttributeInteger("radius", 0, true);
        }
        return this.getIntValue(RADIUS, 0);
    }

    public void setRadius(int radius) {
        this.setPropertyValue(RADIUS, radius + "");
    }

    public void copyBaseReportElement(ReportElement destination, ReportElement source) {
        super.copyBaseReportElement(destination, source);
        if (destination instanceof RectangleReportElement && source instanceof RectangleReportElement) {
            destination.setPropertyValue(RADIUS, source.getPropertyValue(RADIUS));
        }
    }

    public void setStyle(Style style) {
        super.setStyle(style);
    }
}

