/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.server;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.jboss.logging.Logger;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.wsf.common.DOMUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSDLRequestHandler {
    private Logger log = Logger.getLogger(WSDLRequestHandler.class);
    private EndpointMetaData epMetaData;

    public WSDLRequestHandler(EndpointMetaData epMetaData) {
        this.epMetaData = epMetaData;
    }

    public Document getDocumentForPath(URL reqURL, String wsdlHost, String resPath) throws IOException {
        Document wsdlDoc;
        URL wsdlLocation = this.epMetaData.getServiceMetaData().getWsdlLocation();
        if (wsdlLocation == null) {
            throw new IllegalStateException("Cannot obtain wsdl location");
        }
        if (resPath == null) {
            Element wsdlElement = DOMUtils.parse(wsdlLocation.openStream());
            wsdlDoc = wsdlElement.getOwnerDocument();
        } else {
            String impResourcePath = new File(wsdlLocation.getPath()).getParent() + File.separatorChar + resPath;
            File impResourceFile = new File(impResourcePath);
            Element wsdlElement = DOMUtils.parse(impResourceFile.toURL().openStream());
            wsdlDoc = wsdlElement.getOwnerDocument();
        }
        this.modifyAddressReferences(reqURL, wsdlHost, resPath, wsdlDoc.getDocumentElement());
        return wsdlDoc;
    }

    private void modifyAddressReferences(URL reqURL, String wsdlHost, String resPath, Element element) throws IOException {
        NodeList nlist = element.getChildNodes();
        for (int i = 0; i < nlist.getLength(); ++i) {
            String orgLocation;
            Attr locationAttr;
            Node childNode = nlist.item(i);
            if (childNode.getNodeType() != 1) continue;
            Element childElement = (Element)childNode;
            String nodeName = childElement.getLocalName();
            if ("import".equals(nodeName) || "include".equals(nodeName)) {
                boolean isAbsolute;
                locationAttr = childElement.getAttributeNode("schemaLocation");
                if (locationAttr == null) {
                    locationAttr = childElement.getAttributeNode("location");
                }
                if (locationAttr == null) continue;
                orgLocation = locationAttr.getNodeValue();
                while (orgLocation.startsWith("./")) {
                    orgLocation = orgLocation.substring(2);
                }
                boolean bl = isAbsolute = orgLocation.startsWith("http://") || orgLocation.startsWith("https://");
                if (isAbsolute || orgLocation.startsWith(reqURL.getPath())) continue;
                String newResourcePath = orgLocation;
                if (resPath != null && resPath.indexOf("/") > 0) {
                    String resParent = resPath.substring(0, resPath.lastIndexOf("/"));
                    while (orgLocation.startsWith("../") && resParent != null) {
                        if (resParent.indexOf("/") > 0) {
                            resParent = resParent.substring(0, resParent.lastIndexOf("/"));
                            orgLocation = orgLocation.substring(3);
                            newResourcePath = resParent + "/" + orgLocation;
                            continue;
                        }
                        newResourcePath = orgLocation = orgLocation.substring(3);
                        resParent = null;
                    }
                    if (resParent != null) {
                        newResourcePath = resParent + "/" + orgLocation;
                    }
                }
                String reqPath = reqURL.getPath();
                String completeHost = wsdlHost;
                if (!wsdlHost.startsWith("http://") && !wsdlHost.startsWith("https://")) {
                    String reqProtocol = reqURL.getProtocol();
                    int reqPort = reqURL.getPort();
                    String hostAndPort = wsdlHost + (reqPort > 0 ? ":" + reqPort : "");
                    completeHost = reqProtocol + "://" + hostAndPort;
                }
                String newLocation = completeHost + reqPath + "?wsdl&resource=" + newResourcePath;
                locationAttr.setNodeValue(newLocation);
                this.log.trace((Object)("Mapping import from '" + orgLocation + "' to '" + newLocation + "'"));
                continue;
            }
            if ("address".equals(nodeName)) {
                locationAttr = childElement.getAttributeNode("location");
                if (locationAttr == null) continue;
                orgLocation = locationAttr.getNodeValue();
                URL orgURL = new URL(orgLocation);
                String orgProtocol = orgURL.getProtocol();
                String orgHost = orgURL.getHost();
                int orgPort = orgURL.getPort();
                String orgPath = orgURL.getPath();
                if (!"jbossws.undefined.host".equals(orgHost)) continue;
                URL newURL = new URL(wsdlHost);
                String newHost = newURL.getHost();
                int newPort = newURL.getPort();
                String newLocation = orgProtocol + "://" + newHost;
                if (newPort != -1) {
                    newLocation = newLocation + ":" + newPort;
                } else if (orgPort != -1) {
                    newLocation = newLocation + ":" + orgPort;
                }
                newLocation = newLocation + orgPath;
                locationAttr.setNodeValue(newLocation);
                this.log.trace((Object)("Mapping address from '" + orgLocation + "' to '" + newLocation + "'"));
                continue;
            }
            this.modifyAddressReferences(reqURL, wsdlHost, resPath, childElement);
        }
    }
}

