/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import [Ljava.lang.Object;;
import groovy.lang.AdaptingMetaClass;
import groovy.lang.Closure;
import groovy.lang.ExpandoMetaClassCreationHandle;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovySystem;
import groovy.lang.MetaBeanProperty;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassImpl;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import groovy.lang.MutableMetaClass;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.ReflectionCache;
import org.codehaus.groovy.runtime.DefaultCachedMethodKey;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.runtime.metaclass.ClosureMetaMethod;
import org.codehaus.groovy.runtime.metaclass.ClosureStaticMetaMethod;
import org.codehaus.groovy.runtime.metaclass.ConcurrentReaderHashMap;
import org.codehaus.groovy.runtime.metaclass.ThreadManagedMetaBeanProperty;

public class ExpandoMetaClass
extends MetaClassImpl
implements GroovyObject {
    private static final String META_CLASS = "metaClass";
    private static final String CLASS = "class";
    private static final String META_METHODS = "metaMethods";
    private static final String METHODS = "methods";
    private static final String PROPERTIES = "properties";
    public static final String STATIC_QUALIFIER = "static";
    private static final Class[] ZERO_ARGUMENTS = new Class[0];
    private static final String CONSTRUCTOR = "constructor";
    private static final String GET_PROPERTY_METHOD = "getProperty";
    private static final String SET_PROPERTY_METHOD = "setProperty";
    private static final String INVOKE_METHOD_METHOD = "invokeMethod";
    private static final String CLASS_PROPERTY = "class";
    private static final String META_CLASS_PROPERTY = "metaClass";
    private static final String GROOVY_CONSTRUCTOR = "<init>";
    private MetaClass myMetaClass;
    private boolean allowChangesAfterInit;
    private boolean initialized;
    private boolean initCalled;
    private boolean modified;
    private boolean inRegistry;
    private final Set inheritedMetaMethods = new HashSet();
    private final Map beanPropertyCache = new ConcurrentReaderHashMap();
    private final Map staticBeanPropertyCache = new ConcurrentReaderHashMap();
    private final Map expandoMethods = new ConcurrentReaderHashMap();
    private final Map expandoProperties = new ConcurrentReaderHashMap();
    private ClosureMetaMethod getPropertyMethod;
    private ClosureMetaMethod invokeMethodMethod;
    private ClosureMetaMethod setPropertyMethod;
    private ClosureStaticMetaMethod invokeStaticMethodMethod;

    public ExpandoMetaClass(Class theClass) {
        super(GroovySystem.getMetaClassRegistry(), theClass);
        this.myMetaClass = InvokerHelper.getMetaClass(this);
    }

    public ExpandoMetaClass(Class theClass, boolean register) {
        this(theClass);
        this.inRegistry = register;
    }

    public ExpandoMetaClass(Class theClass, boolean register, boolean allowChangesAfterInit) {
        this(theClass);
        this.inRegistry = register;
        this.allowChangesAfterInit = allowChangesAfterInit;
    }

    public Object invokeMissingMethod(Object instance, String methodName, Object[] arguments) {
        for (Class<?> superClass = instance instanceof Class ? (Class<?>)instance : instance.getClass(); superClass != (class$java$lang$Object == null ? ExpandoMetaClass.class$("java.lang.Object") : class$java$lang$Object); superClass = superClass.getSuperclass()) {
            MetaMethod method = this.findMethodInClassHeirarchy(methodName, arguments, superClass);
            if (method == null) continue;
            this.addSuperMethodIfNotOverriden(method);
            return method.invoke(instance, arguments);
        }
        Object[] invokeMethodArgs = new Object[]{methodName, arguments};
        MetaMethod method = this.findMethodInClassHeirarchy(INVOKE_METHOD_METHOD, invokeMethodArgs, this.theClass);
        if (method != null && method instanceof ClosureMetaMethod) {
            this.invokeMethodMethod = (ClosureMetaMethod)method;
            return method.invoke(instance, invokeMethodArgs);
        }
        return super.invokeMissingMethod(instance, methodName, arguments);
    }

    public Object invokeMissingProperty(Object instance, String propertyName, Object optionalValue, boolean isGetter) {
        Class<?> theClass = instance instanceof Class ? (Class<?>)instance : instance.getClass();
        for (CachedClass superClass = this.theCachedClass; superClass != ReflectionCache.OBJECT_CLASS; superClass = superClass.getCachedSuperClass()) {
            MetaBeanProperty property = this.findPropertyInClassHierarchy(propertyName, superClass);
            if (property == null) continue;
            this.addMetaBeanProperty(property);
            if (!isGetter) {
                property.setProperty(instance, optionalValue);
                return null;
            }
            return property.getProperty(instance);
        }
        if (isGetter) {
            Object[] getPropertyArgs = new Object[]{propertyName};
            MetaMethod method = this.findMethodInClassHeirarchy(GET_PROPERTY_METHOD, getPropertyArgs, theClass);
            if (method != null && method instanceof ClosureMetaMethod) {
                this.getPropertyMethod = (ClosureMetaMethod)method;
                return method.invoke(instance, getPropertyArgs);
            }
        } else {
            Object[] setPropertyArgs = new Object[]{propertyName, optionalValue};
            MetaMethod method = this.findMethodInClassHeirarchy(SET_PROPERTY_METHOD, setPropertyArgs, theClass);
            if (method != null && method instanceof ClosureMetaMethod) {
                this.setPropertyMethod = (ClosureMetaMethod)method;
                return method.invoke(instance, setPropertyArgs);
            }
        }
        return super.invokeMissingProperty(instance, propertyName, optionalValue, isGetter);
    }

    private MetaBeanProperty findPropertyInClassHierarchy(String propertyName, CachedClass theClass) {
        MetaBeanProperty property = null;
        CachedClass superClass = theClass.getCachedSuperClass();
        MetaClass metaClass = this.registry.getMetaClass(superClass.getCachedClass());
        if (metaClass instanceof MutableMetaClass && (property = this.getMetaPropertyFromMutableMetaClass(propertyName, metaClass)) == null) {
            if (superClass != ReflectionCache.OBJECT_CLASS) {
                property = this.findPropertyInClassHierarchy(propertyName, superClass);
            }
            if (property == null) {
                Class[] interfaces = theClass.getCachedClass().getInterfaces();
                property = this.searchInterfacesForMetaProperty(propertyName, interfaces);
            }
        }
        return property;
    }

    private MetaBeanProperty searchInterfacesForMetaProperty(String propertyName, Class[] interfaces) {
        Class[] superInterfaces;
        Class anInterface;
        MetaClass metaClass;
        MetaBeanProperty property = null;
        for (int i = 0; !(i >= interfaces.length || (metaClass = this.registry.getMetaClass(anInterface = interfaces[i])) instanceof MutableMetaClass && (property = this.getMetaPropertyFromMutableMetaClass(propertyName, metaClass)) != null || (superInterfaces = anInterface.getInterfaces()).length > 0 && (property = this.searchInterfacesForMetaProperty(propertyName, superInterfaces)) != null); ++i) {
        }
        return property;
    }

    private MetaBeanProperty getMetaPropertyFromMutableMetaClass(String propertyName, MetaClass metaClass) {
        boolean isModified = ((MutableMetaClass)metaClass).isModified();
        MetaProperty metaProperty = metaClass.getMetaProperty(propertyName);
        if (metaProperty instanceof MetaBeanProperty) {
            return isModified ? (MetaBeanProperty)metaProperty : null;
        }
        return null;
    }

    private MetaMethod findMethodInClassHeirarchy(String methodName, Object[] arguments, Class theClass) {
        MetaMethod method = null;
        Class superClass = theClass.getSuperclass();
        if (superClass == null) {
            return null;
        }
        MetaClass metaClass = this.registry.getMetaClass(superClass);
        if (metaClass instanceof MutableMetaClass && (method = this.getMetaMethodFromMutableMetaClass(methodName, arguments, metaClass)) == null) {
            if (superClass != Object.class) {
                method = this.findMethodInClassHeirarchy(methodName, arguments, superClass);
            }
            if (method == null) {
                Class[] interfaces = theClass.getInterfaces();
                method = this.searchInterfacesForMetaMethod(methodName, arguments, interfaces);
            }
        }
        return method;
    }

    private MetaMethod searchInterfacesForMetaMethod(String methodName, Object[] arguments, Class[] interfaces) {
        Class[] superInterfaces;
        Class anInterface;
        MetaClass metaClass;
        MetaMethod method = null;
        for (int i = 0; !(i >= interfaces.length || (metaClass = this.registry.getMetaClass(anInterface = interfaces[i])) instanceof MutableMetaClass && (method = this.getMetaMethodFromMutableMetaClass(methodName, arguments, metaClass)) != null || (superInterfaces = anInterface.getInterfaces()).length > 0 && (method = this.searchInterfacesForMetaMethod(methodName, arguments, superInterfaces)) != null); ++i) {
        }
        return method;
    }

    private MetaMethod getMetaMethodFromMutableMetaClass(String methodName, Object[] arguments, MetaClass metaClass) {
        boolean isModified = ((MutableMetaClass)metaClass).isModified();
        return isModified ? metaClass.getMetaMethod(methodName, arguments) : null;
    }

    public synchronized boolean isModified() {
        return this.modified;
    }

    public static void enableGlobally() {
        ExpandoMetaClassCreationHandle.enable();
    }

    public static void disableGlobally() {
        ExpandoMetaClassCreationHandle.disable();
    }

    public synchronized void initialize() {
        if (!this.isInitialized()) {
            super.initialize();
            this.setInitialized(true);
            this.initCalled = true;
        }
    }

    protected synchronized boolean isInitialized() {
        return this.initialized;
    }

    protected synchronized void setInitialized(boolean b) {
        this.initialized = b;
    }

    private void addSuperMethodIfNotOverriden(final MetaMethod metaMethodFromSuper) {
        this.performOperationOnMetaClass(new Callable(){

            public void call() {
                MetaMethod existing = null;
                try {
                    existing = ExpandoMetaClass.this.pickMethod(metaMethodFromSuper.getName(), metaMethodFromSuper.getNativeParameterTypes());
                }
                catch (GroovyRuntimeException e) {
                    // empty catch block
                }
                if (existing == null) {
                    this.addMethodWithKey(metaMethodFromSuper);
                } else {
                    boolean isGroovyMethod = ExpandoMetaClass.this.getMetaMethods().contains(existing);
                    if (isGroovyMethod) {
                        this.addMethodWithKey(metaMethodFromSuper);
                    } else if (ExpandoMetaClass.this.inheritedMetaMethods.contains(existing)) {
                        ExpandoMetaClass.this.inheritedMetaMethods.remove(existing);
                        this.addMethodWithKey(metaMethodFromSuper);
                    }
                }
            }

            private void addMethodWithKey(MetaMethod metaMethodFromSuper2) {
                ExpandoMetaClass.this.inheritedMetaMethods.add(metaMethodFromSuper2);
                if (metaMethodFromSuper2 instanceof ClosureMetaMethod) {
                    ClosureMetaMethod closureMethod = (ClosureMetaMethod)metaMethodFromSuper2;
                    Closure cloned = (Closure)closureMethod.getClosure().clone();
                    String name = metaMethodFromSuper2.getName();
                    ClosureMetaMethod localMethod = new ClosureMetaMethod(name, ExpandoMetaClass.this.getJavaClass(), cloned);
                    ExpandoMetaClass.this.addMetaMethod(localMethod);
                    DefaultCachedMethodKey key = new DefaultCachedMethodKey(ExpandoMetaClass.this.getJavaClass(), name, localMethod.getParameterTypes(), false);
                    ExpandoMetaClass.this.checkIfGroovyObjectMethod(localMethod, name);
                    ExpandoMetaClass.this.expandoMethods.put(key, localMethod);
                }
            }
        });
    }

    public Object invokeConstructor(Object[] arguments) {
        Class[] argClasses = MetaClassHelper.convertToTypeArray(arguments);
        MetaMethod method = this.pickMethod(GROOVY_CONSTRUCTOR, argClasses);
        if (method != null && method.getParameterTypes().length == arguments.length) {
            return method.invoke(this.theClass, arguments);
        }
        return super.invokeConstructor(arguments);
    }

    protected LinkedList getSuperClasses() {
        LinkedList<Class> superClasses = new LinkedList<Class>();
        for (Class c = this.theClass; c != null; c = c.getSuperclass()) {
            superClasses.addFirst(c);
        }
        if (this.getJavaClass().isArray() && this.getJavaClass() != Object;.class && !this.getJavaClass().getComponentType().isPrimitive()) {
            superClasses.addFirst(Object;.class);
        }
        return superClasses;
    }

    public MetaClass getMetaClass() {
        return this.myMetaClass;
    }

    public Object getProperty(String property) {
        if (this.isValidExpandoProperty(property)) {
            if (property.equals(STATIC_QUALIFIER)) {
                return new ExpandoMetaProperty(property, true);
            }
            if (property.equals(CONSTRUCTOR)) {
                return new ExpandoMetaConstructor();
            }
            if (this.myMetaClass.hasProperty(this, property) == null) {
                return new ExpandoMetaProperty(property);
            }
            return this.myMetaClass.getProperty(this, property);
        }
        return this.myMetaClass.getProperty(this, property);
    }

    private boolean isValidExpandoProperty(String property) {
        return !property.equals("metaClass") && !property.equals("class") && !property.equals(META_METHODS) && !property.equals(METHODS) && !property.equals(PROPERTIES);
    }

    public Object invokeMethod(String name, Object args) {
        return this.myMetaClass.invokeMethod((Object)this, name, args);
    }

    public void setMetaClass(MetaClass metaClass) {
        this.myMetaClass = metaClass;
    }

    public void setProperty(String property, Object newValue) {
        if (newValue instanceof Closure) {
            if (property.equals(CONSTRUCTOR)) {
                property = GROOVY_CONSTRUCTOR;
            }
            Closure callable = (Closure)newValue;
            this.registerInstanceMethod(property, callable);
        } else {
            this.registerBeanProperty(property, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void performOperationOnMetaClass(Callable c) {
        try {
            if (this.allowChangesAfterInit) {
                this.setInitialized(false);
            }
            c.call();
        }
        finally {
            if (this.initCalled) {
                this.setInitialized(true);
            }
        }
    }

    protected void registerBeanProperty(final String property, final Object newValue) {
        this.performOperationOnMetaClass(new Callable(){

            public void call() {
                Class clazz = newValue == null ? (class$java$lang$Object == null ? (class$java$lang$Object = ExpandoMetaClass.class$("java.lang.Object")) : class$java$lang$Object) : newValue.getClass();
                Class type = clazz;
                MetaBeanProperty mbp = newValue instanceof MetaBeanProperty ? (MetaBeanProperty)newValue : new ThreadManagedMetaBeanProperty(ExpandoMetaClass.this.theClass, property, type, newValue);
                MetaMethod getter = mbp.getGetter();
                DefaultCachedMethodKey getterKey = new DefaultCachedMethodKey(ExpandoMetaClass.this.theClass, getter.getName(), CachedClass.EMPTY_ARRAY, false);
                MetaMethod setter = mbp.getSetter();
                DefaultCachedMethodKey setterKey = new DefaultCachedMethodKey(ExpandoMetaClass.this.theClass, setter.getName(), setter.getParameterTypes(), false);
                ExpandoMetaClass.this.addMetaMethod(getter);
                ExpandoMetaClass.this.addMetaMethod(setter);
                ExpandoMetaClass.this.expandoMethods.put(setterKey, setter);
                ExpandoMetaClass.this.expandoMethods.put(getterKey, getter);
                ExpandoMetaClass.this.expandoProperties.put(mbp.getName(), mbp);
                ExpandoMetaClass.this.addMetaBeanProperty(mbp);
                ExpandoMetaClass.this.performRegistryCallbacks();
            }
        });
    }

    protected void registerInstanceMethod(final String methodName, final Closure callable) {
        final boolean inited = this.initCalled;
        this.performOperationOnMetaClass(new Callable(){

            public void call() {
                ClosureMetaMethod metaMethod = new ClosureMetaMethod(methodName, ExpandoMetaClass.this.theClass, callable);
                ExpandoMetaClass.this.checkIfGroovyObjectMethod(metaMethod, methodName);
                DefaultCachedMethodKey key = new DefaultCachedMethodKey(ExpandoMetaClass.this.theClass, methodName, metaMethod.getParameterTypes(), false);
                ExpandoMetaClass.this.addMetaMethod(metaMethod);
                ExpandoMetaClass.this.dropMethodCache(methodName);
                ExpandoMetaClass.this.expandoMethods.put(key, metaMethod);
                if (inited && ExpandoMetaClass.this.isGetter(methodName, metaMethod.getParameterTypes())) {
                    String propertyName = ExpandoMetaClass.this.getPropertyForGetter(methodName);
                    ExpandoMetaClass.this.registerBeanPropertyForMethod(metaMethod, propertyName, true, false);
                } else if (inited && ExpandoMetaClass.this.isSetter(methodName, metaMethod.getParameterTypes())) {
                    String propertyName = ExpandoMetaClass.this.getPropertyForSetter(methodName);
                    ExpandoMetaClass.this.registerBeanPropertyForMethod(metaMethod, propertyName, false, false);
                }
                ExpandoMetaClass.this.performRegistryCallbacks();
            }
        });
    }

    public List getMethods() {
        ArrayList methodList = new ArrayList();
        methodList.addAll(this.expandoMethods.values());
        methodList.addAll(super.getMethods());
        return methodList;
    }

    public List getProperties() {
        ArrayList propertyList = new ArrayList();
        propertyList.addAll(this.expandoProperties.values());
        propertyList.addAll(super.getProperties());
        return propertyList;
    }

    private void checkIfGroovyObjectMethod(ClosureMetaMethod metaMethod, String methodName) {
        if (this.isGetPropertyMethod(methodName)) {
            this.getPropertyMethod = metaMethod;
        } else if (this.isInvokeMethod(methodName, metaMethod)) {
            this.invokeMethodMethod = metaMethod;
        } else if (this.isSetPropertyMethod(methodName, metaMethod)) {
            this.setPropertyMethod = metaMethod;
        }
    }

    private boolean isSetPropertyMethod(String methodName, ClosureMetaMethod metaMethod) {
        return SET_PROPERTY_METHOD.equals(methodName) && metaMethod.getParameterTypes().length == 2;
    }

    private boolean isGetPropertyMethod(String methodName) {
        return GET_PROPERTY_METHOD.equals(methodName);
    }

    private boolean isInvokeMethod(String methodName, ClosureMetaMethod metaMethod) {
        return INVOKE_METHOD_METHOD.equals(methodName) && metaMethod.getParameterTypes().length == 2;
    }

    private void performRegistryCallbacks() {
        ExpandoMetaClassCreationHandle creationHandler;
        MetaClassRegistry registry = GroovySystem.getMetaClassRegistry();
        if (!this.modified) {
            this.modified = true;
            if (this.inRegistry) {
                MetaClass currMetaClass = registry.getMetaClass(this.theClass);
                if (!(currMetaClass instanceof ExpandoMetaClass) && currMetaClass instanceof AdaptingMetaClass) {
                    ((AdaptingMetaClass)currMetaClass).setAdaptee(this);
                } else {
                    registry.setMetaClass(this.theClass, this);
                }
            }
        }
        if (registry.getMetaClassCreationHandler() instanceof ExpandoMetaClassCreationHandle && !(creationHandler = (ExpandoMetaClassCreationHandle)registry.getMetaClassCreationHandler()).hasModifiedMetaClass(this)) {
            creationHandler.registerModifiedMetaClass(this);
        }
    }

    private void registerBeanPropertyForMethod(MetaMethod metaMethod, String propertyName, boolean getter, boolean isStatic) {
        Map propertyCache = isStatic ? this.staticBeanPropertyCache : this.beanPropertyCache;
        MetaBeanProperty beanProperty = (MetaBeanProperty)propertyCache.get(propertyName);
        if (beanProperty == null) {
            beanProperty = getter ? new MetaBeanProperty(propertyName, Object.class, metaMethod, null) : new MetaBeanProperty(propertyName, Object.class, null, metaMethod);
            propertyCache.put(propertyName, beanProperty);
        } else if (getter) {
            MetaMethod setterMethod = beanProperty.getSetter();
            Class type = setterMethod != null ? setterMethod.getParameterTypes()[0].getCachedClass() : Object.class;
            beanProperty = new MetaBeanProperty(propertyName, type, metaMethod, setterMethod);
            propertyCache.put(propertyName, beanProperty);
        } else {
            MetaMethod getterMethod = beanProperty.getGetter();
            beanProperty = new MetaBeanProperty(propertyName, metaMethod.getParameterTypes()[0].getCachedClass(), getterMethod, metaMethod);
            propertyCache.put(propertyName, beanProperty);
        }
        this.expandoProperties.put(beanProperty.getName(), beanProperty);
        this.addMetaBeanProperty(beanProperty);
    }

    protected void registerStaticMethod(final String name, final Closure callable) {
        this.performOperationOnMetaClass(new Callable(){

            public void call() {
                String methodName = name.equals("methodMissing") ? "$static_methodMissing" : (name.equals("propertyMissing") ? "$static_propertyMissing" : name);
                ClosureStaticMetaMethod metaMethod = new ClosureStaticMetaMethod(methodName, ExpandoMetaClass.this.theClass, callable);
                if (methodName.equals(ExpandoMetaClass.INVOKE_METHOD_METHOD) && callable.getParameterTypes().length == 2) {
                    ExpandoMetaClass.this.invokeStaticMethodMethod = metaMethod;
                } else {
                    if (methodName.equals("methodMissing")) {
                        methodName = "$static_methodMissing";
                    }
                    DefaultCachedMethodKey key = new DefaultCachedMethodKey(ExpandoMetaClass.this.theClass, methodName, metaMethod.getParameterTypes(), false);
                    ExpandoMetaClass.this.addMetaMethod(metaMethod);
                    ExpandoMetaClass.this.dropStaticMethodCache(methodName);
                    if (ExpandoMetaClass.this.isGetter(methodName, metaMethod.getParameterTypes())) {
                        String propertyName = ExpandoMetaClass.this.getPropertyForGetter(methodName);
                        ExpandoMetaClass.this.registerBeanPropertyForMethod(metaMethod, propertyName, true, true);
                    } else if (ExpandoMetaClass.this.isSetter(methodName, metaMethod.getParameterTypes())) {
                        String propertyName = ExpandoMetaClass.this.getPropertyForSetter(methodName);
                        ExpandoMetaClass.this.registerBeanPropertyForMethod(metaMethod, propertyName, false, true);
                    }
                    ExpandoMetaClass.this.performRegistryCallbacks();
                    ExpandoMetaClass.this.expandoMethods.put(key, metaMethod);
                }
            }
        });
    }

    public Class getJavaClass() {
        return this.theClass;
    }

    public void refreshInheritedMethods(Set modifiedSuperExpandos) {
        Iterator i = modifiedSuperExpandos.iterator();
        while (i.hasNext()) {
            ExpandoMetaClass superExpando = (ExpandoMetaClass)i.next();
            if (superExpando == this) continue;
            List metaMethods = superExpando.getExpandoMethods();
            Iterator j = metaMethods.iterator();
            while (j.hasNext()) {
                MetaMethod metaMethod = (MetaMethod)j.next();
                if (metaMethod.isStatic()) continue;
                this.addSuperMethodIfNotOverriden(metaMethod);
            }
            Collection metaProperties = superExpando.getExpandoProperties();
            Iterator j2 = metaProperties.iterator();
            while (j2.hasNext()) {
                MetaBeanProperty property = (MetaBeanProperty)j2.next();
                this.expandoProperties.put(property.getName(), property);
                this.addMetaBeanProperty(property);
            }
        }
    }

    public List getExpandoMethods() {
        return Collections.unmodifiableList(DefaultGroovyMethods.toList(this.expandoMethods.values()));
    }

    public Collection getExpandoProperties() {
        return Collections.unmodifiableCollection(this.expandoProperties.values());
    }

    public Object invokeMethod(Class sender, Object object, String methodName, Object[] originalArguments, boolean isCallToSuper, boolean fromInsideClass) {
        if (this.invokeMethodMethod != null) {
            return this.invokeMethodMethod.invoke(object, new Object[]{methodName, originalArguments});
        }
        return super.invokeMethod(sender, object, methodName, originalArguments, isCallToSuper, fromInsideClass);
    }

    public Object invokeStaticMethod(Object object, String methodName, Object[] arguments) {
        if (this.invokeStaticMethodMethod != null) {
            return this.invokeStaticMethodMethod.invoke(object, new Object[]{methodName, arguments});
        }
        return super.invokeStaticMethod(object, methodName, arguments);
    }

    public Object getProperty(Class sender, Object object, String name, boolean useSuper, boolean fromInsideClass) {
        if (this.hasOverrideGetProperty(name) && this.getJavaClass().isInstance(object)) {
            return this.getPropertyMethod.invoke(object, new Object[]{name});
        }
        return super.getProperty(sender, object, name, useSuper, fromInsideClass);
    }

    public Object getProperty(Object object, String name) {
        if (this.hasOverrideGetProperty(name) && this.getJavaClass().isInstance(object)) {
            return this.getPropertyMethod.invoke(object, new Object[]{name});
        }
        return super.getProperty(object, name);
    }

    private boolean hasOverrideGetProperty(String name) {
        return this.getPropertyMethod != null && !name.equals("metaClass") && !name.equals("class");
    }

    public void setProperty(Class sender, Object object, String name, Object newValue, boolean useSuper, boolean fromInsideClass) {
        if (this.setPropertyMethod != null && !name.equals("metaClass") && this.getJavaClass().isInstance(object)) {
            this.setPropertyMethod.invoke(object, new Object[]{name, newValue});
            return;
        }
        super.setProperty(sender, object, name, newValue, useSuper, fromInsideClass);
    }

    public MetaProperty getMetaProperty(String name) {
        MetaProperty mp = (MetaProperty)this.expandoProperties.get(name);
        if (mp != null) {
            return mp;
        }
        return super.getMetaProperty(name);
    }

    public boolean hasMetaProperty(String name) {
        return this.getMetaProperty(name) != null;
    }

    public boolean hasMetaMethod(String name, Class[] args) {
        return super.pickMethod(name, args) != null;
    }

    private boolean isGetter(String name, CachedClass[] args) {
        if (name == null || name.length() == 0 || args == null) {
            return false;
        }
        if (args.length != 0) {
            return false;
        }
        return name.startsWith("get") ? (name = name.substring(3)).length() > 0 && Character.isUpperCase(name.charAt(0)) : name.startsWith("is") && (name = name.substring(2)).length() > 0 && Character.isUpperCase(name.charAt(0));
    }

    private String getPropertyForGetter(String getterName) {
        if (getterName == null || getterName.length() == 0) {
            return null;
        }
        if (getterName.startsWith("get")) {
            String prop = getterName.substring(3);
            return this.convertPropertyName(prop);
        }
        if (getterName.startsWith("is")) {
            String prop = getterName.substring(2);
            return this.convertPropertyName(prop);
        }
        return null;
    }

    private String convertPropertyName(String prop) {
        if (Character.isUpperCase(prop.charAt(0)) && prop.length() > 1 && Character.isUpperCase(prop.charAt(1))) {
            return prop;
        }
        if (Character.isDigit(prop.charAt(0))) {
            return prop;
        }
        return Character.toLowerCase(prop.charAt(0)) + (prop.length() > 1 ? prop.substring(1) : "");
    }

    public String getPropertyForSetter(String setterName) {
        if (setterName == null || setterName.length() == 0) {
            return null;
        }
        if (setterName.startsWith("set")) {
            String prop = setterName.substring(3);
            return this.convertPropertyName(prop);
        }
        return null;
    }

    public boolean isSetter(String name, CachedClass[] args) {
        if (name == null || name.length() == 0 || args == null) {
            return false;
        }
        if (name.startsWith("set")) {
            if (args.length != 1) {
                return false;
            }
            if ((name = name.substring(3)).length() > 0 && Character.isUpperCase(name.charAt(0))) {
                return true;
            }
        }
        return false;
    }

    protected class ExpandoMetaConstructor
    extends GroovyObjectSupport {
        protected ExpandoMetaConstructor() {
        }

        public Object leftShift(Closure c) {
            if (c != null) {
                Constructor ctor;
                Class[] paramTypes = c.getParameterTypes();
                if (paramTypes == null) {
                    paramTypes = ZERO_ARGUMENTS;
                }
                if ((ctor = ExpandoMetaClass.this.retrieveConstructor(paramTypes)) != null) {
                    throw new GroovyRuntimeException("Cannot add new constructor for arguments [" + DefaultGroovyMethods.inspect(paramTypes) + "]. It already exists!");
                }
                ExpandoMetaClass.this.registerInstanceMethod(ExpandoMetaClass.GROOVY_CONSTRUCTOR, c);
            }
            return this;
        }
    }

    protected class ExpandoMetaProperty
    extends GroovyObjectSupport {
        protected String propertyName;
        protected boolean isStatic;

        protected ExpandoMetaProperty(String name) {
            this(name, false);
        }

        protected ExpandoMetaProperty(String name, boolean isStatic) {
            this.propertyName = name;
            this.isStatic = isStatic;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public boolean isStatic() {
            return this.isStatic;
        }

        public Object leftShift(Object arg) {
            this.registerIfClosure(arg, false);
            return this;
        }

        private void registerIfClosure(Object arg, boolean replace) {
            if (arg instanceof Closure) {
                Closure callable = (Closure)arg;
                Class[] paramTypes = callable.getParameterTypes();
                if (paramTypes == null) {
                    paramTypes = ZERO_ARGUMENTS;
                }
                if (!this.isStatic) {
                    Method foundMethod = this.checkIfMethodExists(ExpandoMetaClass.this.theClass, this.propertyName, paramTypes, false);
                    if (foundMethod != null && !replace) {
                        throw new GroovyRuntimeException("Cannot add new method [" + this.propertyName + "] for arguments [" + DefaultGroovyMethods.inspect(paramTypes) + "]. It already exists!");
                    }
                    ExpandoMetaClass.this.registerInstanceMethod(this.propertyName, callable);
                } else {
                    Method foundMethod = this.checkIfMethodExists(ExpandoMetaClass.this.theClass, this.propertyName, paramTypes, true);
                    if (foundMethod != null && !replace) {
                        throw new GroovyRuntimeException("Cannot add new static method [" + this.propertyName + "] for arguments [" + DefaultGroovyMethods.inspect(paramTypes) + "]. It already exists!");
                    }
                    ExpandoMetaClass.this.registerStaticMethod(this.propertyName, callable);
                }
            }
        }

        private Method checkIfMethodExists(Class methodClass, String methodName, Class[] paramTypes, boolean staticMethod) {
            Method foundMethod = null;
            Method[] methods = methodClass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(methodName) || Modifier.isStatic(methods[i].getModifiers()) != staticMethod || !MetaClassHelper.parametersAreCompatible(paramTypes, methods[i].getParameterTypes())) continue;
                foundMethod = methods[i];
                break;
            }
            return foundMethod;
        }

        public Object getProperty(String property) {
            this.propertyName = property;
            return this;
        }

        public void setProperty(String property, Object newValue) {
            this.propertyName = property;
            this.registerIfClosure(newValue, true);
        }
    }

    private static interface Callable {
        public void call();
    }
}

