/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.zkoss.lang.Classes;
import org.zkoss.lang.SystemException;
import org.zkoss.util.CollectionsX;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventThreadCleanup;
import org.zkoss.zk.ui.event.EventThreadInit;
import org.zkoss.zk.ui.event.EventThreadResume;
import org.zkoss.zk.ui.util.Configuration;
import org.zkoss.zkplus.util.ThreadLocals;

public class ThreadLocalListener
implements EventThreadInit,
EventThreadCleanup,
EventThreadResume {
    private static final Log log = Log.lookup((Class)ThreadLocalListener.class);
    private Map _fieldsMap;
    private Map _threadLocalsMap;
    private final boolean _enabled;

    public ThreadLocalListener() {
        WebApp app = Executions.getCurrent().getDesktop().getWebApp();
        this._fieldsMap = (Map)app.getAttribute("zkplus.util.ThreadLocalListener.fieldsMap");
        this._enabled = app.getConfiguration().isEventThreadEnabled();
        if (this._fieldsMap == null) {
            this._fieldsMap = new HashMap(8);
            app.setAttribute("zkplus.util.ThreadLocalListener.fieldsMap", (Object)this._fieldsMap);
            Configuration config = app.getConfiguration();
            String val = config.getPreference("ThreadLocal", null);
            if (val != null) {
                Collection klassSets = CollectionsX.parse(null, (String)val, (char)';');
                Iterator its = klassSets.iterator();
                while (its.hasNext()) {
                    String klassSetStr = (String)its.next();
                    Collection klassSet = CollectionsX.parse(null, (String)klassSetStr, (char)'=');
                    Iterator itz = klassSet.iterator();
                    String klass = (String)itz.next();
                    String fieldsStr = (String)itz.next();
                    Collection fields = CollectionsX.parse(null, (String)fieldsStr, (char)',');
                    this._fieldsMap.put(klass, fields.toArray(new String[fields.size()]));
                }
            }
        }
        this._threadLocalsMap = new HashMap(this._fieldsMap.size());
    }

    public void prepare(Component comp, Event evt) {
        if (this._enabled) {
            this.getThreadLocals();
        }
    }

    public boolean init(Component comp, Event evt) {
        if (this._enabled) {
            this.setThreadLocals();
        }
        return true;
    }

    public void cleanup(Component comp, Event evt, List errs) {
        if (this._enabled) {
            this.getThreadLocals();
        }
    }

    public void complete(Component comp, Event evt) {
        if (this._enabled) {
            this.setThreadLocals();
        }
    }

    public void beforeResume(Component comp, Event evt) {
        if (this._enabled) {
            this.getThreadLocals();
        }
    }

    public void afterResume(Component comp, Event evt) {
        if (this._enabled) {
            this.setThreadLocals();
        }
    }

    public void abortResume(Component comp, Event evt) {
    }

    private void getThreadLocals() {
        Iterator it = this._fieldsMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            try {
                String clsName = (String)me.getKey();
                Class cls = Classes.forNameByThread((String)clsName);
                String[] fields = (String[])me.getValue();
                Object[] threadLocals = new Object[fields.length];
                this._threadLocalsMap.put(clsName, threadLocals);
                for (int j = 0; j < threadLocals.length; ++j) {
                    try {
                        threadLocals[j] = this.getThreadLocal(cls, fields[j]).get();
                        continue;
                    }
                    catch (SystemException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void setThreadLocals() {
        Iterator it = this._threadLocalsMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            try {
                String clsName = (String)me.getKey();
                Class cls = Classes.forNameByThread((String)clsName);
                Object[] threadLocals = (Object[])me.getValue();
                String[] fields = (String[])this._fieldsMap.get(clsName);
                for (int j = 0; j < threadLocals.length; ++j) {
                    this.getThreadLocal(cls, fields[j]).set(threadLocals[j]);
                }
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
            }
        }
        this._threadLocalsMap.clear();
    }

    private ThreadLocal getThreadLocal(Class cls, String fldname) {
        return ThreadLocals.getThreadLocal(cls, fldname);
    }
}

