/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.mesg.MCommon;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.au.in.GenericCommand;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.sys.ComponentsCtrl;
import org.zkoss.zul.Popup;
import org.zkoss.zul.au.in.ColSizeCommand;
import org.zkoss.zul.au.in.PageSizeCommand;
import org.zkoss.zul.au.in.PagingCommand;

public abstract class XulElement
extends HtmlBasedComponent
implements org.zkoss.zul.impl.api.XulElement {
    private String _popup;
    private String _ctx;
    private String _tooltip;
    private String _action;
    private String _ctrlKeys;
    private String _ctkeys;

    public String getCtrlKeys() {
        return this._ctrlKeys;
    }

    public void setCtrlKeys(String ctrlKeys) throws UiException {
        if (ctrlKeys != null && ctrlKeys.length() == 0) {
            ctrlKeys = null;
        }
        if (!Objects.equals((Object)this._ctrlKeys, (Object)ctrlKeys)) {
            this.parseCtrlKeys(ctrlKeys);
            this.smartUpdate("z.ctkeys", this._ctkeys);
        }
    }

    private void parseCtrlKeys(String keys) throws UiException {
        if (keys == null || keys.length() == 0) {
            this._ctkeys = null;
            this._ctrlKeys = null;
            return;
        }
        StringBuffer sbctl = new StringBuffer();
        StringBuffer sbsft = new StringBuffer();
        StringBuffer sbalt = new StringBuffer();
        StringBuffer sbext = new StringBuffer();
        StringBuffer sbcur = null;
        int len = keys.length();
        block6: for (int j = 0; j < len; ++j) {
            int cc = keys.charAt(j);
            switch (cc) {
                case 36: 
                case 64: 
                case 94: {
                    if (sbcur != null) {
                        throw new WrongValueException("Combination of Shift, Alt and Ctrl not supported: " + keys);
                    }
                    sbcur = cc == 94 ? sbctl : (cc == 64 ? sbalt : sbsft);
                    continue block6;
                }
                case 35: {
                    char c2;
                    int k;
                    for (k = j + 1; k < len && ((c2 = keys.charAt(k)) <= 'Z' && c2 >= 'A' || c2 <= 'z' && c2 >= 'a' || c2 <= '9' && c2 >= '0'); ++k) {
                    }
                    if (k == j + 1) {
                        throw new WrongValueException(MCommon.UNEXPECTED_CHARACTER, new Object[]{new Character((char)cc), keys});
                    }
                    String s = keys.substring(j + 1, k).toLowerCase();
                    if ("pgup".equals(s)) {
                        cc = 65;
                    } else if ("pgdn".equals(s)) {
                        cc = 66;
                    } else if ("end".equals(s)) {
                        cc = 67;
                    } else if ("home".equals(s)) {
                        cc = 68;
                    } else if ("left".equals(s)) {
                        cc = 69;
                    } else if ("up".equals(s)) {
                        cc = 70;
                    } else if ("right".equals(s)) {
                        cc = 71;
                    } else if ("down".equals(s)) {
                        cc = 72;
                    } else if ("ins".equals(s)) {
                        cc = 73;
                    } else if ("del".equals(s)) {
                        cc = 74;
                    } else if (s.length() > 1 && s.charAt(0) == 'f') {
                        int v;
                        try {
                            v = Integer.parseInt(s.substring(1));
                        }
                        catch (Throwable ex) {
                            throw new WrongValueException("Unknown #" + s + " in " + keys);
                        }
                        if (v == 0 || v > 12) {
                            throw new WrongValueException("Unsupported function key: #f" + v);
                        }
                        cc = (char)(79 + v);
                    } else {
                        throw new WrongValueException("Unknown #" + s + " in " + keys);
                    }
                    if (sbcur == null) {
                        sbext.append((char)cc);
                    } else {
                        sbcur.append((char)cc);
                        sbcur = null;
                    }
                    j = k - 1;
                    continue block6;
                }
                default: {
                    if (!(sbcur != null && (cc <= 90 && cc >= 65 || cc <= 122 && cc >= 97 || cc <= 57 && cc >= 48))) {
                        throw new WrongValueException(MCommon.UNEXPECTED_CHARACTER, new Object[]{new Character((char)cc), keys});
                    }
                    if (sbcur == sbsft) {
                        throw new WrongValueException("$a - $z not supported (" + keys + "). Supported includes $#f1, $#home and so on.");
                    }
                    if (cc <= 90 && cc >= 65) {
                        cc = (char)(cc + 32);
                    }
                    sbcur.append((char)cc);
                    sbcur = null;
                }
            }
        }
        this._ctkeys = "" + '^' + sbctl + ';' + '@' + sbalt + ';' + '$' + sbsft + ';' + '#' + sbext + ';';
        this._ctrlKeys = keys;
    }

    public String getContext() {
        return this._ctx;
    }

    public void setContext(String context) {
        if (!Objects.equals((Object)this._ctx, (Object)context)) {
            this._ctx = context;
            this.smartUpdate("z.ctx", this._ctx);
        }
    }

    public void setContext(Popup popup) {
        this.setContext(popup != null ? "uuid(" + popup.getUuid() + ")" : null);
    }

    public String getPopup() {
        return this._popup;
    }

    public void setPopup(String popup) {
        if (!Objects.equals((Object)this._popup, (Object)popup)) {
            this._popup = popup;
            this.smartUpdate("z.pop", this._popup);
        }
    }

    public void setPopup(Popup popup) {
        this.setPopup(popup != null ? "uuid(" + popup.getUuid() + ")" : null);
    }

    public String getTooltip() {
        return this._tooltip;
    }

    public void setTooltip(String tooltip) {
        if (!Objects.equals((Object)this._tooltip, (Object)tooltip)) {
            this._tooltip = tooltip;
            this.smartUpdate("z.tip", this._tooltip);
        }
    }

    public void setTooltip(Popup popup) {
        this.setTooltip(popup != null ? "uuid(" + popup.getUuid() + ")" : null);
    }

    public String getAction() {
        return this._action;
    }

    public void setAction(String action) {
        if (action != null && action.length() == 0) {
            action = null;
        }
        if (!Objects.equals((Object)this._action, (Object)action)) {
            this._action = action;
            this.invalidate();
        }
    }

    protected String getActionAttrs() {
        if (this._action == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(100);
        Iterator it = XulElement.parseAction(this._action).entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            HTMLs.appendAttribute((StringBuffer)sb, (String)((String)me.getKey()), (String)this.toJavaScript((String)me.getValue()));
        }
        return sb.toString();
    }

    protected String getAllOnClickAttrs(boolean ignoreOnClick) {
        StringBuffer sb = null;
        if (!ignoreOnClick) {
            sb = this.appendAsapAttr(sb, "onClick");
        }
        sb = this.appendAsapAttr(sb, "onDoubleClick");
        return (sb = this.appendAsapAttr(sb, "onRightClick")) != null ? sb.toString() : null;
    }

    public String getOuterAttrs() {
        String attrs = super.getOuterAttrs();
        String ctx = this.getContext();
        String popup = this.getPopup();
        String tip = this.getTooltip();
        StringBuffer sb = new StringBuffer(80).append(attrs);
        if (ctx != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.ctx", (String)ctx);
        }
        if (popup != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.pop", (String)popup);
        }
        if (tip != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.tip", (String)tip);
        }
        this.appendAsapAttr(sb, "onOK");
        this.appendAsapAttr(sb, "onCancel");
        this.appendAsapAttr(sb, "onCtrlKey");
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.ctkeys", (String)this._ctkeys);
        return sb.toString();
    }

    public String getInnerAttrs() {
        String attrs = super.getInnerAttrs();
        return this._action == null ? attrs : attrs + this.getActionAttrs();
    }

    private static final Map parseAction(String action) {
        HashMap<String, String> map = new HashMap<String, String>();
        int k = action.indexOf(58);
        if (k < 0) {
            throw new WrongValueException("Unknown action: " + action);
        }
        int j = 0;
        int len = action.length();
        while (true) {
            int l;
            String actnm;
            if ((actnm = action.substring(j, k).trim()).length() == 0) {
                throw new WrongValueException("Unknown action: " + action);
            }
            char quote = '\u0000';
            j = ++k;
            while (true) {
                if (k >= len) {
                    l = len;
                    break;
                }
                char cc = action.charAt(k);
                if (cc != '\\') {
                    if (quote != '\u0000') {
                        if (quote == cc) {
                            quote = '\u0000';
                        }
                    } else if (cc == '\'' || cc == '\"') {
                        quote = cc;
                    } else if (cc == ';') {
                        char c2;
                        for (l = Strings.skipWhitespaces((CharSequence)action, (int)(k + 1)); l < len && ((c2 = action.charAt(l)) >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z'); ++l) {
                        }
                        if ((l = Strings.skipWhitespaces((CharSequence)action, (int)l)) >= len) {
                            k = len;
                            break;
                        }
                        if (action.charAt(l) == ':') {
                            ++k;
                            break;
                        }
                        k = l - 1;
                    }
                }
                ++k;
            }
            String val = action.substring(j, k).trim();
            if (val.length() > 0) {
                String nm = actnm.toLowerCase();
                if ("onshow".equals(nm) || "onhide".equals(nm)) {
                    actnm = "z.c" + nm;
                }
                map.put(actnm, val);
            }
            if (l >= len) {
                return map;
            }
            j = k;
            k = l;
        }
    }

    private final String toJavaScript(String action) {
        return action != null ? ComponentsCtrl.parseClientScript((Component)this, (String)action) : null;
    }

    static {
        new ColSizeCommand("onColSize", 0);
        new PagingCommand("onPaging", 1);
        new PageSizeCommand("onPageSize", 1);
        new GenericCommand("onRenderAtScroll", 8);
    }
}

