/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import org.zkoss.lang.Objects;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.Tree;
import org.zkoss.zul.Treecell;
import org.zkoss.zul.Treechildren;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.impl.XulElement;

public class Treerow
extends XulElement
implements org.zkoss.zul.api.Treerow {
    public Tree getTree() {
        Treerow p = this;
        while ((p = p.getParent()) != null) {
            if (!(p instanceof Tree)) continue;
            return (Tree)((Object)p);
        }
        return null;
    }

    public org.zkoss.zul.api.Tree getTreeApi() {
        return this.getTree();
    }

    public int getLevel() {
        Component parent = this.getParent();
        return parent != null ? ((Treeitem)parent).getLevel() : 0;
    }

    public Treechildren getLinkedTreechildren() {
        Component parent = this.getParent();
        return parent != null ? ((Treeitem)parent).getTreechildren() : null;
    }

    public org.zkoss.zul.api.Treechildren getLinkedTreechildrenApi() {
        return this.getLinkedTreechildren();
    }

    protected String getRealSclass() {
        String scls = super.getRealSclass();
        Treeitem ti = (Treeitem)this.getParent();
        String added = ti != null ? (ti.isDisabled() ? this.getZclass() + "-disd" : (ti.isSelected() ? this.getZclass() + "-seld" : "")) : "";
        return scls != null ? scls + " " + added : added;
    }

    public String getZclass() {
        return this._zclass == null ? "z-tree-row" : this._zclass;
    }

    public void setContext(String context) {
        throw new UnsupportedOperationException("Use treeitem instead");
    }

    public void setPopup(String popup) {
        throw new UnsupportedOperationException("Use treeitem instead");
    }

    public void setTooltip(String tooltip) {
        throw new UnsupportedOperationException("Use treeitem instead");
    }

    public String getContext() {
        Treeitem ti = (Treeitem)this.getParent();
        return ti != null ? ti.getContext() : null;
    }

    public String getPopup() {
        Treeitem ti = (Treeitem)this.getParent();
        return ti != null ? ti.getPopup() : null;
    }

    public String getTooltip() {
        Treeitem ti = (Treeitem)this.getParent();
        return ti != null ? ti.getTooltip() : null;
    }

    public String getTooltiptext() {
        Treeitem ti = (Treeitem)this.getParent();
        return ti != null ? ti.getTooltiptext() : null;
    }

    protected boolean isAsapRequired(String evtnm) {
        if (!"onOpen".equals(evtnm)) {
            return super.isAsapRequired(evtnm);
        }
        Treeitem ti = (Treeitem)this.getParent();
        return ti != null && ti.isAsapRequired(evtnm);
    }

    public String getOuterAttrs() {
        Treechildren tcsib;
        Component gp;
        String attrs = super.getOuterAttrs();
        Treeitem item = (Treeitem)this.getParent();
        if (item == null) {
            return attrs;
        }
        StringBuffer sb = new StringBuffer(80).append(attrs);
        Tree tree = this.getTree();
        if (tree != null && tree.getName() != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.value", (String)Objects.toString((Object)item.getValue()));
        }
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.pitem", (String)item.getUuid());
        if (item.isSelected()) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.sel", (boolean)true);
        }
        if (item.isDisabled()) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.disd", (boolean)true);
        }
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.rid", (String)tree.getUuid());
        if (item.isContainer() && item.isOpen()) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.open", (boolean)true);
        }
        if ((gp = item.getParent()) != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.ptch", (String)gp.getUuid());
            Component gpitem = gp.getParent();
            if (gpitem instanceof Treeitem) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z.gpitem", (String)gpitem.getUuid());
            }
        }
        if ((tcsib = this.getLinkedTreechildren()) != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.tchsib", (String)tcsib.getUuid());
        }
        if (tree != null && tree.getModel() != null && !item.isLoaded()) {
            sb.append(" z.lod=\"t\"");
        }
        if (this.getTree().inPagingMold()) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.onOpen", (boolean)true);
        } else {
            this.appendAsapAttr(sb, "onOpen");
        }
        String clkattrs = this.getAllOnClickAttrs();
        if (clkattrs != null) {
            sb.append(clkattrs);
        }
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.visible", (boolean)this.isBothVisible());
        return sb.toString();
    }

    public boolean isVisible() {
        if (!super.isVisible()) {
            return false;
        }
        Component comp = this.getParent();
        if (!(comp instanceof Treeitem)) {
            return true;
        }
        if (!comp.isVisible()) {
            return false;
        }
        return !((comp = comp.getParent()) instanceof Treechildren) || ((Treechildren)comp).isVisible();
    }

    private boolean isBothVisible() {
        if (!super.isVisible()) {
            return false;
        }
        Component comp = this.getParent();
        if (!(comp instanceof Treeitem)) {
            return true;
        }
        return comp.isVisible();
    }

    public boolean setVisible(boolean visible) {
        if (this.isVisible() != visible) {
            this.smartUpdate("z.visible", visible);
        }
        return super.setVisible(visible);
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof Treeitem)) {
            throw new UiException("Wrong parent: " + parent);
        }
        super.beforeParentChanged(parent);
    }

    public void beforeChildAdded(Component child, Component refChild) {
        if (!(child instanceof Treecell)) {
            throw new UiException("Unsupported child for tree row: " + child);
        }
        super.beforeChildAdded(child, refChild);
    }
}

