/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.ext.render.Cropper;
import org.zkoss.zul.Grid;
import org.zkoss.zul.Group;
import org.zkoss.zul.Groupfoot;
import org.zkoss.zul.Row;
import org.zkoss.zul.ext.Paginal;
import org.zkoss.zul.impl.XulElement;

public class Rows
extends XulElement
implements org.zkoss.zul.api.Rows {
    private int _visibleItemCount;
    private transient List _groupsInfo;
    private transient List _groups;

    public Rows() {
        this.init();
    }

    private void init() {
        this._groupsInfo = new LinkedList();
        this._groups = new AbstractList(){

            public int size() {
                return Rows.this.getGroupCount();
            }

            public Iterator iterator() {
                return new IterGroups();
            }

            public Object get(int index) {
                return Rows.this.getChildren().get(((int[])Rows.this._groupsInfo.get(index))[0]);
            }
        };
    }

    public Grid getGrid() {
        return (Grid)this.getParent();
    }

    public org.zkoss.zul.api.Grid getGridApi() {
        return this.getGrid();
    }

    public int getGroupCount() {
        return this._groupsInfo.size();
    }

    public List getGroups() {
        return this._groups;
    }

    public boolean hasGroup() {
        return !this._groupsInfo.isEmpty();
    }

    public int getVisibleItemCount() {
        return this._visibleItemCount;
    }

    void addVisibleItemCount(int count) {
        if (count != 0) {
            this._visibleItemCount += count;
            Grid grid = this.getGrid();
            if (grid != null && grid.inPagingMold()) {
                Paginal pgi = grid.getPaginal();
                pgi.setTotalSize(this._visibleItemCount);
                if (grid.getModel() != null) {
                    grid.invalidate();
                } else {
                    this.invalidate();
                }
            }
        }
    }

    public int getVisibleBegin() {
        return 0;
    }

    public int getVisibleEnd() {
        return Integer.MAX_VALUE;
    }

    void fixGroupIndex(int j, int to, boolean infront) {
        ListIterator it = this.getChildren().listIterator(j);
        while (it.hasNext() && (to < 0 || j <= to)) {
            int[] g;
            Object o = it.next();
            if (o instanceof Group && (g = this.getLastGroupsInfoAt(j + (infront ? -1 : 1))) != null) {
                g[0] = j;
                if (g[2] != -1) {
                    g[2] = g[2] + (infront ? 1 : -1);
                }
            }
            ++j;
        }
    }

    Group getGroup(int index) {
        if (this._groupsInfo.isEmpty()) {
            return null;
        }
        int[] g = this.getGroupsInfoAt(index);
        if (g != null) {
            return (Group)this.getChildren().get(g[0]);
        }
        return null;
    }

    int[] getGroupsInfoAt(int index) {
        return this.getGroupsInfoAt(index, false);
    }

    int[] getLastGroupsInfoAt(int index) {
        int[] rg = null;
        Iterator it = this._groupsInfo.iterator();
        while (it.hasNext()) {
            int[] g = (int[])it.next();
            if (index == g[0]) {
                rg = g;
                continue;
            }
            if (index >= g[0]) continue;
            break;
        }
        return rg;
    }

    int[] getGroupsInfoAt(int index, boolean isGroup) {
        Iterator it = this._groupsInfo.iterator();
        while (it.hasNext()) {
            int[] g = (int[])it.next();
            if (!(isGroup ? index == g[0] : index > g[0] && index <= g[0] + g[1])) continue;
            return g;
        }
        return null;
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof Grid)) {
            throw new UiException("Unsupported parent for rows: " + parent);
        }
        super.beforeParentChanged(parent);
    }

    public void beforeChildAdded(Component child, Component refChild) {
        if (!(child instanceof Row)) {
            throw new UiException("Unsupported child for rows: " + child);
        }
        if (child instanceof Groupfoot) {
            if (!this.hasGroup()) {
                throw new UiException("Groupfoot cannot exist alone, you have to add a Group first");
            }
            if (refChild == null && this.getLastChild() instanceof Groupfoot) {
                throw new UiException("Only one Goupfooter is allowed per Group");
            }
        }
        super.beforeChildAdded(child, refChild);
    }

    public boolean insertBefore(Component child, Component refChild) {
        boolean isReorder;
        Row newItem = (Row)child;
        int jfrom = this.hasGroup() && newItem.getParent() == this ? newItem.getIndex() : -1;
        boolean bl = isReorder = child.getParent() == this;
        if (newItem instanceof Groupfoot) {
            if (refChild == null) {
                int idx;
                int[] ginfo;
                if (isReorder && (ginfo = this.getGroupsInfoAt(idx = newItem.getIndex())) != null) {
                    ginfo[1] = ginfo[1] - 1;
                    ginfo[2] = -1;
                }
                int[] g = (int[])this._groupsInfo.get(this.getGroupCount() - 1);
                g[2] = this.getChildren().size() - (isReorder ? 2 : 1);
            } else {
                int nindex;
                int[] ginfo;
                int idx = ((Row)refChild).getIndex();
                int[] g = this.getGroupsInfoAt(idx);
                if (g == null) {
                    throw new UiException("Groupfoot cannot exist alone, you have to add a Group first");
                }
                if (g[2] != -1) {
                    throw new UiException("Only one Goupfooter is allowed per Group");
                }
                if (idx != g[0] + g[1]) {
                    throw new UiException("Groupfoot must be placed after the last Row of the Group");
                }
                g[2] = idx - 1;
                if (isReorder && (ginfo = this.getGroupsInfoAt(nindex = newItem.getIndex())) != null) {
                    ginfo[1] = ginfo[1] - 1;
                    ginfo[2] = -1;
                }
            }
        }
        if (super.insertBefore(child, refChild)) {
            int index;
            int[] g;
            if (this.hasGroup()) {
                int fixFrom;
                int jto = refChild instanceof Row ? ((Row)refChild).getIndex() : -1;
                int n = fixFrom = jfrom < 0 || jto >= 0 && jfrom > jto ? jto : jfrom;
                if (fixFrom >= 0) {
                    this.fixGroupIndex(fixFrom, jfrom >= 0 && jto >= 0 ? (jfrom > jto ? jfrom : jto) : -1, !isReorder);
                }
            }
            if (newItem instanceof Group) {
                Group group = (Group)newItem;
                int index2 = group.getIndex();
                if (this._groupsInfo.isEmpty()) {
                    this._groupsInfo.add(new int[]{group.getIndex(), this.getChildren().size() - index2, -1});
                } else {
                    int idx = 0;
                    int[] prev = null;
                    int[] next = null;
                    Iterator it = this._groupsInfo.iterator();
                    while (it.hasNext()) {
                        int[] g2 = (int[])it.next();
                        if (g2[0] <= index2) {
                            prev = g2;
                            ++idx;
                            continue;
                        }
                        next = g2;
                        break;
                    }
                    if (prev != null) {
                        int leng = index2 - prev[0];
                        void size = prev[1] - leng + true;
                        prev[1] = leng;
                        this._groupsInfo.add(idx, new int[]{index2, size, size > true && prev[2] > index2 ? prev[2] : -1});
                        if (size > true && prev[2] > index2) {
                            prev[2] = -1;
                        }
                    } else if (next != null) {
                        this._groupsInfo.add(idx, new int[]{index2, next[0] - index2, -1});
                    }
                }
            } else if (this.hasGroup() && (g = this.getGroupsInfoAt(index = newItem.getIndex())) != null) {
                g[1] = g[1] + 1;
                if (g[2] != -1 && (g[2] >= index || newItem instanceof Groupfoot)) {
                    g[2] = g[2] + 1;
                }
            }
            this.afterInsert(child);
            return true;
        }
        return false;
    }

    public boolean removeChild(Component child) {
        int index;
        if (child.getParent() == this) {
            this.beforeRemove(child);
        }
        int n = index = this.hasGroup() ? ((Row)child).getIndex() : -1;
        if (super.removeChild(child)) {
            if (child instanceof Group) {
                int[] prev = null;
                int[] remove = null;
                Iterator it = this._groupsInfo.iterator();
                while (it.hasNext()) {
                    int[] g = (int[])it.next();
                    if (g[0] == index) {
                        remove = g;
                        break;
                    }
                    prev = g;
                }
                if (prev != null && remove != null) {
                    prev[1] = prev[1] + (remove[1] - true);
                }
                this.fixGroupIndex(index, -1, false);
                if (remove != null) {
                    this._groupsInfo.remove(remove);
                    int idx = remove[2];
                    if (idx != -1) {
                        this.removeChild((Component)this.getChildren().get(idx - 1));
                    }
                }
            } else if (this.hasGroup()) {
                int[] g1;
                int[] g = this.getGroupsInfoAt(index);
                if (g != null) {
                    g[1] = g[1] - 1;
                    if (g[2] != -1) {
                        g[2] = g[2] - 1;
                    }
                    this.fixGroupIndex(index, -1, false);
                } else {
                    this.fixGroupIndex(index, -1, false);
                }
                if (child instanceof Groupfoot && (g1 = this.getGroupsInfoAt(index)) != null) {
                    g1[2] = -1;
                }
            }
            return true;
        }
        return false;
    }

    protected void afterInsert(Component comp) {
        this.updateVisibleCount((Row)comp, false);
        this.checkInvalidateForMoved(comp, false);
    }

    protected void beforeRemove(Component comp) {
        this.updateVisibleCount((Row)comp, true);
        this.checkInvalidateForMoved(comp, true);
    }

    private void updateVisibleCount(Row row, boolean isRemove) {
        Grid grid;
        if (row instanceof Group || row.isVisible()) {
            Group g = this.getGroup(row.getIndex());
            if (row instanceof Groupfoot || row instanceof Group || g == null || g.isOpen()) {
                this.addVisibleItemCount(isRemove ? -1 : 1);
            }
            if (row instanceof Group) {
                Group group = (Group)row;
                Row preRow = (Row)row.getPreviousSibling();
                if (preRow == null) {
                    if (!group.isOpen()) {
                        this.addVisibleItemCount(isRemove ? group.getVisibleItemCount() : -group.getVisibleItemCount());
                    }
                } else {
                    Group preGroup;
                    Group group2 = preGroup = preRow instanceof Group ? (Group)preRow : this.getGroup(preRow.getIndex());
                    if (preGroup != null) {
                        if (!preGroup.isOpen() && group.isOpen()) {
                            this.addVisibleItemCount(isRemove ? -group.getVisibleItemCount() : group.getVisibleItemCount());
                        } else if (preGroup.isOpen() && !group.isOpen()) {
                            this.addVisibleItemCount(isRemove ? group.getVisibleItemCount() : -group.getVisibleItemCount());
                        }
                    } else if (!group.isOpen()) {
                        this.addVisibleItemCount(isRemove ? group.getVisibleItemCount() : -group.getVisibleItemCount());
                    }
                }
            }
        }
        if ((grid = this.getGrid()) != null && grid.inPagingMold()) {
            grid.getPaginal().setTotalSize(this.getVisibleItemCount());
        }
    }

    private void checkInvalidateForMoved(Component child, boolean bRemove) {
        Grid grid = this.getGrid();
        if (grid != null && grid.inPagingMold() && !this.isInvalidated()) {
            List children = this.getChildren();
            int sz = children.size();
            int pgsz = grid.getPageSize();
            int n = sz - (grid.getActivePage() + 1) * pgsz;
            if (n <= 0) {
                if (bRemove && (n += pgsz) <= 1) {
                    this.invalidate();
                    return;
                }
            } else if (n > 50) {
                n = 50;
            }
            ListIterator it = children.listIterator(sz);
            while (--n >= 0 && it.hasPrevious()) {
                if (it.previous() != child) continue;
                return;
            }
            this.invalidate();
        }
    }

    public Iterator getVisibleChildrenIterator() {
        Grid grid = this.getGrid();
        if (grid != null && grid.inSpecialMold()) {
            return grid.getDrawerEngine().getVisibleChildrenIterator();
        }
        return new VisibleChildrenIterator();
    }

    public String getZclass() {
        return this._zclass == null ? "z-rows" : this._zclass;
    }

    public Object clone() {
        Rows clone = (Rows)super.clone();
        clone.init();
        return clone;
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
    }

    protected List newChildren() {
        return new Children();
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    private class IterGroups
    implements Iterator {
        private final Iterator _it;
        private int _j;

        private IterGroups() {
            this._it = Rows.this._groupsInfo.iterator();
        }

        public boolean hasNext() {
            return this._j < Rows.this.getGroupCount();
        }

        public Object next() {
            Object o = Rows.this.getChildren().get(((int[])this._it.next())[0]);
            ++this._j;
            return o;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements Cropper {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Rows.this);
        }

        public boolean isCropper() {
            Grid grid = Rows.this.getGrid();
            return grid != null && (grid.inPagingMold() && grid.getPageSize() <= Rows.this.getChildren().size() || grid.inSpecialMold());
        }

        public Component getCropOwner() {
            return Rows.this.getGrid();
        }

        public Set getAvailableAtClient() {
            if (!this.isCropper()) {
                return null;
            }
            Grid grid = Rows.this.getGrid();
            if (grid.inSpecialMold()) {
                return grid.getDrawerEngine().getAvailableAtClient();
            }
            LinkedHashSet<Row> avail = new LinkedHashSet<Row>(32);
            Paginal pgi = grid.getPaginal();
            int pgsz = pgi.getPageSize();
            int ofs = pgi.getActivePage() * pgsz;
            Row row = (Row)Rows.this.getFirstChild();
            while (row != null && pgsz != 0) {
                Group g;
                if (row.isVisible() && --ofs < 0) {
                    --pgsz;
                    avail.add(row);
                }
                if (row instanceof Group && !(g = (Group)row).isOpen()) {
                    int len = g.getItemCount();
                    for (int j = 0; j < len; ++j) {
                        row = (Row)row.getNextSibling();
                    }
                }
                if (row == null) continue;
                row = (Row)row.getNextSibling();
            }
            return avail;
        }
    }

    protected class Children
    extends AbstractComponent.Children {
        protected Children() {
            super((AbstractComponent)Rows.this);
        }

        protected void removeRange(int fromIndex, int toIndex) {
            ListIterator it = this.listIterator(toIndex);
            int n = toIndex - fromIndex;
            while (--n >= 0) {
                it.previous();
                it.remove();
            }
        }
    }

    private class VisibleChildrenIterator
    implements Iterator {
        private final ListIterator _it;
        private Grid _grid;
        private int _count;

        private VisibleChildrenIterator() {
            this._it = Rows.this.getChildren().listIterator();
            this._grid = Rows.this.getGrid();
            this._count = 0;
        }

        public boolean hasNext() {
            if (this._grid == null || !this._grid.inPagingMold()) {
                return this._it.hasNext();
            }
            if (this._count >= this._grid.getPaginal().getPageSize()) {
                return false;
            }
            if (this._count == 0) {
                Paginal pgi = this._grid.getPaginal();
                int begin = pgi.getActivePage() * pgi.getPageSize();
                for (int i = 0; i < begin && this._it.hasNext(); ++i) {
                    this.getVisibleRow((Row)this._it.next());
                }
            }
            return this._it.hasNext();
        }

        private Row getVisibleRow(Row row) {
            Group g;
            if (row instanceof Group && !(g = (Group)row).isOpen()) {
                int len = g.getItemCount();
                for (int j = 0; j < len && this._it.hasNext(); ++j) {
                    this._it.next();
                }
            }
            while (!row.isVisible() && this._it.hasNext()) {
                row = (Row)this._it.next();
            }
            return row;
        }

        public Object next() {
            if (this._grid == null || !this._grid.inPagingMold()) {
                return this._it.next();
            }
            ++this._count;
            Row row = (Row)this._it.next();
            return this._it.hasNext() ? this.getVisibleRow(row) : row;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

