/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Comparator;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.AbstractListModel;
import org.zkoss.zul.GroupDataInfo;
import org.zkoss.zul.GroupsModel;
import org.zkoss.zul.GroupsModelExt;
import org.zkoss.zul.event.GroupsDataEvent;
import org.zkoss.zul.event.GroupsDataListener;

class GroupsListModel
extends AbstractListModel {
    private final GroupsModel _model;
    private transient int _size;
    private transient int[] _gpofs;
    private transient boolean[] _gpfts;
    private transient GroupsDataListener _listener;

    GroupsListModel(GroupsModel model) {
        this._model = model;
        this.init();
    }

    private void init() {
        int groupCount = this._model.getGroupCount();
        this._gpofs = new int[groupCount];
        this._gpfts = new boolean[groupCount];
        this._size = 0;
        for (int j = 0; j < groupCount; ++j) {
            this._gpofs[j] = this._size;
            this._size += 1 + this._model.getChildCount(j);
            this._gpfts[j] = this._model.hasGroupfoot(j);
            if (!this._gpfts[j]) continue;
            ++this._size;
        }
        if (this._listener == null) {
            this._listener = new DataListener();
            this._model.addGroupsDataListener(this._listener);
        }
    }

    GroupsModel getGroupsModel() {
        return this._model;
    }

    int getGroupCount() {
        return this._gpofs.length;
    }

    int getChildCount(int groupIndex) {
        int v = this.getNextOffset(groupIndex) - this._gpofs[groupIndex] - 1;
        return this._gpfts[groupIndex] ? v - 1 : v;
    }

    boolean hasGroupfoot(int groupIndex) {
        return this._gpfts[groupIndex];
    }

    void group(Comparator cmpr, boolean ascending, int colIndex) {
        if (!(this._model instanceof GroupsModelExt)) {
            throw new UiException("GroupsModelExt must be implemented in " + this._model.getClass());
        }
        ((GroupsModelExt)((Object)this._model)).group(cmpr, ascending, colIndex);
    }

    void sort(Comparator cmpr, boolean ascending, int colIndex) {
        if (!(this._model instanceof GroupsModelExt)) {
            throw new UiException("GroupsModelExt must be implemented in " + this._model.getClass());
        }
        ((GroupsModelExt)((Object)this._model)).sort(cmpr, ascending, colIndex);
    }

    private int getNextOffset(int groupIndex) {
        return groupIndex >= this._gpofs.length - 1 ? this._size : this._gpofs[groupIndex + 1];
    }

    GroupDataInfo getDataInfo(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("Not in 0.." + this._size + ": " + index);
        }
        int gi = Arrays.binarySearch(this._gpofs, index);
        if (gi >= 0) {
            return new GroupDataInfo(0, gi, 0);
        }
        gi = -gi - 2;
        int ofs = index - this._gpofs[gi] - 1;
        if (this._gpfts[gi] && ofs >= this.getNextOffset(gi) - this._gpofs[gi] - 2) {
            return new GroupDataInfo(1, gi, 0);
        }
        return new GroupDataInfo(2, gi, ofs);
    }

    public Object getElementAt(int index) {
        GroupDataInfo info = this.getDataInfo(index);
        if (info.type == 0) {
            return this._model.getGroup(info.groupIndex);
        }
        if (info.type == 1) {
            return this._model.getGroupfoot(info.groupIndex);
        }
        return this._model.getChild(info.groupIndex, info.offset);
    }

    public int getSize() {
        return this._size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        this._model.removeGroupsDataListener(this._listener);
        try {
            s.defaultWriteObject();
        }
        finally {
            this._model.addGroupsDataListener(this._listener);
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
    }

    private class DataListener
    implements GroupsDataListener {
        private DataListener() {
        }

        public void onChange(GroupsDataEvent event) {
            int type = event.getType();
            int j0 = event.getIndex0();
            int j1 = event.getIndex1();
            switch (type) {
                case 0: 
                case 1: 
                case 2: {
                    int gi = event.getGroupIndex();
                    if (gi < 0 || gi >= GroupsListModel.this._gpofs.length) {
                        throw new IndexOutOfBoundsException("Group index not in 0.." + GroupsListModel.this.getGroupCount() + ", " + gi);
                    }
                    int ofs = GroupsListModel.this._gpofs[gi] + 1;
                    int n = j0 = j0 >= 0 ? j0 + ofs : ofs;
                    if (j1 >= 0) {
                        j1 += ofs;
                        break;
                    }
                    j1 = GroupsListModel.this.getNextOffset(gi) - 1;
                    if (!GroupsListModel.this._gpfts[gi]) break;
                    --j1;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    type -= 4;
                    if (j0 >= 0) {
                        if (j0 >= GroupsListModel.this._gpofs.length) {
                            throw new IndexOutOfBoundsException("Group index not in 0.." + GroupsListModel.this.getGroupCount() + ", " + j0);
                        }
                        j0 = GroupsListModel.this._gpofs[j0];
                    }
                    if (j1 < 0) break;
                    if (j1 >= GroupsListModel.this._gpofs.length) {
                        throw new IndexOutOfBoundsException("Group index not in 0.." + GroupsListModel.this.getGroupCount() + ", " + j1);
                    }
                    j1 = GroupsListModel.this.getNextOffset(j1) - 1;
                }
            }
            GroupsListModel.this.init();
            GroupsListModel.this.fireEvent(type, j0, j1);
        }
    }
}

