/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.mesg.Messages;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.scripting.Namespaces;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.Columns;
import org.zkoss.zul.FieldComparator;
import org.zkoss.zul.Grid;
import org.zkoss.zul.Group;
import org.zkoss.zul.GroupComparator;
import org.zkoss.zul.GroupsListModel;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelExt;
import org.zkoss.zul.Row;
import org.zkoss.zul.RowComparator;
import org.zkoss.zul.Rows;
import org.zkoss.zul.impl.HeaderElement;
import org.zkoss.zul.mesg.MZul;

public class Column
extends HeaderElement
implements org.zkoss.zul.api.Column {
    private String _sortDir = "natural";
    private transient Comparator _sortAsc;
    private transient Comparator _sortDsc;
    private Object _value;

    public Column() {
    }

    public Column(String label) {
        this();
        this.setLabel(label);
    }

    public Column(String label, String src) {
        this();
        this.setLabel(label);
        this.setImage(src);
    }

    public Column(String label, String src, String width) {
        this();
        this.setLabel(label);
        this.setImage(src);
        this.setWidth(width);
    }

    public Grid getGrid() {
        Component parent = this.getParent();
        return parent != null ? (Grid)parent.getParent() : null;
    }

    public org.zkoss.zul.api.Grid getGridApi() {
        return this.getGrid();
    }

    public String getSortDirection() {
        return this._sortDir;
    }

    public void setSortDirection(String sortDir) throws WrongValueException {
        if (sortDir == null || !"ascending".equals(sortDir) && !"descending".equals(sortDir) && !"natural".equals(sortDir)) {
            throw new WrongValueException("Unknown sort direction: " + sortDir);
        }
        if (!Objects.equals((Object)this._sortDir, (Object)sortDir)) {
            this._sortDir = sortDir;
            this.smartUpdate("z.sort", this._sortDir);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSort(String type) {
        if ("auto".equals(type)) {
            if (this.getSortAscending() == null) {
                this.setSortAscending(new RowComparator(this, true, false, false));
            }
            if (this.getSortDescending() != null) return;
            this.setSortDescending(new RowComparator(this, false, false, false));
            return;
        } else if (!Strings.isBlank((String)type) && type.startsWith("auto")) {
            int j = type.indexOf(40);
            int k = type.lastIndexOf(41);
            if (j < 0 || k < 0) throw new UiException("Unknown sort type: " + type);
            String fieldnames = type.substring(j + 1, k);
            if (this.getSortAscending() == null) {
                this.setSortAscending(new FieldComparator(fieldnames, true));
            }
            if (this.getSortDescending() != null) return;
            this.setSortDescending(new FieldComparator(fieldnames, false));
            return;
        } else {
            if (!"none".equals(type)) return;
            this.setSortAscending((Comparator)null);
            this.setSortDescending((Comparator)null);
        }
    }

    public Comparator getSortAscending() {
        return this._sortAsc;
    }

    public void setSortAscending(Comparator sorter) {
        if (!Objects.equals((Object)this._sortAsc, (Object)sorter)) {
            this._sortAsc = sorter;
            this.invalidate();
        }
    }

    public void setSortAscending(String clsnm) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.setSortAscending(this.toComparator(clsnm));
    }

    public Comparator getSortDescending() {
        return this._sortDsc;
    }

    public void setSortDescending(Comparator sorter) {
        if (!Objects.equals((Object)this._sortDsc, (Object)sorter)) {
            this._sortDsc = sorter;
            this.invalidate();
        }
    }

    public void setSortDescending(String clsnm) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.setSortDescending(this.toComparator(clsnm));
    }

    private Comparator toComparator(String clsnm) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class cls;
        if (clsnm == null || clsnm.length() == 0) {
            return null;
        }
        Page page = this.getPage();
        Class clazz = cls = page != null ? page.getZScriptClass(clsnm) : Classes.forNameByThread((String)clsnm);
        if (cls == null) {
            throw new ClassNotFoundException(clsnm);
        }
        if (!Comparator.class.isAssignableFrom(cls)) {
            throw new UiException("Comparator must be implemented: " + clsnm);
        }
        return (Comparator)cls.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sort(boolean ascending) {
        Comparator cmpr;
        String dir = this.getSortDirection();
        if (ascending ? "ascending".equals(dir) : "descending".equals(dir)) {
            return false;
        }
        Comparator comparator = cmpr = ascending ? this._sortAsc : this._sortDsc;
        if (cmpr == null) {
            return false;
        }
        Grid grid = this.getGrid();
        Rows rows = grid.getRows();
        if (grid == null || rows == null) {
            return false;
        }
        Namespaces.beforeInterpret((Component)this);
        try {
            int activePg;
            ListModel model = grid.getModel();
            boolean isPagingMold = grid.inPagingMold();
            int n = activePg = isPagingMold ? grid.getPaginal().getActivePage() : 0;
            if (model != null) {
                if (model instanceof GroupsListModel) {
                    ((GroupsListModel)model).sort(cmpr, ascending, grid.getColumns().getChildren().indexOf(this));
                } else {
                    if (!(model instanceof ListModelExt)) {
                        throw new UiException("ListModelExt must be implemented in " + model.getClass());
                    }
                    ((ListModelExt)((Object)model)).sort(cmpr, ascending);
                }
            } else {
                Column.sort0(grid, cmpr);
            }
            if (isPagingMold) {
                grid.getPaginal().setActivePage(activePg);
            }
        }
        finally {
            Namespaces.afterInterpret();
        }
        this.fixDirection(grid, ascending);
        return true;
    }

    private static void sort0(Grid grid, Comparator cmpr) {
        Rows rows = grid.getRows();
        if (rows.hasGroup()) {
            Iterator it = rows.getGroups().iterator();
            while (it.hasNext()) {
                Group g = (Group)it.next();
                int index = g.getIndex() + 1;
                Components.sort((List)rows.getChildren(), (int)index, (int)(index + g.getItemCount()), (Comparator)cmpr);
            }
        } else {
            Components.sort((List)rows.getChildren(), (Comparator)cmpr);
        }
    }

    private void fixDirection(Grid grid, boolean ascending) {
        Iterator it = grid.getColumns().getChildren().iterator();
        while (it.hasNext()) {
            Column hd;
            hd.setSortDirection((hd = (Column)it.next()) != this ? "natural" : (ascending ? "ascending" : "descending"));
        }
    }

    public boolean sort(boolean ascending, boolean force) {
        if (force) {
            this.setSortDirection("natural");
        }
        return this.sort(ascending);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean group(boolean ascending) {
        Comparator cmpr;
        String dir = this.getSortDirection();
        if (ascending ? "ascending".equals(dir) : "descending".equals(dir)) {
            return false;
        }
        Comparator comparator = cmpr = ascending ? this._sortAsc : this._sortDsc;
        if (cmpr == null) {
            return false;
        }
        Grid grid = this.getGrid();
        if (grid == null) {
            return false;
        }
        Namespaces.beforeInterpret((Component)this);
        try {
            ListModel model = grid.getModel();
            int index = grid.getColumns().getChildren().indexOf(this);
            if (model != null) {
                if (!(model instanceof GroupsListModel)) {
                    throw new UiException("GroupsModel must be implemented in " + model.getClass().getName());
                }
                ((GroupsListModel)model).group(cmpr, ascending, index);
            } else {
                Rows rows = grid.getRows();
                if (rows == null) {
                    boolean bl = false;
                    return bl;
                }
                if (rows.hasGroup()) {
                    ArrayList groups = new ArrayList(rows.getGroups());
                    Iterator it = groups.iterator();
                    while (it.hasNext()) {
                        ((Group)it.next()).detach();
                    }
                }
                Comparator cmprx = cmpr instanceof GroupComparator ? new Comparator(){

                    public int compare(Object o1, Object o2) {
                        return ((GroupComparator)cmpr).compareGroup(o1, o2);
                    }
                } : cmpr;
                LinkedList children = new LinkedList(rows.getChildren());
                rows.getChildren().clear();
                Collections.sort(children, cmprx);
                Row previous = null;
                Iterator it = children.iterator();
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    it.remove();
                    if (previous == null || cmprx.compare(previous, row) != 0) {
                        Group group;
                        List cells = row.getChildren();
                        if (cells.size() < index) {
                            throw new IndexOutOfBoundsException("Index: " + index + " but size: " + cells.size());
                        }
                        Component cell = (Component)cells.get(index);
                        if (cell instanceof Label) {
                            String val = ((Label)cell).getValue();
                            group = new Group(val);
                        } else {
                            Component cc = cell.getFirstChild();
                            if (cc instanceof Label) {
                                String val = ((Label)cc).getValue();
                                group = new Group(val);
                            } else {
                                group = new Group(Messages.get((int)MZul.GRID_OTHER));
                            }
                        }
                        rows.appendChild((Component)group);
                    }
                    rows.appendChild((Component)row);
                    previous = row;
                }
                if (cmprx != cmpr) {
                    Column.sort0(grid, cmpr);
                }
            }
        }
        finally {
            Namespaces.afterInterpret();
        }
        this.fixDirection(grid, ascending);
        return true;
    }

    public void setLabel(String label) {
        super.setLabel(label);
        if (this.getParent() != null) {
            ((Columns)this.getParent()).postOnInitLater();
        }
    }

    public boolean setVisible(boolean visible) {
        boolean old = super.setVisible(visible);
        if (this.getParent() != null) {
            ((Columns)this.getParent()).postOnInitLater();
        }
        return old;
    }

    public Object getValue() {
        return this._value;
    }

    public void setValue(Object value) {
        this._value = value;
    }

    public void onSort() {
        String dir = this.getSortDirection();
        if ("ascending".equals(dir)) {
            this.sort(false);
        } else if ("descending".equals(dir)) {
            this.sort(true);
        } else if (!this.sort(true)) {
            this.sort(false);
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-column" : this._zclass;
    }

    protected String getRealSclass() {
        String scls = super.getRealSclass();
        String added = this._sortAsc != null || this._sortDsc != null ? this.getZclass() + "-sort" : "";
        return scls != null ? scls + ' ' + added : added;
    }

    public String getOuterAttrs() {
        String clkattrs;
        StringBuffer sb = new StringBuffer(80);
        if (this._sortAsc != null) {
            sb.append(" z.asc=\"true\"");
        }
        if (this._sortDsc != null) {
            sb.append(" z.dsc=\"true\"");
        }
        if (!"natural".equals(this._sortDir)) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.sort", (String)this._sortDir);
        }
        if ((clkattrs = this.getAllOnClickAttrs()) != null) {
            sb.append(clkattrs);
        }
        String attrs = super.getOuterAttrs();
        if (sb.length() == 0) {
            return attrs;
        }
        return sb.insert(0, attrs).toString();
    }

    protected void invalidateWhole() {
        Grid grid = this.getGrid();
        if (grid != null) {
            grid.invalidate();
        }
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof Columns)) {
            throw new UiException("Unsupported parent for column: " + parent);
        }
        super.beforeParentChanged(parent);
    }

    public Object clone() {
        Column clone = (Column)super.clone();
        clone.fixClone();
        return clone;
    }

    private void fixClone() {
        RowComparator c;
        if (this._sortAsc instanceof RowComparator && (c = (RowComparator)this._sortAsc).getColumn() == this && c.isAscending()) {
            this._sortAsc = new RowComparator(this, true, c.shallIgnoreCase(), false);
        }
        if (this._sortDsc instanceof RowComparator && (c = (RowComparator)this._sortDsc).getColumn() == this && !c.isAscending()) {
            this._sortDsc = new RowComparator(this, false, c.shallIgnoreCase(), false);
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        RowComparator c;
        s.defaultWriteObject();
        boolean written = false;
        if (this._sortAsc instanceof RowComparator && (c = (RowComparator)this._sortAsc).getColumn() == this && c.isAscending()) {
            s.writeBoolean(true);
            s.writeBoolean(c.shallIgnoreCase());
            written = true;
        }
        if (!written) {
            s.writeBoolean(false);
            s.writeObject(this._sortAsc);
        }
        written = false;
        if (this._sortDsc instanceof RowComparator && (c = (RowComparator)this._sortDsc).getColumn() == this && !c.isAscending()) {
            s.writeBoolean(true);
            s.writeBoolean(c.shallIgnoreCase());
            written = true;
        }
        if (!written) {
            s.writeBoolean(false);
            s.writeObject(this._sortDsc);
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        boolean igcs;
        s.defaultReadObject();
        boolean b = s.readBoolean();
        if (b) {
            igcs = s.readBoolean();
            this._sortAsc = new RowComparator(this, true, igcs, false);
        } else {
            this._sortAsc = (Comparator)s.readObject();
        }
        b = s.readBoolean();
        if (b) {
            igcs = s.readBoolean();
            this._sortDsc = new RowComparator(this, false, igcs, false);
        } else {
            this._sortDsc = (Comparator)s.readObject();
        }
    }
}

