/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import org.zkoss.lang.Objects;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.ext.client.Checkable;
import org.zkoss.zul.impl.LabelImageElement;

public class Checkbox
extends LabelImageElement
implements org.zkoss.zul.api.Checkbox {
    private String _name;
    private int _tabindex = -1;
    private boolean _checked;
    private boolean _disabled;

    public Checkbox() {
    }

    public Checkbox(String label) {
        this.setLabel(label);
    }

    public Checkbox(String label, String image) {
        this.setLabel(label);
        this.setImage(image);
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.smartUpdate("disabled", this._disabled);
        }
    }

    public boolean isChecked() {
        return this._checked;
    }

    public void setChecked(boolean checked) {
        if (this._checked != checked) {
            this._checked = checked;
            this.smartUpdate("checked", this._checked);
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (!Objects.equals((Object)this._name, (Object)name)) {
            this._name = name;
            this.smartUpdate("name", this._name);
        }
    }

    public int getTabindex() {
        return this._tabindex;
    }

    public void setTabindex(int tabindex) throws WrongValueException {
        if (this._tabindex != tabindex) {
            this._tabindex = tabindex;
            if (tabindex < 0) {
                this.smartUpdate("tabindex", null);
            } else {
                this.smartUpdate("tabindex", Integer.toString(this._tabindex));
            }
        }
    }

    public String getLabelAttrs() {
        String style = HTMLs.getTextRelevantStyle((String)this.getRealStyle());
        return style.length() > 0 ? " style=\"" + style + '\"' : "";
    }

    public String getInnerAttrs() {
        StringBuffer sb = new StringBuffer(64).append(super.getInnerAttrs());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"name", (String)this.getName());
        if (this.isDisabled()) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"disabled", (String)"disabled");
        }
        if (this.isChecked()) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"checked", (String)"checked");
        }
        if (this._tabindex >= 0) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"tabindex", (int)this._tabindex);
        }
        return sb.toString();
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(64).append(super.getOuterAttrs());
        this.appendAsapAttr(sb, "onFocus");
        this.appendAsapAttr(sb, "onBlur");
        this.appendAsapAttr(sb, "onCheck");
        this.appendAsapAttr(sb, "onRightClick");
        this.appendAsapAttr(sb, "onDoubleClick");
        return sb.toString();
    }

    public String getZclass() {
        return this._zclass == null ? "z-checkbox" : this._zclass;
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    protected class ExtraCtrl
    extends LabelImageElement.ExtraCtrl
    implements Checkable {
        protected ExtraCtrl() {
            super(Checkbox.this);
        }

        public void setCheckedByClient(boolean checked) {
            Checkbox.this._checked = checked;
        }
    }
}

