/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.io.read;

import java.beans.IntrospectionException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.XMLBeanInfo;
import org.apache.commons.betwixt.io.read.BeanCreationChain;
import org.apache.commons.betwixt.io.read.ChainedBeanCreator;
import org.apache.commons.betwixt.io.read.ElementMapping;
import org.apache.commons.betwixt.io.read.ReadContext;
import org.apache.commons.logging.Log;

public class ChainedBeanCreatorFactory {
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final ChainedBeanCreator derivedBeanCreator = new ChainedBeanCreator(){

        public Object create(ElementMapping elementMapping, ReadContext context, BeanCreationChain chain) {
            Log log = context.getLog();
            String className = elementMapping.getAttributes().getValue(context.getClassNameAttribute());
            if (className != null) {
                try {
                    ClassLoader classLoader = context.getClassLoader();
                    Class<?> clazz = null;
                    if (classLoader == null) {
                        log.warn((Object)"Read context classloader not set.");
                    } else {
                        try {
                            clazz = classLoader.loadClass(className);
                        }
                        catch (ClassNotFoundException e) {
                            log.info((Object)"Class not found in context classloader:");
                            log.debug(clazz, (Throwable)e);
                        }
                    }
                    if (clazz == null) {
                        clazz = Class.forName(className);
                    }
                    return ChainedBeanCreatorFactory.newInstance(clazz, log);
                }
                catch (Exception e) {
                    log.warn((Object)("Could not create instance of type: " + className));
                    log.debug((Object)"Create new instance failed: ", (Throwable)e);
                    return null;
                }
            }
            return chain.create(elementMapping, context);
        }
    };
    private static final ChainedBeanCreator elementTypeBeanCreator = new ChainedBeanCreator(){

        public Object create(ElementMapping element, ReadContext context, BeanCreationChain chain) {
            Log log = context.getLog();
            Class theClass = null;
            ElementDescriptor descriptor = element.getDescriptor();
            if (descriptor != null && (theClass = context.resolvePolymorphicType(element)) == null) {
                theClass = descriptor.getImplementationClass();
            }
            if (theClass == null) {
                theClass = element.getType();
            }
            if (descriptor != null && descriptor.isPolymorphic()) {
                try {
                    XMLBeanInfo xmlBeanInfo = context.getXMLIntrospector().introspect(theClass);
                    String namespace = element.getNamespace();
                    String name = element.getName();
                    if (namespace == null) {
                        if (!name.equals(xmlBeanInfo.getElementDescriptor().getQualifiedName())) {
                            context.getLog().debug((Object)"Polymorphic type does not match element");
                            return null;
                        }
                    } else if (!namespace.equals(xmlBeanInfo.getElementDescriptor().getURI()) || !name.equals(xmlBeanInfo.getElementDescriptor().getLocalName())) {
                        context.getLog().debug((Object)"Polymorphic type does not match element");
                        return null;
                    }
                }
                catch (IntrospectionException e) {
                    context.getLog().warn((Object)("Could not introspect type to test introspection: " + theClass.getName()));
                    context.getLog().debug((Object)"Introspection failed: ", (Throwable)e);
                    return null;
                }
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Creating instance of class " + theClass.getName() + " for element " + element.getName()));
            }
            try {
                Object result = ChainedBeanCreatorFactory.newInstance(theClass, log);
                return result;
            }
            catch (Exception e) {
                context.getLog().warn((Object)("Could not create instance of type: " + theClass.getName()));
                context.getLog().debug((Object)"Create new instance failed: ", (Throwable)e);
                return null;
            }
        }
    };
    private static final ChainedBeanCreator idRefBeanCreator = new ChainedBeanCreator(){

        public Object create(ElementMapping elementMapping, ReadContext context, BeanCreationChain chain) {
            String idref;
            if (context.getMapIDs() && (idref = elementMapping.getAttributes().getValue("idref")) != null) {
                context.getLog().trace((Object)"Found IDREF");
                Object bean = context.getBean(idref);
                if (bean != null) {
                    if (context.getLog().isTraceEnabled()) {
                        context.getLog().trace((Object)("Matched bean " + bean));
                    }
                    return bean;
                }
                context.getLog().trace((Object)"No match found");
            }
            return chain.create(elementMapping, context);
        }
    };

    public static final ChainedBeanCreator createDerivedBeanCreator() {
        return derivedBeanCreator;
    }

    private static final Object newInstance(Class theClass, Log log) throws Exception {
        Object result;
        block5: {
            result = null;
            try {
                Constructor constructor = theClass.getConstructor(EMPTY_CLASS_ARRAY);
                if (!constructor.isAccessible()) {
                    ((AccessibleObject)constructor).setAccessible(true);
                }
                result = constructor.newInstance(EMPTY_OBJECT_ARRAY);
            }
            catch (SecurityException e) {
                log.debug((Object)"Cannot force accessibility to constructor", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)("Class " + theClass + " has no empty constructor."));
            }
        }
        if (result == null) {
            result = theClass.newInstance();
        }
        return result;
    }

    public static final ChainedBeanCreator createElementTypeBeanCreator() {
        return elementTypeBeanCreator;
    }

    public static final ChainedBeanCreator createIDREFBeanCreator() {
        return idRefBeanCreator;
    }
}

