/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.digester;

import java.beans.PropertyDescriptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.XMLBeanInfo;
import org.apache.commons.betwixt.XMLUtils;
import org.apache.commons.betwixt.digester.MappedPropertyRule;
import org.apache.commons.betwixt.expression.ConstantExpression;
import org.apache.commons.betwixt.expression.Expression;
import org.apache.commons.betwixt.expression.IteratorExpression;
import org.apache.commons.betwixt.expression.MethodExpression;
import org.apache.commons.betwixt.expression.MethodUpdater;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ElementRule
extends MappedPropertyRule {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$commons$betwixt$digester$ElementRule == null ? (class$org$apache$commons$betwixt$digester$ElementRule = ElementRule.class$("org.apache.commons.betwixt.digester.ElementRule")) : class$org$apache$commons$betwixt$digester$ElementRule));
    private Class beanClass;
    static /* synthetic */ Class class$org$apache$commons$betwixt$digester$ElementRule;
    static /* synthetic */ Class class$java$util$Map;

    public static final void setLog(Log newLog) {
        log = newLog;
    }

    public void begin(String name, String namespace, Attributes attributes) throws SAXException {
        String mappingDerivation;
        String nameAttributeValue = attributes.getValue("name");
        ElementDescriptor descriptor = new ElementDescriptor();
        descriptor.setLocalName(nameAttributeValue);
        String uri = attributes.getValue("uri");
        String qName = nameAttributeValue;
        if (uri != null && nameAttributeValue != null) {
            descriptor.setURI(uri);
            String prefix = this.getXMLIntrospector().getConfiguration().getPrefixMapper().getPrefix(uri);
            qName = prefix + ":" + nameAttributeValue;
        }
        descriptor.setQualifiedName(qName);
        String propertyName = attributes.getValue("property");
        descriptor.setPropertyName(propertyName);
        String propertyType = attributes.getValue("type");
        if (log.isTraceEnabled()) {
            log.trace((Object)("(BEGIN) name=" + nameAttributeValue + " uri=" + uri + " property=" + propertyName + " type=" + propertyType));
        }
        if ("introspection".equals(mappingDerivation = attributes.getValue("mappingDerivation"))) {
            descriptor.setUseBindTimeTypeForMapping(false);
        } else if ("bind".equals(mappingDerivation)) {
            descriptor.setUseBindTimeTypeForMapping(true);
        }
        descriptor.setPropertyType(this.getPropertyType(propertyType, this.beanClass, propertyName));
        boolean isCollective = this.getXMLIntrospector().getConfiguration().isLoopType(descriptor.getPropertyType());
        descriptor.setCollective(isCollective);
        if (!isCollective && (nameAttributeValue == null || nameAttributeValue.trim().equals(""))) {
            log.info((Object)"No name attribute has been specified. This element will be polymorphic.");
        }
        if (nameAttributeValue != null && !XMLUtils.isWellFormedXMLName(nameAttributeValue)) {
            throw new SAXException("'" + nameAttributeValue + "' would not be a well formed xml element name.");
        }
        String implementationClass = attributes.getValue("class");
        if (log.isTraceEnabled()) {
            log.trace((Object)("'class' attribute=" + implementationClass));
        }
        if (implementationClass != null) {
            try {
                Class<?> clazz = Class.forName(implementationClass);
                descriptor.setImplementationClass(clazz);
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cannot load class named: " + implementationClass), (Throwable)e);
                }
                throw new SAXException("Cannot load class named: " + implementationClass);
            }
        }
        if (propertyName != null && propertyName.length() > 0) {
            boolean forceAccessible = "true".equals(attributes.getValue("forceAccessible"));
            this.configureDescriptor(descriptor, attributes.getValue("updater"), forceAccessible);
        } else {
            String value = attributes.getValue("value");
            if (value != null) {
                descriptor.setTextExpression(new ConstantExpression(value));
            }
        }
        Object top = this.digester.peek();
        if (top instanceof XMLBeanInfo) {
            XMLBeanInfo beanInfo = (XMLBeanInfo)top;
            beanInfo.setElementDescriptor(descriptor);
            this.beanClass = beanInfo.getBeanClass();
            descriptor.setPropertyType(this.beanClass);
        } else if (top instanceof ElementDescriptor) {
            ElementDescriptor parent = (ElementDescriptor)top;
            parent.addElementDescriptor(descriptor);
        } else {
            throw new SAXException("Invalid use of <element>. It should be nested inside <info> or other <element> nodes");
        }
        this.digester.push((Object)descriptor);
    }

    public void end(String name, String namespace) {
        ElementDescriptor descriptor = (ElementDescriptor)this.digester.pop();
        Object peek = this.digester.peek();
        if (peek instanceof ElementDescriptor) {
            ElementDescriptor parent = (ElementDescriptor)this.digester.peek();
            if (this.getXMLIntrospector().getConfiguration().getElementSuppressionStrategy().suppress(descriptor)) {
                parent.removeElementDescriptor(descriptor);
            }
        }
    }

    protected void configureDescriptor(ElementDescriptor elementDescriptor) {
        this.configureDescriptor(elementDescriptor, null);
    }

    protected void configureDescriptor(ElementDescriptor elementDescriptor, String updateMethodName) {
        this.configureDescriptor(elementDescriptor, null, false);
    }

    private void configureDescriptor(ElementDescriptor elementDescriptor, String updateMethodName, boolean forceAccessible) {
        Class beanClass = this.getBeanClass();
        if (beanClass != null) {
            String name = elementDescriptor.getPropertyName();
            PropertyDescriptor descriptor = this.getPropertyDescriptor(beanClass, name);
            if (descriptor == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cannot find property matching " + name));
                }
            } else {
                this.configureProperty(elementDescriptor, descriptor, updateMethodName, forceAccessible, beanClass);
                this.getProcessedPropertyNameSet().add(name);
            }
        }
    }

    private void configureProperty(ElementDescriptor elementDescriptor, PropertyDescriptor propertyDescriptor, String updateMethodName, boolean forceAccessible, Class beanClass) {
        Class<?> type = propertyDescriptor.getPropertyType();
        Method readMethod = propertyDescriptor.getReadMethod();
        Method writeMethod = propertyDescriptor.getWriteMethod();
        elementDescriptor.setPropertyType(type);
        if (readMethod == null) {
            log.trace((Object)"No read method");
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Read method=" + readMethod.getName()));
        }
        MethodExpression methodExpression = new MethodExpression(readMethod);
        if (this.getXMLIntrospector().isPrimitiveType(type)) {
            elementDescriptor.setTextExpression(methodExpression);
        } else if (this.getXMLIntrospector().isLoopType(type)) {
            Class<?> setterType;
            Class<?>[] parameters;
            log.trace((Object)"Loop type ??");
            Expression expression = methodExpression;
            boolean standardProperty = false;
            if (updateMethodName != null && writeMethod != null && writeMethod.getName().equals(updateMethodName) && (parameters = writeMethod.getParameterTypes()).length == 1 && type.equals(setterType = parameters[0])) {
                standardProperty = true;
            }
            if (!standardProperty) {
                expression = new IteratorExpression(methodExpression);
            }
            elementDescriptor.setContextExpression(expression);
            elementDescriptor.setHollow(true);
            writeMethod = null;
            if ((class$java$util$Map == null ? (class$java$util$Map = ElementRule.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(type)) {
                elementDescriptor.setLocalName("entry");
                ElementDescriptor keyDescriptor = new ElementDescriptor("key");
                keyDescriptor.setHollow(true);
                elementDescriptor.addElementDescriptor(keyDescriptor);
                ElementDescriptor valueDescriptor = new ElementDescriptor("value");
                valueDescriptor.setHollow(true);
                elementDescriptor.addElementDescriptor(valueDescriptor);
            }
        } else {
            log.trace((Object)"Standard property");
            elementDescriptor.setHollow(true);
            elementDescriptor.setContextExpression(methodExpression);
        }
        if (updateMethodName == null) {
            if (writeMethod != null) {
                elementDescriptor.setUpdater(new MethodUpdater(writeMethod));
            }
        } else {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Finding custom method: ");
                log.trace((Object)("  on:" + beanClass));
                log.trace((Object)("  name:" + updateMethodName));
            }
            boolean isMapTypeProperty = (class$java$util$Map == null ? (class$java$util$Map = ElementRule.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(type);
            Method updateMethod = forceAccessible ? this.findAnyMethod(updateMethodName, beanClass, isMapTypeProperty) : this.findPublicMethod(updateMethodName, beanClass, isMapTypeProperty);
            if (updateMethod == null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("No method with name '" + updateMethodName + "' found for update"));
                }
            } else if ((class$java$util$Map == null ? (class$java$util$Map = ElementRule.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(type)) {
                this.getXMLIntrospector().assignAdder(updateMethod, elementDescriptor);
            } else {
                boolean isPrimitive;
                elementDescriptor.setUpdater(new MethodUpdater(updateMethod));
                Class<?> singularType = updateMethod.getParameterTypes()[0];
                elementDescriptor.setSingularPropertyType(singularType);
                if (singularType != null && (isPrimitive = this.getXMLIntrospector().isPrimitiveType(singularType))) {
                    log.debug((Object)"Primitive collective: setting hollow to false");
                    elementDescriptor.setHollow(false);
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Set custom updater on " + elementDescriptor));
                }
            }
        }
    }

    private Method findPublicMethod(String updateMethodName, Class beanType, boolean isMapTypeProperty) {
        Method[] methods = beanType.getMethods();
        Method updateMethod = this.searchMethodsForMatch(updateMethodName, methods, isMapTypeProperty);
        return updateMethod;
    }

    private Method searchMethodsForMatch(String updateMethodName, Method[] methods, boolean isMapType) {
        Method updateMethod = null;
        int size = methods.length;
        for (int i = 0; i < size; ++i) {
            Method method = methods[i];
            if (!updateMethodName.equals(method.getName())) continue;
            int numParams = 1;
            if (isMapType) {
                numParams = 2;
            }
            if (methods[i].getParameterTypes().length != numParams) continue;
            updateMethod = methods[i];
            if (!log.isTraceEnabled()) break;
            log.trace((Object)("Matched method:" + updateMethod));
            break;
        }
        return updateMethod;
    }

    private Method findAnyMethod(String updateMethodName, Class beanType, boolean isMapTypeProperty) {
        Method updateMethod = null;
        Class classToTry = beanType;
        do {
            Method[] methods = classToTry.getDeclaredMethods();
            updateMethod = this.searchMethodsForMatch(updateMethodName, methods, isMapTypeProperty);
            classToTry = classToTry.getSuperclass();
        } while (updateMethod == null && classToTry != null);
        if (updateMethod != null) {
            boolean isPublic;
            boolean bl = isPublic = Modifier.isPublic(updateMethod.getModifiers()) && Modifier.isPublic(beanType.getModifiers());
            if (!isPublic) {
                ((AccessibleObject)updateMethod).setAccessible(true);
            }
        }
        return updateMethod;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

