/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.swing;

import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.ui.AbstractIcon;
import org.aspectj.ajde.ui.GlobalStructureView;
import org.aspectj.ajde.ui.IStructureViewNode;
import org.aspectj.ajde.ui.StructureView;
import org.aspectj.ajde.ui.StructureViewProperties;
import org.aspectj.ajde.ui.swing.StructureTree;
import org.aspectj.ajde.ui.swing.StructureViewTreeListener;
import org.aspectj.ajde.ui.swing.SwingTreeViewNode;
import org.aspectj.ajde.ui.swing.SwingTreeViewNodeRenderer;
import org.aspectj.asm.IHierarchy;
import org.aspectj.asm.IProgramElement;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.Message;

class StructureTreeManager {
    private StructureTree structureTree;
    private SwingTreeViewNodeRenderer cellRenderer = null;
    private TreeSelectionListener treeListener = null;
    private final StructureTreeModel NO_STRUCTURE_MODEL = new StructureTreeModel(new SwingTreeViewNode(IHierarchy.NO_STRUCTURE, new AbstractIcon(null), new ArrayList()));

    public StructureTreeManager() {
        this.structureTree = new StructureTree();
        this.structureTree.setModel(this.NO_STRUCTURE_MODEL);
        this.cellRenderer = new SwingTreeViewNodeRenderer();
        this.structureTree.setCellRenderer(this.cellRenderer);
        this.treeListener = new StructureViewTreeListener(this.structureTree);
        this.structureTree.addTreeSelectionListener(this.treeListener);
        this.structureTree.addMouseListener((MouseListener)((Object)this.treeListener));
    }

    public void highlightNode(IProgramElement node) {
        this.highlightNode((SwingTreeViewNode)this.structureTree.getModel().getRoot(), node);
    }

    public IProgramElement getSelectedIProgramElement() {
        return (IProgramElement)((SwingTreeViewNode)this.structureTree.getLastSelectedPathComponent()).getUserObject();
    }

    public void scrollToHighlightedNode() {
        this.structureTree.scrollPathToVisible(this.structureTree.getSelectionPath());
    }

    private void highlightNode(SwingTreeViewNode parent, IProgramElement node) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            SwingTreeViewNode currNode = (SwingTreeViewNode)parent.getChildAt(i);
            IProgramElement sNode = currNode.getStructureNode();
            if (sNode != null && sNode.equals(node) && currNode.getKind() != IStructureViewNode.Kind.LINK) {
                TreePath path = new TreePath(currNode.getPath());
                this.structureTree.setSelectionPath(path);
                int currRow = this.structureTree.getRowForPath(path);
                this.structureTree.expandRow(currRow);
                this.structureTree.scrollRowToVisible(currRow);
                continue;
            }
            this.highlightNode(currNode, node);
        }
    }

    public void updateTree(final StructureView structureView) {
        if (structureView == null) {
            return;
        }
        Runnable update = new Runnable(){

            public void run() {
                StructureTreeManager.this.structureTree.removeAll();
                if (structureView.getRootNode() == null) {
                    StructureTreeManager.this.structureTree.setModel(StructureTreeManager.this.NO_STRUCTURE_MODEL);
                } else {
                    StructureTreeManager.this.structureTree.setModel(new StructureTreeModel((SwingTreeViewNode)structureView.getRootNode()));
                }
                if (structureView instanceof GlobalStructureView) {
                    GlobalStructureView view = (GlobalStructureView)structureView;
                    if (view.getGlobalViewProperties().getHierarchy() == StructureViewProperties.Hierarchy.DECLARATION) {
                        StructureTreeManager.this.expandTreeToFiles();
                    } else {
                        StructureTreeManager.this.expandTree(15);
                    }
                } else {
                    StructureTreeManager.this.expandTree(10);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            update.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(update);
            }
            catch (Exception e) {
                Message msg = new Message("Could not update tree.", IMessage.ERROR, e, null);
                Ajde.getDefault().getMessageHandler().handleMessage(msg);
            }
        }
    }

    StructureTree getStructureTree() {
        return this.structureTree;
    }

    private void expandTreeToFiles() {
        for (int i = 0; i < this.structureTree.getRowCount(); ++i) {
            TreePath path = this.structureTree.getPathForRow(i);
            SwingTreeViewNode node = (SwingTreeViewNode)path.getLastPathComponent();
            if (node.getUserObject() instanceof IProgramElement) {
                IProgramElement pNode = (IProgramElement)node.getUserObject();
                IProgramElement.Kind kind = pNode.getKind();
                if (kind == IProgramElement.Kind.PROJECT || kind == IProgramElement.Kind.PACKAGE) {
                    this.structureTree.expandPath(path);
                    continue;
                }
                this.structureTree.collapsePath(path);
                continue;
            }
            this.structureTree.collapsePath(path);
        }
        this.structureTree.expandPath(this.structureTree.getPathForRow(0));
    }

    private void expandTree(int depth) {
        for (int i = 0; i < this.structureTree.getRowCount(); ++i) {
            TreePath path = this.structureTree.getPathForRow(i);
            SwingTreeViewNode node = (SwingTreeViewNode)path.getLastPathComponent();
            if (path.getPath().length - 1 > depth || node.getKind() == IStructureViewNode.Kind.RELATIONSHIP) {
                this.structureTree.collapsePath(path);
                continue;
            }
            this.structureTree.expandPath(path);
        }
        this.structureTree.expandPath(this.structureTree.getPathForRow(0));
    }

    private class StructureTreeModel
    extends DefaultTreeModel
    implements TreeModel {
        private static final long serialVersionUID = 1L;

        public StructureTreeModel(TreeNode newRoot) {
            super(newRoot);
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            this.nodeChanged(node);
        }
    }
}

