/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.tests.perftests;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mvel.MVEL;
import org.mvel.tests.main.res.Base;
import org.mvel.tests.main.res.Foo;
import org.mvel.tests.perftests.NativeTest;
import org.mvel.tests.perftests.PerfTest;

public class ELComparisons
implements Runnable {
    private final Base baseClass = new Base();
    public static int RUN_MVEL = 1;
    public static int RUN_OGNL = 2;
    public static int RUN_COMMONS_EL = 4;
    public static int RUN_JAVA_NATIVE = 8;
    private static int COMPILED = 0x40000000;
    private static int INTERPRETED = Integer.MIN_VALUE;
    private static int ALL = RUN_MVEL + RUN_OGNL + RUN_COMMONS_EL + RUN_JAVA_NATIVE;
    private static final int TESTNUM = 100000;
    private static final int TESTITER = 3;
    private long ognlTotal = 0L;
    private long mvelTotal = 0L;
    private long commonElTotal = 0L;
    private long javaNativeTotal = 0L;
    private long groovyTotal = 0L;
    private int testFlags = 0;
    private boolean silent = false;
    private static List<PerfTest> tests = new ArrayList<PerfTest>();
    private static final Map<String, Object> variables = new HashMap<String, Object>();

    static {
        NativeTest nt = new NativeTest(){

            public Object run(Object baseClass, Map vars) {
                return vars.get("data");
            }
        };
        nt = new NativeTest(){

            public Object run(Object baseClass, Map vars) {
                return ((Base)baseClass).getFoo().getBar().getName();
            }
        };
        tests.add(new PerfTest("Deep Property", "foo.bar.name", ALL, nt));
        tests.add(new PerfTest("Static Field Access (MVEL)", "Integer.MAX_VALUE", RUN_MVEL, nt));
        tests.add(new PerfTest("Static Field Access (OGNL)", "@java.lang.Integer@MAX_VALUE", RUN_OGNL, nt));
        tests.add(new PerfTest("Inline Array Creation (MVEL)", "{'foo', 'bar'}", RUN_MVEL, nt));
        tests.add(new PerfTest("Inline Array Creation (OGNL)", "new String[] {'foo', 'bar'}", RUN_OGNL, nt));
        nt = new NativeTest(){

            public Object run(Object baseClass, Map vars) {
                return ((Foo)((Base)baseClass).funMap.get("foo")).happy();
            }
        };
        nt = new NativeTest(){

            public Object run(Object baseClass, Map vars) {
                return new Integer(10);
            }
        };
    }

    public ELComparisons() {
        variables.put("data", this.baseClass.data);
        variables.put("foo", this.baseClass.foo);
        variables.put("funMap", this.baseClass.funMap);
    }

    public void setTestFlags(int testFlags) {
        this.testFlags = testFlags;
    }

    public static void main(String[] args) throws Exception {
        ELComparisons omc = new ELComparisons();
        boolean multithreaded = false;
        boolean compiled = true;
        boolean interpreted = true;
        boolean continuous = false;
        boolean silent = false;
        long totaltime = 0L;
        int threadMax = 1;
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                if (args[i].equals("-continuous")) {
                    continuous = true;
                } else if (args[i].equals("-threaded")) {
                    if (i + 1 == args.length) {
                        throw new RuntimeException("expected parameter for -threaded (number of threads)");
                    }
                    multithreaded = true;
                    threadMax = Integer.parseInt(args[++i]);
                } else if (args[i].equals("-nocompiled")) {
                    compiled = false;
                } else if (args[i].equals("-nointerpret")) {
                    interpreted = false;
                } else if (args[i].equals("-silent")) {
                    silent = true;
                }
                ++i;
            }
        }
        int flags = (compiled ? COMPILED : 0) + (interpreted ? INTERPRETED : 0);
        ELComparisons ognlTests = new ELComparisons();
        ognlTests.setTestFlags(flags + RUN_OGNL);
        ognlTests.setSilent(true);
        ELComparisons mvelTests = new ELComparisons();
        mvelTests.setTestFlags(flags + RUN_MVEL);
        mvelTests.setSilent(silent);
        ELComparisons commonsELTests = new ELComparisons();
        commonsELTests.setTestFlags(flags + RUN_COMMONS_EL);
        commonsELTests.setSilent(silent);
        ELComparisons nativeJavaTests = new ELComparisons();
        nativeJavaTests.setTestFlags(flags + RUN_JAVA_NATIVE);
        nativeJavaTests.setSilent(silent);
        if (multithreaded) {
            System.out.println("THREADS\tOGNL\tMVEL\tCommons-EL\tNative Java");
            int threadNumber = 1;
            while (threadNumber < 100) {
                totaltime = System.currentTimeMillis();
                ognlTests.reset();
                Thread[] threads = new Thread[threadNumber];
                int i = 0;
                while (i < threads.length) {
                    threads[i] = new Thread(ognlTests);
                    ++i;
                }
                Thread[] threadArray = threads;
                int n = threads.length;
                int n2 = 0;
                while (n2 < n) {
                    Thread thread = threadArray[n2];
                    thread.run();
                    ++n2;
                }
                threadArray = threads;
                n = threads.length;
                n2 = 0;
                while (n2 < n) {
                    Thread thread = threadArray[n2];
                    thread.join();
                    ++n2;
                }
                long ognlTotals = ognlTests.getOgnlTotal();
                mvelTests.reset();
                i = 0;
                while (i < threads.length) {
                    threads[i] = new Thread(mvelTests);
                    ++i;
                }
                threadArray = threads;
                n = threads.length;
                n2 = 0;
                while (n2 < n) {
                    Thread thread = threadArray[n2];
                    thread.run();
                    ++n2;
                }
                threadArray = threads;
                n = threads.length;
                n2 = 0;
                while (n2 < n) {
                    Thread thread = threadArray[n2];
                    thread.join();
                    ++n2;
                }
                long mvelTotals = mvelTests.getMvelTotal();
                commonsELTests.reset();
                i = 0;
                while (i < threads.length) {
                    threads[i] = new Thread(commonsELTests);
                    ++i;
                }
                threadArray = threads;
                n = threads.length;
                n2 = 0;
                while (n2 < n) {
                    Thread thread = threadArray[n2];
                    thread.run();
                    ++n2;
                }
                threadArray = threads;
                n = threads.length;
                n2 = 0;
                while (n2 < n) {
                    Thread thread = threadArray[n2];
                    thread.join();
                    ++n2;
                }
                long commonsElTotals = commonsELTests.getCommonElTotal();
                nativeJavaTests.reset();
                i = 0;
                while (i < threads.length) {
                    threads[i] = new Thread(nativeJavaTests);
                    ++i;
                }
                threadArray = threads;
                n = threads.length;
                n2 = 0;
                while (n2 < n) {
                    Thread thread = threadArray[n2];
                    thread.run();
                    ++n2;
                }
                threadArray = threads;
                n = threads.length;
                n2 = 0;
                while (n2 < n) {
                    Thread thread = threadArray[n2];
                    thread.join();
                    ++n2;
                }
                long javaNativeTotals = nativeJavaTests.getJavaNativeTotal();
                totaltime = System.currentTimeMillis() - totaltime;
                System.out.println(String.valueOf(threadNumber) + "\t" + ognlTotals + "\t" + mvelTotals + "\t" + commonsElTotals + "\t" + javaNativeTotals);
                threadNumber += 5;
            }
            System.out.println("Done.");
        } else {
            omc.setTestFlags(ALL + INTERPRETED + COMPILED);
            omc.run();
        }
    }

    public void run() {
        try {
            Iterator<PerfTest> iterator = tests.iterator();
            while (iterator.hasNext()) {
                PerfTest test = iterator.next();
                this.runTest(test, 100000);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(PerfTest test, int count) throws Exception {
        long total;
        block45: {
            int i;
            long mem;
            long time;
            int exFlags = test.getRunFlags();
            String expression = test.getExpression();
            String name = test.getName();
            if (!this.silent) {
                System.out.println("Test Name            : " + test.getName());
                System.out.println("Expression           : " + test.getExpression());
                System.out.println("Iterations           : " + count);
            }
            total = 0L;
            long[] res = new long[3];
            if ((this.testFlags & INTERPRETED) != 0) {
                block44: {
                    block43: {
                        if (!this.silent) {
                            System.out.println("Interpreted Results  :");
                        }
                        if ((this.testFlags & RUN_OGNL) != 0 && (exFlags & RUN_OGNL) != 0) {
                            try {
                                int i2 = 0;
                                while (i2 < count) {
                                    ++i2;
                                }
                                time = System.currentTimeMillis();
                                mem = Runtime.getRuntime().freeMemory();
                                int reps = 0;
                                while (reps < 3) {
                                    i = 0;
                                    while (i < count) {
                                        ++i;
                                    }
                                    if (reps == 0) {
                                        res[0] = total += System.currentTimeMillis() - time;
                                    } else {
                                        long l = total * -1L;
                                        total += System.currentTimeMillis() - time - total;
                                        res[reps] = l + total;
                                    }
                                    ++reps;
                                }
                                if (!this.silent) {
                                    System.out.println("(OGNL)               : " + new BigDecimal(System.currentTimeMillis() - time).divide(new BigDecimal(3), 2, RoundingMode.HALF_UP) + "ms avg.  (mem delta: " + (Runtime.getRuntime().freeMemory() - mem) / 1024L + "kb) " + ELComparisons.resultsToString(res));
                                }
                            }
                            catch (Exception e) {
                                if (this.silent) break block43;
                                System.out.println("(OGNL)               : <<COULD NOT EXECUTE>>");
                            }
                        }
                    }
                    ELComparisons e = this;
                    synchronized (e) {
                        this.ognlTotal += total;
                    }
                    total = 0L;
                    if ((this.testFlags & RUN_MVEL) != 0 && (exFlags & RUN_MVEL) != 0) {
                        try {
                            int i3 = 0;
                            while (i3 < count) {
                                MVEL.eval(expression, this.baseClass);
                                ++i3;
                            }
                            time = System.currentTimeMillis();
                            mem = Runtime.getRuntime().freeMemory();
                            int reps = 0;
                            while (reps < 3) {
                                i = 0;
                                while (i < count) {
                                    MVEL.eval(expression, this.baseClass);
                                    ++i;
                                }
                                if (reps == 0) {
                                    res[0] = total += System.currentTimeMillis() - time;
                                } else {
                                    long l = total * -1L;
                                    total += System.currentTimeMillis() - time - total;
                                    res[reps] = l + total;
                                }
                                ++reps;
                            }
                            if (!this.silent) {
                                System.out.println("(MVEL)               : " + new BigDecimal(System.currentTimeMillis() - time).divide(new BigDecimal(3), 2, RoundingMode.HALF_UP) + "ms avg.  (mem delta: " + (Runtime.getRuntime().freeMemory() - mem) / 1024L + "kb) " + ELComparisons.resultsToString(res));
                            }
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                            if (this.silent) break block44;
                            System.out.println("(MVEL)               : <<COULD NOT EXECUTE>>");
                        }
                    }
                }
                ELComparisons e2 = this;
                synchronized (e2) {
                    this.mvelTotal += total;
                }
                total = 0L;
                e2 = this;
                synchronized (e2) {
                    this.commonElTotal += total;
                }
            }
            total = 0L;
            if ((this.testFlags & RUN_JAVA_NATIVE) != 0 && (exFlags & RUN_JAVA_NATIVE) != 0) {
                NativeTest nt = test.getJavaNative();
                try {
                    i = 0;
                    while (i < count) {
                        nt.run(this.baseClass, variables);
                        ++i;
                    }
                    time = System.currentTimeMillis();
                    mem = Runtime.getRuntime().freeMemory();
                    int reps = 0;
                    while (reps < 3) {
                        int i4 = 0;
                        while (i4 < count) {
                            nt.run(this.baseClass, variables);
                            ++i4;
                        }
                        if (reps == 0) {
                            res[0] = total += System.currentTimeMillis() - time;
                        } else {
                            long l = total * -1L;
                            total += System.currentTimeMillis() - time - total;
                            res[reps] = l + total;
                        }
                        ++reps;
                    }
                    if (!this.silent) {
                        System.out.println("(JavaNative)         : " + new BigDecimal(System.currentTimeMillis() - time).divide(new BigDecimal(3), 2, RoundingMode.HALF_UP) + "ms avg.  (mem delta: " + (Runtime.getRuntime().freeMemory() - mem) / 1024L + "kb) " + ELComparisons.resultsToString(res));
                    }
                }
                catch (Exception e) {
                    if (this.silent) break block45;
                    System.out.println("(JavaNative)         : <<COULD NOT EXECUTE>>");
                }
            }
        }
        ELComparisons eLComparisons = this;
        synchronized (eLComparisons) {
            this.javaNativeTotal += total;
        }
        if (!this.silent) {
            System.out.println("------------------------------------------------");
        }
    }

    private static String resultsToString(long[] res) {
        StringBuffer sbuf = new StringBuffer("[");
        int i = 0;
        while (i < res.length) {
            sbuf.append(res[i]);
            if (i + 1 < res.length) {
                sbuf.append(",");
            }
            ++i;
        }
        sbuf.append("]");
        return sbuf.toString();
    }

    public long getOgnlTotal() {
        return this.ognlTotal;
    }

    public void setOgnlTotal(long ognlTotal) {
        this.ognlTotal = ognlTotal;
    }

    public long getMvelTotal() {
        return this.mvelTotal;
    }

    public void setMvelTotal(long mvelTotal) {
        this.mvelTotal = mvelTotal;
    }

    public long getCommonElTotal() {
        return this.commonElTotal;
    }

    public void setCommonElTotal(long commonElTotal) {
        this.commonElTotal = commonElTotal;
    }

    public long getJavaNativeTotal() {
        return this.javaNativeTotal;
    }

    public void setJavaNativeTotal(long javaNativeTotal) {
        this.javaNativeTotal = javaNativeTotal;
    }

    public long getGroovyTotal() {
        return this.groovyTotal;
    }

    public void setGroovyTotal(long groovyTotal) {
        this.groovyTotal = groovyTotal;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public void reset() {
        this.ognlTotal = 0L;
        this.mvelTotal = 0L;
        this.javaNativeTotal = 0L;
        this.commonElTotal = 0L;
    }
}

