/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.deployment;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javassist.ClassPool;
import javassist.scopedpool.ScopedClassPool;
import javassist.scopedpool.ScopedClassPoolFactory;
import javassist.scopedpool.ScopedClassPoolRepository;
import org.jboss.aop.deployment.JBossClassPool32;
import org.jboss.mx.loading.UnifiedClassLoader;

public class JBossClassPoolFactory32
implements ScopedClassPoolFactory {
    protected File tmpClassesDir;

    public JBossClassPoolFactory32(File tmpClassesDir) throws IOException {
        this.tmpClassesDir = tmpClassesDir;
    }

    public ScopedClassPool create(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository) {
        try {
            File tempdir = this.createTempDir(cl);
            return new JBossClassPool32(cl, src, repository, tempdir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ScopedClassPool create(ClassPool src, ScopedClassPoolRepository repository) {
        return new JBossClassPool32(src, repository);
    }

    public File createTempDir(ClassLoader cl) throws IOException {
        if (!(cl instanceof UnifiedClassLoader)) {
            return null;
        }
        File tempdir = File.createTempFile("ucl", "", this.tmpClassesDir);
        tempdir.delete();
        tempdir.mkdir();
        tempdir.deleteOnExit();
        UnifiedClassLoader ucl = (UnifiedClassLoader)cl;
        URL tmpURL = tempdir.toURL();
        URL tmpCP = new URL(tmpURL, "?dynamic=true");
        if (ucl.getLoaderRepository() != null) {
            ucl.addURL(tmpCP);
        }
        return tempdir;
    }
}

