/*
 * Decompiled with CFR 0.152.
 */
package org.zkforge.timeplot;

import java.util.ArrayList;
import org.zkforge.timeline.data.OccurEvent;
import org.zkforge.timeplot.Timeplot;
import org.zkforge.timeplot.data.PlotData;
import org.zkforge.timeplot.data.PlotDataSource;
import org.zkforge.timeplot.geometry.TimeGeometry;
import org.zkforge.timeplot.geometry.ValueGeometry;
import org.zkforge.timeplot.impl.TimeplotComponent;
import org.zkforge.timeplot.operator.Operator;
import org.zkoss.lang.Objects;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.event.ListDataListener;

public class Plotinfo
extends TimeplotComponent {
    private ListModel _dataModel;
    private ArrayList _dataList = new ArrayList();
    private ListModel _eventModel;
    private ArrayList _eventList = new ArrayList();
    private transient ListDataListener _dataListener;
    private transient ListDataListener _eventListener;
    private String fillColor;
    private String dotColor;
    private String lineColor;
    private float lineWidth = 1.0f;
    private float eventLineWidth = 1.0f;
    private float dotRadius = 2.0f;
    private boolean showValues = false;
    private boolean roundValues = true;
    private int valuesOpacity = 75;
    private int bubbleWidth = 300;
    private int bubbleHeight = 200;
    private PlotDataSource pds = null;
    private Operator operator = null;
    private String eventSourceUri = null;
    private ValueGeometry _valueGeometry = null;
    private TimeGeometry _timeGeometry = null;

    public String getInnerAttrs() {
        String attrs = super.getInnerAttrs();
        StringBuffer sb = new StringBuffer(64);
        if (attrs != null) {
            sb.append(attrs);
        }
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.pid", (String)this.getParent().getUuid());
        if (this.lineColor != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.lineColor", (String)this.lineColor);
        }
        if (this.fillColor != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.fillColor", (String)this.fillColor);
        }
        if (this.dotColor != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.dotColor", (String)this.dotColor);
        }
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.lineWidth", (String)String.valueOf(this.lineWidth));
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.eventLineWidth", (String)String.valueOf(this.eventLineWidth));
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.dotRadius", (String)String.valueOf(this.dotRadius));
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.showValues", (boolean)this.showValues);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.roundValues", (boolean)this.roundValues);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.valuesOpacity", (int)this.valuesOpacity);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.bubbleWidth", (int)this.bubbleWidth);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.bubbleHeight", (int)this.bubbleHeight);
        if (this.operator != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.operator", (String)this.operator.getOperator());
            String params = this.operator.getParams();
            if (params != null) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z.operatorParams", (String)params);
            }
        }
        if (this.pds != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.separator", (String)this.pds.getSeparator());
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.dataSourceColumn", (int)this.pds.getDataSourceColumn());
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.dataSourceUri", (String)this.pds.getDataSourceUri());
        }
        if (this.eventSourceUri != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.eventSourceUri", (String)this.eventSourceUri);
        }
        if (this._valueGeometry != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.valueGeometryDefined", (boolean)true);
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.valueGeometryType", (String)this._valueGeometry.toString());
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.valueGeometry.id", (int)this._valueGeometry.getValueGeometryId());
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.valueGeometry.axisColor", (String)this._valueGeometry.getAxisColor());
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.valueGeometry.axisLabelsPlacement", (String)this._valueGeometry.getAxisLabelsPlacement());
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.valueGeometry.gridColor", (String)this._valueGeometry.getGridColor());
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.valueGeometry.gridLineWidth", (String)String.valueOf(this._valueGeometry.getGridLineWidth()));
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.valueGeometry.gridSpacing", (String)String.valueOf(this._valueGeometry.getGridSpacing()));
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.valueGeometry.gridType", (String)this._valueGeometry.getGridType());
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.valueGeometry.gridShortSize", (String)String.valueOf(this._valueGeometry.getGridShortSize()));
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.valueGeometry.min", (String)String.valueOf(this._valueGeometry.getMin()));
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.valueGeometry.max", (String)String.valueOf(this._valueGeometry.getMax()));
        }
        if (this._timeGeometry != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.timeGeometryDefined", (boolean)true);
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.timeGeometry.id", (int)this._timeGeometry.getTimeGeometryId());
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.timeGeometry.axisColor", (String)this._timeGeometry.getAxisColor());
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.timeGeometry.axisLabelsPlacement", (String)this._timeGeometry.getAxisLabelsPlacement());
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.timeGeometry.gridColor", (String)this._timeGeometry.getGridColor());
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.timeGeometry.gridLineWidth", (String)String.valueOf(this._timeGeometry.getGridLineWidth()));
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.timeGeometry.gridGridStep", (String)String.valueOf(this._timeGeometry.getGridStep()));
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.timeGeometry.gridStepRange", (String)String.valueOf(this._timeGeometry.getGridStepRange()));
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.timeGeometry.min", (String)String.valueOf(this._timeGeometry.getMin()));
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.timeGeometry.max", (String)String.valueOf(this._timeGeometry.getMax()));
        }
        return sb.toString();
    }

    public int getBubbleHeight() {
        return this.bubbleHeight;
    }

    public void setBubbleHeight(int bubbleHeight) {
        if (this.bubbleHeight != bubbleHeight) {
            this.bubbleHeight = bubbleHeight;
            this.smartUpdate("z.bubbleHeight", this.bubbleHeight);
        }
    }

    public int getBubbleWidth() {
        return this.bubbleWidth;
    }

    public void setBubbleWidth(int bubbleWidth) {
        if (this.bubbleWidth != bubbleWidth) {
            this.bubbleWidth = bubbleWidth;
            this.smartUpdate("z.bubbleWidth", this.bubbleWidth);
        }
    }

    public PlotDataSource getPlotDataSource() {
        return this.pds;
    }

    public void setPlotDataSource(PlotDataSource pds) {
        if (!Objects.equals((Object)this.pds, (Object)pds)) {
            this.pds = pds;
            this.smartUpdate("z.separator", this.pds.getSeparator());
            this.smartUpdate("z.dataSourceColumn", this.pds.getDataSourceColumn());
            this.smartUpdate("z.dataSourceUri", this.pds.getDataSourceUri());
        }
    }

    public String getDotColor() {
        return this.dotColor;
    }

    public void setDotColor(String dotColor) {
        if (!Objects.equals((Object)this.dotColor, (Object)dotColor)) {
            this.dotColor = dotColor;
            this.smartUpdate("z.dotColor", this.dotColor);
        }
    }

    public float getDotRadius() {
        return this.dotRadius;
    }

    public void setDotRadius(float dotRadius) {
        if (this.dotRadius != dotRadius) {
            this.dotRadius = dotRadius;
            this.smartUpdate("z.dotRadius", String.valueOf(this.dotRadius));
        }
    }

    public float getEventLineWidth() {
        return this.eventLineWidth;
    }

    public void setEventLineWidth(float eventLineWidth) {
        if (this.eventLineWidth != eventLineWidth) {
            this.eventLineWidth = eventLineWidth;
            this.smartUpdate("z.eventLineWidth", String.valueOf(this.eventLineWidth));
        }
    }

    public String getEventSourceUri() {
        return this.eventSourceUri;
    }

    public void setEventSourceUri(String eventSourceUri) {
        if (!Objects.equals((Object)this.eventSourceUri, (Object)eventSourceUri)) {
            this.eventSourceUri = eventSourceUri;
            this.smartUpdate("z.eventSourceUri", this.eventSourceUri);
        }
    }

    public void repaint() {
        this.smartUpdate("z.repaint", true);
    }

    public String getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(String fillColor) {
        if (!Objects.equals((Object)this.fillColor, (Object)fillColor)) {
            this.fillColor = fillColor;
            this.smartUpdate("z.fillColor", this.fillColor);
        }
    }

    public String getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(String lineColor) {
        if (!Objects.equals((Object)this.lineColor, (Object)lineColor)) {
            this.lineColor = lineColor;
            this.smartUpdate("z.lineColor", this.lineColor);
        }
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float lineWidth) {
        if (this.lineWidth != lineWidth) {
            this.lineWidth = lineWidth;
            this.smartUpdate("z.lineWidth", String.valueOf(this.lineWidth));
        }
    }

    public boolean isRoundValues() {
        return this.roundValues;
    }

    public void setRoundValues(boolean roundValues) {
        if (this.roundValues != roundValues) {
            this.roundValues = roundValues;
            this.smartUpdate("z.roundValues", this.roundValues);
        }
    }

    public boolean isShowValues() {
        return this.showValues;
    }

    public void setShowValues(boolean showValues) {
        if (this.showValues != showValues) {
            this.showValues = showValues;
            this.smartUpdate("z.showValues", this.showValues);
        }
    }

    public int getValuesOpacity() {
        return this.valuesOpacity;
    }

    public void setValuesOpacity(int valuesOpacity) {
        if (this.valuesOpacity != valuesOpacity) {
            this.valuesOpacity = valuesOpacity;
            this.smartUpdate("z.valuesOpacity", this.valuesOpacity);
        }
    }

    public void addPlotEvent(OccurEvent oe) {
        this.response("addPlotEvent" + oe.getId(), (AuResponse)new AuScript((Component)this, "zkPlotinfo.addPlotEvent(\"" + this.getUuid() + "\"" + "," + oe.toString() + ")"));
    }

    public void modifyPlotEvent(OccurEvent oe) {
        this.response("modifyPlotEvent" + oe.getId(), (AuResponse)new AuScript((Component)this, "zkPlotinfo.modifyPlotEvent(\"" + this.getUuid() + "\"" + "," + oe.toString() + ")"));
    }

    public void removePlotEvent(OccurEvent oe) {
        this.response("removePlotEvent" + oe.getId(), (AuResponse)new AuScript((Component)this, "zkPlotinfo.removePlotEvent(\"" + this.getUuid() + "\"" + "," + oe.toString() + ")"));
    }

    public void addPlotData(PlotData pd) {
        this.response("addPlotData" + pd.getId(), (AuResponse)new AuScript((Component)this, "zkPlotinfo.addPlotData(\"" + this.getUuid() + "\"" + "," + pd.toString() + ")"));
    }

    public void modifyPlotData(PlotData pd) {
        this.response("modifyPlotData" + pd.getId(), (AuResponse)new AuScript((Component)this, "zkPlotinfo.modifyPlotData(\"" + this.getUuid() + "\"" + "," + pd.toString() + ")"));
    }

    public void removePlotData(PlotData pd) {
        this.response("removePlotData" + pd.getId(), (AuResponse)new AuScript((Component)this, "zkPlotinfo.removePlotData(\"" + this.getUuid() + "\"" + "," + pd.toString() + ")"));
    }

    public ListModel getDataModel() {
        return this._dataModel;
    }

    public void setDataModel(ListModel dataModel) {
        if (dataModel == null) {
            return;
        }
        if (this._dataModel != null) {
            this._dataModel.removeListDataListener(this._dataListener);
        }
        this._dataModel = dataModel;
        if (this._dataModel != null) {
            this._dataListener = new ListDataListener(){

                public void onChange(ListDataEvent event) {
                    Plotinfo.this.onListDataChange(event);
                }
            };
            this._dataModel.addListDataListener(this._dataListener);
        }
    }

    protected void onListDataChange(ListDataEvent event) {
        int lower = event.getIndex0();
        int upper = event.getIndex1();
        switch (event.getType()) {
            case 1: {
                for (int i = lower; i <= upper; ++i) {
                    PlotData pd = (PlotData)this._dataModel.getElementAt(i);
                    this.addPlotData(pd);
                    this._dataList.add(pd);
                }
                break;
            }
            case 2: {
                for (int i = upper; i >= lower; --i) {
                    PlotData pd = (PlotData)this._dataList.get(i);
                    this._dataList.remove(i);
                    this.removePlotData(pd);
                }
                break;
            }
            case 0: {
                for (int i = lower; i <= upper; ++i) {
                    PlotData pd = (PlotData)this._dataModel.getElementAt(i);
                    this._dataList.set(i, pd);
                    this.modifyPlotData(pd);
                }
                break;
            }
        }
    }

    public ListModel getEventModel() {
        return this._eventModel;
    }

    public void setEventModel(ListModel eventModel) {
        if (eventModel == null) {
            return;
        }
        if (this._eventModel != null) {
            this._eventModel.removeListDataListener(this._eventListener);
        }
        this._eventModel = eventModel;
        if (this._eventModel != null) {
            this._eventListener = new ListDataListener(){

                public void onChange(ListDataEvent event) {
                    Plotinfo.this.onListEventChange(event);
                }
            };
            this._eventModel.addListDataListener(this._eventListener);
        }
    }

    protected void onListEventChange(ListDataEvent event) {
        int lower = event.getIndex0();
        int upper = event.getIndex1();
        switch (event.getType()) {
            case 1: {
                for (int i = lower; i <= upper; ++i) {
                    OccurEvent oe = (OccurEvent)this._eventModel.getElementAt(i);
                    this.addPlotEvent(oe);
                    this._eventList.add(oe);
                }
                break;
            }
            case 2: {
                for (int i = upper; i >= lower; --i) {
                    OccurEvent oe = (OccurEvent)this._eventList.get(i);
                    this._eventList.remove(i);
                    this.removePlotEvent(oe);
                }
                break;
            }
            case 0: {
                for (int i = lower; i <= upper; ++i) {
                    OccurEvent oe = (OccurEvent)this._eventModel.getElementAt(i);
                    this._eventList.set(i, oe);
                    this.modifyPlotEvent(oe);
                }
                break;
            }
        }
    }

    public TimeGeometry getTimeGeometry() {
        return this._timeGeometry;
    }

    public void setTimeGeometry(TimeGeometry timeGeometry) {
        if (!Objects.equals((Object)this._timeGeometry, (Object)timeGeometry)) {
            this._timeGeometry = timeGeometry;
        }
    }

    public ValueGeometry getValueGeometry() {
        return this._valueGeometry;
    }

    public void setValueGeometry(ValueGeometry valueGeometry) {
        if (!Objects.equals((Object)this._valueGeometry, (Object)valueGeometry)) {
            this._valueGeometry = valueGeometry;
        }
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        if (!Objects.equals((Object)this.operator, (Object)operator)) {
            this.operator = operator;
            this.invalidate();
        }
    }

    public void invalidate() {
        super.invalidate();
        if (this.getParent() != null) {
            this.getParent().invalidate();
        }
    }

    public void setParent(Component parent) {
        if (parent != null && !(parent instanceof Timeplot)) {
            throw new UiException("Unsupported parent for plotinfo: " + parent);
        }
        super.setParent(parent);
    }
}

