/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MDocType;
import org.compiere.model.MFactAcct;
import org.compiere.model.MPeriod;
import org.compiere.model.MRule;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.Scriptlet;
import org.compiere.print.ReportEngine;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.eevolution.model.I_HR_Concept;
import org.eevolution.model.I_PP_Cost_Collector;
import org.eevolution.model.MHRAttribute;
import org.eevolution.model.MHRConcept;
import org.eevolution.model.MHRConceptCategory;
import org.eevolution.model.MHREmployee;
import org.eevolution.model.MHRMovement;
import org.eevolution.model.MHRPayroll;
import org.eevolution.model.MHRPayrollConcept;
import org.eevolution.model.MHRPeriod;
import org.eevolution.model.MPPCostCollector;
import org.eevolution.model.X_HR_Process;

public class MHRProcess
extends X_HR_Process
implements DocAction {
    private static final long serialVersionUID = -6884341170854709471L;
    public int m_C_BPartner_ID = 0;
    public int m_AD_User_ID = 0;
    public int m_HR_Concept_ID = 0;
    public String m_columnType = "";
    public Timestamp m_dateFrom;
    public Timestamp m_dateTo;
    public Hashtable<Integer, MHRMovement> m_movement = new Hashtable();
    public MHRPayrollConcept[] linesConcept;
    private MHREmployee m_employee;
    HashMap<String, Object> m_scriptCtx = new HashMap();
    private List<MHRConcept> activeConceptRule = new ArrayList<MHRConcept>();
    private static CLogger s_log = CLogger.getCLogger(MHRProcess.class);
    public static final String CONCEPT_PP_COST_COLLECTOR_LABOR = "PP_COST_COLLECTOR_LABOR";
    Object m_description = null;
    private static StringBuffer s_scriptImport = new StringBuffer(" import org.eevolution.model.*; import org.compiere.model.*; import org.adempiere.model.*; import org.compiere.util.*; import java.math.*; import java.sql.*;");
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public static void addScriptImportPackage(String packageName) {
        s_scriptImport.append(" import ").append(packageName).append(";");
    }

    public MHRProcess(Properties ctx, int HR_Process_ID, String trxName) {
        super(ctx, HR_Process_ID, trxName);
        if (HR_Process_ID == 0) {
            this.setDocStatus("DR");
            this.setDocAction("PR");
            this.setC_DocType_ID(0);
            this.set_ValueNoCheck("DocumentNo", null);
            this.setProcessed(false);
            this.setProcessing(false);
            this.setPosted(false);
            this.setHR_Department_ID(0);
            this.setC_BPartner_ID(0);
        }
    }

    public MHRProcess(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public final void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() <= 0) {
            return;
        }
        String sql = "UPDATE HR_Process SET Processed=? WHERE HR_Process_ID=?";
        DB.executeUpdateEx((String)"UPDATE HR_Process SET Processed=? WHERE HR_Process_ID=?", (Object[])new Object[]{processed, this.get_ID()}, (String)this.get_TrxName());
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getAD_Client_ID() == 0) {
            throw new AdempiereException("@AD_Client_ID@ = 0");
        }
        if (this.getAD_Org_ID() == 0) {
            int context_AD_Org_ID = this.getAD_Org_ID();
            if (context_AD_Org_ID == 0) {
                throw new AdempiereException("@AD_Org_ID@ = *");
            }
            this.setAD_Org_ID(context_AD_Org_ID);
            this.log.warning("Changed Org to Context=" + context_AD_Org_ID);
        }
        this.setC_DocType_ID(this.getC_DocTypeTarget_ID());
        return true;
    }

    public boolean processIt(String processAction) {
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        this.setProcessing(false);
        return true;
    }

    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    public String prepareIt() {
        this.log.info("prepareIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MHRPeriod period = MHRPeriod.get(this.getCtx(), this.getHR_Period_ID());
        MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)(this.getHR_Period_ID() > 0 ? period.getDateAcct() : this.getDateAcct()), (int)this.getC_DocTypeTarget_ID(), (int)this.getAD_Org_ID());
        if ("DR".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || this.getC_DocType_ID() == 0) {
            this.setC_DocType_ID(this.getC_DocTypeTarget_ID());
        }
        try {
            this.createMovements();
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 9);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    public boolean approveIt() {
        return true;
    }

    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        return true;
    }

    public boolean postIt() {
        this.log.info("postIt - " + this.toString());
        return false;
    }

    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public boolean closeIt() {
        if (this.isProcessed()) {
            this.log.info(this.toString());
            this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 3);
            if (this.m_processMsg != null) {
                return false;
            }
            this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 11);
            if (this.m_processMsg != null) {
                return false;
            }
            this.setProcessed(true);
            this.setDocAction("--");
            return true;
        }
        return false;
    }

    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        return this.voidIt();
    }

    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (String)"HRP", (int)this.getAD_Org_ID());
        String sql = "DELETE FROM HR_Movement WHERE HR_Process_ID =" + this.getHR_Process_ID() + " AND IsRegistered = 'N'";
        int no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        this.log.fine("HR_Process deleted #" + no);
        no = MFactAcct.deleteEx((int)Table_ID, (int)this.getHR_Process_ID(), (String)this.get_TrxName());
        this.log.fine("Fact_Acct deleted #" + no);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        return true;
    }

    public int getDoc_User_ID() {
        return 0;
    }

    public BigDecimal getApprovalAmt() {
        return BigDecimal.ZERO;
    }

    public int getC_Currency_ID() {
        return 0;
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public String getSummary() {
        return "";
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(String.valueOf(this.get_TableName()) + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        ReportEngine re = ReportEngine.get((Properties)this.getCtx(), (int)0, (int)0);
        if (re == null) {
            return null;
        }
        return re.getPDF(file);
    }

    public String getDocumentInfo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        return String.valueOf(dt.getName()) + " " + this.getDocumentNo();
    }

    public MHRMovement[] getLines(boolean requery) {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("HR_Process_ID=?");
        params.add(this.getHR_Process_ID());
        whereClause.append("AND (Qty <> 0 OR Amount <> 0)");
        whereClause.append(" AND EXISTS(SELECT 1 FROM HR_Concept c WHERE c.HR_Concept_ID=HR_Movement.HR_Concept_ID AND c.IsActive=? AND c.AccountSign<>?)");
        params.add(true);
        params.add("N");
        whereClause.append(" AND EXISTS(SELECT 1 FROM HR_Concept_Acct ca WHERE ca.HR_Concept_ID=HR_Movement.HR_Concept_ID AND ca.IsActive=? AND ca.IsBalancing<>?)");
        params.add(true);
        params.add(true);
        whereClause.append(" AND C_BPartner_ID IS NOT NULL");
        StringBuffer orderByClause = new StringBuffer();
        orderByClause.append("(SELECT bp.C_BP_Group_ID FROM C_BPartner bp WHERE bp.C_BPartner_ID=HR_Movement.C_BPartner_ID)");
        List list = new Query(this.getCtx(), "HR_Movement", whereClause.toString(), this.get_TrxName()).setParameters(params).setOrderBy(orderByClause.toString()).list();
        return list.toArray(new MHRMovement[list.size()]);
    }

    private void loadMovements(Hashtable<Integer, MHRMovement> movements, int C_PBartner_ID) {
        String whereClause = "HR_Process_ID=? AND C_BPartner_ID=?";
        List list = new Query(this.getCtx(), "HR_Movement", "HR_Process_ID=? AND C_BPartner_ID=?", this.get_TrxName()).setParameters(new Object[]{this.getHR_Process_ID(), C_PBartner_ID}).list();
        for (MHRMovement mvm : list) {
            if (movements.containsKey(mvm.getHR_Concept_ID())) {
                MHRMovement lastM = movements.get(mvm.getHR_Concept_ID());
                String columntype = lastM.getColumnType();
                if (columntype.equals("A")) {
                    mvm.addAmount(lastM.getAmount());
                } else if (columntype.equals("Q")) {
                    mvm.addQty(lastM.getQty());
                }
            }
            movements.put(mvm.getHR_Concept_ID(), mvm);
        }
    }

    private Object executeScript(int AD_Rule_ID, String columnType) {
        MRule rulee = MRule.get((Properties)this.getCtx(), (int)AD_Rule_ID);
        Object result = null;
        this.m_description = null;
        try {
            String text = "";
            if (rulee.getScript() != null) {
                text = rulee.getScript().trim().replaceAll("\\bget", "process.get").replace(".process.get", ".get");
            }
            String resultType = "double";
            if ("D".equals(columnType)) {
                resultType = "Timestamp";
            } else if ("T".equals(columnType)) {
                resultType = "String";
            }
            String script = String.valueOf(s_scriptImport.toString()) + " " + resultType + " result = 0;" + " String description = null;" + text;
            Scriptlet engine = new Scriptlet("result", script, this.m_scriptCtx);
            Exception ex = engine.execute();
            if (ex != null) {
                throw ex;
            }
            result = engine.getResult(false);
            this.m_description = engine.getDescription();
        }
        catch (Exception e) {
            throw new AdempiereException("Execution error - @AD_Rule_ID@=" + rulee.getValue());
        }
        return result;
    }

    private void createCostCollectorMovements(int C_BPartner_ID, MHRPeriod period) {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("EXISTS (SELECT 1 FROM AD_User u WHERE u.AD_User_ID=PP_Cost_Collector.AD_User_ID AND u.C_BPartner_ID=?)");
        params.add(C_BPartner_ID);
        whereClause.append(" AND MovementDate>=?");
        params.add(period.getStartDate());
        whereClause.append(" AND MovementDate<=?");
        params.add(period.getEndDate());
        whereClause.append(" AND DocStatus IN (?,?)");
        params.add("CO");
        params.add("CL");
        List listColector = new Query(this.getCtx(), "PP_Cost_Collector", whereClause.toString(), this.get_TrxName()).setOnlyActiveRecords(true).setParameters(params).setOrderBy("PP_Cost_Collector_ID DESC").list();
        for (MPPCostCollector cc : listColector) {
            this.createMovementForCC(C_BPartner_ID, (I_PP_Cost_Collector)cc);
        }
    }

    private MHRMovement createMovementForCC(int C_BPartner_ID, I_PP_Cost_Collector cc) {
        MHRConcept concept = MHRConcept.forValue(this.getCtx(), CONCEPT_PP_COST_COLLECTOR_LABOR);
        ArrayList<Comparable<Date>> params = new ArrayList<Comparable<Date>>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("? >= ValidFrom AND ( ? <= ValidTo OR ValidTo IS NULL)");
        params.add(this.m_dateFrom);
        params.add(this.m_dateTo);
        whereClause.append(" AND HR_Concept_ID = ? ");
        params.add(Integer.valueOf(concept.get_ID()));
        whereClause.append(" AND EXISTS (SELECT 1 FROM HR_Concept conc WHERE conc.HR_Concept_ID = HR_Attribute.HR_Concept_ID )");
        MHRAttribute att = (MHRAttribute)new Query(this.getCtx(), "HR_Attribute", whereClause.toString(), this.get_TrxName()).setParameters(params).setOnlyActiveRecords(true).setOrderBy("ValidFrom DESC").first();
        if (att == null) {
            throw new AdempiereException();
        }
        if ("E".equals(concept.getType())) {
            Object result = null;
            this.m_scriptCtx.put("_CostCollector", cc);
            try {
                result = this.executeScript(att.getAD_Rule_ID(), att.getColumnType());
            }
            finally {
                this.m_scriptCtx.remove("_CostCollector");
            }
            if (result == null) {
                this.log.warning("Variable (result) is null");
            }
            MHREmployee employee = MHREmployee.getActiveEmployee(this.getCtx(), C_BPartner_ID, this.get_TrxName());
            MHRMovement mv = new MHRMovement(this, (I_HR_Concept)concept);
            mv.setC_BPartner_ID(C_BPartner_ID);
            mv.setAD_Rule_ID(att.getAD_Rule_ID());
            mv.setHR_Job_ID(employee.getHR_Job_ID());
            mv.setHR_Department_ID(employee.getHR_Department_ID());
            mv.setC_Activity_ID(employee.getC_Activity_ID());
            mv.setValidFrom(this.m_dateFrom);
            mv.setValidTo(this.m_dateTo);
            mv.setPP_Cost_Collector_ID(cc.getPP_Cost_Collector_ID());
            mv.setIsRegistered(true);
            mv.setColumnValue(result);
            mv.setProcessed(true);
            mv.saveEx();
            return mv;
        }
        throw new AdempiereException();
    }

    private void createMovements() throws Exception {
        this.m_scriptCtx.clear();
        this.m_scriptCtx.put("process", (Object)this);
        this.m_scriptCtx.put("_Process", this.getHR_Process_ID());
        this.m_scriptCtx.put("_Period", this.getHR_Period_ID());
        this.m_scriptCtx.put("_Payroll", this.getHR_Payroll_ID());
        this.m_scriptCtx.put("_Department", this.getHR_Department_ID());
        this.log.info("info data -  Process: " + this.getHR_Process_ID() + ", Period: " + this.getHR_Period_ID() + ", Payroll: " + this.getHR_Payroll_ID() + ", Department: " + this.getHR_Department_ID());
        MHRPeriod period = new MHRPeriod(this.getCtx(), this.getHR_Period_ID(), this.get_TrxName());
        this.m_dateFrom = period.getStartDate();
        this.m_dateTo = period.getEndDate();
        this.m_scriptCtx.put("_From", period.getStartDate());
        this.m_scriptCtx.put("_To", period.getEndDate());
        int no = DB.executeUpdateEx((String)"DELETE FROM HR_Movement m WHERE HR_Process_ID=? AND IsRegistered<>?", (Object[])new Object[]{this.getHR_Process_ID(), true}, (String)this.get_TrxName());
        this.log.info("HR_Movement deleted #" + no);
        this.linesConcept = MHRPayrollConcept.getPayrollConcepts(this);
        MBPartner[] linesEmployee = MHREmployee.getEmployees(this);
        int count = 1;
        MBPartner[] mBPartnerArray = linesEmployee;
        int n = linesEmployee.length;
        int n2 = 0;
        while (n2 < n) {
            MBPartner bp = mBPartnerArray[n2];
            this.log.info("Employee " + count + "  ---------------------- " + bp.getName());
            ++count;
            this.m_C_BPartner_ID = bp.get_ID();
            this.m_employee = MHREmployee.getActiveEmployee(this.getCtx(), this.m_C_BPartner_ID, this.get_TrxName());
            this.m_scriptCtx.remove("_DateStart");
            this.m_scriptCtx.remove("_DateEnd");
            this.m_scriptCtx.remove("_Days");
            this.m_scriptCtx.remove("_C_BPartner_ID");
            this.m_scriptCtx.put("_DateStart", this.m_employee.getStartDate());
            this.m_scriptCtx.put("_DateEnd", this.m_employee.getEndDate() == null ? TimeUtil.getDay((int)2999, (int)12, (int)31) : this.m_employee.getEndDate());
            this.m_scriptCtx.put("_Days", TimeUtil.getDaysBetween((Timestamp)period.getStartDate(), (Timestamp)period.getEndDate()) + 1);
            this.m_scriptCtx.put("_C_BPartner_ID", bp.getC_BPartner_ID());
            this.createCostCollectorMovements(bp.get_ID(), period);
            this.m_movement.clear();
            this.loadMovements(this.m_movement, this.m_C_BPartner_ID);
            MHRPayrollConcept[] mHRPayrollConceptArray = this.linesConcept;
            int n3 = this.linesConcept.length;
            int n4 = 0;
            while (n4 < n3) {
                MHRPayrollConcept pc = mHRPayrollConceptArray[n4];
                this.m_HR_Concept_ID = pc.getHR_Concept_ID();
                MHRConcept concept = MHRConcept.get(this.getCtx(), this.m_HR_Concept_ID);
                boolean printed = pc.isPrinted() || concept.isPrinted();
                MHRMovement movement = this.m_movement.get(concept.get_ID());
                if (movement == null) {
                    movement = this.createMovementFromConcept(concept, printed);
                    movement = this.m_movement.get(concept.get_ID());
                }
                if (movement == null) {
                    throw new AdempiereException("Concept " + concept.getValue() + " not created");
                }
                ++n4;
            }
            for (MHRMovement m : this.m_movement.values()) {
                boolean saveThisRecord;
                MHRConcept c = (MHRConcept)m.getHR_Concept();
                if (c.isRegistered() || m.isEmpty()) {
                    this.log.fine("Skip saving " + (Object)((Object)m));
                    continue;
                }
                boolean bl = saveThisRecord = m.isPrinted() || c.isPaid() || c.isPrinted();
                if (!saveThisRecord) continue;
                m.saveEx();
            }
            ++n2;
        }
        period.setProcessed(true);
        period.saveEx();
    }

    private MHRMovement createMovementFromConcept(MHRConcept concept, boolean printed) {
        MHRAttribute att;
        this.log.info("Calculating concept " + concept.getValue());
        this.m_columnType = concept.getColumnType();
        ArrayList<Comparable<Date>> params = new ArrayList<Comparable<Date>>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("? >= ValidFrom AND ( ? <= ValidTo OR ValidTo IS NULL)");
        params.add(this.m_dateFrom);
        params.add(this.m_dateTo);
        whereClause.append(" AND HR_Concept_ID = ? ");
        params.add(Integer.valueOf(concept.getHR_Concept_ID()));
        whereClause.append(" AND EXISTS (SELECT 1 FROM HR_Concept conc WHERE conc.HR_Concept_ID = HR_Attribute.HR_Concept_ID )");
        if (concept.isEmployee()) {
            whereClause.append(" AND C_BPartner_ID = ? AND (HR_Employee_ID = ? OR HR_Employee_ID IS NULL)");
            params.add(Integer.valueOf(this.m_employee.getC_BPartner_ID()));
            params.add(Integer.valueOf(this.m_employee.get_ID()));
        }
        if ((att = (MHRAttribute)new Query(this.getCtx(), "HR_Attribute", whereClause.toString(), this.get_TrxName()).setParameters(params).setOnlyActiveRecords(true).setOrderBy("ValidFrom DESC").first()) == null || concept.isRegistered()) {
            this.log.info("Skip concept " + (Object)((Object)concept) + " - attribute not found");
            MHRMovement dummymov = new MHRMovement(this.getCtx(), 0, this.get_TrxName());
            dummymov.setIsRegistered(true);
            this.m_movement.put(concept.getHR_Concept_ID(), dummymov);
            return dummymov;
        }
        this.log.info("Concept - " + concept.getName());
        MHRMovement movement = new MHRMovement(this.getCtx(), 0, this.get_TrxName());
        movement.setC_BPartner_ID(this.m_C_BPartner_ID);
        movement.setHR_Concept_ID(concept.getHR_Concept_ID());
        movement.setHR_Concept_Category_ID(concept.getHR_Concept_Category_ID());
        movement.setHR_Process_ID(this.getHR_Process_ID());
        movement.setHR_Department_ID(this.m_employee.getHR_Department_ID());
        movement.setHR_Job_ID(this.m_employee.getHR_Job_ID());
        movement.setColumnType(this.m_columnType);
        movement.setAD_Rule_ID(att.getAD_Rule_ID());
        movement.setValidFrom(this.m_dateFrom);
        movement.setValidTo(this.m_dateTo);
        movement.setIsPrinted(printed);
        movement.setIsRegistered(concept.isRegistered());
        movement.setC_Activity_ID(this.m_employee.getC_Activity_ID());
        if ("E".equals(concept.getType())) {
            this.log.info("Executing rule for concept " + concept.getValue());
            if (this.activeConceptRule.contains((Object)concept)) {
                throw new AdempiereException("Recursion loop detected in concept " + concept.getValue());
            }
            this.activeConceptRule.add(concept);
            Object result = this.executeScript(att.getAD_Rule_ID(), att.getColumnType());
            this.activeConceptRule.remove((Object)concept);
            if (result == null) {
                this.log.warning("Variable (result) is null");
                return movement;
            }
            movement.setColumnValue(result);
            if (this.m_description != null) {
                movement.setDescription(this.m_description.toString());
            }
        } else {
            movement.setQty(att.getQty());
            movement.setAmount(att.getAmount());
            movement.setTextMsg(att.getTextMsg());
            movement.setServiceDate(att.getServiceDate());
        }
        movement.setProcessed(true);
        this.m_movement.put(concept.getHR_Concept_ID(), movement);
        return movement;
    }

    public double getConcept(String pconcept) {
        MHRConcept concept = MHRConcept.forValue(this.getCtx(), pconcept.trim());
        if (concept == null) {
            return 0.0;
        }
        MHRMovement m = this.m_movement.get(concept.get_ID());
        if (m == null) {
            this.createMovementFromConcept(concept, concept.isPrinted());
            m = this.m_movement.get(concept.get_ID());
        }
        if (m == null) {
            throw new AdempiereException("Concept " + concept.getValue() + " not created");
        }
        String type = m.getColumnType();
        if ("A".equals(type)) {
            return m.getAmount().doubleValue();
        }
        if ("Q".equals(type)) {
            return m.getQty().doubleValue();
        }
        return 0.0;
    }

    public String getConceptString(String pconcept) {
        String type;
        MHRConcept concept = MHRConcept.forValue(this.getCtx(), pconcept.trim());
        if (concept == null) {
            return null;
        }
        MHRMovement m = this.m_movement.get(concept.get_ID());
        if (m == null) {
            this.createMovementFromConcept(concept, concept.isPrinted());
            m = this.m_movement.get(concept.get_ID());
        }
        if ("T".equals(type = m.getColumnType())) {
            return m.getTextMsg();
        }
        return null;
    }

    public Timestamp getConceptDate(String pconcept) {
        String type;
        MHRConcept concept = MHRConcept.forValue(this.getCtx(), pconcept.trim());
        if (concept == null) {
            return null;
        }
        MHRMovement m = this.m_movement.get(concept.get_ID());
        if (m == null) {
            this.createMovementFromConcept(concept, concept.isPrinted());
            m = this.m_movement.get(concept.get_ID());
        }
        if ("T".equals(type = m.getColumnType())) {
            return m.getServiceDate();
        }
        return null;
    }

    public void setConcept(String conceptValue, double value) {
        try {
            MHRConcept c = MHRConcept.forValue(this.getCtx(), conceptValue);
            if (c == null) {
                return;
            }
            MHRMovement m = new MHRMovement(this.getCtx(), 0, this.get_TrxName());
            MHREmployee employee = MHREmployee.getActiveEmployee(this.getCtx(), this.m_C_BPartner_ID, this.get_TrxName());
            m.setColumnType(c.getColumnType());
            m.setColumnValue(BigDecimal.valueOf(value));
            m.setHR_Process_ID(this.getHR_Process_ID());
            m.setHR_Concept_ID(this.m_HR_Concept_ID);
            m.setC_BPartner_ID(this.m_C_BPartner_ID);
            m.setDescription("Added From Rule");
            m.setValidFrom(this.m_dateTo);
            m.setValidTo(this.m_dateTo);
            m.setHR_Concept_Category_ID(c.getHR_Concept_Category_ID());
            m.setHR_Department_ID(employee.getHR_Department_ID());
            m.setHR_Job_ID(employee.getHR_Job_ID());
            m.setIsRegistered(c.isRegistered());
            m.setC_Activity_ID(employee.getC_Activity_ID());
            m.saveEx();
        }
        catch (Exception e) {
            s_log.warning(e.getMessage());
        }
    }

    public void setConcept(String conceptValue, double value, boolean isRegistered) {
        try {
            MHRConcept c = MHRConcept.forValue(this.getCtx(), conceptValue);
            if (c == null) {
                return;
            }
            MHRMovement m = new MHRMovement(Env.getCtx(), 0, this.get_TrxName());
            MHREmployee employee = MHREmployee.getActiveEmployee(this.getCtx(), this.m_C_BPartner_ID, this.get_TrxName());
            m.setColumnType(c.getColumnType());
            if (c.getColumnType().equals("A")) {
                m.setAmount(BigDecimal.valueOf(value));
            } else if (c.getColumnType().equals("Q")) {
                m.setQty(BigDecimal.valueOf(value));
            } else {
                return;
            }
            m.setHR_Process_ID(this.getHR_Process_ID());
            m.setHR_Concept_ID(c.getHR_Concept_ID());
            m.setC_BPartner_ID(this.m_C_BPartner_ID);
            m.setDescription("Added From Rule");
            m.setValidFrom(this.m_dateTo);
            m.setValidTo(this.m_dateTo);
            m.setIsRegistered(isRegistered);
            m.setHR_Concept_Category_ID(c.getHR_Concept_Category_ID());
            m.setHR_Department_ID(employee.getHR_Department_ID());
            m.setHR_Job_ID(employee.getHR_Job_ID());
            m.setIsRegistered(c.isRegistered());
            m.setC_Activity_ID(employee.getC_Activity_ID());
            m.saveEx();
        }
        catch (Exception e) {
            s_log.warning(e.getMessage());
        }
    }

    public double getConceptGroup(String pconcept) {
        MHRConceptCategory category = MHRConceptCategory.forValue(this.getCtx(), pconcept);
        if (category == null) {
            return 0.0;
        }
        double value = 0.0;
        MHRPayrollConcept[] mHRPayrollConceptArray = this.linesConcept;
        int n = this.linesConcept.length;
        int n2 = 0;
        while (n2 < n) {
            MHRPayrollConcept pc = mHRPayrollConceptArray[n2];
            MHRConcept con = MHRConcept.get(this.getCtx(), pc.getHR_Concept_ID());
            if (con.getHR_Concept_Category_ID() == category.get_ID()) {
                MHRMovement movement = this.m_movement.get(pc.getHR_Concept_ID());
                if (movement == null) {
                    this.createMovementFromConcept(con, con.isPrinted());
                    movement = this.m_movement.get(con.get_ID());
                } else {
                    String columnType = movement.getColumnType();
                    if ("A".equals(columnType)) {
                        value += movement.getAmount().doubleValue();
                    } else if ("Q".equals(columnType)) {
                        value += movement.getQty().doubleValue();
                    }
                }
            }
            ++n2;
        }
        return value;
    }

    public double getList(String pList, double amount, String columnParam) {
        BigDecimal value = Env.ZERO;
        String column = columnParam;
        if (this.m_columnType.equals("A")) {
            column = column.toString().length() == 1 ? "Col_" + column : "Amount" + column;
            ArrayList<Object> params = new ArrayList<Object>();
            String sqlList = "SELECT " + column + " FROM HR_List l " + "INNER JOIN HR_ListVersion lv ON (lv.HR_List_ID=l.HR_List_ID) " + "INNER JOIN HR_ListLine ll ON (ll.HR_ListVersion_ID=lv.HR_ListVersion_ID) " + "WHERE l.IsActive='Y' AND lv.IsActive='Y' AND ll.IsActive='Y' AND l.Value = ? AND " + "l.AD_Client_ID = ? AND " + "(? BETWEEN lv.ValidFrom AND lv.ValidTo ) AND " + "(? BETWEEN ll.MinValue AND\tll.MaxValue)";
            params.add(pList);
            params.add(this.getAD_Client_ID());
            params.add(this.m_dateFrom);
            params.add(BigDecimal.valueOf(amount));
            value = DB.getSQLValueBDEx((String)this.get_TrxName(), (String)sqlList, params);
        }
        if (value == null) {
            throw new IllegalStateException("getList Out of Range");
        }
        return value.doubleValue();
    }

    public double getAttribute(String pConcept) {
        MHRAttribute attribute;
        MHRConcept concept = MHRConcept.forValue(this.getCtx(), pConcept);
        if (concept == null) {
            return 0.0;
        }
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("ValidFrom<=?");
        params.add(this.m_dateFrom);
        whereClause.append(" AND AD_Client_ID = ?");
        params.add(this.getAD_Client_ID());
        whereClause.append(" AND EXISTS (SELECT 1 FROM HR_Concept c WHERE c.HR_Concept_ID=HR_Attribute.HR_Concept_ID AND c.Value = ?)");
        params.add(pConcept);
        if (!concept.getType().equals("I")) {
            whereClause.append(" AND C_BPartner_ID = ?");
            params.add(this.m_C_BPartner_ID);
        }
        if ((attribute = (MHRAttribute)new Query(this.getCtx(), "HR_Attribute", whereClause.toString(), this.get_TrxName()).setParameters(params).setOrderBy("ValidFrom DESC").first()) == null) {
            return 0.0;
        }
        if (concept.getColumnType().equals("Q")) {
            return attribute.getQty().doubleValue();
        }
        if (concept.getColumnType().equals("A")) {
            return attribute.getAmount().doubleValue();
        }
        return 0.0;
    }

    public Timestamp getAttributeDate(String conceptValue) {
        MHRAttribute attribute;
        MHRConcept concept = MHRConcept.forValue(this.getCtx(), conceptValue);
        if (concept == null) {
            return null;
        }
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("AD_Client_ID = ?");
        params.add(this.getAD_Client_ID());
        whereClause.append(" AND EXISTS (SELECT 1 FROM HR_Concept c WHERE c.HR_Concept_ID=HR_Attribute.HR_Concept_ID AND c.Value = ?)");
        params.add(conceptValue);
        if (!concept.getType().equals("I")) {
            whereClause.append(" AND C_BPartner_ID = ?");
            params.add(this.m_C_BPartner_ID);
        }
        if ((attribute = (MHRAttribute)new Query(this.getCtx(), "HR_Attribute", whereClause.toString(), this.get_TrxName()).setParameters(params).setOrderBy("ValidFrom DESC").first()) == null) {
            return null;
        }
        return attribute.getServiceDate();
    }

    public String getAttributeString(String conceptValue) {
        MHRAttribute attribute;
        MHRConcept concept = MHRConcept.forValue(this.getCtx(), conceptValue);
        if (concept == null) {
            return null;
        }
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("AD_Client_ID = ?");
        params.add(this.getAD_Client_ID());
        whereClause.append(" AND EXISTS (SELECT 1 FROM HR_Concept c WHERE c.HR_Concept_ID=HR_Attribute.HR_Concept_ID AND c.Value = ?)");
        params.add(conceptValue);
        if (!concept.getType().equals("I")) {
            whereClause.append(" AND C_BPartner_ID = ?");
            params.add(this.m_C_BPartner_ID);
        }
        if ((attribute = (MHRAttribute)new Query(this.getCtx(), "HR_Attribute", whereClause.toString(), this.get_TrxName()).setParameters(params).setOrderBy("ValidFrom DESC").first()) == null) {
            return null;
        }
        return attribute.getTextMsg();
    }

    public int getDays(Timestamp date1, Timestamp date2) {
        return TimeUtil.getDaysBetween((Timestamp)date1, (Timestamp)date2) + 1;
    }

    public int getDays(String date1, String date2) {
        Timestamp dat1 = Timestamp.valueOf(date1);
        Timestamp dat2 = Timestamp.valueOf(date2);
        return this.getDays(dat1, dat2);
    }

    public int getMonths(Timestamp startParam, Timestamp endParam) {
        boolean negative = false;
        Timestamp end = endParam;
        Timestamp start = startParam;
        if (end.before(start)) {
            negative = true;
            Timestamp temp = start;
            start = end;
            end = temp;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(start);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        GregorianCalendar calEnd = new GregorianCalendar();
        calEnd.setTime(end);
        calEnd.set(11, 0);
        calEnd.set(12, 0);
        calEnd.set(13, 0);
        calEnd.set(14, 0);
        if (cal.get(1) == calEnd.get(1)) {
            if (negative) {
                return (calEnd.get(2) - cal.get(2)) * -1;
            }
            return calEnd.get(2) - cal.get(2);
        }
        int counter = 0;
        while (calEnd.after(cal)) {
            cal.add(2, 1);
            ++counter;
        }
        if (negative) {
            return counter * -1;
        }
        return counter;
    }

    public double getConcept(String conceptValue, int periodFrom, int periodTo) {
        return this.getConcept(conceptValue, null, periodFrom, periodTo);
    }

    public double getConcept(String conceptValue, String payrollValue, int periodFrom, int periodTo) {
        String fieldName;
        int payroll_id = payrollValue == null ? this.getHR_Payroll_ID() : MHRPayroll.forValue(this.getCtx(), payrollValue).get_ID();
        MHRConcept concept = MHRConcept.forValue(this.getCtx(), conceptValue);
        if (concept == null) {
            return 0.0;
        }
        if ("Q".equals(concept.getColumnType())) {
            fieldName = "Qty";
        } else if ("A".equals(concept.getColumnType())) {
            fieldName = "Amount";
        } else {
            return 0.0;
        }
        MHRPeriod p = MHRPeriod.get(this.getCtx(), this.getHR_Period_ID());
        ArrayList<Integer> params = new ArrayList<Integer>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("AD_Client_ID = ?");
        params.add(this.getAD_Client_ID());
        whereClause.append(" AND HR_Concept_ID=?");
        params.add(concept.get_ID());
        whereClause.append(" AND C_BPartner_ID=?");
        params.add(this.m_C_BPartner_ID);
        whereClause.append(" AND EXISTS (SELECT 1 FROM HR_Process p INNER JOIN HR_Period pr ON (pr.HR_Period_id=p.HR_Period_ID) WHERE HR_Movement.HR_Process_ID = p.HR_Process_ID AND p.HR_Payroll_ID=?");
        params.add(payroll_id);
        if (periodFrom < 0) {
            whereClause.append(" AND pr.PeriodNo >= ?");
            params.add(p.getPeriodNo() + periodFrom);
        }
        if (periodTo > 0) {
            whereClause.append(" AND pr.PeriodNo <= ?");
            params.add(p.getPeriodNo() + periodTo);
        }
        whereClause.append(")");
        StringBuffer sql = new StringBuffer("SELECT COALESCE(SUM(").append(fieldName).append("),0) FROM ").append("HR_Movement").append(" WHERE ").append(whereClause);
        BigDecimal value = DB.getSQLValueBDEx((String)this.get_TrxName(), (String)sql.toString(), params);
        return value.doubleValue();
    }

    public double getConcept(String conceptValue, String payrollValue, Timestamp from, Timestamp to) {
        String fieldName;
        int payroll_id = payrollValue == null ? this.getHR_Payroll_ID() : MHRPayroll.forValue(this.getCtx(), payrollValue).get_ID();
        MHRConcept concept = MHRConcept.forValue(this.getCtx(), conceptValue);
        if (concept == null) {
            return 0.0;
        }
        if ("Q".equals(concept.getColumnType())) {
            fieldName = "Qty";
        } else if ("A".equals(concept.getColumnType())) {
            fieldName = "Amount";
        } else {
            return 0.0;
        }
        ArrayList<Comparable<Integer>> params = new ArrayList<Comparable<Integer>>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("AD_Client_ID = ?");
        params.add(Integer.valueOf(this.getAD_Client_ID()));
        whereClause.append(" AND HR_Concept_ID=?");
        params.add(Integer.valueOf(concept.get_ID()));
        whereClause.append(" AND C_BPartner_ID=?");
        params.add(Integer.valueOf(this.m_C_BPartner_ID));
        whereClause.append(" AND validTo BETWEEN ? AND ?");
        params.add(from);
        params.add(to);
        whereClause.append(" AND EXISTS (SELECT 1 FROM HR_Process p INNER JOIN HR_Period pr ON (pr.HR_Period_id=p.HR_Period_ID) WHERE HR_Movement.HR_Process_ID = p.HR_Process_ID AND p.HR_Payroll_ID=?");
        params.add(Integer.valueOf(payroll_id));
        whereClause.append(")");
        StringBuffer sql = new StringBuffer("SELECT COALESCE(SUM(").append(fieldName).append("),0) FROM ").append("HR_Movement").append(" WHERE ").append(whereClause);
        BigDecimal value = DB.getSQLValueBDEx((String)this.get_TrxName(), (String)sql.toString(), params);
        return value.doubleValue();
    }

    public double getAttribute(Properties ctx, String vAttribute, Timestamp dateFrom, Timestamp dateTo) {
        this.log.warning("not implemented yet -> getAttribute (Properties, String, Timestamp, Timestamp)");
        return 0.0;
    }

    public double getAttribute(Properties ctx, String vAttribute, int periodFrom, int periodTo, String pFrom, String pTo) {
        this.log.warning("not implemented yet -> getAttribute (Properties, String, int, int, String, String)");
        return 0.0;
    }

    public int getAttributeInvoice(String pConcept) {
        MHRAttribute attribute;
        MHRConcept concept = MHRConcept.forValue(this.getCtx(), pConcept);
        if (concept == null) {
            return 0;
        }
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("ValidFrom<=?");
        params.add(this.m_dateFrom);
        whereClause.append(" AND AD_Client_ID = ?");
        params.add(this.getAD_Client_ID());
        whereClause.append(" AND EXISTS (SELECT 1 FROM HR_Concept c WHERE c.HR_Concept_ID=HR_Attribute.HR_Concept_ID AND c.Value = ?)");
        params.add(pConcept);
        if (!"I".equals(concept.getType())) {
            whereClause.append(" AND C_BPartner_ID = ?");
            params.add(this.m_C_BPartner_ID);
        }
        if ((attribute = (MHRAttribute)new Query(this.getCtx(), "HR_Attribute", whereClause.toString(), this.get_TrxName()).setParameters(params).setOrderBy("ValidFrom DESC").first()) != null) {
            return (Integer)attribute.get_Value("C_Invoice_ID");
        }
        return 0;
    }

    public int getAttributeDocType(String pConcept) {
        MHRAttribute attribute;
        MHRConcept concept = MHRConcept.forValue(this.getCtx(), pConcept);
        if (concept == null) {
            return 0;
        }
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("ValidFrom<=?");
        params.add(this.m_dateFrom);
        whereClause.append(" AND AD_Client_ID = ?");
        params.add(this.getAD_Client_ID());
        whereClause.append(" AND EXISTS (SELECT 1 FROM HR_Concept c WHERE c.HR_Concept_ID=HR_Attribute.HR_Concept_ID AND c.Value = ?)");
        params.add(pConcept);
        if (!"I".equals(concept.getType())) {
            whereClause.append(" AND C_BPartner_ID = ?");
            params.add(this.m_C_BPartner_ID);
        }
        if ((attribute = (MHRAttribute)new Query(this.getCtx(), "HR_Attribute", whereClause.toString(), this.get_TrxName()).setParameters(params).setOrderBy("ValidFrom DESC").first()) != null) {
            return (Integer)attribute.get_Value("C_DocType_ID");
        }
        return 0;
    }

    public double getDays(int period) {
        this.log.warning("instead of using getDays in the formula it's recommended to use _DaysPeriod+1");
        return Env.getContextAsInt((Properties)this.getCtx(), (String)"_DaysPeriod") + 1;
    }
}

