/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MCalendar;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.eevolution.model.X_HR_Payroll;

public class MHRPayroll
extends X_HR_Payroll {
    private static final long serialVersionUID = -1407037967021019961L;
    private static CCache<Integer, MHRPayroll> s_cache = new CCache("HR_Payroll", 10);
    private static CCache<String, MHRPayroll> s_cacheValue = new CCache("HR_Payroll_Value", 10);

    public static MHRPayroll forValue(Properties ctx, String value) {
        if (Util.isEmpty((String)value, (boolean)true)) {
            return null;
        }
        int AD_Client_ID = Env.getAD_Client_ID((Properties)ctx);
        String key = String.valueOf(AD_Client_ID) + "#" + value;
        MHRPayroll payroll = (MHRPayroll)((Object)s_cacheValue.get((Object)key));
        if (payroll != null) {
            return payroll;
        }
        String whereClause = "Value=? AND AD_Client_ID IN (?,?)";
        payroll = (MHRPayroll)new Query(ctx, "HR_Payroll", "Value=? AND AD_Client_ID IN (?,?)", null).setParameters(new Object[]{value, 0, AD_Client_ID}).setOnlyActiveRecords(true).setOrderBy("AD_Client_ID DESC").first();
        if (payroll != null) {
            s_cacheValue.put((Object)key, (Object)payroll);
            s_cache.put((Object)payroll.get_ID(), (Object)payroll);
        }
        return payroll;
    }

    public static MHRPayroll get(Properties ctx, int HR_Payroll_ID) {
        if (HR_Payroll_ID <= 0) {
            return null;
        }
        MHRPayroll payroll = (MHRPayroll)((Object)s_cache.get((Object)HR_Payroll_ID));
        if (payroll != null) {
            return payroll;
        }
        payroll = new MHRPayroll(ctx, HR_Payroll_ID, null);
        if (payroll.get_ID() == HR_Payroll_ID) {
            s_cache.put((Object)HR_Payroll_ID, (Object)payroll);
        } else {
            payroll = null;
        }
        return payroll;
    }

    public MHRPayroll(Properties ctx, int HR_Payroll_ID, String trxName) {
        super(ctx, HR_Payroll_ID, trxName);
        if (HR_Payroll_ID == 0) {
            this.setProcessing(false);
        }
    }

    public MHRPayroll(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MHRPayroll(MCalendar calendar) {
        this(calendar.getCtx(), 0, calendar.get_TrxName());
        this.setClientOrg((PO)calendar);
    }
}

