/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MCurrency;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.eevolution.model.I_HR_Concept;
import org.eevolution.model.MHRConcept;
import org.eevolution.model.MHREmployee;
import org.eevolution.model.MHRProcess;
import org.eevolution.model.X_HR_Movement;
import org.eevolution.model.X_I_HR_Movement;

public class MHRMovement
extends X_HR_Movement {
    private static final long serialVersionUID = -9074136731316014532L;

    public MHRMovement(Properties ctx, int HR_Movement_ID, String trxName) {
        super(ctx, HR_Movement_ID, trxName);
    }

    public MHRMovement(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MHRMovement(X_I_HR_Movement impHRm) {
        this(impHRm.getCtx(), 0, impHRm.get_TrxName());
        MHRConcept hrconcept = new MHRConcept(this.getCtx(), impHRm.getHR_Concept_ID(), this.get_TrxName());
        MHREmployee employee = MHREmployee.getActiveEmployee(this.getCtx(), impHRm.getC_BPartner_ID(), this.get_TrxName());
        MHRProcess process = new MHRProcess(this.getCtx(), impHRm.getHR_Process_ID(), this.get_TrxName());
        this.setAD_Org_ID(process.getAD_Org_ID());
        this.setUpdatedBy(impHRm.getUpdatedBy());
        this.setHR_Process_ID(impHRm.getHR_Process_ID());
        this.setC_BPartner_ID(impHRm.getC_BPartner_ID());
        this.setHR_Concept_ID(impHRm.getHR_Concept_ID());
        this.setHR_Concept_Category_ID(hrconcept.getHR_Concept_Category_ID());
        this.setDescription(impHRm.getDescription());
        this.setHR_Job_ID(employee.getHR_Job_ID());
        this.setHR_Department_ID(employee.getHR_Department_ID());
        this.setC_Activity_ID(employee.getC_Activity_ID());
        this.setColumnType(hrconcept.getColumnType());
        this.setValidFrom(impHRm.getValidFrom());
        this.setIsRegistered(hrconcept.isRegistered());
        this.setIsPrinted(hrconcept.isPrinted());
        this.setAmount(null);
        this.setQty(null);
        this.setServiceDate(null);
        this.setTextMsg(null);
        if (hrconcept.getColumnType().equals("Q")) {
            this.setQty(impHRm.getQty());
        } else if (hrconcept.getColumnType().equals("A")) {
            this.setAmount(impHRm.getAmount());
        } else if (hrconcept.getColumnType().equals("D")) {
            this.setServiceDate(impHRm.getServiceDate());
        } else if (hrconcept.getColumnType().equals("T")) {
            this.setTextMsg(impHRm.getTextMsg());
        }
    }

    public MHRMovement(MHRProcess proc, I_HR_Concept concept) {
        this(proc.getCtx(), 0, proc.get_TrxName());
        this.setHR_Process_ID(proc.getHR_Process_ID());
        this.setHR_Concept_Category_ID(concept.getHR_Concept_Category_ID());
        this.setHR_Concept_ID(concept.getHR_Concept_ID());
        this.setColumnType(concept.getColumnType());
    }

    public void addAmount(BigDecimal amount) {
        this.setAmount(this.getAmount().add(amount == null ? Env.ZERO : amount));
    }

    public void addQty(BigDecimal qty) {
        this.setQty(this.getAmount().add(qty == null ? Env.ZERO : qty));
    }

    public boolean isEmpty() {
        return this.getQty().signum() == 0 && this.getAmount().signum() == 0 && Util.isEmpty((String)this.getTextMsg());
    }

    public void setColumnValue(Object value) {
        block8: {
            try {
                String columnType = this.getColumnType();
                if ("Q".equals(columnType)) {
                    BigDecimal qty = new BigDecimal(value.toString());
                    this.setQty(qty);
                    this.setAmount(Env.ZERO);
                    break block8;
                }
                if ("A".equals(columnType)) {
                    int precision = MCurrency.getStdPrecision((Properties)this.getCtx(), (int)Env.getContextAsInt((Properties)this.p_ctx, (String)"#C_Currency_ID"));
                    BigDecimal amount = new BigDecimal(value.toString()).setScale(precision, 4);
                    this.setAmount(amount);
                    this.setQty(Env.ZERO);
                    break block8;
                }
                if ("T".equals(columnType)) {
                    this.setTextMsg(value.toString().trim());
                    break block8;
                }
                if ("D".equals(columnType)) {
                    if (value instanceof Timestamp) {
                        this.setServiceDate((Timestamp)value);
                    } else {
                        this.setServiceDate(Timestamp.valueOf(String.valueOf(value.toString().trim().substring(0, 10)) + " 00:00:00.0"));
                    }
                    break block8;
                }
                throw new AdempiereException("@NotSupported@ @ColumnType@ - " + columnType);
            }
            catch (Exception e) {
                throw new AdempiereException("@Script Error@");
            }
        }
    }

    protected boolean beforeSave(boolean newRecord) {
        MHREmployee employee = MHREmployee.getActiveEmployee(Env.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
        if (employee != null) {
            this.setAD_Org_ID(employee.getAD_Org_ID());
        }
        this.setC_BP_Group_ID(this.getC_BPartner().getC_BP_Group_ID());
        int C_BP_BankAccount_ID = new Query(this.getCtx(), "C_BP_BankAccount", "C_BPartner_ID=?", this.get_TrxName()).setOnlyActiveRecords(true).setParameters(new Object[]{this.getC_BPartner_ID()}).setOrderBy("C_BP_BankAccount_ID DESC").firstId();
        if (C_BP_BankAccount_ID > 0) {
            this.setC_BP_BankAccount_ID(C_BP_BankAccount_ID);
        }
        this.setAccountSign(this.getHR_Concept().getAccountSign());
        return true;
    }
}

