/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.eevolution.model.X_HR_Concept;

public class MHRConcept
extends X_HR_Concept {
    private static final long serialVersionUID = 7859469065116713767L;
    private static CCache<Integer, MHRConcept> s_cache = new CCache("HR_Concept", 100);
    private static CCache<String, MHRConcept> s_cacheValue = new CCache("HR_Concept_Value", 100);

    public static MHRConcept get(Properties ctx, int HR_Concept_ID) {
        if (HR_Concept_ID <= 0) {
            return null;
        }
        MHRConcept concept = (MHRConcept)((Object)s_cache.get((Object)HR_Concept_ID));
        if (concept != null) {
            return concept;
        }
        concept = new MHRConcept(ctx, HR_Concept_ID, null);
        if (concept.get_ID() == HR_Concept_ID) {
            s_cache.put((Object)HR_Concept_ID, (Object)concept);
        } else {
            concept = null;
        }
        return concept;
    }

    public static MHRConcept forValue(Properties ctx, String value) {
        if (Util.isEmpty((String)value, (boolean)true)) {
            return null;
        }
        int AD_Client_ID = Env.getAD_Client_ID((Properties)ctx);
        String key = String.valueOf(AD_Client_ID) + "#" + value;
        MHRConcept concept = (MHRConcept)((Object)s_cacheValue.get((Object)key));
        if (concept != null) {
            return concept;
        }
        String whereClause = "Value=? AND AD_Client_ID IN (?,?)";
        concept = (MHRConcept)new Query(ctx, "HR_Concept", "Value=? AND AD_Client_ID IN (?,?)", null).setParameters(new Object[]{value, 0, AD_Client_ID}).setOnlyActiveRecords(true).setOrderBy("AD_Client_ID DESC").first();
        if (concept != null) {
            s_cacheValue.put((Object)key, (Object)concept);
            s_cache.put((Object)concept.get_ID(), (Object)concept);
        }
        return concept;
    }

    public static MHRConcept[] getConcepts(int payroll_id, int department_id, String sqlWhere) {
        Properties ctx = Env.getCtx();
        ArrayList<Integer> params = new ArrayList<Integer>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("AD_Client_ID in (?,?)");
        params.add(0);
        params.add(Env.getAD_Client_ID((Properties)Env.getCtx()));
        whereClause.append(" AND (HR_Payroll_ID =? OR HR_Payroll_ID IS NULL)");
        params.add(payroll_id);
        if (department_id != 0) {
            whereClause.append(" AND HR_Concept.HR_Department_ID=?");
            params.add(department_id);
        }
        if (!Util.isEmpty((String)sqlWhere)) {
            whereClause.append(sqlWhere);
        }
        List list = new Query(ctx, "HR_Concept", whereClause.toString(), null).setParameters(params).setOnlyActiveRecords(true).setOrderBy("COALESCE(SeqNo,999999999999) DESC, Value").list();
        return list.toArray(new MHRConcept[list.size()]);
    }

    public MHRConcept(Properties ctx, int HR_Concept_ID, String trxName) {
        super(ctx, HR_Concept_ID, trxName);
        if (HR_Concept_ID == 0) {
            this.setValue("");
            this.setName("");
            this.setDescription("");
            this.setIsEmployee(false);
            this.setIsPrinted(false);
            this.setHR_Payroll_ID(0);
            this.setHR_Job_ID(0);
            this.setHR_Department_ID(0);
        }
    }

    public MHRConcept(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public int getConceptAccountCR() {
        String sql = " HR_Expense_Acct FROM HR_Concept c  INNER JOIN HR_Concept_Acct ca ON (c.HR_Concept_ID=ca.HR_Concept_ID) WHERE c.HR_Concept_ID " + this.getHR_Concept_ID();
        int result = DB.getSQLValue((String)"ConceptCR", (String)sql);
        if (result > 0) {
            return result;
        }
        return 0;
    }

    public int getConceptAccountDR() {
        String sql = " HR_Revenue_Acct FROM HR_Concept c  INNER JOIN HR_Concept_Acct ca ON (c.HR_Concept_ID=ca.HR_Concept_ID) WHERE c.HR_Concept_ID " + this.getHR_Concept_ID();
        int result = DB.getSQLValue((String)"ConceptCR", (String)sql);
        if (result > 0) {
            return result;
        }
        return 0;
    }

    public String toString() {
        return this.getValue();
    }
}

