/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.deploy.shared;

import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchiveFactory;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.deploy.shared.InputJarArchive;
import com.sun.enterprise.deployment.deploy.shared.OutputJarArchive;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;

public class ArchiveFactory
implements AbstractArchiveFactory {
    public AbstractArchive createArchive(String path) throws IOException {
        try {
            return this.createArchive(ArchiveFactory.prepareArchiveURI(path));
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public AbstractArchive openArchive(String path) throws IOException {
        try {
            return this.openArchive(ArchiveFactory.prepareArchiveURI(path));
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public AbstractArchive createArchive(URI path) throws IOException {
        String protocol = path.getScheme();
        if (protocol.equals("file")) {
            FileArchive output = new FileArchive();
            output.create(path.getPath());
            return output;
        }
        if (protocol.equals("jar")) {
            OutputJarArchive ja = new OutputJarArchive();
            ja.create(path.getPath());
            return ja;
        }
        throw new MalformedURLException("Protocol not supported : " + protocol);
    }

    public AbstractArchive openArchive(URI path) throws IOException {
        String protocol = path.getScheme();
        if (protocol.equals("file")) {
            FileArchive input = new FileArchive();
            input.open(path.getPath());
            return input;
        }
        if (protocol.equals("jar")) {
            InputJarArchive ja = new InputJarArchive();
            ja.open(path.getPath());
            return ja;
        }
        throw new MalformedURLException("Protocol not supported : " + protocol);
    }

    static URI prepareArchiveURI(String path) throws URISyntaxException, UnsupportedEncodingException, IOException {
        File archiveFile = new File(path);
        URI archiveURI = archiveFile.toURI();
        String scheme = archiveFile.isDirectory() ? "file" : "jar";
        URI answer = new URI(scheme, null, archiveURI.getPath(), null, null);
        return answer;
    }
}

