/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployapi;

import com.sun.appserv.management.client.ConnectionSource;
import com.sun.enterprise.admin.common.exception.AFException;
import com.sun.enterprise.deployment.client.DeploymentClientUtils;
import com.sun.enterprise.deployment.client.ServerConnectionIdentifier;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.Serializable;
import javax.enterprise.deploy.spi.Target;
import javax.management.MBeanServerConnection;

public class SunTarget
implements Target,
Serializable {
    private ServerConnectionIdentifier connectionInfo;
    private String appServer;
    private boolean connected = false;
    private ConnectionSource dasConnection = null;
    private MBeanServerConnection mbsc = null;
    private String targetType;
    private static StringManager localStrings = StringManager.getManager(SunTarget.class);
    private static final String DAS_TARGET_NAME = "server";

    public SunTarget(ServerConnectionIdentifier svi) {
        this.connectionInfo = svi;
    }

    public SunTarget(SunTarget other) {
        this.connectionInfo = other.connectionInfo;
        this.appServer = other.appServer;
        this.dasConnection = other.dasConnection;
        this.mbsc = other.mbsc;
        this.targetType = other.targetType;
    }

    public String getDescription() {
        String version = localStrings.getString("enterprise.deployapi.spi.ProductVersion", "9.0");
        return localStrings.getString("enterprise.deployapi.spi.suntargetdescription", version, this.getHostName());
    }

    public String getName() {
        return this.appServer;
    }

    public void release() {
        this.connected = false;
    }

    public String getHostName() {
        return this.connectionInfo.getHostName();
    }

    public String getPort() {
        return new Integer(this.connectionInfo.getHostPort()).toString();
    }

    public ServerConnectionIdentifier getConnectionInfo() {
        return this.connectionInfo;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String toString() {
        return this.getHostName() + ":" + (this.getPort() != null ? this.getPort() : "DefaultPort") + "_" + this.appServer;
    }

    public String debugString() {
        String s = "";
        if (this.connected) {
            s = "Connected ";
        }
        return s + "Server " + this.getHostName() + ":" + (this.getPort() != null ? this.getPort() : "DefaultPort") + "; Name: " + this.appServer;
    }

    public boolean equals(Object other) {
        if (other instanceof SunTarget) {
            SunTarget theOther = (SunTarget)other;
            return this.connectionInfo.equals(theOther.connectionInfo) && this.getName() != null && this.getName().equals(theOther.getName()) && this.getTargetType() != null && this.getTargetType().equals(theOther.getTargetType());
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.connectionInfo == null ? 0 : this.connectionInfo.hashCode());
        result = 37 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 37 * result + (this.getTargetType() == null ? 0 : this.getTargetType().hashCode());
        return result;
    }

    public boolean isManagedBySameDAS(Object other) {
        if (other instanceof SunTarget) {
            SunTarget theOther = (SunTarget)other;
            return this.connectionInfo.equals(theOther.connectionInfo);
        }
        return false;
    }

    public boolean isDAS() {
        return this.appServer.equals(DAS_TARGET_NAME);
    }

    public String getAppServerInstance() {
        return this.appServer;
    }

    public void setAppServerInstance(String appServer) {
        this.appServer = appServer;
    }

    public void setTargetType(String type) {
        this.targetType = type;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public void setConnectionSource(ConnectionSource conn) {
        this.dasConnection = conn;
    }

    public ConnectionSource getConnectionSource() {
        return this.dasConnection;
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return this.dasConnection.getExistingMBeanServerConnection();
    }

    public String exportClientStubs(String appName, int appType, String destDir) throws AFException {
        try {
            return DeploymentClientUtils.downloadClientStubs(appName, destDir, this.dasConnection);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AFException(e.getMessage());
        }
    }
}

