/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployapi;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.client.AppserverConnectionSource;
import com.sun.appserv.management.client.ConnectionSource;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.client.TLSParams;
import com.sun.appserv.management.config.ClusterConfig;
import com.sun.appserv.management.config.DeployedItemRefConfig;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.HTTPListenerConfig;
import com.sun.appserv.management.config.StandaloneServerConfig;
import com.sun.appserv.management.config.TemplateResolver;
import com.sun.appserv.management.config.WebModuleConfig;
import com.sun.appserv.management.helper.DeployedItemHelper;
import com.sun.enterprise.admin.util.HostAndPort;
import com.sun.enterprise.deployapi.DeploymentStatusImplWithError;
import com.sun.enterprise.deployapi.ProgressObjectSink;
import com.sun.enterprise.deployapi.SimpleProgressObjectImpl;
import com.sun.enterprise.deployapi.SunTarget;
import com.sun.enterprise.deployapi.SunTargetModuleID;
import com.sun.enterprise.deployapi.config.SunDeploymentConfiguration;
import com.sun.enterprise.deployment.client.DeploymentClientUtils;
import com.sun.enterprise.deployment.client.DeploymentFacility;
import com.sun.enterprise.deployment.client.DeploymentFacilityFactory;
import com.sun.enterprise.deployment.client.JESProgressObject;
import com.sun.enterprise.deployment.client.ServerConnectionEnvironment;
import com.sun.enterprise.deployment.client.ServerConnectionIdentifier;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.deploy.shared.Archive;
import com.sun.enterprise.deployment.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.deploy.shared.MemoryMappedArchive;
import com.sun.enterprise.deployment.deploy.shared.WritableArchive;
import com.sun.enterprise.deployment.util.DeploymentProperties;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.net.ssl.X509TrustManager;

public class SunDeploymentManager
implements com.sun.enterprise.deployment.deploy.spi.DeploymentManager {
    private SunTarget target = null;
    private ConnectionSource dasConnection = null;
    private DomainRoot rootProxy = null;
    private DomainConfig domainConfigProxy = null;
    private ProxyFactory proxyFactory = null;
    private ServerConnectionIdentifier serverId = null;
    private DeploymentFacility deploymentFacility = null;
    private static final String applicationsMBeanName = "com.sun.appserv:type=applications,category=config";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SunDeploymentManager.class);
    private static Locale defaultLocale = Locale.US;
    private Locale currentLocale = defaultLocale;
    private static Locale[] supportedLocales = new Locale[]{Locale.US};
    private String disconnectedMessage = localStrings.getLocalString("enterprise.deployapi.spi.disconnectedDM", "Illegal operation for a disconnected DeploymentManager");
    private static final String ENABLED_ATTRIBUTE_NAME = "Enabled";
    private static final String EE_APPLICATIONS_CONFIG_MBEAN_SUFFIX = ".EEApplicationsConfigMBean";

    public SunDeploymentManager() {
    }

    public SunDeploymentManager(ServerConnectionIdentifier sci) {
        this.target = new SunTarget(sci);
        this.serverId = sci;
    }

    public void setServerConnectionEnvironment(ServerConnectionEnvironment env) {
        this.serverId.setConnectionEnvironment(env);
    }

    public Target[] getTargets() throws IllegalStateException {
        this.verifyConnected();
        Target[] result = null;
        try {
            DomainConfig domainCfg = this.getDomainConfigProxy();
            Map standaloneServers = domainCfg.getStandaloneServerConfigMap();
            Map clusters = domainCfg.getClusterConfigMap();
            Vector<SunTarget> targets = new Vector<SunTarget>();
            Iterator it = standaloneServers.keySet().iterator();
            while (it.hasNext()) {
                targets.add(this.createSunTarget(this.target, (String)it.next(), "stand_alone_server"));
            }
            it = clusters.keySet().iterator();
            while (it.hasNext()) {
                targets.add(this.createSunTarget(this.target, (String)it.next(), "cluster"));
            }
            result = targets.toArray(new SunTarget[0]);
        }
        catch (Throwable e) {
            IllegalStateException ex = new IllegalStateException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        return result;
    }

    private SunTarget createSunTarget(SunTarget target, String name, String type) throws IOException {
        SunTarget aTarget = new SunTarget(target);
        aTarget.setAppServerInstance(name);
        aTarget.setConnectionSource(this.getDasConnection());
        aTarget.setTargetType(type);
        return aTarget;
    }

    public TargetModuleID[] getRunningModules(ModuleType moduleType, Target[] targetList) throws TargetException, IllegalStateException {
        return this.getModules(moduleType, targetList, ENABLED_ATTRIBUTE_NAME, Boolean.TRUE);
    }

    public TargetModuleID[] getNonRunningModules(ModuleType moduleType, Target[] targetList) throws TargetException, IllegalStateException {
        return this.getModules(moduleType, targetList, ENABLED_ATTRIBUTE_NAME, Boolean.FALSE);
    }

    public TargetModuleID[] getAvailableModules(ModuleType moduleType, Target[] targetList) throws TargetException, IllegalStateException {
        return this.getModules(moduleType, targetList, null, null);
    }

    private void verifyConnected() {
        if (this.isDisconnected()) {
            throw new IllegalStateException(this.disconnectedMessage);
        }
    }

    private boolean isDisconnected() {
        return this.target == null;
    }

    private TargetModuleID[] getModules(ModuleType moduleType, Target[] targetList, String attribute, Object status) throws TargetException, IllegalStateException {
        this.verifyConnected();
        if (moduleType == null) {
            return null;
        }
        try {
            Vector resultingTMIDs = new Vector();
            for (int i = 0; i < targetList.length; ++i) {
                SunTarget aTarget = (SunTarget)targetList[i];
                String[] moduleNames = this.getModulesOnATarget(aTarget, moduleType, attribute, status);
                this.addToTargetModuleIDs(moduleNames, moduleType, aTarget, resultingTMIDs);
            }
            TargetModuleID[] answer = resultingTMIDs.toArray(new SunTargetModuleID[0]);
            return answer;
        }
        catch (Exception e) {
            TargetException tg = new TargetException(localStrings.getLocalString("enterprise.deployapi.spi.errorgetreqmods", "Error getting required modules"));
            tg.initCause((Throwable)e);
            throw tg;
        }
    }

    private String[] getModulesOnATarget(SunTarget aTarget, ModuleType requiredType, String attribute, Object status) throws IOException {
        Set modules = null;
        DeployedItemHelper helper = new DeployedItemHelper(this.getRootProxy());
        modules = !aTarget.getTargetType().equals("cluster") ? helper.queryStandaloneServerDeployedItemObjectNames(aTarget.getName()) : helper.queryClusterDeployedItemObjectNames(aTarget.getName());
        if (attribute != null) {
            modules = helper.filterByAttributeValue(modules, attribute, status);
        }
        Vector<String> modulesMatchingType = new Vector<String>();
        String xtype = this.getXType(requiredType);
        for (ObjectName objectName : modules) {
            String modId = objectName.getKeyProperty("name");
            AMX proxy = this.getDomainConfigProxy().getContainee(xtype, modId);
            if (null == proxy) continue;
            modulesMatchingType.add(modId);
        }
        String[] actualModules = null;
        actualModules = modulesMatchingType.toArray(new String[0]);
        return actualModules;
    }

    private String getXType(ModuleType moduleType) {
        String result = DeploymentClientUtils.mapModuleTypeToXType(moduleType);
        return result;
    }

    private void addToTargetModuleIDs(String[] moduleIDs, ModuleType type, SunTarget sunTarget, Collection resultingTMIDs) throws IOException {
        for (int j = 0; j < moduleIDs.length; ++j) {
            HostAndPort webHost = this.getHostPort(moduleIDs[j], sunTarget);
            SunTargetModuleID tmid = new SunTargetModuleID(moduleIDs[j], sunTarget);
            tmid.setModuleType(type);
            resultingTMIDs.add(tmid);
            try {
                if (type.equals(ModuleType.EAR)) {
                    this.setJ2EEApplicationTargetModuleIDInfo(tmid, moduleIDs[j], webHost);
                    continue;
                }
                if (!type.equals(ModuleType.WAR)) continue;
                this.setWebApplicationTargetModuleIDInfo(tmid, moduleIDs[j], webHost);
                continue;
            }
            catch (Exception exp) {
                Print.dprintStackTrace(exp.getLocalizedMessage(), exp);
                Print.dprint("***Exception occured while navigating or accessing admin proxies:  Keep continuing\n");
            }
        }
    }

    private void setJ2EEApplicationTargetModuleIDInfo(SunTargetModuleID tmid, String moduleID, HostAndPort hostAndPort) throws AttributeNotFoundException, MalformedURLException, IOException {
        this.addChildTargetModuleIDsToJ2EEUsingMBeans(tmid, moduleID, hostAndPort);
    }

    private void setWebApplicationTargetModuleIDInfo(SunTargetModuleID tmid, String moduleID, HostAndPort webHost) throws MalformedURLException, IOException {
        SunTarget sunTarget = (SunTarget)tmid.getTarget();
        WebModuleConfig webProxy = (WebModuleConfig)this.getDomainConfigProxy().getContainee("X-WebModuleConfig", moduleID);
        String path = webProxy.getContextRoot();
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        String host = this.isPE() ? tmid.getConnectionInfo().getHostName() : webHost.getHost();
        URL webURL = new URL("http", host, webHost.getPort(), path);
        tmid.setWebURL(webURL.toExternalForm());
    }

    private HostAndPort getHostPort(String moduleID, SunTarget aTarget) throws IOException {
        DeployedItemRefConfig cfg = null;
        StandaloneServerConfig resolver = null;
        if (!aTarget.getTargetType().equals("cluster")) {
            StandaloneServerConfig svrProxy = (StandaloneServerConfig)this.getDomainConfigProxy().getContainee("X-StandaloneServerConfig", aTarget.getName());
            cfg = (DeployedItemRefConfig)svrProxy.getContainee("X-DeployedItemRefConfig", moduleID);
            resolver = svrProxy;
        } else {
            ClusterConfig clProxy = (ClusterConfig)this.getDomainConfigProxy().getContainee("X-ClusterConfig", aTarget.getName());
            cfg = (DeployedItemRefConfig)clProxy.getContainee("X-DeployedItemRefConfig", moduleID);
            resolver = null;
        }
        String vServers = cfg.getVirtualServers();
        if (vServers == null) {
            return this.getDefaultHostPort((TemplateResolver)resolver);
        }
        String[] vsList = vServers.split(" ,");
        if (vsList.length == 0) {
            return this.getDefaultHostPort((TemplateResolver)resolver);
        }
        HostAndPort answer = null;
        for (int i = 0; i < vsList.length && answer == null; ++i) {
            answer = this.getVirtualServerHostAndPort(vsList[i], (TemplateResolver)resolver);
        }
        if (answer == null) {
            answer = this.getDefaultHostPort((TemplateResolver)resolver);
        }
        return answer;
    }

    private HostAndPort getVirtualServerHostAndPort(String vs, TemplateResolver resolver) throws IOException {
        try {
            return this.getVirtualServerHostAndPortUsingMBeans(vs);
        }
        catch (Throwable thr) {
            IOException ioe = new IOException(localStrings.getLocalString("enterprise.deployapi.spi.errretreivevirtualserverhostport", "Error retrieving virtual server host and port"));
            ioe.initCause(thr);
            throw ioe;
        }
    }

    private HostAndPort getVirtualServerHostAndPortUsingMBeans(String vs) throws IOException, MalformedObjectNameException, InstanceNotFoundException, MBeanException, ReflectionException {
        HostAndPort result = null;
        MBeanServerConnection mbsc = this.getMBeanServerConnection();
        Object[] params = new Object[]{vs, Boolean.FALSE};
        String[] signature = new String[]{"java.lang.String", "boolean"};
        ObjectName applicationsMBean = new ObjectName(applicationsMBeanName);
        result = (HostAndPort)mbsc.invoke(applicationsMBean, "getVirtualServerHostAndPort", params, signature);
        return result;
    }

    private HostAndPort getDefaultHostPort(TemplateResolver resolver) throws IOException {
        try {
            return this.getDefaultHostPortUsingMBeans();
        }
        catch (Throwable thr) {
            IOException ioe = new IOException(localStrings.getLocalString("enterprise.deployapi.spi.errretrievedefaulthostport", "Error retrieving default host and port"));
            ioe.initCause(thr);
            throw ioe;
        }
    }

    private HostAndPort getDefaultHostPortUsingMBeans() throws IOException, MalformedObjectNameException, MBeanException, InstanceNotFoundException, ReflectionException {
        MBeanServerConnection mbsc = this.getMBeanServerConnection();
        HostAndPort result = null;
        Object[] params = new Object[]{Boolean.FALSE};
        String[] signature = new String[]{"boolean"};
        ObjectName applicationsMBean = new ObjectName(applicationsMBeanName);
        result = (HostAndPort)mbsc.invoke(applicationsMBean, "getHostAndPort", params, signature);
        return result;
    }

    private HostAndPort getHostPort(HTTPListenerConfig listenerProxy, TemplateResolver resolver) throws IOException {
        String serverName = null;
        int port = 0;
        if (!listenerProxy.getEnabled()) {
            return null;
        }
        if ("__asadmin".equals(listenerProxy.getDefaultVirtualServer())) {
            return null;
        }
        if (!listenerProxy.getSecurityEnabled()) {
            serverName = listenerProxy.getServerName();
            if (serverName == null || serverName.trim().equals("")) {
                serverName = this.getDefaultHostName();
            }
            String portString = listenerProxy.getPort();
            port = new Integer(this.getPropertyValueFromTemplate(portString, resolver));
            if (listenerProxy.getRedirectPort() != null) {
                port = new Integer(this.getPropertyValueFromTemplate(listenerProxy.getRedirectPort(), resolver));
            }
        }
        HostAndPort hostPort = new HostAndPort(serverName, port);
        return hostPort;
    }

    private String getPropertyValueFromTemplate(String str, TemplateResolver resolver) throws IOException {
        String result = resolver.resolveTemplateString(str);
        return result;
    }

    private String getDefaultHostName() {
        String defaultHostName = "localhost";
        try {
            InetAddress host = InetAddress.getLocalHost();
            defaultHostName = host.getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return defaultHostName;
    }

    public DeploymentConfiguration createConfiguration(DeployableObject dObj) throws InvalidModuleException {
        try {
            SunDeploymentConfiguration deploymentConfiguration = new SunDeploymentConfiguration(dObj);
            deploymentConfiguration.setDeploymentManager((DeploymentManager)this);
            return deploymentConfiguration;
        }
        catch (ConfigurationException e) {
            InvalidModuleException ime = new InvalidModuleException(e.getMessage());
            ime.initCause((Throwable)e);
            throw ime;
        }
    }

    public ProgressObject distribute(Target[] targetList, File moduleArchive, File deploymentPlan) throws IllegalStateException {
        return this.deploy(targetList, moduleArchive, deploymentPlan, null);
    }

    public ProgressObject distribute(Target[] targetList, InputStream moduleArchive, InputStream deploymentPlan) throws IllegalStateException {
        return this.deploy(targetList, moduleArchive, deploymentPlan, null);
    }

    public ProgressObject distribute(Target[] targetList, ModuleType type, InputStream moduleArchive, InputStream deploymentPlan) throws IllegalStateException {
        DeploymentProperties dProps = new DeploymentProperties();
        dProps.setType(type);
        return this.deploy(targetList, moduleArchive, deploymentPlan, (Properties)dProps);
    }

    public ProgressObject start(TargetModuleID[] moduleIDList) throws IllegalStateException {
        return this.executeCommandUsingFacility(CommandType.START, moduleIDList);
    }

    public ProgressObject stop(TargetModuleID[] moduleIDList) throws IllegalStateException {
        return this.executeCommandUsingFacility(CommandType.STOP, moduleIDList);
    }

    public ProgressObject undeploy(TargetModuleID[] moduleIDList) throws IllegalStateException {
        return this.executeCommandUsingFacility(CommandType.UNDEPLOY, moduleIDList);
    }

    public boolean isRedeploySupported() {
        return true;
    }

    public ProgressObject redeploy(TargetModuleID[] moduleIDList, File moduleArchive, File deploymentPlan) throws UnsupportedOperationException, IllegalStateException {
        try {
            TargetModuleIDCollection coll = new TargetModuleIDCollection(moduleIDList);
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                DeploymentFacilityModuleWork work = (DeploymentFacilityModuleWork)it.next();
                ProgressObject po = this.deploy(work.targets(), moduleArchive, deploymentPlan, (Properties)this.getRedeployOptions(work.getModuleID()));
                work.setProgressObject(po);
                coll.getProgressObjectSink().sinkProgressObject(po);
            }
            return coll.getProgressObjectSink();
        }
        catch (Throwable e) {
            return this.prepareErrorProgressObject(CommandType.REDEPLOY, e);
        }
    }

    public ProgressObject redeploy(TargetModuleID[] moduleIDList, InputStream moduleArchive, InputStream deploymentPlan) throws UnsupportedOperationException, IllegalStateException {
        try {
            TargetModuleIDCollection coll = new TargetModuleIDCollection(moduleIDList);
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                DeploymentFacilityModuleWork work = (DeploymentFacilityModuleWork)it.next();
                DeploymentProperties dProps = this.getRedeployOptions(work.getModuleID());
                dProps.setType(this.getModuleTypeFor(work.getModuleID()));
                ProgressObject po = this.deploy(work.targets(), moduleArchive, deploymentPlan, (Properties)dProps);
                work.setProgressObject(po);
                coll.getProgressObjectSink().sinkProgressObject(po);
            }
            return coll.getProgressObjectSink();
        }
        catch (Throwable e) {
            return this.prepareErrorProgressObject(CommandType.REDEPLOY, e);
        }
    }

    public void release() {
        if (!this.isDisconnected()) {
            this.target.release();
            this.target = null;
        }
    }

    public Locale getDefaultLocale() {
        return defaultLocale;
    }

    public Locale getCurrentLocale() {
        return this.currentLocale;
    }

    public void setLocale(Locale locale) throws UnsupportedOperationException {
        for (int i = 0; i < supportedLocales.length; ++i) {
            if (supportedLocales[i] != locale) continue;
            this.currentLocale = locale;
            return;
        }
        throw new UnsupportedOperationException(localStrings.getLocalString("enterprise.deployapi.spi.localnotsupported", "Locale {0} is not supported", new Object[]{locale}));
    }

    public Locale[] getSupportedLocales() {
        return supportedLocales;
    }

    public boolean isLocaleSupported(Locale locale) {
        Locale[] locales = this.getSupportedLocales();
        for (int i = 0; i < locales.length; ++i) {
            if (!locales[i].equals(locale)) continue;
            return true;
        }
        return false;
    }

    public DConfigBeanVersionType getDConfigBeanVersion() {
        return DConfigBeanVersionType.V5;
    }

    public boolean isDConfigBeanVersionSupported(DConfigBeanVersionType version) {
        return version.getValue() == this.getDConfigBeanVersion().getValue();
    }

    public void setDConfigBeanVersion(DConfigBeanVersionType version) throws DConfigBeanVersionUnsupportedException {
        if (!this.isDConfigBeanVersionSupported(version)) {
            throw new DConfigBeanVersionUnsupportedException(localStrings.getLocalString("enterprise.deployapi.spi.dconfigbeanversionnotsupported", "DConfigBean version {0} is not supported", new Object[]{version.toString()}));
        }
    }

    private DeploymentProperties getRedeployOptions(String moduleID) {
        DeploymentProperties deplProps = new DeploymentProperties();
        deplProps.setForce(true);
        deplProps.setName(moduleID);
        return deplProps;
    }

    private MBeanServerConnection getMBeanServerConnection() throws IllegalStateException {
        return this.getDasConnection().getExistingMBeanServerConnection();
    }

    private ProgressObject deploy(Target[] targetList, InputStream moduleStream, InputStream deploymentPlanStream, Properties presetOptions) throws IllegalStateException {
        MemoryMappedArchive moduleArchive = null;
        MemoryMappedArchive deploymentPlanArchive = null;
        try {
            moduleArchive = new MemoryMappedArchive(moduleStream);
            if (deploymentPlanStream != null) {
                deploymentPlanArchive = new MemoryMappedArchive(deploymentPlanStream);
            }
            return this.deploy(targetList, moduleArchive, deploymentPlanArchive, presetOptions);
        }
        catch (Throwable e) {
            String msg = localStrings.getLocalString("enterprise.deployapi.spi.errpreparearchstream", "Could not prepare archives for module and/or deployment plan input streams");
            IllegalArgumentException ex = new IllegalArgumentException(msg);
            ex.initCause(e);
            return this.prepareErrorProgressObject(CommandType.DISTRIBUTE, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProgressObject deploy(Target[] targetList, File moduleArchive, File deploymentPlan, Properties presetOptions) throws IllegalStateException {
        ProgressObject progressObject;
        AbstractArchive appArchive = null;
        AbstractArchive planArchive = null;
        ArchiveFactory archiveFactory = new ArchiveFactory();
        try {
            ProgressObject po;
            appArchive = archiveFactory.openArchive(this.toJarURI(moduleArchive));
            if (deploymentPlan != null && deploymentPlan.length() != 0L && (planArchive = archiveFactory.openArchive(this.toJarURI(deploymentPlan))) == null) {
                throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployapi.spi.noarchivisthandlesplan", "No archivist is able to handle the deployment plan {0}", new Object[]{deploymentPlan.getAbsolutePath()}));
            }
            progressObject = po = this.deploy(targetList, appArchive, planArchive, presetOptions);
            this.closeArchives(CommandType.DISTRIBUTE, appArchive, moduleArchive.getAbsolutePath(), planArchive, deploymentPlan != null ? deploymentPlan.getAbsolutePath() : null);
        }
        catch (Exception se) {
            ProgressObject progressObject2;
            try {
                String msg = localStrings.getLocalString("enterprise.deployapi.spi.errpreparearchfile", "Could not prepare archives for module and/or deployment plan files");
                IllegalArgumentException ex = new IllegalArgumentException(msg);
                ex.initCause(se);
                progressObject2 = this.prepareErrorProgressObject(CommandType.DISTRIBUTE, ex);
                this.closeArchives(CommandType.DISTRIBUTE, appArchive, moduleArchive.getAbsolutePath(), planArchive, deploymentPlan != null ? deploymentPlan.getAbsolutePath() : null);
            }
            catch (Throwable throwable) {
                this.closeArchives(CommandType.DISTRIBUTE, appArchive, moduleArchive.getAbsolutePath(), planArchive, deploymentPlan != null ? deploymentPlan.getAbsolutePath() : null);
                throw throwable;
            }
            return progressObject2;
        }
        return progressObject;
    }

    private ProgressObject deploy(Target[] targetList, AbstractArchive moduleArchive, AbstractArchive planArchive, Properties presetOptions) throws IllegalStateException {
        this.verifyConnected();
        String moduleID = null;
        ProgressObject progressObj = null;
        try {
            String UriPath = moduleArchive.getArchiveUri();
            moduleID = this.computeModuleID(moduleArchive);
            Properties options = this.getProperties(UriPath, moduleID);
            if (presetOptions != null) {
                options.putAll((Map<?, ?>)presetOptions);
            }
            progressObj = this.getDeploymentFacility().deploy(targetList, moduleArchive, planArchive, options);
        }
        catch (Throwable e) {
            progressObj = this.prepareErrorProgressObject(CommandType.DISTRIBUTE, e);
        }
        return progressObj;
    }

    private ProgressObject closeArchives(CommandType commandType, AbstractArchive moduleArchive, String moduleArchiveSpec, AbstractArchive planArchive, String planArchiveSpec) {
        ProgressObject errorPO = null;
        IOException moduleIOE = this.closeArchive(moduleArchive);
        IOException planIOE = this.closeArchive(planArchive);
        IOException excForProgressObject = null;
        String errorMsg = null;
        if (moduleIOE != null) {
            excForProgressObject = moduleIOE;
            errorMsg = planIOE != null ? localStrings.getLocalString("enterprise.deployapi.spi.errclosearchs", "Could not close module archive {0} or deployment plan archive {1}", new Object[]{moduleArchiveSpec, planArchiveSpec}) : localStrings.getLocalString("enterprise.deployapi.spi.errclosemodulearch", "Could not close module archive {0}", new Object[]{moduleArchiveSpec});
        } else if (planIOE != null) {
            excForProgressObject = planIOE;
            errorMsg = localStrings.getLocalString("enterprise.deployapi.spi.errcloseplanarch", "Could not close deployment plan archive {0}", new Object[]{planArchiveSpec});
        }
        if (errorMsg != null) {
            IOException ioe = new IOException(errorMsg);
            ioe.initCause(excForProgressObject);
            errorPO = this.prepareErrorProgressObject(commandType, ioe);
        }
        return errorPO;
    }

    private IOException closeArchive(AbstractArchive archive) {
        IOException errorIOE = null;
        if (archive != null) {
            try {
                archive.close();
            }
            catch (IOException ioe) {
                errorIOE = ioe;
            }
        }
        return errorIOE;
    }

    private String computeModuleID(AbstractArchive moduleArchive) throws Exception {
        String moduleID = null;
        String UriPath = moduleArchive.getArchiveUri();
        if (UriPath != null && UriPath.length() > 0) {
            moduleID = this.pathExcludingType(UriPath);
            moduleID = moduleID.replace(' ', '_');
            moduleID = moduleID.replace('\\', '_').replace('/', '_');
            moduleID = moduleID.replace(':', '_').replace('*', '_');
            moduleID = moduleID.replace('?', '_').replace('\"', '_');
            moduleID = moduleID.replace('<', '_').replace('>', '_');
            moduleID = moduleID.replace('|', '_');
            moduleID = moduleID.replace(',', '_').replace('=', '_');
        }
        return moduleID;
    }

    private ProgressObject executeCommandUsingFacility(CommandType commandType, TargetModuleID[] targetModuleIDList) throws IllegalStateException {
        this.verifyConnected();
        try {
            DeploymentFacility df = this.getDeploymentFacility();
            TargetModuleIDCollection coll = new TargetModuleIDCollection(targetModuleIDList);
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                DeploymentFacilityModuleWork work = (DeploymentFacilityModuleWork)it.next();
                JESProgressObject po = null;
                if (commandType.equals(CommandType.START)) {
                    po = df.enable(work.targets(), work.getModuleID());
                } else if (commandType.equals(CommandType.STOP)) {
                    po = df.disable(work.targets(), work.getModuleID());
                } else if (commandType.equals(CommandType.UNDEPLOY)) {
                    po = df.undeploy(work.targets(), work.getModuleID());
                } else {
                    throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployapi.spi.unexpcommand", "Received unexpected deployment facility command ${0}", new Object[]{commandType.toString()}));
                }
                work.setProgressObject(po);
                coll.getProgressObjectSink().sinkProgressObject(po);
            }
            return coll.getProgressObjectSink();
        }
        catch (Throwable thr) {
            return this.prepareErrorProgressObject(commandType, thr);
        }
    }

    private ProgressObject prepareErrorProgressObject(CommandType commandType, Throwable thr) {
        DeploymentStatusImplWithError ds = new DeploymentStatusImplWithError(CommandType.DISTRIBUTE, thr);
        SimpleProgressObjectImpl progressObj = new SimpleProgressObjectImpl(ds);
        ProgressEvent event = new ProgressEvent((Object)progressObj, null, (DeploymentStatus)ds);
        progressObj.fireProgressEvent(event);
        return progressObj;
    }

    protected Properties getProperties(String archiveName, String moduleID) {
        DeploymentProperties dProps = new DeploymentProperties();
        dProps.setArchiveName(archiveName);
        dProps.setName(moduleID);
        dProps.setEnable(false);
        return dProps;
    }

    private String pathExcludingType(String path) {
        if ((path = path.substring(path.lastIndexOf(47) + 1)).lastIndexOf(46) != -1) {
            path = path.substring(0, path.lastIndexOf(46));
        }
        return path;
    }

    private ConnectionSource getDasConnection() {
        if (this.dasConnection == null) {
            if (this.serverId == null) {
                throw new IllegalStateException(localStrings.getLocalString("enterprise.deployapi.spi.targetorprinnotset", "Attempted to connect to DAS management interface but target and/or principal have not been set"));
            }
            TLSParams tlsParams = null;
            if (this.serverId.isSecure()) {
                X509TrustManager trustManager = (X509TrustManager)this.serverId.getConnectionEnvironment().get("TRUST_MANAGER_KEY");
                tlsParams = new TLSParams(trustManager, null);
            }
            this.dasConnection = new AppserverConnectionSource("sun-as-http", this.serverId.getHostName(), this.serverId.getHostPort(), this.serverId.getUserName(), this.serverId.getPassword(), tlsParams, null);
        }
        return this.dasConnection;
    }

    private DomainRoot getRootProxy() throws IOException {
        if (this.rootProxy == null) {
            this.rootProxy = this.getProxyFactory().createDomainRoot();
        }
        this.rootProxy.waitAMXReady();
        return this.rootProxy;
    }

    private DomainConfig getDomainConfigProxy() throws IOException {
        if (this.domainConfigProxy == null) {
            this.domainConfigProxy = this.getRootProxy().getDomainConfig();
        }
        return this.domainConfigProxy;
    }

    private ProxyFactory getProxyFactory() {
        if (this.proxyFactory == null) {
            this.proxyFactory = ProxyFactory.getInstance((ConnectionSource)this.getDasConnection());
        }
        return this.proxyFactory;
    }

    public ProgressObject distribute(Target[] targetList, Archive moduleArchive, Archive deploymentPlan, Object deploymentOptions) throws IllegalStateException {
        return null;
    }

    public WritableArchive getArchive(URI path, String name) throws IOException {
        if (path == null) {
            File root = File.createTempFile(name, ".jar");
            path = root.toURI();
        }
        ArchiveFactory factory = new ArchiveFactory();
        boolean exists = false;
        if (!path.getScheme().equals("file") && !path.getScheme().equals("jar")) {
            return null;
        }
        File target = new File(path);
        exists = target.exists();
        if (exists) {
            return factory.openArchive(path);
        }
        return factory.createArchive(path);
    }

    private URI toJarURI(File archiveFile) throws URISyntaxException {
        URI archiveFileURI = archiveFile.toURI();
        URI answer = new URI("jar", "", archiveFileURI.getSchemeSpecificPart(), null, null);
        return answer;
    }

    private DeploymentFacility getDeploymentFacility() {
        if (this.deploymentFacility == null) {
            this.deploymentFacility = DeploymentFacilityFactory.getDeploymentFacility();
            this.deploymentFacility.connect(this.serverId);
        }
        return this.deploymentFacility;
    }

    private void addChildTargetModuleIDsToJ2EEUsingMBeans(SunTargetModuleID sunTargetModuleID, String moduleID, HostAndPort hostAndPort) {
        SunTarget sunTarget = (SunTarget)sunTargetModuleID.getTarget();
        try {
            MBeanServerConnection mbsc = this.getMBeanServerConnection();
            ObjectName query = new ObjectName("com.sun.appserv:category=runtime,name=" + moduleID + ",J2EEServer=" + sunTarget.getAppServerInstance() + ",*");
            Set<ObjectName> mbeans = mbsc.queryNames(query, null);
            for (ObjectName module : mbeans) {
                String[] subModules = (String[])mbsc.getAttribute(module, "modules");
                for (int i = 0; i < subModules.length; ++i) {
                    Set<ObjectName> subModuleObjectNames = mbsc.queryNames(new ObjectName(subModules[i]), null);
                    if (subModuleObjectNames == null) continue;
                    for (ObjectName aSubModule : subModuleObjectNames) {
                        SunTargetModuleID childTmid;
                        String aSubModuleName = aSubModule.toString();
                        if (aSubModuleName.indexOf("WebModule") != -1) {
                            String id = moduleID + "#" + (String)mbsc.getAttribute(aSubModule, "name");
                            String path = (String)mbsc.getAttribute(aSubModule, "path");
                            childTmid = this.prepareWebChildTargetModuleID(id, sunTarget, hostAndPort, path);
                        } else {
                            String name = (String)mbsc.getAttribute(aSubModule, "name");
                            ModuleType moduleType = this.deriveModuleTypeFromModuleName(aSubModuleName);
                            childTmid = this.prepareNonWebChildTargetModuleID(moduleID, sunTarget, name, moduleType);
                        }
                        sunTargetModuleID.addChildTargetModuleID(childTmid);
                        childTmid.setParentTargetModuleID(sunTargetModuleID);
                    }
                }
            }
        }
        catch (Exception exp) {
            Print.dprintStackTrace(exp.getLocalizedMessage(), exp);
            Print.dprint("***Exception occured while accessing mbean details:  Keep continuing\n");
        }
    }

    private SunTargetModuleID prepareWebChildTargetModuleID(String id, SunTarget sunTarget, HostAndPort hostAndPort, String path) throws MalformedURLException {
        id = id.replace(':', '#');
        SunTargetModuleID childTmid = new SunTargetModuleID(id, sunTarget);
        String host = this.isPE() ? childTmid.getConnectionInfo().getHostName() : hostAndPort.getHost();
        URL webURL = new URL("http", host, hostAndPort.getPort(), path);
        childTmid.setWebURL(webURL.toExternalForm());
        childTmid.setModuleType(ModuleType.WAR);
        return childTmid;
    }

    private SunTargetModuleID prepareNonWebChildTargetModuleID(String id, SunTarget sunTarget, String subModuleName, ModuleType moduleType) {
        String moduleID = id + "#" + subModuleName;
        SunTargetModuleID childTmid = new SunTargetModuleID(moduleID, sunTarget);
        childTmid.setModuleType(moduleType);
        return childTmid;
    }

    private ModuleType deriveModuleTypeFromModuleName(String moduleName) {
        ModuleType moduleType = null;
        moduleType = moduleName.indexOf("EJBModule") != -1 ? ModuleType.EJB : (moduleName.indexOf("AppClientModule") != -1 ? ModuleType.CAR : ModuleType.RAR);
        return moduleType;
    }

    public boolean isPE() {
        return this.isPE(null);
    }

    public boolean isPE(MBeanServerConnection mbsc) {
        try {
            boolean result = this.applicationsConfigMBeanIsPE(mbsc);
            return result;
        }
        catch (Throwable thr) {
            throw new RuntimeException(localStrings.getLocalString("enterprise.deployapi.spi.errcheckingtype", "Error checking type of DAS"), thr);
        }
    }

    private boolean applicationsConfigMBeanIsPE(MBeanServerConnection mbsc) throws MalformedObjectNameException, InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        ObjectName applicationsMBean;
        MBeanInfo info;
        String className;
        if (mbsc == null) {
            mbsc = this.getMBeanServerConnection();
        }
        boolean result = !(className = (info = mbsc.getMBeanInfo(applicationsMBean = new ObjectName(applicationsMBeanName))).getClassName()).endsWith(EE_APPLICATIONS_CONFIG_MBEAN_SUFFIX);
        return result;
    }

    private ModuleType getModuleTypeFor(String moduleID) throws Exception {
        MBeanServerConnection mbsc = this.getMBeanServerConnection();
        ObjectName applicationsMBean = new ObjectName(applicationsMBeanName);
        String[] signature = new String[]{"java.lang.String"};
        Object[] params = new Object[]{moduleID};
        Integer result = (Integer)mbsc.invoke(applicationsMBean, "getModuleType", params, signature);
        if (result == null) {
            String msg = localStrings.getLocalString("enterprise.deployapi.spi.redeploy.modulenotfound", "Module " + moduleID + " not found");
            throw new IllegalArgumentException(msg);
        }
        return ModuleType.getModuleType((int)result);
    }

    protected class DeploymentFacilityModuleWork {
        private String moduleID = null;
        private Collection targets = new Vector();
        private ProgressObject progressObject = null;

        public DeploymentFacilityModuleWork(String moduleID) {
            this.moduleID = moduleID;
        }

        public void addTarget(Target target) {
            if (!(target instanceof SunTarget)) {
                throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployapi.spi.unexptargettyp", "Target must be of type SunTarget but encountered {0}", new Object[]{target.getClass().getName()}));
            }
            this.targets.add(target);
        }

        public Target[] targets() {
            return this.targets.toArray(new SunTarget[0]);
        }

        public ProgressObject getProgressObject() {
            return this.progressObject;
        }

        public void setProgressObject(ProgressObject progressObject) {
            this.progressObject = progressObject;
        }

        public String getModuleID() {
            return this.moduleID;
        }
    }

    protected class TargetModuleIDCollection {
        private HashMap moduleIDToInfoMap = new HashMap();
        ProgressObjectSink progressObjectSink = null;

        public TargetModuleIDCollection(TargetModuleID[] targetModuleIDs) throws IllegalArgumentException {
            for (int i = 0; i < targetModuleIDs.length; ++i) {
                Target candidateTarget = targetModuleIDs[i].getTarget();
                if (!(candidateTarget instanceof SunTarget)) {
                    throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployapi.spi.notSunTarget", "Expected SunTarget instance but found instance of {0}", new Object[]{candidateTarget.getClass().getName()}));
                }
                SunTarget candidateSunTarget = (SunTarget)candidateTarget;
                String moduleID = targetModuleIDs[i].getModuleID();
                DeploymentFacilityModuleWork work = (DeploymentFacilityModuleWork)this.moduleIDToInfoMap.get(moduleID);
                if (work == null) {
                    work = new DeploymentFacilityModuleWork(moduleID);
                    this.moduleIDToInfoMap.put(moduleID, work);
                }
                work.addTarget(candidateTarget);
            }
        }

        public Iterator iterator() {
            return this.moduleIDToInfoMap.values().iterator();
        }

        public int size() {
            return this.moduleIDToInfoMap.size();
        }

        public ProgressObjectSink getProgressObjectSink() {
            if (this.progressObjectSink == null) {
                this.progressObjectSink = new ProgressObjectSink();
            }
            return this.progressObjectSink;
        }
    }
}

