/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.jmx.remote;

import com.sun.enterprise.admin.jmx.remote.MBeanServerConnectionFactory;
import com.sun.enterprise.admin.jmx.remote.internal.RemoteMBeanServerConnection;
import com.sun.enterprise.admin.jmx.remote.notification.ClientNotificationManager;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;

public abstract class UrlConnector
implements JMXConnector {
    private static final Logger logger = Logger.getLogger("com.sun.logging.enterprise.system.admin.jmx.connector");
    protected final JMXServiceURL serviceUrl;
    protected final Map environment;
    protected final URL connectionUrl;
    private MBeanServerConnection mbsc;
    private int state;
    private final Object stateLock = new Object();
    private final NotificationBroadcasterSupport connectionNotifier;
    private static final int CREATED = 1;
    private static final int CONNECTED = 2;
    private static final int CLOSED = 3;
    private static final String PROTOCOL_PREFIX = "s1as";
    private final String NULL_STR_MESSAGE = "String is null";

    protected UrlConnector(JMXServiceURL serviceUrl, Map environment) {
        this.logMap(environment);
        this.serviceUrl = serviceUrl;
        this.environment = environment;
        this.validateJmxServiceUrl();
        this.validateEnvironment();
        this.connectionUrl = this.serviceUrl2Url(serviceUrl);
        this.changeState(1);
        this.connectionNotifier = new NotificationBroadcasterSupport();
        logger.fine("Connector created to the url: " + this.connectionUrl);
    }

    private void logMap(Map env) {
        for (String key : env.keySet()) {
            String str = env.get(key) == null ? null : env.get(key).toString();
            logger.fine(str);
        }
    }

    public void addConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.connectionNotifier.addNotificationListener(listener, filter, handback);
    }

    public void close() throws IOException {
        String message = "UrlConnector.close: Requires that connector is CONNECTED";
        try {
            this.assertState(2, "UrlConnector.close: Requires that connector is CONNECTED");
            ClientNotificationManager notifMgr = ((RemoteMBeanServerConnection)this.mbsc).getNotificationManager();
            if (notifMgr != null) {
                notifMgr.close();
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public void connect() throws IOException {
        String msg = "Environment has to be provided";
        throw new UnsupportedOperationException("Environment has to be provided");
    }

    public void connect(Map env) throws IOException {
        String message = "UrlConnector.connect: Requires that connector is not CLOSED";
        this.assertStateNot(3, "UrlConnector.connect: Requires that connector is not CLOSED");
        if (this.connected()) {
            return;
        }
        try {
            this.mbsc = MBeanServerConnectionFactory.getRemoteMBeanServerConnection(this.environment, this.serviceUrl);
            this.changeState(2);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    public String getConnectionId() throws IOException {
        return "TODO";
    }

    public MBeanServerConnection getMBeanServerConnection() throws IOException {
        String message = "Connector should be in CONNECTED state";
        this.assertState(2, "Connector should be in CONNECTED state");
        return this.mbsc;
    }

    public MBeanServerConnection getMBeanServerConnection(Subject delegationSubject) throws IOException {
        return null;
    }

    public void removeConnectionNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
    }

    public void removeConnectionNotificationListener(NotificationListener l, NotificationFilter f, Object handback) throws ListenerNotFoundException {
    }

    protected void validateEnvironment() throws RuntimeException {
        boolean userPresent = this.environment.containsKey("USER");
        boolean pwdPresent = this.environment.containsKey("PASSWORD");
        logger.fine("USERPRESENT: " + userPresent);
        logger.fine("PWDPRESENT: " + pwdPresent);
        if (!userPresent || !pwdPresent) {
            throw new IllegalArgumentException("User and Password has to be there in the map");
        }
        String adminUser = (String)this.environment.get("USER");
        String adminPassword = (String)this.environment.get("PASSWORD");
    }

    protected abstract void validateJmxServiceUrl() throws RuntimeException;

    private void validateString(String str) throws RuntimeException {
        if (str == null || str.length() == 0) {
            throw new RuntimeException("String is null");
        }
    }

    protected URL serviceUrl2Url(JMXServiceURL serviceUrl) throws RuntimeException {
        try {
            String transportProtocol = this.getTransport(serviceUrl.getProtocol());
            String host = serviceUrl.getHost();
            int port = serviceUrl.getPort();
            String remainder = serviceUrl.getURLPath();
            if (remainder == null || remainder.trim().length() == 0) {
                remainder = "/web1/remotejmx";
            }
            return new URL(transportProtocol, host, port, remainder);
        }
        catch (MalformedURLException mu) {
            throw new RuntimeException(mu.getMessage());
        }
    }

    private String getTransport(String proprietoryProtocolString) {
        return proprietoryProtocolString.substring(PROTOCOL_PREFIX.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertState(int legalState, String message) throws IllegalStateException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != legalState) {
                throw new IllegalStateException(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertStateNot(int illegalState, String message) throws IllegalStateException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == illegalState) {
                throw new IllegalStateException(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeState(int toState) {
        assert (toState == 1 || toState == 2 || toState == 3) : "This is illegal state transition, to: " + toState;
        Object object = this.stateLock;
        synchronized (object) {
            this.state = toState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connected() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state == 2;
        }
    }
}

