/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.jmx.remote;

import com.sun.enterprise.admin.jmx.remote.IStringManager;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public class StringManager
implements IStringManager {
    private static final Logger logger = Logger.getLogger("com.sun.logging.enterprise.system.admin.jmx.connector");
    private static Class asStringManagerClass = null;
    private static Method getStr = null;
    private static Method getStrDef = null;
    private static Method getStrGeneric = null;
    private static Method getManager = null;
    private Object asStringManager = null;

    public StringManager(String packageName) {
        try {
            if (asStringManagerClass == null) {
                asStringManagerClass = Class.forName("com.sun.enterprise.util.i18n.StringManager");
                getStr = asStringManagerClass.getMethod("getString", String.class);
                getStrDef = asStringManagerClass.getMethod("getString", String.class, Object.class);
                getStrGeneric = asStringManagerClass.getMethod("getString", String.class, Object[].class);
                getManager = asStringManagerClass.getMethod("getManager", String.class);
            }
            this.asStringManager = getManager.invoke((Object)asStringManagerClass, packageName);
        }
        catch (Throwable e) {
            e.printStackTrace();
            StackTraceElement[] ste = e.getStackTrace();
            for (int i = 0; i < ste.length; ++i) {
                logger.severe(ste[i].toString());
            }
            logger.severe("StringManager could not be configured");
        }
    }

    public String getString(String key) {
        try {
            return (String)getStr.invoke(this.asStringManager, key);
        }
        catch (Exception ex) {
            logger.severe("Method invocation failed on com.sun.enterprise.util.i18n.StringManager");
            return null;
        }
    }

    public String getString(String key, Object arg) {
        try {
            return (String)getStrDef.invoke(this.asStringManager, key, arg);
        }
        catch (Exception ex) {
            logger.severe("Method invocation failed on com.sun.enterprise.util.i18n.StringManager");
            return null;
        }
    }

    public String getString(String key, Object[] args) {
        try {
            return (String)getStrGeneric.invoke(this.asStringManager, key, args);
        }
        catch (Exception ex) {
            logger.severe("Method invocation failed on com.sun.enterprise.util.i18n.StringManager");
            return null;
        }
    }
}

