/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.util.resource;

import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import javax.servlet.ServletContext;
import org.zkoss.lang.Library;
import org.zkoss.util.resource.LabelLocator;

public class ServletLabelLocator
implements LabelLocator {
    private final ServletContext _ctx;
    private static String PREFIX;
    private static String SUFFIX;

    public ServletLabelLocator(ServletContext ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("null");
        }
        this._ctx = ctx;
    }

    public URL locate(Locale locale) throws IOException {
        ServletLabelLocator.init();
        return this._ctx.getResource(locale == null ? PREFIX + SUFFIX : PREFIX + '_' + locale + SUFFIX);
    }

    private static final void init() {
        if (PREFIX == null) {
            String s = Library.getProperty((String)"org.zkoss.util.label.web.location", (String)"/WEB-INF/i3-label.properties");
            int j = s.lastIndexOf(46);
            PREFIX = j >= 0 ? s.substring(0, j) : s;
            SUFFIX = j >= 0 ? s.substring(j) : "";
        }
    }

    public int hashCode() {
        return this._ctx.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof ServletLabelLocator && ((ServletLabelLocator)o)._ctx.equals(this._ctx);
    }
}

