/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.property;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;

public class Math {
    private boolean strict = false;

    public Math() {
    }

    public Math(boolean strict) {
        this.strict = strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public static double add(double a, double b) {
        return a + b;
    }

    public static float add(float a, float b) {
        return a + b;
    }

    public static long add(long a, long b) {
        return a + b;
    }

    public static int add(int a, int b) {
        return a + b;
    }

    public static double add(double[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        double b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b += a[i];
        }
        return b;
    }

    public static float add(float[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        float b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b += a[i];
        }
        return b;
    }

    public static long add(long[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        long b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b += a[i];
        }
        return b;
    }

    public static int add(int[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        int b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b += a[i];
        }
        return b;
    }

    public static double subtract(double a, double b) {
        return a - b;
    }

    public static float subtract(float a, float b) {
        return a - b;
    }

    public static long subtract(long a, long b) {
        return a - b;
    }

    public static int subtract(int a, int b) {
        return a - b;
    }

    public static double subtract(double[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        double b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b -= a[i];
        }
        return b;
    }

    public static float subtract(float[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        float b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b -= a[i];
        }
        return b;
    }

    public static long subtract(long[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        long b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b -= a[i];
        }
        return b;
    }

    public static int subtract(int[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        int b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b -= a[i];
        }
        return b;
    }

    public static double multiply(double a, double b) {
        return a * b;
    }

    public static float multiply(float a, float b) {
        return a * b;
    }

    public static long multiply(long a, long b) {
        return a * b;
    }

    public static int multiply(int a, int b) {
        return a * b;
    }

    public static double multiply(double[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        double b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b *= a[i];
        }
        return b;
    }

    public static float multiply(float[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        float b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b *= a[i];
        }
        return b;
    }

    public static long multiply(long[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        long b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b *= a[i];
        }
        return b;
    }

    public static int multiply(int[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        int b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b *= a[i];
        }
        return b;
    }

    public static double divide(double a, double b) {
        return a / b;
    }

    public static float divide(float a, float b) {
        return a / b;
    }

    public static long divide(long a, long b) {
        return a / b;
    }

    public static int divide(int a, int b) {
        return a / b;
    }

    public static double divide(double[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        double b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b /= a[i];
        }
        return b;
    }

    public static float divide(float[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        float b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b /= a[i];
        }
        return b;
    }

    public static long divide(long[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        long b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b /= a[i];
        }
        return b;
    }

    public static int divide(int[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        int b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b /= a[i];
        }
        return b;
    }

    public static double mod(double a, double b) {
        return a % b;
    }

    public static float mod(float a, float b) {
        return a % b;
    }

    public static long mod(long a, long b) {
        return a % b;
    }

    public static int mod(int a, int b) {
        return a % b;
    }

    public static double mod(double[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        double b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b %= a[i];
        }
        return b;
    }

    public static float mod(float[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        float b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b %= a[i];
        }
        return b;
    }

    public static long mod(long[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        long b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b %= a[i];
        }
        return b;
    }

    public static int mod(int[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        int b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b %= a[i];
        }
        return b;
    }

    public Number calculate(String op, String[] operands) {
        return this.calculate(op, "double", operands);
    }

    public Number calculate(String op, String type, String[] operands) {
        try {
            String name;
            int i;
            if (operands.length > 2) {
                if (op.equals("add") || op.equals("subtract") || op.equals("multiply") || op.equals("divide") || op.equals("mod")) {
                    return this.calculateArray(op, type, operands);
                }
                throw new IllegalArgumentException("too many operands");
            }
            Class<?> c = this.strict ? Class.forName("java.lang.StrictMath") : Class.forName("java.lang.Math");
            if (op.equals("random")) {
                Method m = c.getDeclaredMethod(op, new Class[0]);
                Object result = m.invoke(c, null);
                return (Number)result;
            }
            Vector<Method> candidates = new Vector<Method>();
            Method[] methods = c.getDeclaredMethods();
            for (i = 0; i < methods.length; ++i) {
                name = methods[i].getName();
                if (!name.equals(op)) continue;
                candidates.addElement(methods[i]);
            }
            if (candidates.size() == 0) {
                c = this.getClass();
                methods = c.getDeclaredMethods();
                for (i = 0; i < methods.length; ++i) {
                    name = methods[i].getName();
                    if (!name.equals(op)) continue;
                    candidates.addElement(methods[i]);
                }
            }
            if (candidates.size() == 0) {
                throw new RuntimeException("Unknown operation: " + op);
            }
            Class wantTypeClass = this.getDataType(type);
            int paramCount = -1;
            try {
                Method candidate;
                for (int i2 = 0; i2 <= candidates.size() && (paramCount = (candidate = (Method)candidates.elementAt(i2)).getParameterTypes().length) != operands.length; ++i2) {
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Wrong number of arguments, have " + operands.length + ", but can't find corresponding method.");
            }
            Class typeClass = null;
            if (candidates.size() == 1) {
                Method m = (Method)candidates.elementAt(0);
                typeClass = m.getParameterTypes()[0];
            } else {
                Enumeration e = candidates.elements();
                while (e.hasMoreElements()) {
                    Method m = (Method)e.nextElement();
                    if (!m.getParameterTypes()[0].equals(wantTypeClass)) continue;
                    typeClass = wantTypeClass;
                    break;
                }
                if (typeClass == null) {
                    throw new RuntimeException("Can't find a method with parameters of type " + type);
                }
            }
            Class[] paramTypes = new Class[paramCount];
            for (int i3 = 0; i3 < paramCount; ++i3) {
                paramTypes[i3] = typeClass;
            }
            Method m = c.getDeclaredMethod(op, paramTypes);
            Object[] params = this.getParams(typeClass, operands);
            Object result = m.invoke(c, params);
            return (Number)result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Number calculateArray(String op, String type, String[] operands) {
        try {
            Class<?> c = this.getClass();
            Vector<Method> candidates = new Vector<Method>();
            Method[] methods = c.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                String name = methods[i].getName();
                if (!name.equals(op) || methods[i].getParameterTypes().length != 1 || !methods[i].getParameterTypes()[0].isArray()) continue;
                candidates.addElement(methods[i]);
            }
            if (candidates.size() == 0) {
                throw new RuntimeException("Unknown operation: " + op);
            }
            Object wantTypeClass = this.getDataTypeArray(type, operands.length);
            Class typeClass = null;
            Enumeration e = candidates.elements();
            while (e.hasMoreElements()) {
                Method m = (Method)e.nextElement();
                if (!m.getParameterTypes()[0].equals(wantTypeClass.getClass())) continue;
                typeClass = this.getDataType(type);
                Object[] params = this.getParamsArray(typeClass, operands);
                Object result = m.invoke(c, params);
                return (Number)result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private Class getDataType(String type) {
        if (type == null) {
            return Double.TYPE;
        }
        if (type.equals("int")) {
            return Integer.TYPE;
        }
        if (type.equals("long")) {
            return Long.TYPE;
        }
        if (type.equals("float")) {
            return Float.TYPE;
        }
        return Double.TYPE;
    }

    private Object getDataTypeArray(String type, int length) {
        if (type == null) {
            return Array.newInstance(Double.TYPE, length);
        }
        if (type.equals("int")) {
            return Array.newInstance(Integer.TYPE, length);
        }
        if (type.equals("long")) {
            return Array.newInstance(Long.TYPE, length);
        }
        if (type.equals("float")) {
            return Array.newInstance(Float.TYPE, length);
        }
        return Array.newInstance(Double.TYPE, length);
    }

    private Object[] getParams(Class typeClass, String[] operands) {
        int paramCount = operands.length;
        Object[] params = new Object[paramCount];
        if (typeClass == Double.TYPE) {
            for (int i = 0; i < paramCount; ++i) {
                params[i] = new Double(operands[i]);
            }
        } else if (typeClass == Long.TYPE) {
            for (int i = 0; i < paramCount; ++i) {
                params[i] = new Long(operands[i]);
            }
        } else if (typeClass == Float.TYPE) {
            for (int i = 0; i < paramCount; ++i) {
                params[i] = new Float(operands[i]);
            }
        } else {
            for (int i = 0; i < paramCount; ++i) {
                params[i] = new Integer(operands[i]);
            }
        }
        if (paramCount > 2) {
            params = new Object[]{params};
        }
        return params;
    }

    private Object[] getParamsArray(Class typeClass, String[] operands) {
        int paramCount = operands.length;
        if (typeClass == Double.TYPE) {
            double[] array = (double[])Array.newInstance(typeClass, operands.length);
            for (int i = 0; i < paramCount; ++i) {
                Array.setDouble(array, i, new Double(operands[i]));
            }
            return new Object[]{array};
        }
        if (typeClass == Long.TYPE) {
            long[] array = (long[])Array.newInstance(typeClass, operands.length);
            for (int i = 0; i < paramCount; ++i) {
                Array.setLong(array, i, new Long(operands[i]));
            }
            return new Object[]{array};
        }
        if (typeClass == Float.TYPE) {
            float[] array = (float[])Array.newInstance(typeClass, operands.length);
            for (int i = 0; i < paramCount; ++i) {
                Array.setFloat(array, i, new Float(operands[i]).floatValue());
            }
            return new Object[]{array};
        }
        Object array = Array.newInstance(typeClass, operands.length);
        for (int i = 0; i < paramCount; ++i) {
            Array.setInt(array, i, new Integer(operands[i]));
        }
        return new Object[]{array};
    }

    public static void main(String[] args) {
        Math math = new Math();
        System.out.println(math.calculate("add", new String[]{"6", "5", "4"}));
    }
}

