/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.util;

import net.morilib.lang.Hashes;

/**
 * This interface represents the pair of objects.
 * <p>オブジェクトの対(Pair)を表すインターフェースである.
 * 
 * @author MORIGUCHI, Yuichiro 2005/09/21
 */
public class Tuple2<A, B> implements Pair<A, B> {
	
	//
	protected A valueA;
	protected B valueB;
	
	
	public Tuple2(A a, B b) {
		valueA = a;
		valueB = b;
	}
	
	/**
	 * gets the first value of this pair.
	 * <p>対の第1の値を得る.
	 */
	public A getA() {
		return valueA;
	}
	
	/**
	 * gets the second value of this pair.
	 * <p>対の第2の値を得る.
	 */
	public B getB() {
		return valueB;
	}
	
	
	public boolean equals(Object o) {
		if(o == null) {
			return false;
		} else if(o instanceof Tuple2<?, ?>) {
			Tuple2<?, ?> o2 = (Tuple2<?, ?>)o;
			
			return (Objects.equals(valueA, o2.valueA) &&
					Objects.equals(valueB, o2.valueB));
		}
		return false;
	}
	
	
	public int hashCode() {
		int res = Hashes.INIT;
		
		res = Hashes.A * res + Hashes.hashCode(valueA);
		res = Hashes.A * res + Hashes.hashCode(valueB);
		return res;
	}
	
	
	public String toString() {
		return "(" + valueA + "," + valueB + ")";
	}
	
}
