/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.swing;

import java.awt.event.AdjustmentListener;

import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Undef;
import net.morilib.lisp.subr.BinaryArgs;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2011/03/14
 */
public interface AdjustmentListenable {

	/**
	 * 
	 *
	 *
	 * @author MORIGUCHI, Yuichiro 2011/03/14
	 */
	public static class AddAdjustmentListenerS extends BinaryArgs {

		/* (non-Javadoc)
		 * @see net.morilib.lisp.subr.BinaryArgs#execute(net.morilib.lisp.Datum, net.morilib.lisp.Datum, net.morilib.lisp.Environment, net.morilib.lisp.LispMessage)
		 */
		@Override
		protected Datum execute(
				Datum c1a, Datum c2a, Environment env,
				LispMessage mesg) {
			AdjustmentListenable b;

			if(!(c1a instanceof AdjustmentListenable)) {
				throw mesg.getError(
						"err.swing.require.listener.adjustment", c1a);
			} else if(!(c2a instanceof Procedure)) {
				throw mesg.getError("err.require.procedure", c2a);
			}

			b = (AdjustmentListenable)c1a;
			b.addAdjustmentListener(
					LispSwing.createAdjustmentListener
					(c2a, env, mesg));
			return Undef.UNDEF;
		}

	}

	/**
	 * 
	 * @param listener
	 */
	public void addAdjustmentListener(AdjustmentListener l);

}
