/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.automata.dfa;

import net.morilib.util.Tuple2;

public abstract class DFABuilder {
	
	//
	private static final DFABuilder INSTANCE = new NFADFABuilder();
	
	//
	/*package*/ DFABuilder() {
		// do nothing
	}
	
	
	public static DFABuilder getInstance() {
		return INSTANCE;
	}
	
	
	public abstract DFA<Integer, Void, Tuple2<Void, Integer>> build(
			String regexp);
	
	
	public abstract
	DFA<Integer, Integer, Tuple2<Integer, Integer>> buildCombined(
			String... regexps);
	
}
