/*
 * Copyright 2004-2006 Robbie.JP
 */
package robbie.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * ClassIuWFNg쐬t@NgNXB<p>
 * @since 1.2.0
 */
public class ClassFactory {

    private static Log LOG = LogFactory.getLog(ClassFactory.class);
    
    /**
     * ClassIuWFNgĕԂ܂B<p> 
     * @since 1.2.0
     * @param className Class
     * @return ClssIuWFNg
     * @throws ClassNotFoundException 
     */
    public static Class getClass(String className) throws ClassNotFoundException {
        
        try {
            return Class.forName(className);
        } catch(ClassNotFoundException  ex) {
            LOG.warn("Class name=" + className + "܂łB" +
                    "Thread.currentThread().getContextClassLoader()ClassT܂B");
            try {
                return getClass(className, Thread.currentThread().getContextClassLoader());
            } catch(ClassNotFoundException  ex2) {
                LOG.error("Class name=" + className + "ContextClassLoaderł܂łB");
                throw ex2;
            } catch(Error error) {
                LOG.error("Class name" + className + "̏ɃG[܂B");
                throw error;
            }
        }
    }
    
    /**
     * ClassLoaderw肵ClassIuWFNgĕԂ܂B<p> 
     * @since 1.2.0
     * @param className Class
     * @param loader ClassLoader
     * @return ClssIuWFNg
     * @throws ClassNotFoundException 
     */
    public static Class getClass(String className, ClassLoader loader) throws ClassNotFoundException {
        
        try {
            return Class.forName(className, true, loader);
        } catch(ClassNotFoundException  ex) {
            LOG.warn("Class name=" + className + "܂łB"); 
            throw ex;
        } catch(Error error) {
            LOG.error("Class name" + className + "̏ɃG[܂B");
            throw error;
        }
    }
}
