/*
 * Copyright 2004-2006 Robbie.JP
 */
package robbie.dao.x;

import java.util.Map;
import java.util.List;

import java.sql.SQLException;

import robbie.dao.BaseDao;
import robbie.dao.DaoUtil;
import robbie.dao.resource.DbResource;

/**
 * XDAONXB<p>
 * <pre>
 * ̃NX́AXMLt@Cɒ`ꂽASQLƃf[^x[X\[XgpāA
 * f[^x[XANZXsȂDAONXłBXML`𗘗pꍇɂ́A
 * ̃NXpNXƖvɎĂB
 * ܂ÃNXɂ̓ftHgŁAPgUNV̌ƍXV݂̂Ă܂B
 * gsȂꍇɂ́ÃNXpNX쐬AXML&lt;class-name&gt;
 * NXƗp郊\[Xݒ肵ĂB
 * </pre>
 * @see robbie.dao.BaseDao
 * @see robbie.dao.x.XQueryFactory
 * @see robbie.dao.resource.DbResource
 */
public class XDao extends BaseDao {

    private static final long serialVersionUID = 5877166542598269789L;
    
    /**
     * update\bhsSQLExceptionCatchۂɕԂXVB<p>
     * ۂɂ-1Ԃ܂B
     */
    public static final int CATCH_SQL_EXCEPTION_COUNT = -1;

    /**
     * XQueryFactoryNX̃CX^XB<p>
     * <pre>
     * ̕ϐ𗘗pāAsSQLCX^X擾܂B
     * TuNXł͈ȉ̂悤ɂāASQLCX^X擾
     * gsȂĂB
     * 
     * Query query = queryFactory.createSQLInstance(id, params);
     * 
     * </pre>
     * @see robbie.dao.Query
     * @see XQueryFactory#createQueryInstance(String, Map)
     */
    protected XQueryFactory queryFactory = null;
    
    /**
     * XDbResourceNX̃CX^XB<p>
     * <pre>
     * ̕ϐ𗘗pāAf[^x[XւConnection擾܂B
     * TuNXł͈ȉ̂悤ɂāAConnectionCX^X擾
     * gsȂĂB
     * 
     * java.sql.Connection conn = resource.getConnection();
     * 
     * ܂ADAOs\ɂꍇɂ́Â悤Ɏƕ֗łB
     * 
     * setConnection(resource.getConnection());
     * 
     * </pre>
     * @see DbResource#getConnection()
     */
    protected DbResource resource = null;
    
    /**
     * O̍XVŔSQLExceptionB<p>
     */
    protected SQLException exception = null;
    
    /**
     * XQueryFactoryCX^XZbg܂B<p>
     * @param queryFactory XSQLFactoryCX^X
     */
    public void setQueryFactory(XQueryFactory queryFactory) {
        this.queryFactory = queryFactory;
    }

    /**
     * XDbResourceCX^XZbg܂B<p>
     * @param resource XmlDBResourceCX^X
     */
    public void setResource(DbResource resource) {
        this.resource = resource;
    }
    
    /**
     * O̍XVŎ擾SQLExceptionԂ܂B<p>
     * @return OɎ擾SQLException
     */
    public SQLException getSQLException() {
        return exception;
    }
    
    /**
     * configure()\bh̃I[oChB<p>
     * XDaoł͉Ă܂B
     * ̃\bh͏ƂXDaoCX^X쐬ɌĂяoĂ܂B
     * XDaõTuNXŏKvȏꍇ΁AI[oChĎgpĂB
     */
    public void configure() {
        // Ȃ
    }
    
    /**
     * ₢킹sAʂMapListŕԂ܂B<p>
     * <pre>
     * RlNV擾AsListԂA
     * RlNVclose܂B
     * </pre>
     * @param id queryid
     * @param params p[^Map
     * @return ʂMapList
     */
    public List query(String id, Map params) {
        
        if (id == null) {
            throw new IllegalArgumentException("p[^idNULLł.");
        }
        
        try{
            setConnection(resource.getConnection());
            return executeQuery(queryFactory.createQueryInstance(id, params));
        } catch(Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new XDaoException("catch exception.", ex);
        } finally {
            try {
                closeConnection();
            } catch(Exception ex) {
                //throw new XDaoException("", ex);
            }
        }
    }
    
    /**
     * ₢킹sAʂObject[][]ŕԂ܂B<p>
     * Object[0][*]̓J̃wb_ɂȂ܂B
     * f[^gpꍇɂ́AObject[1][*]gpĂ
     * @param id queryid
     * @param params p[^Map
     * @return ʂ2z
     */
    public Object[][] queryForArray(String id, Map params) {
        
        if (id == null) {
            throw new IllegalArgumentException("p[^idNULLł.");
        }
        
        try{
            setConnection(resource.getConnection());
            return executeQueryForArray(queryFactory.createQueryInstance(id, params));
        } catch(Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new XDaoException("catch exception.", ex);
        } finally {
            try {
                closeConnection();
            } catch(Exception ex) {
                //throw new XDaoException("", ex);
            }
        }
    }
    
    /**
     * ₢킹sAʂJavaBeansListŕԂ܂B<p>
     * @param id queryid
     * @param params p[^Map
     * @param beanClass ϊBeanClassIuWFNg
     * @return JavaBeansList
     * @deprecated
     */
    public List queryForBeans(String id, Map params, Class beanClass) {
        
        if (id == null || beanClass == null) {
            throw new IllegalArgumentException("p[^idbeanClassNULLł. id" + id + " beanCLass" + beanClass);
        }
        
        try{
            setConnection(resource.getConnection());
            return executeQueryForBeans(queryFactory.createQueryInstance(id, params), beanClass);
        } catch(Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new XDaoException("catch exception.", ex);
        } finally {
            try {
                closeConnection();
            } catch(Exception ex) {
                //throw new XDaoException("", ex);
            }
        }
    }
    
    /**
     * ₢킹sAʂJavaBeansListŕԂ܂B<p>
     * @param id queryid
     * @param params p[^Map
     * @return JavaBeansList
     * @since 1.2.0
     */
    public List queryForBeans(String id, Map params) {
        
        if (id == null) {
            throw new IllegalArgumentException("p[^idNULLł. id" + id);
        }
        
        try{
            setConnection(resource.getConnection());
            return executeQueryForBeans(queryFactory.createQueryInstance(id, params));
        } catch(Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new XDaoException("catch exception.", ex);
        } finally {
            try {
                closeConnection();
            } catch(Exception ex) {
                //throw new XDaoException("", ex);
            }
        }
    }
    
    /**
     * XVs܂B<p>
     * <pre>
     * ̃\bhSQLExceptionꍇɂ́A-1Ԃ܂B
     * -1Ԃꂽꍇɂ͂SQLExceptionoϐƂĕێ܂̂ŁA
     * KvȏꍇɂgetSQLException()炻SQLException擾邱Ƃ\łB
     * ܂Ã\bhJDBCgUNV̏ꍇɂ́A1gUNVƂ
     * s邱ƂɒӂĉBAJTÃgUNVReił́A
     * Reî̃gUNVD悳܂B
     * </pre>
     * @param id queryid
     * @param params p[^Map
     * @return XVASQLExceptionꍇɂ-1
     */
    public int update(String id, Map params) {
        
        if (id == null) {
            throw new IllegalArgumentException("p[^idNULLł.");
        }
        
        try{
            setConnection(resource.getConnection());
            return executeUpdate(queryFactory.createQueryInstance(id, params));
        } catch(SQLException ex) {
            this.exception = ex;
            return CATCH_SQL_EXCEPTION_COUNT;
        } catch(Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new XDaoException("catch exception.", ex);
        } finally {
            try {
                closeConnection();
            } catch(Exception ex) {
                //throw new XDaoException("", ex);
            }
        }
    }
    
    /**
     * JavaBeansoChϐMap쐬čXVs܂B<p>
     * <pre>
     * ̃\bhSQLExceptionꍇɂ́A-1Ԃ܂B
     * -1Ԃꂽꍇɂ͂SQLExceptionoϐƂĕێ܂̂ŁA
     * KvȏꍇɂgetSQLException()炻SQLException擾邱Ƃ\łB
     * </pre>
     * @param id queryid
     * @param beans oChϐƂȂJavaBeans
     * @return XVASQLExceptionꍇɂ-1
     */
    public int update(String id, Object beans) {
        
        if (id == null) {
            throw new IllegalArgumentException("p[^idNULLł.");
        }
        
        try {
            return update(id, DaoUtil.beansToMap(beans));
        } catch(Exception ex) {
            if (ex instanceof RuntimeException) {
                throw(RuntimeException)ex;
            }
            throw new XDaoException("catch exception.", ex);
        }
    }
    
    /**
     * f[^x[Xڑ\[XJ܂B<p>
     * f[^x[XڑSĊAK̃\bhĂłB
     */
    public void release() {
        resource.release();
    }
}
