/*
 * Decompiled with CFR 0.152.
 */
package robbie.dao.resource;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import robbie.dao.DaoSysException;
import robbie.dao.DbConnectionUtil;
import robbie.dao.resource.DbResource;
import robbie.dao.resource.JdbcConnectionProxy;
import robbie.dao.resource.JdbcConnectionWrapper;

public class JdbcResource
implements DbResource {
    private static final long serialVersionUID = 1898964070539584048L;
    private JdbcConnectionProxy proxy = new JdbcConnectionProxy();
    protected Properties env = null;

    public JdbcResource(Properties env) {
        if (env == null) {
            throw new IllegalArgumentException("JDBC\u63a5\u7d9a\u30d7\u30ed\u30d1\u30c6\u30a3\u304cNULL\u3067\u3059.");
        }
        this.env = env;
    }

    public Connection getConnection() {
        try {
            Connection conn = this.proxy.getConnection();
            if (conn == null || conn.isClosed()) {
                conn = new JdbcConnectionWrapper(DbConnectionUtil.getConnection(this.env), false);
                this.proxy.setConnection(conn);
            }
            return conn;
        }
        catch (Exception ex) {
            throw new DaoSysException("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f.", ex);
        }
    }

    public void release() {
        JdbcConnectionWrapper wrapper = (JdbcConnectionWrapper)this.proxy.getConnection();
        if (wrapper != null) {
            try {
                wrapper.closeConnection();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected JdbcConnectionProxy getJdbcConnectionProxy() {
        return this.proxy;
    }

    public String toString() {
        return "JDBC PROPERTY=" + this.env;
    }
}

